/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.task;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.enums.AssistTypeEnum;
import kd.fi.frm.common.enums.DataTypeEnum;
import kd.fi.frm.common.enums.ReconcilationResultEnum;
import kd.fi.frm.common.model.FrmLogger;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanDetailModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanModel;
import kd.fi.frm.common.task.TaskDao;
import kd.fi.frm.common.task.TaskInfo;
import kd.fi.frm.common.task.TaskStatusEnum;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.common.util.ThrowableHelper;
import kd.fi.frm.mservice.ReconTabServiceExecutor;
import kd.fi.frm.mservice.impl.AbstractReconTabService;
import kd.fi.frm.mservice.impl.ReconServiceHelper;

public class ReconBizDataRuleEntryTask
extends ReconServiceHelper
implements Callable<Boolean> {
    private static final Log logger = LogFactory.getLog(ReconBizDataRuleEntryTask.class);
    private ReconciliationParamModel paramModel;
    private Integer reconTab;
    private BizReconPlanDetailModel planDetailModel;

    public ReconBizDataRuleEntryTask(ReconciliationParamModel paramModel, BizReconPlanDetailModel planDetailModel, int reconTab) {
        this.paramModel = paramModel;
        if (paramModel.isAnalyzeMode()) {
            paramModel.setAnalyzeMode();
        }
        this.reconTab = reconTab;
        this.planDetailModel = planDetailModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean call() throws Exception {
        Long taskEntryId = this.planDetailModel.getTaskEntryId();
        TaskInfo taskInfo = this.paramModel.getTaskInfo();
        try {
            DLock lock = DLock.create((String)("fi.frm.task.entry.FINISH." + taskEntryId));
            try {
                BizReconPlanModel planModel;
                boolean getLock = lock.tryLock();
                if (!getLock) return Boolean.TRUE;
                logger.info("\u83b7\u53d6\u5230\u5206\u5f55\u7ed3\u675f\u66f4\u65b0\u72b6\u6001\u9501\uff0c\u5f00\u59cb\u5904\u7406\u6570\u636e, taskEntryId = {}", (Object)taskEntryId);
                if (!TaskDao.isExecutePlanEntryFinish((Long)taskEntryId)) return Boolean.TRUE;
                logger.info("\u65b9\u6848\u5206\u5f55\u4e1a\u52a1\u53d6\u6570\u5b8c\u6210,taskId = {}, planEntryId = {}", (Object)taskInfo.getId(), (Object)this.planDetailModel.getId());
                if (TaskDao.isTaskOver((TaskInfo)taskInfo)) {
                    Boolean bl = true;
                    return bl;
                }
                String taskCache = AppCacheHelper.getTaskCache((String)taskInfo.getBatchNo(), (String)taskInfo.getId().toString());
                TaskInfo cacheTaskInfo = (TaskInfo)SerializationUtils.deSerializeFromBase64((String)taskCache);
                if (cacheTaskInfo == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8d26\u4efb\u52a1\u7f13\u5b58\u6570\u636e\u5df2\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u5bf9\u8d26", (String)"ReconBizDataRuleEntryTask_1", (String)"fi-frm-mservice", (Object[])new Object[0]));
                }
                logger.info("\u65b9\u6848\u5206\u5f55\u5f00\u59cb\u5408\u5e76\u4e1a\u52a1\u548c\u603b\u8d26\u6570\u636e,taskId = {}, planEntryId = {}", (Object)taskInfo.getId(), (Object)this.planDetailModel.getId());
                Map<Long, Integer> dcMap = ReconServiceHelper.getDCMap(Collections.singletonList(this.planDetailModel));
                ReconServiceHelper.setDc(this.planDetailModel, dcMap);
                Set taskEntryDetailCachedId = TaskDao.getTaskEntryDetailCachedId((Long)taskEntryId);
                DataSet bizDataSet = null;
                HashMap<String, Set<Long>> needQueryBasedata = new HashMap<String, Set<Long>>(10);
                if (this.reconTab != 1) {
                    Map originAssistIndexMap = this.planDetailModel.getBizAssistIndexMap();
                    HashMap<Long, Map<Integer, String>> assistIndexMap = new HashMap<Long, Map<Integer, String>>();
                    HashMap indexAssitMap = new HashMap(10);
                    originAssistIndexMap.forEach((k, v) -> indexAssitMap.put(v, k));
                    assistIndexMap.put(this.planDetailModel.getId(), indexAssitMap);
                    for (String id : taskEntryDetailCachedId) {
                        CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)id);
                        this.getBizDataBaseDataMap(this.planDetailModel.getId(), assistIndexMap, needQueryBasedata, cacheDataSet);
                        if (bizDataSet == null) {
                            bizDataSet = cacheDataSet.toDataSet(Algo.create((String)"frm"), false);
                            continue;
                        }
                        bizDataSet = bizDataSet.union(cacheDataSet.toDataSet(Algo.create((String)"frm"), false));
                    }
                } else {
                    for (String id : taskEntryDetailCachedId) {
                        CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)id);
                        if (bizDataSet == null) {
                            bizDataSet = cacheDataSet.toDataSet(Algo.create((String)"frm"), false);
                            continue;
                        }
                        bizDataSet = bizDataSet.union(cacheDataSet.toDataSet(Algo.create((String)"frm"), false));
                    }
                }
                DataSet sumDataSet = ReconBizDataRuleEntryTask.sumDataSet(bizDataSet, this.paramModel, this.planDetailModel.getBalanceDc(), needQueryBasedata, this.planDetailModel.getBizAssistIndexMap());
                ReconciliationUtil.initFrmLoggerCache((FrmLogger)this.paramModel.getFrmLogger());
                long orgId = taskInfo.getOrgId();
                if (this.paramModel.isApi()) {
                    orgId = this.paramModel.getOrgIds().toArray(new Long[0])[0];
                }
                if ((planModel = ReconciliationUtil.getPlanModel((Long)this.paramModel.getBookTypeId(), (Long)orgId, (String)taskInfo.getAppId(), (Long)this.paramModel.getPeriodId(), null)) == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7[%s]\u672a\u83b7\u53d6\u5230\u5bf9\u8d26\u65b9\u6848", (String)"ReconBizDataRuleEntryTask_2", (String)"fi-frm-mservice", (Object[])new Object[0]), orgId));
                }
                AbstractReconTabService reconTabService = ReconTabServiceExecutor.serviceBuilder(this.planDetailModel.getAssistType()).planModel(planModel).paramModel(this.paramModel).detailModel(this.planDetailModel).build();
                DataSet glDataSet = reconTabService.getGlAmount();
                sumDataSet = this.reconTab.intValue() != AssistTypeEnum.Acct.getValue() ? reconTabService.bizAssistDataMapping(sumDataSet) : sumDataSet.addNullField(new String[]{"app_show_assist1", "app_show_assist2", "app_show_assist3", "app_show_assist4", "app_show_assist5", "app_show_assist6", "app_show_assist7", "app_show_assist8"});
                boolean reconEqual = ReconBizDataRuleEntryTask.joinDataSet(this.paramModel, planModel, this.planDetailModel, sumDataSet, glDataSet, this.reconTab);
                logger.info("\u65b9\u6848\u5206\u5f55\u603b\u8d26\u53d6\u6570\u5b8c\u6210,taskId = {}, planEntryId = {}", (Object)taskInfo.getId(), (Object)this.planDetailModel.getId());
                if (!reconEqual) {
                    TaskDao.finishExecutePlanEntry((Long)taskInfo.getId(), (Long)this.planDetailModel.getId(), (ReconcilationResultEnum)ReconcilationResultEnum.fail);
                    if (this.paramModel.getDataType() == DataTypeEnum.OnlyStatus) {
                        AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)String.valueOf(taskInfo.getId()), (ReconcilationResultEnum)ReconcilationResultEnum.fail, (String)taskInfo.getStatus(), (TaskStatusEnum)TaskStatusEnum.FINISHED, null, null);
                    }
                } else {
                    TaskDao.finishExecutePlanEntry((Long)taskInfo.getId(), (Long)this.planDetailModel.getId(), (ReconcilationResultEnum)ReconcilationResultEnum.Pass);
                }
                DLock taskFinishLock = DLock.create((String)("fi.frm.task.FINISH." + taskInfo.getId()));
                try {
                    if (!taskFinishLock.tryLock(5000L)) return Boolean.TRUE;
                    if (TaskDao.isTaskOver((TaskInfo)taskInfo)) {
                        Boolean bl = true;
                        return bl;
                    }
                    if (!TaskDao.isTaskAllFinish((Long)taskInfo.getId())) return Boolean.TRUE;
                    logger.info("\u5206\u5e03\u5f0f\u5bf9\u8d26\u4efb\u52a1[{}]\u5168\u90e8\u5b8c\u6210\uff0c\u66f4\u65b0\u4efb\u52a1\u72b6\u6001...", (Object)taskInfo.getId());
                    taskInfo.setTaskStatus(TaskStatusEnum.FINISHED);
                    taskInfo.setPercent(Integer.valueOf(100));
                    AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)taskInfo.getId().toString(), null, null, (TaskStatusEnum)TaskStatusEnum.FINISHED, null, null);
                    return Boolean.TRUE;
                }
                finally {
                    taskFinishLock.unlock();
                }
            }
            finally {
                lock.unlock();
            }
        }
        catch (Throwable e) {
            logger.error("\u5bf9\u8d26\u83b7\u53d6\u4e1a\u52a1\u6570\u636eID\u62a5\u9519", e);
            String errorMsgTag = ThrowableHelper.toString((Throwable)e);
            AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)String.valueOf(taskInfo.getId()), (ReconcilationResultEnum)ReconcilationResultEnum.error, null, (TaskStatusEnum)TaskStatusEnum.ERROR, null, (String[])new String[]{errorMsgTag, errorMsgTag});
            return false;
        }
    }

    private void getBizDataBaseDataMap(Long plandetailid, Map<Long, Map<Integer, String>> assistIndexMap, Map<String, Set<Long>> needQueryBasedata, CachedDataSet cacheDataSet) {
        block0: for (Row row : cacheDataSet.getList(0, cacheDataSet.getRowCount())) {
            Map<Integer, String> assistBitMap = assistIndexMap.get(plandetailid);
            for (int i = 1; i <= 8; ++i) {
                Object assist1_app = row.get("assist" + i + "_app");
                if (assistBitMap.get(i) == null) continue block0;
                Set assistIdSet = needQueryBasedata.computeIfAbsent(assistBitMap.get(i), k -> new HashSet(20));
                if (assist1_app == null || Objects.equals(assist1_app, 0L)) continue;
                assistIdSet.add((Long)assist1_app);
            }
        }
    }
}

