/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.mservice.task;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.enums.ReconAmountTypeEnum;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.bizdata.BizDataParam;
import kd.fi.frm.common.model.bizdata.BizDataSourceConfig;
import kd.fi.frm.common.model.bizdata.BizReconPlanDetailModel;
import kd.fi.frm.common.task.TaskDao;
import kd.fi.frm.common.task.TaskInfo;
import kd.fi.frm.common.task.TaskStatusEnum;
import kd.fi.frm.common.util.ReconciliationParmUtil;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.common.util.ThrowableHelper;
import kd.fi.frm.mservice.bizdata.BizDataService;
import kd.fi.frm.mservice.bizdata.ext.custom.AbstractCustomParamService;
import kd.fi.frm.mservice.bizdata.ext.custom.CustomParamUtil;
import kd.fi.frm.mservice.task.ReconBizDataRuleEntryTask;

public class ReconSpecialRuleConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(ReconSpecialRuleConsumer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object message, String messageId, boolean resend, MessageAcker ack) {
        ReconAmountTypeEnum reconAmountTypeEnum;
        Long dataRuleId;
        logger.info("recon task receive message {}", message);
        TaskInfo taskInfo = null;
        BizDataSourceConfig bizConfig = null;
        BizReconPlanDetailModel planDetailModel = null;
        ReconciliationParamModel reconParamModel = null;
        BizDataParam bizParam = null;
        boolean onlyGlData = false;
        try {
            Map param = (Map)message;
            dataRuleId = (Long)param.get("dataRuleId");
            reconAmountTypeEnum = (ReconAmountTypeEnum)param.get("reconAmountType");
            Object taskId = param.get("taskId");
            taskInfo = TaskDao.getTaskInfo((Long)Long.parseLong(String.valueOf(taskId)));
            if (taskInfo == null) {
                logger.warn("recon task[{}] not exists!", taskId);
                ack.ack(messageId);
                return;
            }
            TaskStatusEnum taskStatus = taskInfo.getTaskStatus();
            if (TaskStatusEnum.FINISHED == taskStatus || TaskStatusEnum.ERROR == taskStatus || TaskStatusEnum.STOPPED == taskStatus) {
                logger.warn("recon task[{}] not running!", taskId);
                ack.ack(messageId);
                return;
            }
            reconParamModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param.get("reconParam").toString(), ReconciliationParamModel.class);
            String planDetailModelStr = (String)param.get("planDetailModel");
            planDetailModel = (BizReconPlanDetailModel)SerializationUtils.fromJsonString((String)planDetailModelStr, BizReconPlanDetailModel.class);
            onlyGlData = Boolean.parseBoolean(param.get("onlyGlData").toString());
            if (!onlyGlData) {
                bizParam = (BizDataParam)SerializationUtils.fromJsonString((String)param.get("bizParam").toString(), BizDataParam.class);
                bizConfig = (BizDataSourceConfig)SerializationUtils.fromJsonString((String)param.get("bizConfig").toString(), BizDataSourceConfig.class);
                Set bizOrgIds = (Set)param.get("bizOrgIds");
                taskInfo.setBizOrgIds(bizOrgIds);
            }
            if (reconParamModel == null || planDetailModel == null || !onlyGlData && bizConfig == null) {
                ack.ack(messageId);
                String errorMsg = ResManager.loadKDString((String)"\u53c2\u6570\u4f20\u9012\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u5bf9\u8d26", (String)"ReconSpecialRuleConsumer_0", (String)"fi-frm-mservice", (Object[])new Object[0]);
                AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)String.valueOf(taskInfo.getId()), null, null, (TaskStatusEnum)TaskStatusEnum.ERROR, null, (String[])new String[]{errorMsg, errorMsg + message});
                return;
            }
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u6d88\u8d39\u5f02\u5e38", (Throwable)e);
            if (taskInfo != null) {
                String errorMsg = ResManager.loadKDString((String)"\u53c2\u6570\u4f20\u9012\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u5bf9\u8d26", (String)"ReconSpecialRuleConsumer_0", (String)"fi-frm-mservice", (Object[])new Object[0]);
                AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)String.valueOf(taskInfo.getId()), null, null, (TaskStatusEnum)TaskStatusEnum.ERROR, null, (String[])new String[]{errorMsg, errorMsg});
            }
            ack.ack(messageId);
            return;
        }
        Long orgId = taskInfo.getOrgId();
        ReconciliationUtil.planDetailAssist((BizReconPlanDetailModel)planDetailModel, (Long)orgId);
        DynamicObject dataRule = ReconciliationUtil.getDataRule((Long)dataRuleId, (ReconAmountTypeEnum)reconAmountTypeEnum);
        CustomParamUtil.setCustomParam(reconParamModel, dataRule);
        AbstractCustomParamService customParamService = CustomParamUtil.paramConversion(reconParamModel, planDetailModel, orgId);
        List bizAssistIdSetMapList = ReconciliationParmUtil.getBizAssistSetFromBizFilter((BizReconPlanDetailModel)planDetailModel);
        try {
            Map param = (Map)message;
            TaskDao.startExecutePlanEntry((Long)taskInfo.getId(), (Long)planDetailModel.getId());
            reconParamModel.setTaskInfo(taskInfo);
            int reconTab = (Integer)param.get("reconTab");
            int bizDataCount = 0;
            String bizDataSetId = "";
            if (!onlyGlData) {
                bizParam.setSourceConfig(bizConfig);
                bizParam.setAcctOrgID(orgId.longValue());
                bizParam.setAssistIndexMap(planDetailModel.getBizAssistIndexMap());
                bizParam.setAssistType(planDetailModel.getAssistType());
                bizParam.setBizAssistIdSetMapList(bizAssistIdSetMapList);
                ReconciliationUtil.initSysParam((ReconciliationParamModel)reconParamModel, (String)bizParam.getAppNumber());
                BizDataService bizDataService = new BizDataService(bizParam, reconParamModel);
                bizDataService.setCustomParamService(customParamService);
                bizDataService.execute();
                bizDataSetId = bizDataService.getDataResult().getResultCacheId();
                bizDataCount = bizDataService.getDataResult().getDataSize();
                if (bizDataSetId == null) {
                    bizDataSetId = "";
                }
                TaskDao.finishExecuteRuleEntry((Long)taskInfo.getId(), (Long)bizConfig.getRuleEntryId(), (Long)planDetailModel.getTaskEntryId(), (int)bizDataCount, (String)bizDataSetId);
                AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)taskInfo.getId().toString(), null, null, null, (Integer)1, null);
                logger.info("\u89c4\u5219\u5206\u5f55ruleEntry{}\u6267\u884c\u5b8c\u6210", (Object)bizConfig.getRuleEntryId());
            }
            ReconBizDataRuleEntryTask task = new ReconBizDataRuleEntryTask(reconParamModel, planDetailModel, reconTab);
            task.call();
        }
        catch (Exception e) {
            logger.error("\u4efb\u52a1\u6267\u884c\u5f02\u5e38", (Throwable)e);
            if (!onlyGlData) {
                TaskDao.failExecuteRuleEntry((Long)taskInfo.getId(), (Long)bizConfig.getRuleEntryId(), (Long)bizConfig.getTaskEntryId());
            }
            String errorTag = ThrowableHelper.toString((Exception)e);
            AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)String.valueOf(taskInfo.getId()), null, null, (TaskStatusEnum)TaskStatusEnum.ERROR, null, (String[])new String[]{errorTag, errorTag});
        }
        finally {
            ack.ack(messageId);
        }
    }
}

