/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.frm.common.enums.PermissonType;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.task.TaskDao;
import kd.fi.frm.common.util.AccSysUtil;
import kd.fi.frm.common.util.DapUtil;
import kd.fi.frm.common.util.ShowConfirmUtil;

public class BizReconciliationIndexNewPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(BizReconciliationIndexNewPlugin.class);
    public static final String FormId_Key = "frm_reconciliation_index";
    private static final String Key_Button_account = "buttonap";
    private static final String KEY_RECON_TASK = "recontask";
    private static final String KEY_PERIODTYPE = "periodtype";
    public static final String KEY_PERIOD = "period";
    public static final String KEY_PERIODNUMBER = "periodnumber";
    public static final String KEY_ORG = "orgs";
    public static final String KEY_INIT = "init";
    private static final String KEY_BOOKTYPE = "booktype";
    private static final String KEY_APP = "bizapps";
    private static final String KEY_BOOKTYPSIDS = "booktypeids";
    private static final String ENTITY_GL_ACCOUNTBOOK = "gl_accountbook";
    public static final String MODEL = "model";
    public static final String IGNORE_RESULT = "ignoreresult";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_Button_account, KEY_RECON_TASK});
        BasedataEdit periodF7 = (BasedataEdit)this.getView().getControl(KEY_PERIOD);
        periodF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit booktype = (BasedataEdit)this.getView().getControl(KEY_BOOKTYPE);
        booktype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit org = (MulBasedataEdit)this.getView().getControl(KEY_ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit bizapp = (MulBasedataEdit)this.getView().getControl(KEY_APP);
        bizapp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit periodTypeF7 = (BasedataEdit)this.getView().getControl(KEY_PERIODTYPE);
        periodTypeF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        String key = btn.getKey();
        if (Key_Button_account.equalsIgnoreCase(key)) {
            this.checkAccount();
        } else if (KEY_RECON_TASK.equalsIgnoreCase(key)) {
            this.showReconTask();
        }
    }

    private void setDefaultValue() {
        long curOrgId = RequestContext.get().getOrgId();
        Long orgId = curOrgId;
        List pkSet = AccSysUtil.getAcctOrgPkList((String)"gl_voucher", (boolean)false, (PermissonType)PermissonType.VIEW);
        if (pkSet.size() > 0) {
            if (!pkSet.contains(curOrgId)) {
                orgId = pkSet.toArray(new Long[0])[0];
            }
        } else {
            Set acctOrgs = DapUtil.getAcctOrgIncludeSelf((long)curOrgId);
            if (!acctOrgs.contains(curOrgId) && acctOrgs.size() > 0) {
                orgId = acctOrgs.toArray(new Long[0])[0];
            }
        }
        this.getModel().setValue(KEY_ORG, (Object)new Long[]{orgId});
        this.orgChanged();
        this.setCustomerApp();
    }

    private void setCustomerApp() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object appNumberObj = customParams.get("appNumber");
        if (appNumberObj != null) {
            String appNumberStr = String.valueOf(appNumberObj);
            String[] split = appNumberStr.split(",");
            Map cacheMap = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)split)});
            ArrayList appObjs = new ArrayList(cacheMap.keySet());
            this.getModel().setValue(KEY_APP, (Object)appObjs.toArray());
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_APP});
            if (appObjs.size() == 1) {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_APP});
            }
        }
    }

    private void checkAccount() {
        DynamicObjectCollection apps;
        IDataModel model = this.getView().getModel();
        DynamicObjectCollection orgs = (DynamicObjectCollection)model.getValue(KEY_ORG);
        if (null == orgs || orgs.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"BizReconciliationIndexNewPlugin_0", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject bookType = (DynamicObject)model.getValue(KEY_BOOKTYPE);
        if (null == bookType) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"BizReconciliationIndexNewPlugin_1", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject periodType = (DynamicObject)model.getValue(KEY_PERIODTYPE);
        if (null == periodType) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u8d26\u671f\u95f4\u3002", (String)"BizReconciliationIndexNewPlugin_2", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean init = (Boolean)model.getValue(KEY_INIT);
        long periodId = 0L;
        if (!init) {
            DynamicObject period = (DynamicObject)model.getValue(KEY_PERIOD);
            if (null == period) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u8d26\u671f\u95f4\u3002", (String)"BizReconciliationIndexNewPlugin_2", (String)"fi-frm-formplugin", (Object[])new Object[0]));
                return;
            }
            periodId = (Long)period.getPkValue();
        }
        if (null == (apps = (DynamicObjectCollection)model.getValue(KEY_APP)) || apps.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5e94\u7528\u3002", (String)"BizReconciliationIndexNewPlugin_3", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            return;
        }
        String param = this.getPageCache().get(MODEL);
        ReconciliationParamModel paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
        paramModel.setBookTypeId((Long)bookType.getPkValue());
        paramModel.setPeriodId(Long.valueOf(periodId));
        paramModel.setAppIds(new HashSet());
        for (DynamicObject app : apps) {
            DynamicObject basedataObj = app.getDynamicObject("fbasedataid");
            paramModel.addAppId((String)basedataObj.getPkValue());
        }
        paramModel.setInit(((Boolean)model.getValue(KEY_INIT)).booleanValue());
        this.getPageCache().put(MODEL, SerializationUtils.toJsonString((Object)paramModel));
        DynamicObjectCollection existTasks = TaskDao.getExistTasks((ReconciliationParamModel)paramModel);
        if (existTasks.size() == 0) {
            boolean ignoreresult = (Boolean)this.getModel().getValue(IGNORE_RESULT);
            if (ignoreresult) {
                this.showBizAssistForm(paramModel);
            } else {
                this.showReconciliationReport();
            }
        } else {
            ShowConfirmUtil.showTaskConfirm((IFormView)this.getView(), (IPageCache)this.getPageCache(), (DynamicObjectCollection)existTasks);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("stopTask".equals(messageBoxClosedEvent.getCallBackId())) {
            ShowConfirmUtil.taskConfirm((MessageBoxClosedEvent)messageBoxClosedEvent, (String)this.getPageCache().get("existTaskIds"), (IFormView)this.getView());
        }
    }

    private void showReconTask() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("frm_task");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showReconciliationReport() {
        FormShowParameter parameEdit = new FormShowParameter();
        parameEdit.setFormId("frm_reconciliation_rst_new");
        parameEdit.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameEdit.getOpenStyle().setTargetKey("tabap");
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put(MODEL, this.getPageCache().get(MODEL));
        parameEdit.setCustomParams(customParams);
        this.getView().showForm(parameEdit);
    }

    private void showBizAssistForm(ReconciliationParamModel paramModel) {
        Set orgIds = paramModel.getOrgIds();
        Set appIds = paramModel.getAppIds();
        String paramStr = SerializationUtils.toJsonString((Object)paramModel);
        HashSet<String> appOrgSet = new HashSet<String>(12);
        for (Object orgId : orgIds) {
            for (String appId : appIds) {
                appOrgSet.add(orgId + "," + appId);
            }
        }
        if (appOrgSet.size() > 8) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u548c\u4e1a\u52a1\u7cfb\u7edf\u7684\u7ec4\u5408\u5927\u4e8e8\u4e2a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01", (String)"BizReconciliationIndexNewPlugin_6", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> appOrgList = new ArrayList<String>(appOrgSet.size());
        for (String appOrgStr : appOrgSet) {
            appOrgList.add(appOrgStr);
        }
        ReconciliationParamModel model = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)paramStr, ReconciliationParamModel.class);
        FormShowParameter parame = new FormShowParameter();
        parame.setFormId("frm_reconciliation_rst_fst");
        parame.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        model.getOrgIds().clear();
        model.getAppIds().clear();
        String appOrgStr = (String)appOrgList.get(0);
        model.addOrg(Long.valueOf(Long.parseLong(appOrgStr.split(",")[0])));
        model.addAppId(appOrgStr.split(",")[1]);
        parame.setCustomParam(MODEL, (Object)SerializationUtils.toJsonString((Object)model));
        appOrgList.remove(0);
        parame.setCustomParam("appOrgList", appOrgList);
        this.getView().showForm(parame);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().getPageCache().put("pageCacheShiftMBtn", "recontask,ignoreresult");
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BOOKTYPE, KEY_PERIODTYPE});
        this.setDefaultValue();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)KEY_BOOKTYPE)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BOOKTYPE});
            String typeIdStr = this.getPageCache().get(KEY_BOOKTYPE);
            if (StringUtils.isEmpty((CharSequence)typeIdStr)) {
                return;
            }
            Map typeMap = (Map)SerializationUtils.fromJsonString((String)typeIdStr, Map.class);
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            HashSet idSet = new HashSet();
            List idList = typeMap.keySet().stream().mapToLong(s -> Long.parseLong(s)).boxed().collect(Collectors.toList());
            idSet.addAll(idList);
            listFilterParameter.setFilter(new QFilter("id", "in", idSet));
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)KEY_ORG)) {
            List pkSet = AccSysUtil.getAcctOrgPkList((String)"gl_voucher", (boolean)false, (PermissonType)PermissonType.VIEW);
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.setFilter(new QFilter("id", "in", (Object)pkSet));
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)KEY_APP)) {
            Set<String> schemeAppIds = this.getSchemeAppIds();
            if (schemeAppIds == null || schemeAppIds.isEmpty()) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u7ec4\u7ec7\u4e0b\u672a\u67e5\u8be2\u5230\u76f8\u5e94\u5bf9\u8d26\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e", (String)"BizReconciliationIndexNewPlugin_4", (String)"fi-frm-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.setFilter(new QFilter("id", "in", schemeAppIds));
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)KEY_PERIOD)) {
            DynamicObject periodType;
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            String minPeriodId = this.getPageCache().get(KEY_PERIODNUMBER);
            if (StringUtils.isNotEmpty((CharSequence)minPeriodId)) {
                qFilters.add(new QFilter("id", ">=", (Object)Long.parseLong(minPeriodId)));
            }
            if ((periodType = this.getModel().getDataEntity().getDynamicObject(KEY_PERIODTYPE)) != null) {
                Long periodTypeId = periodType.getLong("id");
                qFilters.add(new QFilter(KEY_PERIODTYPE, "=", (Object)periodTypeId));
            }
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter filterParam = showParameter.getListFilterParameter();
            filterParam.getQFilters().addAll(qFilters);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)KEY_PERIODTYPE)) {
            Set<Long> orgIds = this.getAcctOrgs();
            DynamicObject bookType = this.getModel().getDataEntity().getDynamicObject(KEY_BOOKTYPE);
            if (bookType != null) {
                Long bookTypeId = bookType.getLong("id");
                Map peroidTypeMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_PERIODTYPE), Map.class);
                HashSet<Long> periodTypeIds = new HashSet<Long>();
                for (Long orgId : orgIds) {
                    Object periodType = peroidTypeMap.get(orgId + "," + bookTypeId);
                    if (periodType == null) continue;
                    String[] split = periodType.toString().split(",");
                    periodTypeIds.add(Long.parseLong(split[0]));
                }
                QFilter periodTypeFilter = new QFilter("id", "in", periodTypeIds);
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                ListFilterParameter filterParam = showParameter.getListFilterParameter();
                filterParam.getQFilters().add(periodTypeFilter);
            }
        }
    }

    private Set<String> getSchemeAppIds() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter bakFilter = new QFilter("bak", "=", (Object)Boolean.FALSE);
        DynamicObject bookType = this.getModel().getDataEntity().getDynamicObject(KEY_BOOKTYPE);
        QFilter bookTypeFilter = null;
        if (bookType != null) {
            Long bookTypeId = bookType.getLong("id");
            bookTypeFilter = new QFilter(KEY_BOOKTYPE, "=", (Object)bookTypeId);
        }
        QFilter orgBaseDataFilter = null;
        Set<Long> acctOrgs = this.getAcctOrgs();
        if (!CollectionUtils.isEmpty(acctOrgs)) {
            orgBaseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"ai_reconciliation_scheme", new ArrayList<Long>(acctOrgs), (boolean)true);
        }
        HashSet<String> appIds = new HashSet<String>(6);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + ".getConfigSchemeAppId"), (String)"frm_reconciliation_scheme", (String)"bizapp", (QFilter[])new QFilter[]{enableFilter, bakFilter, bookTypeFilter, orgBaseDataFilter}, null);){
            for (Row row : ds) {
                appIds.add(row.getString("bizapp"));
            }
        }
        return appIds;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (KEY_ORG.equals(key)) {
            this.orgChanged();
        } else if (KEY_BOOKTYPE.equals(key)) {
            this.bookTypeChanged();
        } else if (KEY_PERIODTYPE.equals(key)) {
            this.periodTypeChanged();
        } else if (KEY_INIT.equals(key)) {
            DynamicObjectCollection orgs;
            boolean isInit = false;
            boolean enable = false;
            ChangeData[] datas = e.getChangeSet();
            if (datas != null && datas.length > 0) {
                ChangeData data = datas[0];
                isInit = (Boolean)data.getNewValue();
            }
            if (!isInit && (orgs = (DynamicObjectCollection)this.getModel().getValue(KEY_ORG)) != null && !orgs.isEmpty()) {
                enable = true;
            }
            this.getView().setVisible(Boolean.valueOf(enable), new String[]{KEY_PERIOD});
        }
        if (((Boolean)this.getModel().getValue(KEY_INIT)).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PERIOD, KEY_PERIODTYPE});
            this.resetInitPeriodId();
        }
    }

    private void viewControl(int changeProp, Map<Long, Set<Long>> bookTypeMap, Set<Long> periodTypeSet, Set<Long> periods) {
        this.clearField(changeProp);
    }

    private void orgChanged() {
        this.getModel().setValue(KEY_PERIODTYPE, null);
        this.getModel().setValue(KEY_PERIOD, null);
        this.getModel().setValue(KEY_BOOKTYPE, null);
        Set<Long> acctOrgs = this.getAcctOrgs();
        this.storeParam(acctOrgs, KEY_ORG);
        this.getView().setEnable(Boolean.valueOf(acctOrgs.size() != 0), new String[]{KEY_PERIOD});
        QFilter idFilter = new QFilter("org", "in", acctOrgs);
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection acctBooks = this.getAccBook(idFilter.and(statusFilter));
        HashMap<String, String> periodTypeMap = new HashMap<String, String>(acctBooks.size());
        HashMap<Long, Set<Long>> bookTypeMap = new HashMap<Long, Set<Long>>(acctBooks.size());
        HashMap<Long, Long> bookTypePeriodMap = new HashMap<Long, Long>(acctBooks.size());
        Long mainBookTypeId = null;
        HashSet<Long> periods = new HashSet<Long>();
        HashSet<Long> periodTypeSet = new HashSet<Long>();
        Long startPeriodId = 0L;
        Long minPeriodId = 0L;
        for (DynamicObject acctBook : acctBooks) {
            Long bookstype = acctBook.getLong("bookstype.id");
            Long orgId = acctBook.getLong("org.id");
            Long periodType = acctBook.getLong("periodtype.id");
            Long curPeriod = acctBook.getLong("curperiod.id");
            startPeriodId = acctBook.getLong("startperiod.id");
            if (startPeriodId != null && startPeriodId > 0L && (minPeriodId == 0L || startPeriodId < minPeriodId)) {
                minPeriodId = startPeriodId;
            }
            bookTypeMap.computeIfAbsent(bookstype, k -> new HashSet()).add(orgId);
            String accountType = acctBook.getString("bookstype.accounttype");
            if ("1".equals(accountType)) {
                mainBookTypeId = bookstype;
            }
            bookTypePeriodMap.put(bookstype, curPeriod);
            periods.add(curPeriod);
            periodTypeSet.add(periodType);
            periodTypeMap.put(orgId + "," + bookstype, periodType + "," + curPeriod);
        }
        this.getPageCache().put(KEY_PERIODTYPE, SerializationUtils.toJsonString(periodTypeMap));
        this.getPageCache().put(KEY_BOOKTYPE, SerializationUtils.toJsonString(bookTypeMap));
        this.getPageCache().put(KEY_PERIOD, SerializationUtils.toJsonString(periods));
        this.resetPageCache(KEY_PERIODNUMBER, Long.toString(minPeriodId));
        this.viewControl(3, bookTypeMap, periodTypeSet, periods);
        Long periodId = null;
        if (bookTypeMap.size() == 1) {
            Long bookTypeId = bookTypeMap.keySet().toArray(new Long[0])[0];
            this.getModel().setValue(KEY_BOOKTYPE, (Object)bookTypeId);
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BOOKTYPE});
            this.getPageCache().remove(KEY_BOOKTYPSIDS);
        } else if (bookTypeMap.size() > 1) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_BOOKTYPE});
            this.getPageCache().put(KEY_BOOKTYPE, SerializationUtils.toJsonString(bookTypeMap));
            Long mainBookType = null;
            for (Map.Entry bookTypeOrgEntry : bookTypeMap.entrySet()) {
                Long bookType = (Long)bookTypeOrgEntry.getKey();
                Set orgSet = (Set)bookTypeOrgEntry.getValue();
                if (orgSet.size() != acctOrgs.size() || !bookType.equals(mainBookTypeId)) continue;
                mainBookType = bookType;
            }
            if (mainBookType != null) {
                this.getModel().setValue(KEY_BOOKTYPE, mainBookType);
                periodId = (Long)bookTypePeriodMap.get(mainBookType);
            } else {
                this.getModel().setValue(KEY_BOOKTYPE, null);
            }
        }
        HashSet<Long> periodTypeIds = new HashSet<Long>();
        DynamicObject bookType = this.getModel().getDataEntity().getDynamicObject(KEY_BOOKTYPE);
        if (bookType != null) {
            long bookTypeId = bookType.getLong("id");
            for (Long tmpOrgId : acctOrgs) {
                Object tmpPeriodType = periodTypeMap.get(tmpOrgId + "," + bookTypeId);
                if (tmpPeriodType == null) continue;
                String[] split = tmpPeriodType.toString().split(",");
                periodTypeIds.add(Long.parseLong(split[0]));
            }
        }
        if (periodTypeIds.size() == 1) {
            Long periodTypeId = periodTypeSet.toArray(new Long[0])[0];
            this.getModel().setValue(KEY_PERIODTYPE, (Object)periodTypeId);
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PERIODTYPE});
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_PERIOD});
            if (periodId == null) {
                periodId = periods.toArray(new Long[0])[0];
            }
            this.getModel().setValue(KEY_PERIOD, (Object)periodId);
        } else {
            this.getModel().setValue(KEY_PERIODTYPE, null);
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_PERIODTYPE});
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_PERIODTYPE, KEY_PERIOD});
        }
    }

    private void bookTypeChanged() {
        DynamicObject bookType = this.getModel().getDataEntity().getDynamicObject(KEY_BOOKTYPE);
        if (bookType != null) {
            Long bookTypeId = bookType.getLong("id");
            Map peroidTypeMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_PERIODTYPE), Map.class);
            Set<Long> acctOrgs = this.getAcctOrgs();
            QFilter bookTypeIdFilter = new QFilter("bookstype", "=", (Object)bookTypeId);
            QFilter idFilter = new QFilter("org", "in", acctOrgs);
            QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
            DynamicObjectCollection acctBooks = this.getAccBook(bookTypeIdFilter.and(idFilter).and(statusFilter));
            Long minPeriodId = 0L;
            Long startPeriodId = 0L;
            for (DynamicObject dyAcct : acctBooks) {
                startPeriodId = dyAcct.getLong("startperiod.id");
                if (startPeriodId == null || startPeriodId <= 0L || minPeriodId != 0L && startPeriodId >= minPeriodId) continue;
                minPeriodId = startPeriodId;
            }
            this.resetPageCache(KEY_PERIODNUMBER, Long.toString(minPeriodId));
            HashSet<Long> orgIds = new HashSet<Long>();
            HashSet<Long> periodTypeIds = new HashSet<Long>();
            HashSet<Long> periodIds = new HashSet<Long>();
            for (Long orgId : acctOrgs) {
                Object periodType = peroidTypeMap.get(orgId + "," + bookTypeId);
                if (periodType == null) continue;
                orgIds.add(orgId);
                String[] split = periodType.toString().split(",");
                periodTypeIds.add(Long.parseLong(split[0]));
                if (StringUtils.equals((CharSequence)"0", (CharSequence)split[1])) continue;
                periodIds.add(Long.parseLong(split[1]));
            }
            this.storeParam(orgIds, KEY_ORG);
            if (periodTypeIds.size() == 1) {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PERIODTYPE});
                this.getModel().setValue(KEY_PERIODTYPE, periodTypeIds.iterator().next());
                if (periodIds.size() > 0) {
                    this.getModel().setValue(KEY_PERIOD, (Object)this.getMaxPeriod(periodIds));
                    this.getView().setVisible(Boolean.TRUE, new String[]{KEY_PERIOD});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{KEY_PERIOD});
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PERIODTYPE});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_PERIODTYPE});
                this.getModel().setValue(KEY_PERIODTYPE, null);
                this.getModel().setValue(KEY_PERIOD, null);
                this.getView().setEnable(Boolean.FALSE, new String[]{KEY_PERIOD});
            }
        }
    }

    private void periodTypeChanged() {
        DynamicObject periodType = this.getModel().getDataEntity().getDynamicObject(KEY_PERIODTYPE);
        if (periodType != null) {
            Long periodTypeId = periodType.getLong("id");
            DynamicObject bookType = this.getModel().getDataEntity().getDynamicObject(KEY_BOOKTYPE);
            if (bookType == null) {
                return;
            }
            Long bookTypeId = bookType.getLong("id");
            Map peroidTypeMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(KEY_PERIODTYPE), Map.class);
            Set<Long> acctOrgs = this.getAcctOrgs();
            HashSet<Long> orgIds = new HashSet<Long>();
            HashSet<Long> periodIds = new HashSet<Long>();
            for (Long orgId : acctOrgs) {
                Object tempPeriodType = peroidTypeMap.get(orgId + "," + bookTypeId);
                if (tempPeriodType == null) continue;
                String[] split = tempPeriodType.toString().split(",");
                if (!StringUtils.equals((CharSequence)String.valueOf(periodTypeId), (CharSequence)split[0])) continue;
                orgIds.add(orgId);
                if (StringUtils.equalsIgnoreCase((CharSequence)"0", (CharSequence)split[1])) continue;
                periodIds.add(Long.parseLong(split[1]));
            }
            if (periodIds.size() > 0) {
                this.getModel().setValue(KEY_PERIOD, (Object)this.getMaxPeriod(periodIds));
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PERIOD});
            }
            this.storeParam(orgIds, KEY_ORG);
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_PERIOD});
        }
    }

    private void clearField(int changeProp) {
        if (changeProp > 2) {
            this.getModel().setValue(KEY_BOOKTYPE, null);
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_PERIODTYPE, KEY_BOOKTYPE});
        }
        if (changeProp > 1) {
            this.getModel().setValue(KEY_PERIODTYPE, null);
        }
        if (changeProp > 0) {
            this.getModel().setValue(KEY_PERIOD, null);
        }
    }

    private Long getMaxPeriod(Set<Long> ids) {
        Long maxPeriodId = 0L;
        QFilter qfilter = new QFilter("id", "in", ids);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"max_period", (String)"bd_period", (String)"id", (QFilter[])new QFilter[]{qfilter}, (String)"begindate desc");
        Iterator childIte = dataSet.iterator();
        if (childIte.hasNext()) {
            maxPeriodId = ((Row)childIte.next()).getLong("id");
            dataSet.close();
        }
        return maxPeriodId;
    }

    private void storeParam(Object value, String type) {
        ReconciliationParamModel param = this.getParamModel();
        switch (type) {
            case "orgs": {
                param.setOrgIds((Set)value);
            }
        }
        this.getPageCache().put(MODEL, SerializationUtils.toJsonString((Object)param));
        this.calculateAcctOrgCount(param);
    }

    private void calculateAcctOrgCount(ReconciliationParamModel param) {
        int size = 0;
        size = param.getOrgIds().size();
        ((Label)this.getControl("total")).setText(size + this.getHomeSuffix());
    }

    private ReconciliationParamModel getParamModel() {
        ReconciliationParamModel paramModel = null;
        if (this.getPageCache().get(MODEL) == null) {
            paramModel = new ReconciliationParamModel();
            this.getPageCache().put(MODEL, SerializationUtils.toJsonString((Object)paramModel));
        } else {
            paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)this.getPageCache().get(MODEL), ReconciliationParamModel.class);
        }
        return paramModel;
    }

    private DynamicObjectCollection getAccBook(QFilter filter) {
        QFilter[] filters = filter == null ? null : filter.toArray();
        String acctorgSelectFields = "org.id, org.name, bookstype.id, bookstype.accounttype, periodtype.id, curperiod.id, curperiod.number,startperiod.id,startperiod.number";
        return QueryServiceHelper.query((String)ENTITY_GL_ACCOUNTBOOK, (String)acctorgSelectFields, (QFilter[])filters);
    }

    private void resetPageCache(String key, String value) {
        this.getPageCache().remove(key);
        this.getPageCache().put(key, value);
    }

    private void resetInitPeriodId() {
        DynamicObject bookType;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        Set<Long> acctOrgs = this.getAcctOrgs();
        if (acctOrgs.size() > 0) {
            QFilter idFilter = new QFilter("org", "in", acctOrgs);
            filters.add(idFilter);
        }
        if ((bookType = this.getModel().getDataEntity().getDynamicObject(KEY_BOOKTYPE)) != null) {
            QFilter booksTypeFilter = new QFilter("bookstype", "=", (Object)bookType.getLong("id"));
            filters.add(booksTypeFilter);
        }
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        QFilter endInitFilter = new QFilter("isendinit", "=", (Object)"1");
        filters.add(statusFilter);
        filters.add(endInitFilter);
        QFilter[] filterArr = new QFilter[filters.size()];
        filters.toArray(filterArr);
        String acctorgSelectFields = "startperiod.id";
        Long maxPeriodId = 0L;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass() + ".getInitPeriod"), (String)ENTITY_GL_ACCOUNTBOOK, (String)acctorgSelectFields, (QFilter[])filterArr, null);){
            Iterator iter = ds.iterator();
            Row row = null;
            while (iter.hasNext()) {
                row = (Row)iter.next();
                Long periodId = row.getLong(acctorgSelectFields);
                if (periodId <= maxPeriodId) continue;
                maxPeriodId = periodId;
            }
        }
        this.getModel().setValue(KEY_PERIOD, (Object)maxPeriodId);
    }

    private String getHomeSuffix() {
        if (Lang.get().equals((Object)Lang.zh_CN) || Lang.get().equals((Object)Lang.zh_TW)) {
            return ResManager.loadKDString((String)"\u5bb6", (String)"BizReconciliationIndexNewPlugin_5", (String)"fi-frm-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private Set<Long> getAcctOrgs() {
        HashSet<Long> acctOrgs = new HashSet<Long>(16);
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(KEY_ORG);
        if (orgs != null && orgs.size() > 0) {
            for (DynamicObject org : orgs) {
                acctOrgs.add(((DynamicObject)org.get("fbasedataid")).getLong("id"));
            }
        }
        return acctOrgs;
    }
}

