/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.frm.common.util.ThrowableHelper;
import kd.fi.frm.formplugin.util.ExportDataSetUtil;

public class DataSetViewerFormPlugin
extends AbstractFormPlugin {
    private static final String BAR_EXEC = "exec";
    private static final String KSQL_TEXT = "ksqltext";
    private static final String TABLE_KEY_ENTRYENTITY = "entryentity";
    private static final String FSEQ_NAME = "fseq";
    private static final int PAGE_ROW = 50;
    private static final String EXPR_DATE_REGEX = "DATE\\('(.+?)'\\)";
    private static final Pattern EXPR_DATE_PATTERN = Pattern.compile("DATE\\('(.+?)'\\)");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BAR_EXEC, "help"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (BAR_EXEC.equals(key)) {
            this.exec();
        } else if ("help".equals(key)) {
            this.help();
        }
    }

    private void help() {
        Object function = this.getModel().getValue("function");
        if ("view".equals(function) || "export".equals(function)) {
            this.viewHelp();
        }
    }

    private void viewHelp() {
        StringBuilder sb = new StringBuilder();
        sb.append("{[\"dataSetName\":\"xx\",]\"entityName\":\"xx\",\"selectFields\":\"xx,xx\",\"filters\":\"[xx, xx, xx=DATE('xx')]\"[,\"orderBys\":\"xx\",\"top\":-1]}").append("<br>");
        sb.append("{\"type\":\"groupBy\", \"src\":\"xxx\", \"dest\":\"yyy\", \"dim\":\"xxx,xxxx\", \"sum\":\"xxx,xxxx\"}").append("<br>");
        sb.append("{\"type\":\"join\", \"first\":\"xxx\", \"second\":\"xxxx\", \"dest\":\"yyy\", \"joinType\":\"InnerJoin|LeftJoin|RightJoin|FullJoin|CrossJoin\", \"on\":\"xx,xx;xx,xx\"[, \"select\":\"xx,xx\"]}").append("<br>");
        sb.append("{\"type\":\"filter\",\"src\":\"xx\",\"dest\":\"xx\",\"filter\":\"xx\"[,\"select\":\"xx\"]}").append("<br>");
        sb.append("{\"type\":\"select\",\"src\":\"xx\",\"dest\":\"xx\",\"select\":\"xx\"}").append("<br>");
        sb.append("{\"type\":\"union\",\"dest\":\"xx\",\"dataSetNames\":\"xx,xx,xx,...\"}").append("<br>");
        sb.append("{\"type\":\"copy\",\"src\":\"xx\",\"dest\":\"xx\"}").append("<br>");
        this.getView().showMessage(sb.toString());
    }

    private void exec() {
        Object function = this.getModel().getValue("function");
        if ("view".equals(function)) {
            this.view();
        } else if ("export".equals(function)) {
            this.export();
        } else if ("viewsysparam".equals(function)) {
            this.viewsysparam();
        }
    }

    private void viewsysparam() {
        CodeEdit sqlEditor = (CodeEdit)this.getControl(KSQL_TEXT);
        String paramName = sqlEditor.getText();
        String property = System.getProperty(paramName, "not setted");
        this.getView().showTipNotification(property);
    }

    private void export() {
        this.calcDataSet(this::exportDataSet);
    }

    private void exportDataSet(DataSet ds) {
        ExportDataSetUtil.export(ds, this.getView());
    }

    private void view() {
        this.calcDataSet(this::showDataSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcDataSet(Consumer<DataSet> fn) {
        CodeEdit sqlEditor = (CodeEdit)this.getControl(KSQL_TEXT);
        String bigtext = sqlEditor.getText();
        String[] lines = bigtext.split("\n");
        if (lines.length == 1) {
            String line = lines[0];
            Map params = (Map)SerializationUtils.fromJsonString((String)line, Map.class);
            try (DataSet ds = this.getDataSet(params);){
                fn.accept(ds);
            }
        } else {
            HashMap<String, DataSet> dataSetMap = new HashMap<String, DataSet>();
            ArrayList<DataSet> allDataSet = new ArrayList<DataSet>();
            ArrayList<Map> operateLst = new ArrayList<Map>();
            for (String line : lines) {
                Map params = (Map)SerializationUtils.fromJsonString((String)line, Map.class);
                String dataSetName = (String)params.get("dataSetName");
                if (dataSetName != null) {
                    dataSetMap.put(dataSetName, this.getDataSet(params));
                    continue;
                }
                operateLst.add(params);
            }
            for (Map operateParam : operateLst) {
                DataSet dest;
                DataSet srcDs;
                String src;
                String type = (String)operateParam.get("type");
                if ("groupBy".equals(type)) {
                    String[] sumArr;
                    src = (String)operateParam.get("src");
                    srcDs = (DataSet)dataSetMap.get(src);
                    GroupbyDataSet groupByDs = srcDs.groupBy(((String)operateParam.get("dim")).split(","));
                    for (String sum : sumArr = ((String)operateParam.get("sum")).split(",")) {
                        groupByDs = groupByDs.sum(sum);
                    }
                    DataSet dest2 = groupByDs.finish();
                    dataSetMap.put((String)operateParam.get("dest"), dest2);
                    allDataSet.add(dest2);
                    continue;
                }
                if ("join".equals(type)) {
                    DataSet first = (DataSet)dataSetMap.get(operateParam.get("first"));
                    DataSet second = (DataSet)dataSetMap.get(operateParam.get("second"));
                    String[] onArr = ((String)operateParam.get("on")).split(";");
                    JoinDataSet join = first.join(second, this.getJoinType(operateParam));
                    for (String on : onArr) {
                        String[] split = on.split(",");
                        join = join.on(split[0], split[1]);
                    }
                    String select = (String)operateParam.get("select");
                    DataSet dest3 = select != null ? join.select(select.split(",")).finish() : join.finish();
                    dataSetMap.put((String)operateParam.get("dest"), dest3);
                    allDataSet.add(dest3);
                    continue;
                }
                if ("filter".equals(type)) {
                    src = (String)operateParam.get("src");
                    srcDs = (DataSet)dataSetMap.get(src);
                    dest = srcDs.filter((String)operateParam.get("filter"));
                    String select = (String)operateParam.get("select");
                    if (select != null) {
                        dest = dest.select(select.split(","));
                    }
                    dataSetMap.put((String)operateParam.get("dest"), dest);
                    allDataSet.add(dest);
                    continue;
                }
                if ("select".equals(type)) {
                    src = (String)operateParam.get("src");
                    srcDs = (DataSet)dataSetMap.get(src);
                    dest = srcDs.select(((String)operateParam.get("select")).split(","));
                    dataSetMap.put((String)operateParam.get("dest"), dest);
                    allDataSet.add(dest);
                    continue;
                }
                if ("union".equals(type)) {
                    DataSet dataSetNameArr;
                    DataSet dest4 = null;
                    for (DataSet dataSetName : dataSetNameArr = ((String)operateParam.get("dataSetNames")).split(",")) {
                        if (dest4 == null) {
                            dest4 = (DataSet)dataSetMap.get(dataSetName);
                            continue;
                        }
                        DataSet dest1 = dest4.union((DataSet)dataSetMap.get(dataSetName));
                        dest4.close();
                        dest4 = dest1;
                    }
                    dataSetMap.put((String)operateParam.get("dest"), dest4);
                    allDataSet.add(dest4);
                    continue;
                }
                if (!"copy".equals(type)) continue;
                src = (String)operateParam.get("src");
                srcDs = (DataSet)dataSetMap.get(src);
                dest = srcDs.copy();
                dataSetMap.put((String)operateParam.get("dest"), dest);
                allDataSet.add(dest);
            }
            Object last = ((Map)operateLst.get(operateLst.size() - 1)).get("dest");
            DataSet lastDs = (DataSet)dataSetMap.get(last);
            fn.accept(lastDs);
            for (DataSet ds : allDataSet) {
                ds.close();
            }
        }
    }

    private void showDataSet(DataSet ds) {
        Field[] fields = ds.getRowMeta().getFields();
        this.createGrid(fields);
        ArrayList<List<Object>> datas = new ArrayList<List<Object>>(200);
        int limit = 666;
        int i = 1;
        for (Row row : ds) {
            if (i > limit) break;
            ArrayList<Object> data = new ArrayList<Object>(fields.length);
            data.add(i);
            data.add(i);
            for (Field field : fields) {
                Object value = row.get(field.getName());
                if (value != null) {
                    value = value.toString();
                }
                data.add(value);
            }
            datas.add(data);
            ++i;
        }
        this.setGridData(fields, datas);
    }

    private JoinType getJoinType(Map<String, String> operateParam) {
        String joinType = operateParam.get("joinType");
        if (JoinType.INNER.getName().equals(joinType)) {
            return JoinType.INNER;
        }
        if (JoinType.LEFT.getName().equals(joinType)) {
            return JoinType.LEFT;
        }
        if (JoinType.RIGHT.getName().equals(joinType)) {
            return JoinType.RIGHT;
        }
        if (JoinType.FULL.getName().equals(joinType)) {
            return JoinType.FULL;
        }
        if (JoinType.CROSS.getName().equals(joinType)) {
            return JoinType.CROSS;
        }
        return null;
    }

    private DataSet getDataSet(Map<String, String> params) {
        String algoKey = params.get("algoKey");
        if (algoKey == null) {
            algoKey = ((Object)((Object)this)).getClass().getName();
        }
        String entityName = params.get("entityName");
        String selectFields = params.get("selectFields");
        QFilter[] filters = this.getQFilterArr(params.get("filters"));
        String orderBys = params.get("orderBys");
        int top = -1;
        if (params.get("top") != null) {
            top = Integer.parseInt(params.get("top"));
        }
        DataSet ds = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)selectFields, (QFilter[])filters, (String)orderBys, (int)top);
        return ds;
    }

    private void setGridData(Field[] fields, List<List<Object>> datas) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("dataindex", this.getDataIndex(fields));
        data.put("rows", datas);
        data.put("datacount", datas.size());
        data.put("isSelectedAll", Boolean.FALSE);
        data.put("isSplitPage", Boolean.FALSE);
        data.put("pagerows", 50);
        data.put("pageindex", 1);
        int pageCount = this.getPageCount(50, datas.size());
        data.put("pagecount", pageCount);
        data.put("realPageCount", pageCount);
        data.put("rowcount", 50);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setEntryProperty(TABLE_KEY_ENTRYENTITY, "data", data);
    }

    private int getPageCount(int pageRow, int total) {
        int pageCount = 0;
        pageCount = total / pageRow;
        if (total / pageRow > pageCount) {
            ++pageCount;
        }
        if (pageCount < 0) {
            pageCount = 0;
        }
        return pageCount;
    }

    private Object getDataIndex(Field[] fields) {
        LinkedHashMap<String, Integer> dataIndex = new LinkedHashMap<String, Integer>(2 + fields.length);
        dataIndex.put("rk", 0);
        dataIndex.put(FSEQ_NAME, 1);
        for (int i = 0; i < fields.length; ++i) {
            dataIndex.put(fields[i].getName().toLowerCase().replace(".", "\u00b7"), i + 2);
        }
        return dataIndex;
    }

    private List<Map<String, Object>> createColumns(Field[] fields) {
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>(2 + fields.length);
        cols.add(this.genRKColumn());
        cols.add(this.genSeqColumn());
        for (Field field : fields) {
            cols.add(this.createColumn(field));
        }
        return cols;
    }

    private void createGrid(Field[] fields) {
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("key", TABLE_KEY_ENTRYENTITY);
        meta.put("methodname", "createGridColumns");
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("rk", "rk");
        args.put("seq", FSEQ_NAME);
        args.put("columns", this.createColumns(fields));
        meta.put("args", new Map[]{args});
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("InvokeControlMethod", meta);
    }

    private Map<String, Object> genSeqColumn() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataIndex", FSEQ_NAME);
        map.put("header", new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"DataSetViewerFormPlugin_0", (String)"fi-frm-formplugin", (Object[])new Object[0])));
        map.put("isColPageFixed", Boolean.TRUE);
        map.put("type", "numberfield");
        map.put("width", 100);
        return map;
    }

    private Map<String, Object> genRKColumn() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataIndex", "rk");
        map.put("header", new LocaleString("rk"));
        map.put("visible", Boolean.FALSE);
        map.put("width", "50");
        return map;
    }

    private Map<String, Object> createColumn(Field field) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String fieldName = field.getName().toLowerCase();
        fieldName = fieldName.replace(".", "\u00b7");
        map.put("dataIndex", fieldName);
        map.put("header", fieldName);
        map.put("visible", true);
        return map;
    }

    private QFilter[] getQFilterArr(String str) {
        str = str.substring(1, str.length() - 1);
        String[] split = str.split(", ");
        ArrayList<QFilter> filterLst = new ArrayList<QFilter>();
        for (String expr : split) {
            if (expr == null || "null".equals(expr)) continue;
            List<Date> dateLst = this.handleExprContainsDate(expr);
            if (!dateLst.isEmpty()) {
                expr = expr.replaceAll(EXPR_DATE_REGEX, "?");
                filterLst.add(QFilter.of((String)expr, (Object[])dateLst.toArray()));
                continue;
            }
            filterLst.add(QFilter.of((String)expr, (Object[])new Object[0]));
        }
        return filterLst.toArray(new QFilter[0]);
    }

    private List<Date> handleExprContainsDate(String expr) {
        Matcher m = EXPR_DATE_PATTERN.matcher(expr);
        ArrayList<Date> dateLst = new ArrayList<Date>();
        while (m.find()) {
            try {
                String dateStr = m.group(1);
                if (dateStr.contains(":")) {
                    dateLst.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateStr));
                    continue;
                }
                dateLst.add(new SimpleDateFormat("yyyy-MM-dd").parse(dateStr));
            }
            catch (ParseException e) {
                throw new KDException(ThrowableHelper.toString((Exception)e));
            }
        }
        return dateLst;
    }
}

