/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.ai.function.DapFunctionTypes;
import kd.fi.frm.common.enums.AssistDataType;
import kd.fi.frm.common.model.Expression;
import kd.fi.frm.common.model.ReturnData;
import kd.fi.frm.common.model.mulassist.MulassistArgs;
import kd.fi.frm.common.model.mulassist.MulassistConfigModel;
import kd.fi.frm.common.util.EntityFieldTreeOption;
import kd.fi.frm.common.util.EntityFieldTreeResult;
import kd.fi.frm.common.util.EntityTreeUtil;
import kd.fi.frm.common.util.ExpressionType;
import kd.fi.frm.formplugin.DSField;

public class FrmBizAssistFormPlugin
extends AbstractFormPlugin {
    private static final String BIZ_ASSIST_ENTRY = "entryentity";
    private static final String BIZ_RECON_ASSIST = "bizreconassist";
    private static final String BIZ_ASSIST_CONDITION_DESC = "conditiondesc";
    private static final String BIZ_ASSIST_CONDITION = "condition";
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    public static final int MAX_DESC_LENGTH = 1000;
    public static final String EXPRESSION = "exprTran";
    private static final String NON_FIELDS = "nonFields";
    public static final String BIZ_ASSIST_DATA = "bizSelectableDim";
    public static final String BIZ_ASSIST_ENTRY_DATA = "selectedAssist";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BIZ_ASSIST_CONDITION_DESC, BTN_OK, BTN_CANCEL});
        this.getView().addCustomControls(new String[]{BIZ_ASSIST_ENTRY});
    }

    public void afterCreateNewData(EventObject e) {
        String selectableAssistStr = (String)this.getView().getFormShowParameter().getCustomParams().get(BIZ_ASSIST_DATA);
        Set selectableAssist = new HashSet(0);
        if (StringUtils.isNotEmpty((CharSequence)selectableAssistStr)) {
            selectableAssist = (Set)SerializationUtils.deSerializeFromBase64((String)selectableAssistStr);
        }
        if (CollectionUtils.isEmpty(selectableAssist)) {
            return;
        }
        String selectedAssistStr = (String)this.getView().getFormShowParameter().getCustomParams().get(BIZ_ASSIST_ENTRY_DATA);
        List selectedAssist = (List)SerializationUtils.deSerializeFromBase64((String)selectedAssistStr);
        HashMap<String, DSField> cacheAllAssist = new HashMap<String, DSField>(selectableAssist.size(), 1.0f);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(selectableAssist.size());
        for (String assistKey : selectableAssist) {
            String[] splitKey = assistKey.split("\\.");
            String bdtype = splitKey[0];
            String entityId = splitKey[1];
            ComboItem item = new ComboItem();
            item.setId(assistKey);
            item.setValue(assistKey);
            DSField field = new DSField();
            field.setEntityId(entityId);
            field.setDataType(bdtype);
            if (AssistDataType.isBaseDataType((String)bdtype)) {
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
                if (dataEntityType == null) continue;
                item.setCaption(dataEntityType.getDisplayName());
                field.setFieldName(dataEntityType.getDisplayName());
                field.setFieldValue(entityId);
            } else if (AssistDataType.isAssistantDataType((String)bdtype)) {
                DynamicObject assistGroup = BusinessDataServiceHelper.loadSingle((String)"bos_assistantdatagroup", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(entityId))});
                if (assistGroup == null) continue;
                LocaleString name = new LocaleString(assistGroup.getString("name"));
                item.setCaption(name);
                field.setFieldName(name);
                field.setFieldValue(assistGroup.getString("number"));
            }
            cacheAllAssist.put(assistKey, field);
            items.add(item);
        }
        this.getPageCache().put(BIZ_ASSIST_DATA, SerializationUtils.serializeToBase64(cacheAllAssist));
        ComboEdit assistCombo = (ComboEdit)this.getControl(BIZ_RECON_ASSIST);
        assistCombo.setComboItems(items);
        if (!CollectionUtils.isEmpty((Collection)selectedAssist)) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
            int rowIndex = 0;
            for (DSField assist : selectedAssist) {
                String comboId = assist.getDataType() + "." + assist.getEntityId();
                String conditionTag = assist.getFieldKey();
                tableValueSetter.set(BIZ_RECON_ASSIST, (Object)comboId, rowIndex);
                tableValueSetter.set(BIZ_ASSIST_CONDITION, (Object)conditionTag, rowIndex);
                if (StringUtils.isNotEmpty((CharSequence)conditionTag)) {
                    tableValueSetter.set(BIZ_ASSIST_CONDITION_DESC, (Object)String.valueOf(JSONObject.parseObject((String)conditionTag).get((Object)EXPRESSION)), rowIndex);
                }
                ++rowIndex;
            }
            model.batchCreateNewEntryRow(BIZ_ASSIST_ENTRY, tableValueSetter);
            model.endInit();
            this.getView().updateView(BIZ_ASSIST_ENTRY);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (BIZ_ASSIST_CONDITION_DESC.equals(key)) {
            int index = this.getModel().getEntryCurrentRowIndex(BIZ_ASSIST_ENTRY);
            this.fillFields(BIZ_ASSIST_CONDITION, ExpressionType.Condition, false, null);
            this.showConditionForm(index, BIZ_ASSIST_CONDITION, this.getPageCache().get(BIZ_ASSIST_CONDITION));
        }
        if (BTN_OK.equals(key)) {
            this.passBizAssistConfig();
        }
        if (BTN_CANCEL.equals(key)) {
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object data = e.getReturnData();
        if (data == null) {
            return;
        }
        if (BIZ_ASSIST_CONDITION.equals(e.getActionId())) {
            this.receiveExpressionSet(e, BIZ_ASSIST_ENTRY, BIZ_ASSIST_CONDITION, BIZ_ASSIST_CONDITION_DESC);
        }
    }

    private void passBizAssistConfig() {
        int rowCount = this.getModel().getEntryRowCount(BIZ_ASSIST_ENTRY);
        ArrayList<MulassistConfigModel> list = new ArrayList<MulassistConfigModel>(6);
        StringBuilder stringBuilder = new StringBuilder();
        Map assistKeyMap = new HashMap(0);
        String cacheAssistData = this.getPageCache().get(BIZ_ASSIST_DATA);
        if (StringUtils.isNotEmpty((CharSequence)cacheAssistData)) {
            assistKeyMap = (Map)SerializationUtils.deSerializeFromBase64((String)cacheAssistData);
        }
        HashSet<String> validateNumber = new HashSet<String>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            MulassistConfigModel mulassistConfigModel = new MulassistConfigModel();
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(BIZ_ASSIST_ENTRY, i);
            String rowAssistEntity = entryRowEntity.getString(BIZ_RECON_ASSIST);
            if (StringUtils.isEmpty((CharSequence)rowAssistEntity)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u672a\u586b\u5199\u4e1a\u52a1\u7ef4\u5ea6\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u6216\u5220\u9664\u8be5\u884c\u3002", (String)"FrmBizAssistFormPlugin_1", (String)"fi-frm-formplugin", (Object[])new Object[0]), i + 1));
            }
            if (validateNumber.contains(rowAssistEntity)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8d26\u7ef4\u5ea6\u4e0d\u80fd\u91cd\u590d\u914d\u7f6e\uff0c\u8bf7\u5220\u9664\u91cd\u590d\u914d\u7f6e\u3002", (String)"FrmMulassistPlugin_1", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            }
            validateNumber.add(rowAssistEntity);
            DSField dsField = (DSField)assistKeyMap.get(rowAssistEntity);
            if (dsField == null) continue;
            mulassistConfigModel.setAssistId(rowAssistEntity);
            String number = String.valueOf(dsField.getFieldValue());
            String name = String.valueOf(dsField.getFieldName().getLocaleValue());
            stringBuilder.append(number).append(',').append(name);
            String conditionDesc = String.valueOf(entryRowEntity.get(BIZ_ASSIST_CONDITION_DESC));
            if (StringUtils.isNotEmpty((CharSequence)conditionDesc)) {
                stringBuilder.append('(').append(conditionDesc).append(')').append(';');
                String conditionStr = String.valueOf(entryRowEntity.get(BIZ_ASSIST_CONDITION));
                mulassistConfigModel.setConditionTag(conditionStr);
            } else {
                mulassistConfigModel.setConditionTag("");
                stringBuilder.append(';');
            }
            list.add(mulassistConfigModel);
        }
        MulassistArgs mulassistArgs = new MulassistArgs();
        mulassistArgs.setList(list);
        String desc = stringBuilder.toString();
        if (desc.length() > 1000) {
            desc = desc.substring(0, 999);
        }
        mulassistArgs.setDesc(desc);
        ReturnData returnData = new ReturnData();
        returnData.setDataStr(SerializationUtils.toJsonString((Object)mulassistArgs));
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)returnData));
        this.getView().close();
    }

    private void fillFields(String key, ExpressionType type, boolean readChildEntity, Class<?> cls) {
        MainEntityType mainEntityType = this.readSrcMainEntityType();
        if (mainEntityType == null) {
            this.getPageCache().put(key, "");
        } else {
            EntityFieldTreeOption option = EntityFieldTreeOption.create();
            option.setEntityType((IDataEntityType)mainEntityType);
            option.setReadEntryEntity(readChildEntity);
            option.setExprType(type);
            option.setFieldType(cls);
            EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
            TreeNode rootNode = new TreeNode("", "root", "");
            rootNode.setIsOpened(true);
            TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
            rootNode.addChild(tree);
            String toJson = SerializationUtils.toJsonString((Object)rootNode);
            this.getPageCache().put(key, toJson);
            String nonFdStr = this.getPageCache().get(NON_FIELDS);
            result.getNonFields().add("root");
            if (nonFdStr != null) {
                Set nonSet = (Set)SerializationUtils.fromJsonString((String)nonFdStr, Set.class);
                nonSet.addAll(result.getNonFields());
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)nonSet));
            } else {
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)result.getNonFields()));
            }
        }
    }

    private void showConditionForm(int rowIndex, String sourceCtrlKey, String fieldNodes) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("frm_condition");
        String conditionJson = (String)this.getModel().getValue(sourceCtrlKey, rowIndex);
        showParameter.getCustomParams().put("formula", conditionJson);
        String entityKey = (String)this.getModel().getValue(BIZ_RECON_ASSIST, rowIndex);
        if (StringUtils.isEmpty((CharSequence)entityKey)) {
            return;
        }
        String[] splitKey = entityKey.split("\\.");
        if (AssistDataType.isBaseDataType((String)splitKey[0])) {
            showParameter.getCustomParams().put("entitynumber", splitKey[1]);
        } else {
            showParameter.getCustomParams().put("entitynumber", "bos_assistantdata_detail");
        }
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.getCustomParams().put("treeViewRootVisible", Boolean.FALSE);
        showParameter.setCustomParam(NON_FIELDS, (Object)this.getPageCache().get(NON_FIELDS));
        showParameter.getCustomParams().put("functiontypes", conditionJson);
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = DapFunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private MainEntityType readSrcMainEntityType() {
        MainEntityType mainEntityType = null;
        int index = this.getModel().getEntryCurrentRowIndex(BIZ_ASSIST_ENTRY);
        String comboVal = (String)this.getModel().getValue(BIZ_RECON_ASSIST, index);
        if (StringUtils.isEmpty((CharSequence)comboVal)) {
            return null;
        }
        String[] splitKey = comboVal.split("\\.");
        String srcFormNumber = "";
        srcFormNumber = AssistDataType.isAssistantDataType((String)splitKey[0]) ? "bos_assistantdata_detail" : splitKey[1];
        if (srcFormNumber != null) {
            mainEntityType = EntityMetadataCache.getDataEntityType((String)srcFormNumber);
        }
        return mainEntityType;
    }

    private void receiveExpressionSet(ClosedCallBackEvent closedCallBackEvent, String entityKey, String expressionFldKey, String descFldKey) {
        if (closedCallBackEvent.getReturnData() != null) {
            String str = (String)closedCallBackEvent.getReturnData();
            int row = this.getModel().getEntryCurrentRowIndex(entityKey);
            if (StringUtils.isBlank((CharSequence)str)) {
                this.getModel().setValue(expressionFldKey, (Object)"", row);
                this.getModel().setValue(descFldKey, (Object)"", row);
            } else {
                ReturnData returnData = (ReturnData)SerializationUtils.fromJsonString((String)str, ReturnData.class);
                Expression expression = (Expression)SerializationUtils.fromJsonString((String)returnData.getDataStr(), Expression.class);
                this.getModel().setValue(expressionFldKey, (Object)returnData.getDataStr(), row);
                String desp = StringUtils.isNotEmpty((CharSequence)expression.getExprTran().trim()) ? expression.getExprTran() : "";
                if (desp.length() > 1000) {
                    desp = desp.substring(0, 999);
                }
                this.getModel().setValue(descFldKey, (Object)desp, row);
            }
        }
    }
}

