/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.ConditionEdit;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.FormulaException;
import kd.fi.frm.common.model.ReturnData;
import kd.fi.frm.common.util.DapEntityTypeUtil;
import kd.fi.frm.common.util.EntityFieldUtil;
import kd.fi.frm.mservice.bizdata.CommonFilterAnalyseUtil;

public class FrmConditionEdit
extends ConditionEdit {
    public static final String TREE_VIEW_ROOT_VISIBLE = "treeViewRootVisible";
    private static final String NON_FIELDS = "nonFields";

    public void afterCreateNewData(EventObject e) {
        String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam("formula");
        CRFormula formulaObj = this.deserialize(conditonJson);
        this.setFormulaObj(formulaObj);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("hideExpression") && ((Boolean)customParams.get("hideExpression")).booleanValue()) {
            Tab tab = (Tab)this.getControl("tabap_condition");
            tab.deleteControls(new String[]{"tabpageap_expression"});
        }
        String entityNumber = (String)customParams.get("entitynumber");
        List filterColumns = (List)customParams.get("filterColumns");
        if (filterColumns == null && StringUtils.isNotBlank((CharSequence)entityNumber)) {
            MainEntityType entityType = null;
            entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            filterColumns = DapEntityTypeUtil.getFilterColumns((IDataEntityType)entityType);
        }
        if (filterColumns != null) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
            filterGrid.setFilterColumns(filterColumns);
            filterGrid.setEntityNumber(entityNumber);
        }
    }

    protected void setFormulaObj(CRFormula formulaObj) {
        this.getModel().setValue("fexpression", (Object)formulaObj.getExpression());
        this.getModel().setValue("fdescription", (Object)formulaObj.getDescription().toString());
        String tranExpr = this.tranExpression(formulaObj.getExpression());
        this.getModel().setValue("ftranexpr", (Object)tranExpr);
    }

    protected String tranExpression(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        String expressionDesc = expression;
        expressionDesc = CommonFilterAnalyseUtil.replaceFrmFunctionDesc((String)expressionDesc);
        expressionDesc = CommonFilterAnalyseUtil.dealFrmFunctionFormula((String)expressionDesc);
        String[] vars = FormulaEngine.extractVariables((String)expression);
        if (vars.length != 0 && !StringUtils.isBlank((CharSequence)vars[0])) {
            String json = (String)this.getView().getFormShowParameter().getCustomParam("treenodes");
            TreeNode rootNode = new TreeNode();
            if (StringUtils.isNotBlank((CharSequence)json)) {
                rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
            }
            ArrayList<String> orderVars = new ArrayList<String>(10);
            for (int i = 0; i < vars.length; ++i) {
                String var = vars[i];
                orderVars.add(var);
            }
            orderVars.sort((o1, o2) -> {
                if (o1.length() > o2.length()) {
                    return -1;
                }
                return o1.length() < o2.length() ? 1 : o2.compareTo((String)o1);
            });
            HashMap<String, String> tmpVariables = new HashMap<String, String>(16);
            int index = 1;
            for (String var : orderVars) {
                String string = String.format("###%s###", index);
                String varCaption = var;
                TreeNode node = rootNode.getTreeNode(var, 5);
                if (node != null) {
                    varCaption = node.getText();
                }
                tmpVariables.put(string, varCaption);
                expressionDesc = expressionDesc.replace(var, string);
                ++index;
            }
            for (Map.Entry entry : tmpVariables.entrySet()) {
                expressionDesc = expressionDesc.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
            return expressionDesc;
        }
        return expression;
    }

    public void click(EventObject evt) {
        try {
            Control ctlSource = (Control)evt.getSource();
            if ("btnok".equalsIgnoreCase(ctlSource.getKey())) {
                this.checkOutEntry();
            } else {
                super.click(evt);
            }
        }
        catch (Throwable e) {
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TreeView treeView = (TreeView)this.getControl("tv_fields");
        Boolean rootVisible = (Boolean)this.getView().getFormShowParameter().getCustomParam(TREE_VIEW_ROOT_VISIBLE);
        if (rootVisible != null) {
            treeView.setRootVisible(rootVisible.booleanValue());
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeID = e.getNodeId().toString();
        String nonFdStr = (String)this.getView().getFormShowParameter().getCustomParam(NON_FIELDS);
        if (StringUtils.isNotBlank((CharSequence)nonFdStr)) {
            Set nonSet = (Set)SerializationUtils.fromJsonString((String)nonFdStr, Set.class);
            if (!nonSet.contains(nodeID)) {
                FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)"tv_fields", (String)"fexpression", (String)nodeID);
            }
        } else {
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)"tv_fields", (String)"fexpression", (String)nodeID);
        }
    }

    private void checkOutEntry() {
        String conditonJson = "";
        CRFormula formulaObj = this.deserialize(conditonJson);
        this.getFormulaObj(formulaObj);
        try {
            String tranExpr = this.tranFormula(formulaObj);
            formulaObj.setExprTran(tranExpr);
        }
        catch (FormulaException exp) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s", (String)"FrmConditionEdit_0", (String)"bos-designer-plugin", (Object[])new Object[0]), exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage()));
            return;
        }
        catch (Throwable exp) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s", (String)"FrmConditionEdit_0", (String)"bos-designer-plugin", (Object[])new Object[0]), exp.getMessage()));
            return;
        }
        String currentFormId = (String)this.getView().getFormShowParameter().getCustomParam("ai_button_key");
        String entitynumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        String cacheValue = EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView());
        ReturnData returnData = EntityFieldUtil.validateDiffEntry((Object)formulaObj, (String)currentFormId, (String)entitynumber, (String)cacheValue);
        if (returnData.isStatus()) {
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)returnData));
            this.getView().close();
        } else if (!returnData.isStatus() && StringUtils.isNotEmpty((CharSequence)returnData.getMessage())) {
            this.getView().showTipNotification(returnData.getMessage());
        }
    }

    protected String tranFormula(CRFormula formulaObj) {
        String tranExpr = this.tranExpression(formulaObj.getExpression());
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return tranExpr;
        }
        MainEntityType mainType = null;
        mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterCondition filterCondition = ((CRCondition)formulaObj).getFilterCondition();
        if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
            FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
            String[] scripts = filterBuilder.buildFilterScript();
            ArrayList<String> descs = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)scripts[1])) {
                descs.add(scripts[1]);
            }
            if (StringUtils.isNotBlank((CharSequence)tranExpr)) {
                descs.add(tranExpr);
            }
            tranExpr = StringUtils.join((Object[])descs.toArray(), (String)ResManager.loadKDString((String)" \u4e14 ", (String)"FrmConditionEdit_1", (String)"bos-designer-plugin", (Object[])new Object[0]));
        }
        return tranExpr;
    }
}

