/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.FormulaException;
import kd.bos.lang.Lang;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.frm.common.model.ReturnData;
import kd.fi.frm.common.util.BuildTree;
import kd.fi.frm.common.util.EntityFieldUtil;
import kd.fi.frm.common.util.ExpressionType;

public class FrmFormulaEdit
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    public static final String TREE_VIEW_ROOT_VISIBLE = "treeViewRootVisible";
    public static final String CustParamKey_TreeNodes = "treenodes";
    private static final String Key_FDescription = "fdescription";
    private static final String Key_FExpression = "fexpression";
    private static final String Key_FTranExpr = "ftranexpr1";
    private static final String Key_btnOK = "btnok";
    private static final String Key_btnCancel = "btncancel";
    private static final String Key_TreeView = "tv_fields";
    private static final String BUILD = "build";
    public static final String CustParamKey_EntityNumber = "entitynumber";
    public static final String CustParamKey_FunctionTypes = "functiontypes";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_btnOK, Key_btnCancel});
        this.addClickListeners(new String[]{"btnadd", "btnsubtraction", "btnmultiplication", "btndivison", "btnequal", "btnnotequal", "btnlessthen", "btnmorethen", "btnlessequal", "btnmoreequal", "btnand", "btnor", "btnleft", "btnright", "clr"});
        TreeView tv = (TreeView)this.getView().getControl(Key_TreeView);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl("searchfield");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String str = (String)this.getView().getFormShowParameter().getCustomParam("formula");
        if (!StringUtils.isBlank((CharSequence)str)) {
            CRFormula crformula = (CRFormula)SerializationUtils.fromJsonString((String)str, CRFormula.class);
            this.getModel().setValue(Key_FExpression, (Object)crformula.getExpression());
            this.getModel().setValue(Key_FDescription, (Object)crformula.getExprDesc());
            this.afterBindData(e);
            String json = this.getPageCache().get(CustParamKey_TreeNodes);
            String tranExpr = BuildTree.tranExpression((String)crformula.getExpression(), (String)json);
            this.getModel().setValue(Key_FTranExpr, (Object)tranExpr);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String id = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_EntityNumber);
        ExpressionType expressionType = ExpressionType.valueOf((String)(this.getView().getFormShowParameter().getCustomParam("expressionType") + ""));
        TreeNode rootNode = new TreeNode();
        TreeNode rootNode_nottext = new TreeNode();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            MainEntityType srcMainET = MetadataServiceHelper.getDataEntityType((String)id);
            String onlyAmount = (String)this.getView().getFormShowParameter().getCustomParam("onlyamount");
            Class clazz = null;
            clazz = Boolean.parseBoolean(onlyAmount) ? (ExpressionType.Formula == expressionType ? AmountProp.class : null) : (ExpressionType.Formula == expressionType ? DecimalProp.class : null);
            rootNode = BuildTree.buildTree((MainEntityType)srcMainET, (String)"fexplanation", (ExpressionType)expressionType, (boolean)true, clazz, (boolean)false);
            rootNode_nottext = BuildTree.buildTree((MainEntityType)srcMainET, (String)"fexplanation", (ExpressionType)ExpressionType.Formula, (boolean)true, null, (boolean)false);
            this.getPageCache().put("treenodes_nottext", SerializationUtils.toJsonString((Object)rootNode_nottext));
        }
        this.getPageCache().put(CustParamKey_TreeNodes, SerializationUtils.toJsonString((Object)rootNode));
        TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
        tree.addNode(rootNode);
        tree.expand(rootNode.getId());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (Key_btnOK.equalsIgnoreCase(ctlSource.getKey())) {
            String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam("formula");
            CRFormula formulaObj = this.deserialize(conditonJson);
            this.getFormulaObj(formulaObj);
            try {
                if (StringUtils.isNotBlank((CharSequence)formulaObj.getExpression())) {
                    FormulaEngine.extractVariables((String)formulaObj.getExpression());
                }
                if (StringUtils.isBlank((Object)this.getModel().getValue(Key_FTranExpr))) {
                    String json = this.getPageCache().get(CustParamKey_TreeNodes);
                    String tranExpr = BuildTree.tranExpression((String)formulaObj.getExpression(), (String)json);
                    formulaObj.setExprTran(tranExpr);
                } else {
                    formulaObj.setExprTran((String)this.getModel().getValue(Key_FTranExpr));
                }
            }
            catch (FormulaException exp) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s", (String)"AiFormulaEdit_0", (String)"bos-designer-plugin", (Object[])new Object[0]), exp.getCause() != null ? exp.getCause().getMessage() : exp.getMessage()));
                return;
            }
            catch (Throwable exp) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s", (String)"AiFormulaEdit_0", (String)"bos-designer-plugin", (Object[])new Object[0]), exp.getMessage()));
                return;
            }
            String currentFormId = (String)this.getView().getFormShowParameter().getCustomParam("ai_button_key");
            String entitynumber = (String)this.getView().getFormShowParameter().getCustomParam(CustParamKey_EntityNumber);
            String cacheValue = EntityFieldUtil.getCacheValueFromFormParameter((IFormView)this.getView());
            ReturnData returnData = EntityFieldUtil.validateDiffEntry((Object)formulaObj, (String)currentFormId, (String)entitynumber, (String)cacheValue);
            if (returnData.isStatus()) {
                this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)returnData));
                this.getView().close();
            } else if (!returnData.isStatus() && StringUtils.isNotEmpty((CharSequence)returnData.getMessage())) {
                this.getView().showTipNotification(returnData.getMessage());
            }
        } else if (Key_btnCancel.equalsIgnoreCase(ctlSource.getKey())) {
            this.getPageCache().remove(CustParamKey_TreeNodes);
            this.getPageCache().remove("treenodes_nottext");
            this.getView().close();
        } else {
            this.clickCompareButton(ctlSource.getKey());
        }
    }

    protected void getFormulaObj(CRFormula formulaObj) {
        String expression = (String)this.getModel().getValue(Key_FExpression);
        formulaObj.setExpression(expression);
        String desc = (String)this.getModel().getValue(Key_FDescription);
        formulaObj.getDescription().setItem(Lang.defaultLang().toString(), (Object)desc);
    }

    protected CRFormula deserialize(String json) {
        CRFormula formulaObj = null;
        formulaObj = StringUtils.isBlank((CharSequence)json) ? new CRFormula() : (CRFormula)SerializationUtils.fromJsonString((String)json, CRFormula.class);
        return formulaObj;
    }

    public void treeNodeClick(TreeNodeEvent arg0) {
        String expression = (String)this.getModel().getValue(Key_FExpression);
        expression = expression + " " + arg0.getNodeId();
        this.getModel().setValue(Key_FExpression, (Object)expression);
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    private void clickCompareButton(String compareKey) {
        String compareValue = "";
        switch (compareKey) {
            case "btnadd": {
                compareValue = "+";
                break;
            }
            case "btnsubtraction": {
                compareValue = "-";
                break;
            }
            case "btnmultiplication": {
                compareValue = "*";
                break;
            }
            case "btndivison": {
                compareValue = "/";
                break;
            }
            case "btnequal": {
                compareValue = "==";
                break;
            }
            case "btnnotequal": {
                compareValue = "<>";
                break;
            }
            case "btnlessthen": {
                compareValue = "<";
                break;
            }
            case "btnmorethen": {
                compareValue = ">";
                break;
            }
            case "btnlessequal": {
                compareValue = "<=";
                break;
            }
            case "btnmoreequal": {
                compareValue = ">=";
                break;
            }
            case "btnand": {
                compareValue = "and";
                break;
            }
            case "btnor": {
                compareValue = "or";
                break;
            }
            case "btnleft": {
                compareValue = "(";
                break;
            }
            case "btnright": {
                compareValue = ")";
                break;
            }
            case "clr": {
                compareValue = "";
                this.getModel().setValue(Key_FExpression, (Object)"");
                break;
            }
        }
        if (!StringUtils.isBlank((CharSequence)compareValue)) {
            String expression = (String)this.getModel().getValue(Key_FExpression);
            expression = expression + " " + compareValue;
            this.getModel().setValue(Key_FExpression, (Object)expression);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equalsIgnoreCase(Key_FExpression)) {
            String expression = (String)this.getModel().getValue(Key_FExpression);
            String tranExpr = "";
            try {
                String json = this.getPageCache().get(CustParamKey_TreeNodes);
                tranExpr = BuildTree.tranExpression((String)expression, (String)json);
            }
            catch (FormulaException exp) {
                tranExpr = exp.getMessage();
            }
            catch (Throwable exp) {
                tranExpr = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u89e3\u6790\u9519\u8bef\uff0c\u81ea\u52a8\u7ffb\u8bd1\u5931\u8d25\u3002", (String)"ExpressionEdit_0", (String)"fi-frm-formplugin", (Object[])new Object[0]);
            }
            this.getModel().setValue(Key_FTranExpr, (Object)tranExpr);
        }
    }

    public void search(SearchEnterEvent evt) {
        Search search = (Search)evt.getSource();
        String json = this.getPageCache().get(CustParamKey_TreeNodes);
        if (StringUtils.equals((CharSequence)"searchfield", (CharSequence)search.getKey()) && StringUtils.isNotBlank((CharSequence)json)) {
            String searchText = evt.getText();
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
            TreeView tree = (TreeView)this.getView().getControl(Key_TreeView);
            TreeNode treeNode = BuildTree.searchTree((String)searchText, (TreeNode)rootNode);
            tree.updateNode(treeNode);
        }
    }
}

