/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.fi.ai.function.DapFunctionTypes;
import kd.fi.frm.common.enums.AssistDataType;
import kd.fi.frm.common.model.Expression;
import kd.fi.frm.common.model.ReturnData;
import kd.fi.frm.common.model.mulassist.MulassistArgs;
import kd.fi.frm.common.model.mulassist.MulassistConfigModel;
import kd.fi.frm.common.util.EntityFieldTreeOption;
import kd.fi.frm.common.util.EntityFieldTreeResult;
import kd.fi.frm.common.util.EntityTreeUtil;
import kd.fi.frm.common.util.ExpressionType;
import kd.fi.frm.common.util.ReconciliationUtil;

public class FrmMulassistPlugin
extends AbstractFormPlugin {
    private static final String MUL_ASSIST_TYPE = "mulassisttype";
    private static final String MUL_ASSIST_MAP = "assistmap";
    private static final String MUL_ASSIST_ENTRY = "entryentity";
    private static final String MUL_ASSIST_CONDITION_DESC = "conditiondesc";
    private static final String MUL_ASSIST_CONDITION = "condition";
    private static final String VALUE_SOURCE_NUMBER = "valuesource.number";
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    public static final String ASSIST_ID = "assistId";
    public static final String MUL_ASSIST_ENTRY_DATA = "entryData";
    private static final String NON_FIELDS = "nonFields";
    public static final int MAX_DESC_LENGTH = 1000;
    public static final String EXPRESSION = "exprTran";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{MUL_ASSIST_CONDITION_DESC, BTN_OK, BTN_CANCEL});
        this.getView().addCustomControls(new String[]{MUL_ASSIST_ENTRY});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit mulassist = (BasedataEdit)this.getControl(MUL_ASSIST_TYPE);
        mulassist.addBeforeF7SelectListener(evt -> {
            ListShowParameter accTablePar = (ListShowParameter)evt.getFormShowParameter();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object useOrg = formShowParameter.getCustomParams().get("useorg");
            accTablePar.setUseOrgId(Long.parseLong(String.valueOf(useOrg)));
            List filters = accTablePar.getListFilterParameter().getQFilters();
            filters.add(new QFilter("valuetype", "!=", (Object)"3"));
            List mulassistIdObj = (List)this.getView().getFormShowParameter().getCustomParams().get(ASSIST_ID);
            if (CollectionUtils.isNotEmpty((Collection)mulassistIdObj)) {
                QFilter idFilter = new QFilter("id", "in", formShowParameter.getCustomParams().get(ASSIST_ID));
                filters.add(idFilter);
            }
            int entryRowCount = this.getModel().getEntryRowCount(MUL_ASSIST_ENTRY);
            HashSet<Object> selectedMulassistIdSet = new HashSet<Object>(entryRowCount);
            DynamicObject dynamicObject = null;
            for (int i = 0; i < entryRowCount; ++i) {
                Object mulassistId;
                dynamicObject = this.getModel().getEntryRowEntity(MUL_ASSIST_ENTRY, i).getDynamicObject(MUL_ASSIST_TYPE);
                if (dynamicObject == null || (mulassistId = dynamicObject.getPkValue()) == null) continue;
                selectedMulassistIdSet.add(mulassistId);
            }
            if (selectedMulassistIdSet.size() > 0) {
                QFilter idFilter = new QFilter("id", "not in", selectedMulassistIdSet);
                filters.add(idFilter);
            }
        });
        BasedataEdit assistMapEdit = (BasedataEdit)this.getControl(MUL_ASSIST_MAP);
        assistMapEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            Object useorg = this.getView().getFormShowParameter().getCustomParam("useorg");
            if (useorg != null) {
                listShowParameter.setUseOrgId(Long.parseLong(useorg.toString()));
            }
            int rowIndex = this.getModel().getEntryCurrentRowIndex(MUL_ASSIST_ENTRY);
            DynamicObject asstType = (DynamicObject)this.getModel().getValue(MUL_ASSIST_TYPE, rowIndex);
            if (asstType == null) {
                evt.setCancel(true);
                return;
            }
            long masterid = asstType.getLong("masterid");
            filters.add(new QFilter("asstacttype.masterid", "=", (Object)masterid));
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (MUL_ASSIST_CONDITION_DESC.equals(key)) {
            int index = this.getModel().getEntryCurrentRowIndex(MUL_ASSIST_ENTRY);
            this.fillFields(MUL_ASSIST_CONDITION, ExpressionType.Condition, false, null);
            this.showConditionForm(index, MUL_ASSIST_CONDITION, this.getPageCache().get(MUL_ASSIST_CONDITION));
        }
        if (BTN_OK.equals(key)) {
            this.checkConfig();
            this.passMulassistConfig();
        }
        if (BTN_CANCEL.equals(key)) {
            this.getView().close();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(MUL_ASSIST_ENTRY);
        int rowIndex = -1;
        for (DynamicObject row : entryEntity) {
            ++rowIndex;
            Object asstType = row.get(MUL_ASSIST_TYPE);
            if (asstType != null) {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{MUL_ASSIST_MAP});
                continue;
            }
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{MUL_ASSIST_MAP});
        }
        this.getView().updateView(MUL_ASSIST_ENTRY);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (MUL_ASSIST_TYPE.equals(key)) {
            ChangeData changeData = e.getChangeSet()[0];
            int index = this.getModel().getEntryCurrentRowIndex(MUL_ASSIST_ENTRY);
            if (changeData != null) {
                this.getModel().setValue(MUL_ASSIST_MAP, null, index);
                this.getView().setEnable(Boolean.valueOf(true), index, new String[]{MUL_ASSIST_MAP});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{MUL_ASSIST_MAP});
            }
        }
    }

    private void checkConfig() {
        Long dataRuleId = (Long)this.getView().getFormShowParameter().getCustomParams().get("dataRuleId");
        List amountTypes = (List)this.getView().getFormShowParameter().getCustomParams().get("amountTypes");
        Set assistKeySet = ReconciliationUtil.getAssistKeyFromDataRule((Long)dataRuleId, (Collection)amountTypes);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(MUL_ASSIST_ENTRY);
        int asstTypeSize = entryEntity.size();
        int rowIndex = 0;
        for (DynamicObject row : entryEntity) {
            ++rowIndex;
            DynamicObject asstType = row.getDynamicObject(MUL_ASSIST_TYPE);
            if (asstType == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u672a\u586b\u5199\u6838\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u6216\u5220\u9664\u8be5\u884c\u3002", (String)"FrmMulassistPlugin_0", (String)"fi-frm-formplugin", (Object[])new Object[0]), rowIndex));
            }
            DynamicObject assisMapping = row.getDynamicObject(MUL_ASSIST_MAP);
            if (assisMapping == null) {
                String datatype;
                String entityId = AssistDataType.isBaseDataType((String)(datatype = asstType.getString("valuetype"))) ? asstType.getString(VALUE_SOURCE_NUMBER) : asstType.getString("assistanttype.id");
                String asstKey = AssistDataType.makeAssistKey((String)datatype, (String)entityId);
                if (assistKeySet.contains(asstKey)) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6838\u7b97\u7ef4\u5ea6\uff0c\u4e0d\u5728\u53d6\u6570\u89c4\u5219\u901a\u7528\u8bbe\u7f6e\u914d\u7f6e\u7684\u5bf9\u8d26\u7ef4\u5ea6\u8303\u56f4\u5185\u3002", (String)"FrmMulassistPlugin_2", (String)"fi-frm-formplugin", (Object[])new Object[0]), rowIndex));
            }
            if (asstTypeSize > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u884c\u6838\u7b97\u7ef4\u5ea6\u65f6\uff0c\u6682\u4e0d\u652f\u6301\u6838\u7b97\u7ef4\u5ea6\u6620\u5c04\u3002", (String)"FrmMulassistPlugin_4", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection bizAssistEntry = assisMapping.getDynamicObjectCollection("fieldmapentry");
            HashSet<String> mappingSet = new HashSet<String>(bizAssistEntry.size());
            for (DynamicObject assistRow : bizAssistEntry) {
                mappingSet.add(AssistDataType.makeAssistKey((String)(Integer.parseInt(assistRow.getString("datatype")) + 1 + ""), (String)assistRow.getString("entityid")));
            }
            if (assistKeySet.containsAll(mappingSet)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u6838\u7b97\u7ef4\u5ea6\u6620\u5c04\u7684\u5bf9\u8d26\u7ef4\u5ea6\u4e0d\u5728\u53d6\u6570\u89c4\u5219\u901a\u7528\u8bbe\u7f6e\u7684\u5bf9\u8d26\u7ef4\u5ea6\u8303\u56f4\u5185\u3002", (String)"FrmMulassistPlugin_3", (String)"fi-frm-formplugin", (Object[])new Object[0]), rowIndex));
        }
    }

    private void passMulassistConfig() {
        int rowCount = this.getModel().getEntryRowCount(MUL_ASSIST_ENTRY);
        ArrayList<MulassistConfigModel> list = new ArrayList<MulassistConfigModel>(6);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(MUL_ASSIST_ENTRY, i);
            DynamicObject dynamicObject = entryRowEntity.getDynamicObject(MUL_ASSIST_TYPE);
            if (dynamicObject == null) continue;
            MulassistConfigModel mulassistConfigModel = new MulassistConfigModel();
            Object pkValue = dynamicObject.getPkValue();
            String assistId = pkValue == null ? "" : String.valueOf(pkValue);
            mulassistConfigModel.setAssistId(assistId);
            DynamicObject assisMapping = entryRowEntity.getDynamicObject(MUL_ASSIST_MAP);
            if (assisMapping != null) {
                mulassistConfigModel.setAssistMapId(Long.valueOf(assisMapping.getLong("id")));
                mulassistConfigModel.setAssistMapMasterId(Long.valueOf(assisMapping.getLong("masterid")));
            }
            String number = String.valueOf(dynamicObject.get("number"));
            String name = String.valueOf(dynamicObject.get("name"));
            stringBuilder.append(number).append(',').append(name);
            String conditionDesc = String.valueOf(entryRowEntity.get(MUL_ASSIST_CONDITION_DESC));
            if (StringUtils.isNotEmpty((CharSequence)conditionDesc)) {
                stringBuilder.append('(').append(conditionDesc).append(')').append(';');
                String conditionStr = String.valueOf(entryRowEntity.get(MUL_ASSIST_CONDITION));
                mulassistConfigModel.setConditionTag(conditionStr);
            } else {
                mulassistConfigModel.setConditionTag("");
                stringBuilder.append(';');
            }
            list.add(mulassistConfigModel);
        }
        MulassistArgs mulassistArgs = new MulassistArgs();
        mulassistArgs.setList(list);
        String desc = stringBuilder.toString();
        if (desc.length() > 1000) {
            desc = desc.substring(0, 999);
        }
        mulassistArgs.setDesc(desc);
        ReturnData returnData = new ReturnData();
        returnData.setDataStr(SerializationUtils.toJsonString((Object)mulassistArgs));
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)returnData));
        this.getView().close();
    }

    private void fillFields(String key, ExpressionType type, boolean readChildEntity, Class<?> cls) {
        MainEntityType mainEntityType = this.readSrcMainEntityType();
        if (mainEntityType == null) {
            this.getPageCache().put(key, "");
        } else {
            EntityFieldTreeOption option = EntityFieldTreeOption.create();
            option.setEntityType((IDataEntityType)mainEntityType);
            option.setReadEntryEntity(readChildEntity);
            option.setExprType(type);
            option.setFieldType(cls);
            EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
            TreeNode rootNode = new TreeNode("", "root", "");
            rootNode.setIsOpened(true);
            TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
            rootNode.addChild(tree);
            String toJson = SerializationUtils.toJsonString((Object)rootNode);
            this.getPageCache().put(key, toJson);
            String nonFdStr = this.getPageCache().get(NON_FIELDS);
            result.getNonFields().add("root");
            if (nonFdStr != null) {
                Set nonSet = (Set)SerializationUtils.fromJsonString((String)nonFdStr, Set.class);
                nonSet.addAll(result.getNonFields());
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)nonSet));
            } else {
                this.getPageCache().put(NON_FIELDS, SerializationUtils.toJsonString((Object)result.getNonFields()));
            }
        }
    }

    private void showConditionForm(int rowIndex, String sourceCtrlKey, String fieldNodes) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("frm_condition");
        String conditionJson = (String)this.getModel().getValue(sourceCtrlKey, rowIndex);
        showParameter.getCustomParams().put("formula", conditionJson);
        DynamicObject sourceBill = (DynamicObject)this.getModel().getValue(MUL_ASSIST_TYPE, rowIndex);
        if (sourceBill == null) {
            return;
        }
        String srcFormNumber = (String)sourceBill.get(VALUE_SOURCE_NUMBER);
        showParameter.getCustomParams().put("entitynumber", srcFormNumber);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.getCustomParams().put("treeViewRootVisible", Boolean.FALSE);
        showParameter.setCustomParam(NON_FIELDS, (Object)this.getPageCache().get(NON_FIELDS));
        showParameter.getCustomParams().put("functiontypes", conditionJson);
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = DapFunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private MainEntityType readSrcMainEntityType() {
        MainEntityType mainEntityType = null;
        int index = this.getModel().getEntryCurrentRowIndex(MUL_ASSIST_ENTRY);
        DynamicObject sourceBill = (DynamicObject)this.getModel().getValue(MUL_ASSIST_TYPE, index);
        if (sourceBill != null) {
            String srcFormNumber = (String)sourceBill.get(VALUE_SOURCE_NUMBER);
            mainEntityType = EntityMetadataCache.getDataEntityType((String)srcFormNumber);
        }
        return mainEntityType;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object data = e.getReturnData();
        if (data == null) {
            return;
        }
        if (MUL_ASSIST_CONDITION.equals(e.getActionId())) {
            this.receiveExpressionSet(e, MUL_ASSIST_ENTRY, MUL_ASSIST_CONDITION, MUL_ASSIST_CONDITION_DESC);
        }
    }

    private void receiveExpressionSet(ClosedCallBackEvent closedCallBackEvent, String entityKey, String expressionFldKey, String descFldKey) {
        if (closedCallBackEvent.getReturnData() != null) {
            String str = (String)closedCallBackEvent.getReturnData();
            int row = this.getModel().getEntryCurrentRowIndex(entityKey);
            if (StringUtils.isBlank((CharSequence)str)) {
                this.getModel().setValue(expressionFldKey, (Object)"", row);
                this.getModel().setValue(descFldKey, (Object)"", row);
            } else {
                ReturnData returnData = (ReturnData)SerializationUtils.fromJsonString((String)str, ReturnData.class);
                Expression expression = (Expression)SerializationUtils.fromJsonString((String)returnData.getDataStr(), Expression.class);
                this.getModel().setValue(expressionFldKey, (Object)returnData.getDataStr(), row);
                String desp = StringUtils.isNotEmpty((CharSequence)expression.getExprTran().trim()) ? expression.getExprTran() : "";
                if (desp.length() > 1000) {
                    desp = desp.substring(0, 999);
                }
                this.getModel().setValue(descFldKey, (Object)desp, row);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object entryData = this.getView().getFormShowParameter().getCustomParams().get(MUL_ASSIST_ENTRY_DATA);
        if (entryData != null && !"".equals(entryData)) {
            List list = (List)JSONArray.parseObject((String)entryData.toString(), List.class);
            this.fillEntry(list);
            this.getView().updateView(MUL_ASSIST_ENTRY);
        }
    }

    private void fillEntry(List list) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        for (int i = 0; i < list.size(); ++i) {
            MulassistConfigModel mulassistConfigModel = (MulassistConfigModel)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)String.valueOf(list.get(i))), MulassistConfigModel.class);
            tableValueSetter.set(MUL_ASSIST_TYPE, (Object)mulassistConfigModel.getAssistId(), i);
            String conditionTag = mulassistConfigModel.getConditionTag();
            tableValueSetter.set(MUL_ASSIST_CONDITION, (Object)conditionTag, i);
            if (StringUtils.isNotEmpty((CharSequence)conditionTag)) {
                tableValueSetter.set(MUL_ASSIST_CONDITION_DESC, (Object)String.valueOf(JSONObject.parseObject((String)conditionTag).get((Object)EXPRESSION)), i);
            }
            tableValueSetter.set(MUL_ASSIST_MAP, (Object)mulassistConfigModel.getAssistMapMasterId(), i);
        }
        model.batchCreateNewEntryRow(MUL_ASSIST_ENTRY, tableValueSetter);
        model.endInit();
    }
}

