/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.frm.common.enums.AssistDataType;

public class RecDataRuleListDataProvider
extends ListDataProvider {
    public void setListFields(List<ListField> listFields) {
        super.setListFields(listFields);
    }

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection rows = super.getData(start, limit);
        rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("reconassist", String.class, (Object)""));
        HashSet<Long> idSet = new HashSet<Long>();
        for (DynamicObject row : rows) {
            idSet.add(row.getLong("id"));
        }
        HashMap<Long, StringBuilder> assistNameMap = new HashMap<Long, StringBuilder>(idSet.size());
        DataSet assistDataSet = QueryServiceHelper.queryDataSet((String)"rec_list_asssit", (String)"frm_recdatarule", (String)"id,assistentry.sourcenumber sourcenumber, assistentry.bdtype bdtype", (QFilter[])new QFilter("id", "in", idSet).toArray(), (String)"id");
        while (assistDataSet.hasNext()) {
            Row entry = assistDataSet.next();
            Long id = entry.getLong("id");
            StringBuilder assistStr = assistNameMap.computeIfAbsent(id, v -> new StringBuilder());
            String entityId = entry.getString("sourcenumber");
            if (StringUtils.isEmpty((CharSequence)entityId)) continue;
            if (assistStr.length() > 0) {
                assistStr.append(",");
            }
            String bdtype = entry.getString("bdtype");
            String localeValue = "";
            MainEntityType dataEntityType = null;
            if (AssistDataType.isBaseDataType((String)bdtype)) {
                try {
                    dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (dataEntityType == null) continue;
                localeValue = dataEntityType.getDisplayName().getLocaleValue();
            } else if (AssistDataType.isAssistantDataType((String)bdtype)) {
                DynamicObject assistGroup = BusinessDataServiceHelper.loadSingle((String)"bos_assistantdatagroup", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(entityId))});
                if (assistGroup == null) continue;
                localeValue = assistGroup.getString("name");
            }
            assistStr.append(localeValue);
        }
        for (DynamicObject row : rows) {
            row.set("reconassist", (Object)((StringBuilder)assistNameMap.get(row.getLong("id"))).toString());
        }
        return rows;
    }
}

