/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin;

import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.frm.common.util.ReconciliactionConfigUtil;
import kd.fi.frm.formplugin.RecDataRuleListDataProvider;

public class RecDataRuleListPlugin
extends AbstractListPlugin {
    private static final String BTN_RETURN_DATA = "btnreturndata";
    private static final String BTN_CLOSE = "btnclose";
    private static final String CLICK_NEW = "clicknew";
    private static final String FRM_REC_DATA_RULE_F7 = "frm_recdatarule_f7";
    public static final String DATA_RULE_F7_FLAG = "dataRuleF7Flag";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new RecDataRuleListDataProvider());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CLOSE, BTN_RETURN_DATA, CLICK_NEW});
        this.addItemClickListeners(new String[]{BTN_CLOSE, BTN_RETURN_DATA});
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(new QFilter("bak", "=", (Object)false));
    }

    public void itemClick(ItemClickEvent e) {
        String key;
        super.itemClick(e);
        switch (key = e.getItemKey()) {
            case "btnreturndata": {
                this.returnData();
                break;
            }
            case "btnclose": {
                this.getView().close();
                break;
            }
        }
    }

    public void click(EventObject evt) {
        Label label;
        super.click(evt);
        if (evt.getSource() instanceof Label && CLICK_NEW.equals((label = (Label)evt.getSource()).getKey())) {
            this.showCreateView();
        }
    }

    private void showCreateView() {
        BillShowParameter billShowParameter = ReconciliactionConfigUtil.buildBillShowParameter((IFormView)this.getView(), (boolean)Boolean.FALSE, (OperationStatus)OperationStatus.ADDNEW, (String)"addnew");
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "reconciliactionconfig"));
        this.getView().getParentView().showForm((FormShowParameter)billShowParameter);
        this.getView().close();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.refreshData();
    }

    private void showEditView(long id) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        DynamicObject rule = QueryServiceHelper.queryOne((String)"frm_recdatarule", (String)"bizapp.id,bizapp.name,createorg.id,preset", (QFilter[])new QFilter[]{idFilter});
        boolean preset = false;
        String operate = null;
        OperationStatus operationStatus = null;
        if (rule != null) {
            Object useOrg = formShowParameter.getCustomParam("useorg");
            String daraRuleCreateOrgId = rule.getString("createorg.id");
            if (daraRuleCreateOrgId.equals(useOrg)) {
                operationStatus = OperationStatus.EDIT;
                operate = "edit";
            } else {
                operationStatus = OperationStatus.VIEW;
                operate = "view";
            }
            preset = rule.getBoolean("preset");
        }
        BillShowParameter billShowParameter = ReconciliactionConfigUtil.buildBillShowParameter((IFormView)this.getView(), (boolean)preset, operationStatus, operate);
        billShowParameter.setCustomParam("pkId", (Object)id);
        billShowParameter.setPkId((Object)id);
        billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "reconciliactionconfig"));
        this.getView().getParentView().showForm((FormShowParameter)billShowParameter);
        this.getView().close();
    }

    private void returnData() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection collection = listView.getSelectedRows();
        if (collection.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d6\u6570\u89c4\u5219", (String)"RecDataRuleListPlugin_0", (String)"fi-frm-formplugin", (Object[])new Object[0]));
        }
        this.getView().returnDataToParent(collection.get(0).getPrimaryKeyValue());
        this.getView().close();
    }

    private void refreshData() {
        IListView listView = (IListView)this.getView();
        BillList list = (BillList)this.getControl("billlistap");
        listView.refresh();
        list.clearSelection();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        HyperLinkClickEvent hyperLinkClickEvent = e.getHyperLinkClickEvent();
        BillList list = (BillList)hyperLinkClickEvent.getSource();
        IListView view = (IListView)list.getView();
        String formId = view.getFormShowParameter().getFormId();
        if (FRM_REC_DATA_RULE_F7.equals(formId)) {
            e.setCancel(true);
            long pkid = (Long)((IListView)this.getView()).getFocusRowPkId();
            this.showEditView(pkid);
        }
    }
}

