/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.util.FIMetaDataUtil;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.cache.frm.ReconModelCacheHelper;
import kd.fi.frm.common.constant.ReconciliationFormConstant;
import kd.fi.frm.common.enums.AssistDataType;
import kd.fi.frm.common.enums.AssistTypeEnum;
import kd.fi.frm.common.enums.BalanceBasisEnum;
import kd.fi.frm.common.enums.DataTypeEnum;
import kd.fi.frm.common.enums.DetailTypeEnum;
import kd.fi.frm.common.enums.ReconAmountTypeEnum;
import kd.fi.frm.common.enums.ReconcilationResultEnum;
import kd.fi.frm.common.model.FrmAnalyzeLogger;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanDetailModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanModel;
import kd.fi.frm.common.mq.ReconciliationPublish;
import kd.fi.frm.common.task.TaskDao;
import kd.fi.frm.common.task.TaskInfo;
import kd.fi.frm.common.task.TaskStatusEnum;
import kd.fi.frm.common.util.FaBillParamUtils;
import kd.fi.frm.common.util.FrmCommonUtil;
import kd.fi.frm.common.util.FrmRowUtil;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.common.util.ShowConfirmUtil;
import kd.fi.frm.formplugin.DSField;
import kd.fi.frm.formplugin.export.ExportTaskDownTask;
import kd.fi.frm.formplugin.util.AssistFieldUtil;
import kd.fi.frm.formplugin.util.ExportDataSetUtil;
import kd.fi.frm.formplugin.util.ExportUtil;

public class ReconciliactionAssistResultFormPlugin
extends AbstractFormPlugin
implements CellClickListener,
ProgresssListener,
ReconciliationFormConstant,
RowClickEventListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(ReconciliactionAssistResultFormPlugin.class);
    private static final String[] initExportFields = new String[]{"status", "accountnumber", "account", "currency", "assist_gl", "assit_app", "init_app", "init_gl", "init_diff"};
    private static final String[] exportFields = new String[]{"status", "accountnumber", "account", "currency", "assist_gl", "assit_app", "openingbalance_app", "openingbalance_gl", "openingbalance_diff", "debitamount_app", "debitamount_gl", "debitamount_diff", "creditamount_app", "creditamount_gl", "creditamount_diff", "closingbalance_app", "closingbalance_gl", "closingbalance_diff"};
    private static final String[] EXPORT_FIELDS_DEBIT = new String[]{"status", "accountnumber", "account", "currency", "assist_gl", "assit_app", "debitamount_app", "debitamount_gl", "debitamount_diff"};
    private static final String[] EXPORT_FIELDS_CREDIT = new String[]{"status", "accountnumber", "account", "currency", "assist_gl", "assit_app", "creditamount_app", "creditamount_gl", "creditamount_diff"};
    private static final String[] EXPORT_FIELDS_DEBIT_CREDIT = new String[]{"status", "accountnumber", "account", "currency", "assist_gl", "assit_app", "debitamount_app", "debitamount_gl", "debitamount_diff", "creditamount_app", "creditamount_gl", "creditamount_diff"};
    public static final String PAGE_CACHE_EXPORT_DETAIL = "pageCacheExportDetail";
    public static final String PAGE_CACHE_ENABLE_ALGOX = "pageCacheEnableAlgox";
    private static final List<String> CLICK_CELLS = Arrays.asList("status", "debitamount_diff", "creditamount_diff");
    private static final String STATUS = "status";
    private static final String DEBIT_DIFF = "debitamount_diff";
    private static final String CREDIT_DIFF = "creditamount_diff";
    private static final String DETAIL_DEBIT_EXPORT = "detaildebitexport";
    private static final String DETAIL_CREDIT_EXPORT = "detailcreditexport";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        String param = (String)this.getView().getFormShowParameter().getCustomParam("model");
        ReconciliationParamModel paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.addHyperClickListener((HyperLinkClickListener)this);
        entryentity.addRowClickListener((RowClickEventListener)this);
        if (!paramModel.isInit()) {
            entryentity.addCellClickListener((CellClickListener)this);
        }
        ProgressBar bar = (ProgressBar)this.getControl("rst_progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("refresh".equals(key) || "exportDetail".equalsIgnoreCase(key)) {
            String param = this.getPageCache().get("model");
            ReconciliationParamModel paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
            DynamicObjectCollection existTasks = TaskDao.getExistTasks((ReconciliationParamModel)paramModel);
            if (existTasks != null && existTasks.size() > 0) {
                ShowConfirmUtil.showTaskConfirm((IFormView)this.getView(), (IPageCache)this.getPageCache(), (DynamicObjectCollection)existTasks);
            } else {
                if ("exportDetail".equalsIgnoreCase(key)) {
                    this.getPageCache().put(PAGE_CACHE_EXPORT_DETAIL, "1");
                    EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                    int[] rows = entryGrid.getSelectRows();
                    if (rows != null && rows.length > 0) {
                        DynamicObject dyObj = this.getModel().getEntryRowEntity("entryentity", rows[0]);
                        paramModel.setPlanDetailId(Long.valueOf(dyObj.getLong("plandetailid")));
                    }
                    param = SerializationUtils.toJsonString((Object)paramModel);
                } else {
                    this.getModel().deleteEntryData("entryentity");
                    this.getView().setEnable(Boolean.FALSE, new String[]{"refresh"});
                    this.getPageCache().remove("fi_ai_rec_body_syncresult");
                }
                this.getPageCache().put("isFist", "1");
                this.getPageCache().put("mark", "wait");
                this.getPageCache().remove("fillHeadFlag");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryentity"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"rst_progressbarap", "progresslabel", "flexpanelap4"});
                ProgressBar bar = (ProgressBar)this.getControl("rst_progressbarap");
                bar.setPercent(0);
                bar.start();
                this.asynQuery(param);
            }
        } else if ("export".equals(key)) {
            this.export();
        } else if ("viewrule".equals(key)) {
            this.viewRule();
        } else if ("vieworiginal".equals(key)) {
            this.viewOriginal();
        } else if ("showrecontab".equals(key)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"assisttype"});
            this.getView().updateView();
        } else if ("algox".equals(key)) {
            IPageCache pageCache2 = this.getView().getPageCache();
            String enableAlgox = pageCache2.get(PAGE_CACHE_ENABLE_ALGOX);
            if (enableAlgox == null) {
                pageCache2.put(PAGE_CACHE_ENABLE_ALGOX, "1");
                this.getView().showTipNotification("algox enable");
            } else {
                pageCache2.remove(PAGE_CACHE_ENABLE_ALGOX);
                this.getView().showTipNotification("algox disable");
            }
        } else if ("snapshot".equals(key)) {
            this.snapshot();
        } else if ("analyze".equals(key)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("frm_analyze");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            StyleCss styleCss = new StyleCss();
            styleCss.setWidth("400");
            styleCss.setHeight("400");
            parameter.getOpenStyle().setInlineStyleCss(styleCss);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "frm_analyze"));
            this.getView().showForm(parameter);
        } else if ("dimconfig".equals(key)) {
            this.dimConfig();
        } else if (DETAIL_DEBIT_EXPORT.equals(key)) {
            this.detailExport(DEBIT_DIFF);
        } else if (DETAIL_CREDIT_EXPORT.equals(key)) {
            this.detailExport(CREDIT_DIFF);
        }
    }

    private void detailExport(String detailDiffType) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 1) {
            boolean diffEmptyFlag;
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            int rowIndex = model.getEntryCurrentRowIndex("entryentity");
            String diff = DEBIT_DIFF.equals(detailDiffType) ? String.valueOf(model.getValue(DEBIT_DIFF, rowIndex)) : String.valueOf(model.getValue(CREDIT_DIFF, rowIndex));
            boolean bl = diffEmptyFlag = StringUtils.isBlank((String)diff) || "0E-10".equals(diff) || "null".equals(diff) || Double.parseDouble(diff) == 0.0;
            if (diffEmptyFlag) {
                view.showMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u5dee\u5f02\u6570\u636e\uff0c\u4e0d\u80fd\u5bfc\u51fa\u3002", (String)"ReconciliactionAssistResultFormPlugin_20", (String)"fi-frm-formplugin", (Object[])new Object[0]));
                return;
            }
            String param = (String)view.getFormShowParameter().getCustomParam("model");
            ReconciliationParamModel paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
            DynamicObjectCollection existTasks = TaskDao.getExistTasks((ReconciliationParamModel)paramModel);
            if (existTasks.size() > 0) {
                ShowConfirmUtil.showTaskConfirm((IFormView)this.getView(), (IPageCache)this.getPageCache(), (DynamicObjectCollection)existTasks);
            } else {
                Object assist;
                Object objAcct;
                Object objRule;
                paramModel.setDataType(DataTypeEnum.Detail);
                Object assistType = model.getValue("assisttype", rowIndex);
                if (assistType != null) {
                    paramModel.setAssistTypeEnum(AssistTypeEnum.getEnum((Integer)Integer.parseInt(String.valueOf(assistType))));
                }
                if ((objRule = model.getValue("ruleid", rowIndex)) != null) {
                    paramModel.setRuleIds(objRule.toString());
                }
                if ((objAcct = model.getValue("account", rowIndex)) != null) {
                    DynamicObjectCollection dyAccts = (DynamicObjectCollection)objAcct;
                    HashSet acctIds = new HashSet(dyAccts.size());
                    dyAccts.forEach(p -> acctIds.add(((DynamicObject)p.get("fbasedataid")).getLong("id")));
                    paramModel.setAccountIds(acctIds);
                }
                paramModel.setAssist((assist = model.getValue("assist", rowIndex)) == null ? "" : assist.toString());
                paramModel.setAssistStr(model.getValue("assist_gl", rowIndex) + "");
                String bizAssist = (String)model.getValue("bizassist", rowIndex);
                paramModel.setBizAssistTable(bizAssist == null ? "" : bizAssist);
                paramModel.setBizAssistStr(model.getValue("assit_app", rowIndex) + "");
                switch (detailDiffType) {
                    case "debitamount_diff": {
                        paramModel.setDetailTypeEnum(DetailTypeEnum.DEBIT_DIFF);
                        break;
                    }
                    case "creditamount_diff": {
                        paramModel.setDetailTypeEnum(DetailTypeEnum.CREDIT_DIFF);
                        break;
                    }
                }
                DynamicObject currency = (DynamicObject)model.getValue("currency", rowIndex);
                paramModel.setCurrency(Long.valueOf(currency == null ? 0L : currency.getLong("id")));
                Long acctTableId = ((DynamicObject)model.getValue("accounttable")).getLong("id");
                paramModel.setAccountTable(acctTableId);
                paramModel.setPlanDetailId(Long.valueOf(Long.parseLong(model.getValue("plandetailid", rowIndex) + "")));
                paramModel.setBizOrgIds(this.getBizOrgIdsFromCache());
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
                String glassgrps = rowEntity.getString("glassgrps");
                boolean enableMore = FaBillParamUtils.getBooleanValue((Long)paramModel.getOrgIds().toArray(new Long[0])[0], (String)"frm_detail_dapmul");
                Long recPlanId = ((DynamicObject)this.getModel().getValue("execplan")).getLong("id");
                HashMap<String, Object> taskParam = new HashMap<String, Object>();
                taskParam.put("enableMore", enableMore);
                taskParam.put("recPlanId", recPlanId);
                taskParam.put("paramModel", SerializationUtils.toJsonString((Object)paramModel));
                taskParam.put("glassgrps", glassgrps);
                taskParam.put("showAll", false);
                taskParam.put("export", true);
                taskParam.put("isRelation", false);
                taskParam.put("lang", Lang.get());
                ExportTaskDownTask.createAndDispatchTask(taskParam, (IFormPlugin)this, this.getView());
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u6570\u636e\u884c\u8fdb\u884c\u5bfc\u51fa\u660e\u7ec6\u5dee\u5f02\u3002", (String)"ReconciliactionAssistResultFormPlugin_21", (String)"fi-frm-formplugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("frm_analyze".equalsIgnoreCase(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            String param = this.getPageCache().get("model");
            ReconciliationParamModel paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
            Map ret = (Map)SerializationUtils.fromJsonString((String)returnData.toString(), Map.class);
            boolean printDataSet = Boolean.parseBoolean((String)ret.get("printDataSet"));
            paramModel.setPrintDataSet(printDataSet);
            paramModel.setAnalyzeMode();
            String cacheDataSetId = (String)ret.get("cachedatasetid");
            if (!StringUtils.isEmpty((String)cacheDataSetId)) {
                IAppCache cache = AppCache.get((String)"frm");
                String taskId = this.getPageCache().get("id") == null ? "taskId" : this.getPageCache().get("id");
                String frmLoggerCacheKey = "frmLogger" + taskId;
                CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cacheDataSetId);
                DataSet dataSet = cacheDataSet.toDataSet(Algo.create((String)"frm"), false);
                ((FrmAnalyzeLogger)paramModel.getFrmLogger()).setPrintDataSet(true);
                paramModel.getFrmLogger().log("cachedatasetid: " + cacheDataSetId);
                paramModel.getFrmLogger().logDataSet("analyzeData:", dataSet);
                cache.put(frmLoggerCacheKey, (Object)paramModel.getFrmLogger().getLogs());
                this.printFrmLog();
                return;
            }
            String planDetailIdStr = (String)ret.get("plandetailid");
            long analyzePlanDetailId = 0L;
            if (planDetailIdStr == null || planDetailIdStr.length() <= 0) {
                return;
            }
            analyzePlanDetailId = Long.parseLong(planDetailIdStr);
            paramModel.setPlanDetailId(Long.valueOf(analyzePlanDetailId));
            String ruleIds = (String)ret.get("ruleids");
            if (ruleIds != null && ruleIds.length() > 0) {
                Set analyzeRuleIds = Stream.of(ruleIds.split(",")).map(v -> Long.parseLong(v)).collect(Collectors.toSet());
                paramModel.setAnalyzeRuleIds(analyzeRuleIds);
            }
            param = SerializationUtils.toJsonString((Object)paramModel);
            this.getModel().deleteEntryData("entryentity");
            this.getView().setEnable(Boolean.FALSE, new String[]{"refresh"});
            this.getPageCache().remove("fi_ai_rec_body_syncresult");
            ((ProgressBar)this.getControl("rst_progressbarap")).setPercent(0, "0%");
            this.getPageCache().put("isFist", "1");
            this.getPageCache().put("mark", "wait");
            ProgressBar bar = (ProgressBar)this.getControl("rst_progressbarap");
            bar.start();
            this.asynQuery(param);
        } else if ("taskcloseback".equals(actionId)) {
            Map result = (Map)closedCallBackEvent.getReturnData();
            ExportTaskDownTask.download(result, this.getView());
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.setColumnProperty(STATUS, "isFixed", (Object)true);
        entryGrid.setColumnProperty("detailbalcbasis", "isFixed", (Object)true);
        entryGrid.setColumnProperty("account", "isFixed", (Object)true);
        entryGrid.setColumnProperty("assist_gl", "isFixed", (Object)true);
        entryGrid.setColumnProperty("assit_app", "isFixed", (Object)true);
        entryGrid.setColumnProperty("currency", "isFixed", (Object)true);
        this.getView().getPageCache().put("pageCacheShiftMBtn", "vieworiginal,algox,analyze,showrecontab,dimconfig,detaildebitexport,detailcreditexport");
        this.getView().setEnable(Boolean.FALSE, new String[]{"viewrule", "export"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryentity"});
        String isFirstJob = this.getPageCache().get("isFist");
        if (StringUtils.isEmpty((String)isFirstJob)) {
            this.beforeAsynExecute();
        }
        this.getView().getPageCache().put("mark", "wait");
        Label progressLabel = (Label)this.getView().getControl("progresslabel");
        progressLabel.setText(ResManager.loadKDString((String)"\u7b49\u5f85\u6267\u884c\u5bf9\u8d26...", (String)"ReconciliactionAssistResultFormPlugin_15", (String)"fi-frm-formplugin", (Object[])new Object[0]));
        ProgressBar bar = (ProgressBar)this.getControl("rst_progressbarap");
        bar.start();
        String paramModelStr = (String)this.getView().getFormShowParameter().getCustomParam("model");
        List appOrgList = (List)this.getView().getFormShowParameter().getCustomParam("appOrgList");
        if (!CollectionUtils.isEmpty((Collection)appOrgList)) {
            FormShowParameter parame = new FormShowParameter();
            parame.setFormId("frm_reconciliation_rst_fst");
            parame.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ReconciliationParamModel model = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)paramModelStr, ReconciliationParamModel.class);
            model.getOrgIds().clear();
            model.getAppIds().clear();
            String appOrgStr = String.valueOf(appOrgList.get(0));
            model.addOrg(Long.valueOf(Long.parseLong(appOrgStr.split(",")[0])));
            model.addAppId(appOrgStr.split(",")[1]);
            parame.setCustomParam("model", (Object)SerializationUtils.toJsonString((Object)model));
            appOrgList.remove(0);
            parame.setCustomParam("appOrgList", (Object)appOrgList);
            this.getView().showForm(parame);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        this.getView().setEnable(Boolean.valueOf(evt.getRow() > -1), new String[]{"viewrule"});
    }

    public IPageCache getPageCache() {
        return new PageCache(this.getView().getPageId(), false);
    }

    public void onProgress(ProgressEvent progressevent) {
        try {
            ProgressBar bar = (ProgressBar)this.getControl("rst_progressbarap");
            String mark = this.getPageCache().get("mark");
            if ("wait".equals(mark)) {
                String isFirstJob = this.getPageCache().get("isFist");
                if (StringUtils.isEmpty((String)isFirstJob)) {
                    String param = this.getPageCache().get("model");
                    this.asynQuery(param);
                    this.getPageCache().put("isFist", "1");
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"rst_progressbarap"});
                this.getPageCache().put("mark", "running");
                return;
            }
            if ("running".equals(mark)) {
                String taskId = this.getPageCache().get("id");
                String batchNo = this.getPageCache().get("batchno");
                if (batchNo == null || taskId == null) {
                    return;
                }
                String cacheTaskStr = AppCacheHelper.getTaskCache((String)batchNo, (String)taskId);
                if (StringUtils.isEmpty((String)cacheTaskStr)) {
                    return;
                }
                TaskInfo cacheTaskInfo = (TaskInfo)SerializationUtils.deSerializeFromBase64((String)cacheTaskStr);
                if (TaskStatusEnum.NOT_START == cacheTaskInfo.getTaskStatus()) {
                    return;
                }
                Label progressLabel = (Label)this.getView().getControl("progresslabel");
                progressLabel.setText(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u5bf9\u8d26...", (String)"ReconciliactionAssistResultFormPlugin_4", (String)"fi-frm-formplugin", (Object[])new Object[0]));
                boolean hasFinish = this.fillHeaderField(cacheTaskInfo);
                if (!hasFinish && TaskStatusEnum.FINISHED == cacheTaskInfo.getTaskStatus()) {
                    progressevent.setProgress(100);
                    bar.stop();
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"rst_progressbarap", "progresslabel"});
                }
                Integer taskPercent = cacheTaskInfo.getPercent();
                TaskStatusEnum taskStatus = cacheTaskInfo.getTaskStatus();
                if (100 == taskPercent && taskStatus != TaskStatusEnum.FINISHED) {
                    taskPercent = 98;
                }
                if (TaskStatusEnum.ERROR == taskStatus || ReconcilationResultEnum.error == cacheTaskInfo.getCode()) {
                    bar.stop();
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"rst_progressbarap", "progresslabel"});
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"refresh"});
                    String[] error = cacheTaskInfo.getError();
                    String errorMsg = "";
                    errorMsg = error == null ? ResManager.loadKDString((String)"\u5bf9\u8d26\u4efb\u52a1\u6267\u884c\u5f02\u5e38", (String)"ReconciliactionAssistResultFormPlugin_14", (String)"fi-frm-formplugin", (Object[])new Object[0]) : (error.length == 1 ? error[0] : error[1]);
                    this.getView().showMessage(errorMsg);
                    this.printFrmLog();
                    return;
                }
                if (TaskStatusEnum.STOPPED == taskStatus) {
                    bar.stop();
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"rst_progressbarap", "progresslabel"});
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"refresh"});
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5bf9\u8d26\u4efb\u52a1\u5df2\u88ab\u7ec8\u6b62\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u5bf9\u8d26", (String)"ReconciliactionAssistResultFormPlugin_16", (String)"fi-frm-formplugin", (Object[])new Object[0]));
                    this.printFrmLog();
                    return;
                }
                if (TaskStatusEnum.FINISHED == taskStatus) {
                    bar.stop();
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"rst_progressbarap", "progresslabel"});
                    this.getPageCache().put("mark", "finish");
                    this.getView().setEnable(Boolean.TRUE, new String[]{"refresh", "export"});
                    if (this.getPageCache().get(PAGE_CACHE_EXPORT_DETAIL) != null) {
                        boolean error;
                        boolean bl = error = this.getPageCache().get("fi_ai_reconciliationError") != null;
                        if (error) {
                            this.getPageCache().remove(PAGE_CACHE_EXPORT_DETAIL);
                            this.getPageCache().remove("fi_ai_reconciliationError");
                            this.getPageCache().put("isFist", "0");
                        } else {
                            String cacheBodyId = AppCacheHelper.getResultCache((String)("fi_ai_rec_body_syncresult_exportDetail_" + taskId));
                            CachedDataSet cacheDataSet2 = Algo.getCacheDataSet((String)cacheBodyId);
                            List resultList2 = cacheDataSet2.getList(0, Integer.MAX_VALUE);
                            RowMeta rowMeta = cacheDataSet2.getRowMeta();
                            ExportDataSetUtil.export(rowMeta, resultList2.iterator(), this.getView());
                        }
                    }
                    if (hasFinish) {
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{"entryentity"});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap4"});
                        this.fillEntry(taskId);
                    }
                    this.printFrmLog();
                }
                progressevent.setProgress(taskPercent.intValue());
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            ProgressBar bar = (ProgressBar)this.getControl("rst_progressbarap");
            bar.stop();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"rst_progressbarap", "progresslabel"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"refresh"});
            this.getPageCache().put("isFist", "0");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u754c\u9762\u5904\u7406\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"ReconciliactionAssistResultFormPlugin_3", (String)"fi-frm-formplugin", (Object[])new Object[0]));
        }
    }

    private void printFrmLog() {
        IAppCache cache = AppCache.get((String)"frm");
        String taskId = this.getPageCache().get("id") == null ? "taskId" : this.getPageCache().get("id");
        String frmLoggerCacheKey = "frmLogger" + taskId;
        String frmLogMsg = (String)cache.get(frmLoggerCacheKey, String.class);
        if (frmLogMsg != null) {
            cache.remove(frmLoggerCacheKey);
            FrmCommonUtil.downloadLog((IFormView)this.getView(), (String)"analyze.log", (String)frmLogMsg);
        }
    }

    public void cellClick(CellClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if ("entryentity".equals(entryGrid.getEntryKey())) {
            DynamicObjectCollection existTasks;
            boolean creditDiffEmptyFlag;
            boolean debitDiffEmptyFlag;
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            if (!CLICK_CELLS.contains(evt.getFieldKey())) {
                return;
            }
            if (this.isPlanModified()) {
                return;
            }
            int rowIndex = model.getEntryCurrentRowIndex("entryentity");
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            String glassgrps = rowEntity.getString("glassgrps");
            String debitDiff = String.valueOf(model.getValue(DEBIT_DIFF, rowIndex));
            boolean bl = debitDiffEmptyFlag = StringUtils.isBlank((String)debitDiff) || "0E-10".equals(debitDiff) || "null".equals(debitDiff) || Double.parseDouble(debitDiff) == 0.0;
            if (DEBIT_DIFF.equals(evt.getFieldKey()) && debitDiffEmptyFlag) {
                return;
            }
            String creditDiff = String.valueOf(model.getValue(CREDIT_DIFF, rowIndex));
            boolean bl2 = creditDiffEmptyFlag = StringUtils.isBlank((String)creditDiff) || "0E-10".equals(creditDiff) || "null".equals(creditDiff) || Double.parseDouble(creditDiff) == 0.0;
            if (CREDIT_DIFF.equals(evt.getFieldKey()) && creditDiffEmptyFlag) {
                return;
            }
            if (STATUS.equals(evt.getFieldKey()) && debitDiffEmptyFlag && creditDiffEmptyFlag) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f59\u989d\u5dee\u5f02\u4e0d\u652f\u6301\u8054\u67e5\u660e\u7ec6\u8868\u3002", (String)"ReconciliactionAssistResultFormPlugin_23", (String)"fi-frm-formplugin", (Object[])new Object[0]));
                return;
            }
            Object objStatus = model.getValue(STATUS, rowIndex);
            if (STATUS.equals(evt.getFieldKey()) && objStatus == null) {
                return;
            }
            if (STATUS.equals(evt.getFieldKey()) && "1".equals(objStatus.toString())) {
                return;
            }
            Long recPlanId = ((DynamicObject)this.getModel().getValue("execplan")).getLong("id");
            Long plandetailid = (Long)model.getValue("plandetailid", rowIndex);
            BizReconPlanModel planModel = ReconModelCacheHelper.getPlanModel((String)String.valueOf(recPlanId));
            Optional<BizReconPlanDetailModel> first = planModel.getDetail().stream().filter(m -> m.getId().equals(plandetailid)).findFirst();
            if (first.isPresent() && !first.get().isViewDetail()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u8d26\u65b9\u6848\u5206\u5f55\u884c\u672a\u5f00\u542f\u8054\u67e5\u660e\u7ec6\u53c2\u6570\u3002", (String)"ReconciliactionAssistResultFormPlugin_22", (String)"fi-frm-formplugin", (Object[])new Object[0]));
                return;
            }
            String param = (String)view.getFormShowParameter().getCustomParam("model");
            ReconciliationParamModel paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
            paramModel.setDataType(DataTypeEnum.Detail);
            Object assistType = model.getValue("assisttype", rowIndex);
            if (assistType != null) {
                paramModel.setAssistTypeEnum(AssistTypeEnum.getEnum((Integer)Integer.parseInt(String.valueOf(assistType))));
            }
            if ((existTasks = TaskDao.getExistTasks((ReconciliationParamModel)paramModel)) != null && existTasks.size() > 0) {
                ShowConfirmUtil.showTaskConfirm((IFormView)this.getView(), (IPageCache)this.getPageCache(), (DynamicObjectCollection)existTasks);
            } else {
                boolean isUnittest;
                Object objAcct;
                Object objRule = model.getValue("ruleid", rowIndex);
                if (objRule != null) {
                    paramModel.setRuleIds(objRule.toString());
                }
                if ((objAcct = model.getValue("account", rowIndex)) != null) {
                    DynamicObjectCollection dyAccts = (DynamicObjectCollection)objAcct;
                    HashSet acctIds = new HashSet(dyAccts.size());
                    dyAccts.forEach(p -> acctIds.add(((DynamicObject)p.get("fbasedataid")).getLong("id")));
                    paramModel.setAccountIds(acctIds);
                }
                FormShowParameter parame = new FormShowParameter();
                parame.setFormId("frm_rec_detail");
                parame.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parame.getOpenStyle().setTargetKey("_submaintab_");
                parame.setStatus(OperationStatus.VIEW);
                Object assist = model.getValue("assist", rowIndex);
                paramModel.setAssist(assist == null ? "" : assist.toString());
                paramModel.setAssistStr(model.getValue("assist_gl", rowIndex) + "");
                String bizAssist = (String)model.getValue("bizassist", rowIndex);
                paramModel.setBizAssistTable(bizAssist == null ? "" : bizAssist);
                paramModel.setBizAssistStr(model.getValue("assit_app", rowIndex) + "");
                boolean bl3 = isUnittest = model.getValue("accounttable") == null;
                if (isUnittest) {
                    String showParamModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
                    String appId = showParamModel.getAppIds().toArray(new String[0])[0];
                    Long orgId = showParamModel.getOrgIds().toArray(new Long[0])[0];
                    Long bookTypeId = showParamModel.getBookTypeId();
                    Long periodId = showParamModel.getPeriodId();
                    QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
                    QFilter bookTypeFilter = new QFilter("bookstype", "=", (Object)bookTypeId);
                    DynamicObject bookType = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"accounttable.id,basecurrency.id,startperiod.id", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter});
                    this.getModel().setValue("bizapp", (Object)appId);
                    this.getModel().setValue("accounttable", bookType.get("accounttable.id"));
                    this.getModel().setValue("period", (Object)periodId);
                    DynamicObject currency = (DynamicObject)model.getValue("currency", rowIndex);
                    if (currency == null) {
                        model.setValue("currency", (Object)1L, rowIndex);
                    }
                }
                switch (evt.getFieldKey()) {
                    case "status": {
                        paramModel.setDetailTypeEnum(DetailTypeEnum.STATUS);
                        break;
                    }
                    case "debitamount_diff": {
                        paramModel.setDetailTypeEnum(DetailTypeEnum.DEBIT_DIFF);
                        break;
                    }
                    case "creditamount_diff": {
                        paramModel.setDetailTypeEnum(DetailTypeEnum.CREDIT_DIFF);
                        break;
                    }
                }
                DynamicObject currency = (DynamicObject)model.getValue("currency", rowIndex);
                paramModel.setCurrency(Long.valueOf(currency == null ? 0L : currency.getLong("id")));
                Long acctTableId = ((DynamicObject)model.getValue("accounttable")).getLong("id");
                paramModel.setAccountTable(acctTableId);
                paramModel.setPlanDetailId(Long.valueOf(Long.parseLong(model.getValue("plandetailid", rowIndex) + "")));
                paramModel.setBizOrgIds(this.getBizOrgIdsFromCache());
                parame.setCustomParam("model", (Object)SerializationUtils.toJsonString((Object)paramModel));
                String periodName = ((DynamicObject)model.getValue("period")).getString("name");
                parame.setCustomParam("ai_gldata3_bizrst_tip", (Object)String.format("%s%s", ((DynamicObject)model.getValue("bizapp")).get("name"), periodName));
                parame.setCustomParam("ai_gldata3_glrst_tip", (Object)String.format(ResManager.loadKDString((String)"\u603b\u8d26%s", (String)"ReconciliactionAssistResultFormPlugin_9", (String)"fi-frm-formplugin", (Object[])new Object[0]), periodName));
                parame.setCustomParam("planmodelid", (Object)((DynamicObject)this.getModel().getValue("execplan")).getLong("id"));
                parame.setCustomParam("glassgrps", (Object)glassgrps);
                view.showForm(parame);
            }
            this.getView().updateView("entryentity");
        }
    }

    private boolean isPlanModified() {
        long planId = ((DynamicObject)this.getModel().getValue("execplan")).getLong("id");
        boolean isPlanModified = ReconModelCacheHelper.isPlanModified((Long)planId);
        if (isPlanModified) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u8d26\u65b9\u6848\u3001\u53d6\u6570\u89c4\u5219\u3001\u901a\u7528\u8bbe\u7f6e\u88ab\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u5bf9\u8d26\u518d\u8fdb\u5165\u5bf9\u8d26\u5dee\u5f02\u660e\u7ec6\u8868\u3002", (String)"ReconciliactionAssistResultFormPlugin_17", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void cellDoubleClick(CellClickEvent evt) {
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("stopTask".equals(messageBoxClosedEvent.getCallBackId())) {
            ShowConfirmUtil.taskConfirm((MessageBoxClosedEvent)messageBoxClosedEvent, (String)this.getPageCache().get("existTaskIds"), (IFormView)this.getView());
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if ("assit_app".equals(fieldName)) {
            int rowIndex = evt.getRowIndex();
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            long planId = ((DynamicObject)this.getModel().getValue("execplan")).getLong("id");
            long dataruleId = ((DynamicObject)this.getModel().getValue("datarule")).getLong("id");
            long plandetailId = rowEntity.getLong("plandetailid");
            int assisttype = rowEntity.getInt("assisttype");
            if (AssistTypeEnum.Acct.getValue() == assisttype) {
                DynamicObject reconPlan = BusinessDataServiceHelper.loadSingleFromCache((Object)planId, (String)"frm_reconciliation_scheme");
                DynamicObjectCollection fieldMapEntry = reconPlan.getDynamicObjectCollection("fieldmapentry");
                List<DSField> dynFields = AssistFieldUtil.getSchemeAssistFromDataRule(fieldMapEntry);
                DynamicObjectCollection tab1Entry = reconPlan.getDynamicObjectCollection("modularentryentity");
                for (DynamicObject entryRow : tab1Entry) {
                    String assistfilter;
                    if (!entryRow.getPkValue().equals(plandetailId) || StringUtils.isEmpty((String)(assistfilter = entryRow.getString("assistfilterinfo_tag")))) continue;
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setFormId("frm_bizassist_filter");
                    showParameter.getCustomParams().put("assists", SerializationUtils.serializeToBase64(dynFields));
                    showParameter.getCustomParams().put("assistfilter", assistfilter);
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    showParameter.setStatus(OperationStatus.VIEW);
                    this.getView().showForm(showParameter);
                }
            }
        }
    }

    private boolean fillHeaderField(TaskInfo taskInfo) {
        String fillHeadFlag = this.getPageCache().get("fillHeadFlag");
        if ("true".equalsIgnoreCase(fillHeadFlag)) {
            return true;
        }
        if (taskInfo.getPlanId() == null) {
            return false;
        }
        this.getModel().setValue("execplan", (Object)taskInfo.getPlanId());
        this.getModel().setValue("recontask", (Object)taskInfo.getId());
        DynamicObject plan = (DynamicObject)this.getModel().getValue("execplan");
        if (plan == null) {
            return false;
        }
        Object desc = this.getModel().getValue("desc");
        if (desc != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(desc);
            StringBuilder sbTemp = new StringBuilder();
            sbTemp.append(';').append(' ').append(ResManager.loadKDString((String)"\u5bf9\u8d26\u65b9\u6848", (String)"ReconciliactionAssistResultFormPlugin_2", (String)"fi-frm-formplugin", (Object[])new Object[0])).append(':').append(plan.get("number")).append(' ').append(plan.get("name"));
            if (sb.indexOf(sbTemp.toString()) == -1) {
                sb.append((CharSequence)sbTemp);
                this.getModel().setValue("desc", (Object)sb.toString());
            }
        }
        this.getModel().setValue("datarule", (Object)taskInfo.getDataRuleId());
        int amtType = plan.getInt("reconamounttype");
        this.getModel().setValue("reconamounttype", (Object)amtType);
        this.getModel().setValue("balancebasis", plan.get("balancebasis"));
        this.getModel().setValue("glapp", (Object)taskInfo.getGlAppCfgId());
        this.showAmountColumn(amtType);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"assisttype"});
        this.getPageCache().put("fillHeadFlag", "true");
        return true;
    }

    private Set<Long> getBizOrgIdsFromCache() {
        Set bizOrgIds;
        String bizOrgIdCache = this.getPageCache().get("bizorgids");
        if (StringUtils.isEmpty((String)bizOrgIdCache)) {
            String taskId = this.getPageCache().get("id");
            String batchNo = this.getPageCache().get("batchno");
            String cacheTaskStr = AppCacheHelper.getTaskCache((String)batchNo, (String)taskId);
            if (StringUtils.isEmpty((String)cacheTaskStr)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u671f\u9875\u9762\u6570\u636e\u7f13\u5b58\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u5bf9\u8d26\u3002", (String)"ReconciliactionAssistResultFormPlugin_18", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            }
            TaskInfo cacheTaskInfo = (TaskInfo)SerializationUtils.deSerializeFromBase64((String)cacheTaskStr);
            bizOrgIds = cacheTaskInfo.getBizOrgIds();
            this.getPageCache().put("bizorgids", SerializationUtils.toJsonString((Object)bizOrgIds));
        } else {
            Set ids = (Set)SerializationUtils.fromJsonString((String)bizOrgIdCache, Set.class);
            bizOrgIds = ids.stream().map(id -> Long.parseLong(id.toString())).collect(Collectors.toSet());
        }
        return bizOrgIds;
    }

    private void showAmountColumn(int reconAmtType) {
        String param = (String)this.getView().getFormShowParameter().getCustomParam("model");
        ReconciliationParamModel paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
        if (!paramModel.isInit()) {
            ReconAmountTypeEnum amountType = ReconAmountTypeEnum.getEnum((Integer)reconAmtType);
            if (amountType == null) {
                this.setAmountVisible(Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
            } else {
                switch (amountType) {
                    case DEBIT: {
                        this.setAmountVisible(Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE);
                        break;
                    }
                    case CREDIT: {
                        this.setAmountVisible(Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE);
                        break;
                    }
                    case DEBIT_CREDIT: {
                        this.setAmountVisible(Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE);
                        break;
                    }
                    case DEBIT_CREDIT_CLOSE: {
                        this.setAmountVisible(Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
                        break;
                    }
                }
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"detailbalcbasis"});
        }
    }

    private void setAmountVisible(boolean init, boolean opening, boolean debit, boolean credit, boolean close) {
        this.getView().setVisible(Boolean.valueOf(init), new String[]{"initgroup", "init_app", "init_gl", "init_diff"});
        this.getView().setVisible(Boolean.valueOf(opening), new String[]{"openinggroup", "openingbalance_app", "openingbalance_gl", "openingbalance_diff"});
        this.getView().setVisible(Boolean.valueOf(debit), new String[]{"debitgroup", "debitamount_app", "debitamount_gl", DEBIT_DIFF});
        this.getView().setVisible(Boolean.valueOf(credit), new String[]{"creditgroup", "creditamount_app", "creditamount_gl", CREDIT_DIFF});
        this.getView().setVisible(Boolean.valueOf(close), new String[]{"closegroup", "closingbalance_app", "closingbalance_gl", "closingbalance_diff"});
    }

    private void viewOriginal() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 0) {
            return;
        }
        DynamicObject[] selectRows = this.getModel().getEntryEntity("entryentity", rows[0], 1 + rows[0]);
        this.getView().showMessage(SerializationUtils.toJsonString((Object)selectRows[0]));
    }

    private void viewRule() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows.length == 1) {
            Long ruleId = ((DynamicObject)this.getModel().getValue("datarule")).getLong("id");
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId("frm_recdatarule");
            parameter.setPkId((Object)ruleId);
            parameter.getOpenStyle().setShowType(FIMetaDataUtil.getShowType((String)"frm_recdatarule"));
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            DynamicObject app = (DynamicObject)this.getModel().getValue("bizapp");
            parameter.getCustomParams().put("bizApp", app.getString("id"));
            DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", rows[0]);
            int assistType = entry.getInt("assistType");
            AssistTypeEnum assistTypeEnum = AssistTypeEnum.getEnum((Integer)assistType);
            parameter.getCustomParams().put("assistType", assistType);
            long planDetailId = entry.getLong("planDetailId");
            parameter.getCustomParams().put("planDetailId", planDetailId);
            parameter.getCustomParams().put("planId", this.getModel().getValue("execplan_id"));
            DynamicObjectCollection accts = (DynamicObjectCollection)entry.get("account");
            StringBuilder sb = new StringBuilder();
            for (DynamicObject acct : accts) {
                DynamicObject account = (DynamicObject)acct.get("fbasedataid");
                sb.append(account.getString("number"));
                sb.append(",");
                sb.append(account.getString("name"));
                sb.append(";");
            }
            parameter.getCustomParams().put("account", sb.toString());
            String taskId = this.getPageCache().get("id");
            DynamicObjectCollection matchRules = QueryServiceHelper.query((String)"frm_task", (String)"planentry.ruleentry.ruleentryid,planentry.ruleentry.count", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(taskId)), new QFilter("planentry.plandetailid", "=", (Object)planDetailId)});
            Set matchQueryRules = matchRules.stream().map(d -> d.getLong("planentry.ruleentry.ruleentryid")).collect(Collectors.toSet());
            String ruleids = entry.getString("ruleid");
            Set matchDataRules = StringUtils.isEmpty((String)ruleids) ? Collections.emptySet() : Arrays.stream(ruleids.split(",")).map(Long::parseLong).collect(Collectors.toSet());
            parameter.getCustomParams().put("matchQueryRules", matchQueryRules);
            parameter.getCustomParams().put("matchDataRules", matchDataRules);
            parameter.getCustomParams().put("bizassist", entry.getString("bizassist"));
            parameter.getCustomParams().put("assist", entry.getString("assist"));
            String entityTableName = "";
            if (assistTypeEnum != null) {
                switch (assistTypeEnum) {
                    case Acct: {
                        entityTableName = "t_ai_recon_scheme_amtype";
                        break;
                    }
                    case Asstact: {
                        entityTableName = "t_ai_recon_scheme_amtype1";
                        break;
                    }
                    case Assist: {
                        entityTableName = "t_ai_recon_scheme_amtype2";
                        break;
                    }
                }
            }
            HashSet<Long> amountTypeIds = new HashSet<Long>(6);
            String sql = "SELECT fbasedataid FROM " + entityTableName + " WHERE fentryid = " + planDetailId;
            try (DataSet ds = DB.queryDataSet((String)"ALGO_KEY", (DBRoute)DBRoute.of((String)"ai"), (String)sql);){
                for (Row row : ds) {
                    amountTypeIds.add(row.getLong("fbasedataid"));
                }
            }
            parameter.getCustomParams().put("amountTypeIds", SerializationUtils.toJsonString(amountTypeIds));
            String param = (String)this.getView().getFormShowParameter().getCustomParam("model");
            ReconciliationParamModel paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency", rows[0]);
            paramModel.setCurrency(Long.valueOf(currency == null ? 0L : currency.getLong("id")));
            if (paramModel.getPeriodId() == null || 0L == paramModel.getPeriodId()) {
                Long periodId = ((DynamicObject)this.getModel().getValue("period", rows[0])).getLong("id");
                paramModel.setPeriodId(periodId);
            }
            paramModel.setBizOrgIds(this.getBizOrgIdsFromCache());
            parameter.getCustomParams().put("model", SerializationUtils.toJsonString((Object)paramModel));
            parameter.getCustomParams().put("summary", Boolean.TRUE);
            parameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)parameter);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u6761\u6570\u636e\u884c\u8fdb\u884c\u67e5\u770b\u89c4\u5219\u3002", (String)"ReconciliactionAssistResultFormPlugin_0", (String)"fi-frm-formplugin", (Object[])new Object[0]));
        }
    }

    private void snapshot() {
    }

    private void dimConfig() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("frm_rec_dimconfig");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void export() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        DynamicObjectCollection exportCols = null;
        IDataModel model = this.getModel();
        if (rows != null && rows.length > 0) {
            exportCols = new DynamicObjectCollection();
            for (int i = 0; i < rows.length; ++i) {
                exportCols.add((Object)model.getEntryRowEntity("entryentity", rows[i]));
            }
        } else {
            exportCols = this.getModel().getEntryEntity("entryentity");
            if (exportCols.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"ReconciliactionAssistResultFormPlugin_10", (String)"fi-frm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        IFormView view = this.getView();
        ExportUtil export = new ExportUtil();
        ArrayList<String> fieldList = new ArrayList<String>(22);
        String param = (String)this.getView().getFormShowParameter().getCustomParam("model");
        ReconciliationParamModel paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
        Long recPlanId = ((DynamicObject)this.getModel().getValue("execplan")).getLong("id");
        BizReconPlanModel planModel = ReconModelCacheHelper.getPlanModel((String)recPlanId.toString());
        BalanceBasisEnum headBalanceBasis = planModel.getBalanceBasis();
        boolean hideBalanceBasis = true;
        if (planModel.getDetail().size() > 0) {
            for (BizReconPlanDetailModel detailModel : planModel.getDetail()) {
                BalanceBasisEnum balanceBasis = detailModel.getBalanceBasis();
                if (headBalanceBasis == balanceBasis) continue;
                hideBalanceBasis = false;
            }
        }
        if (paramModel.isInit()) {
            fieldList.addAll(Arrays.asList(initExportFields));
        } else {
            Object reconAmountType = this.getModel().getValue("reconamounttype");
            ReconAmountTypeEnum reconAmountTypeEnum = ReconAmountTypeEnum.getEnum((Integer)Integer.parseInt(reconAmountType.toString()));
            switch (reconAmountTypeEnum) {
                case DEBIT: {
                    fieldList.addAll(Arrays.asList(EXPORT_FIELDS_DEBIT));
                    break;
                }
                case CREDIT: {
                    fieldList.addAll(Arrays.asList(EXPORT_FIELDS_CREDIT));
                    break;
                }
                case DEBIT_CREDIT: {
                    fieldList.addAll(Arrays.asList(EXPORT_FIELDS_DEBIT_CREDIT));
                    break;
                }
                case DEBIT_CREDIT_CLOSE: {
                    fieldList.addAll(Arrays.asList(exportFields));
                    break;
                }
            }
            if (!hideBalanceBasis) {
                fieldList.add(1, "detailbalcbasis");
            }
        }
        String url = export.export(exportCols, fieldList, ResManager.loadKDString((String)"\u5bf9\u8d26\u6c47\u603b\u8868", (String)"ReconciliactionAssistResultFormPlugin_1", (String)"fi-frm-formplugin", (Object[])new Object[0]));
        export.openUrl(url, view);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"ReconciliactionAssistResultFormPlugin_19", (String)"fi-frm-formplugin", (Object[])new Object[0]));
    }

    private void asynQuery(String param) {
        ReconciliationParamModel paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
        paramModel.setUnitTest(this.isUnitTest());
        String pageCacheEnableAlgox = this.getView().getPageCache().get(PAGE_CACHE_ENABLE_ALGOX);
        if ("1".equals(pageCacheEnableAlgox)) {
            paramModel.setEnableAlgox(Boolean.TRUE.booleanValue());
        } else if (StringUtils.isNotEmpty((String)pageCacheEnableAlgox)) {
            paramModel.setEnableAlgox(Boolean.FALSE.booleanValue());
        }
        DynamicObject app = (DynamicObject)this.getModel().getValue("bizapp");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long orgId = (Long)org.getPkValue();
        String appId = (String)app.getPkValue();
        DynamicObject task = TaskDao.buildTask((long)orgId, (String)appId, (ReconciliationParamModel)paramModel);
        TaskDao.addNew((DynamicObject)task, () -> {
            ReconciliationPublish publish = new ReconciliationPublish();
            publish.setParamModel(paramModel);
            return publish;
        });
        this.getPageCache().put("batchno", task.getString("batchno"));
        this.getPageCache().put("id", task.getString("id"));
    }

    private boolean isUnitTest() {
        StackTraceElement[] stackTraces = Thread.currentThread().getStackTrace();
        String rootTrace = stackTraces[stackTraces.length - 1].toString();
        return rootTrace.indexOf("kd.bos.unittest") == 0;
    }

    private void beforeAsynExecute() {
        this.getView().setEnable(Boolean.FALSE, new String[]{"refresh"});
        String param = (String)this.getView().getFormShowParameter().getCustomParam("model");
        ReconciliationParamModel paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
        paramModel.setDataType(DataTypeEnum.NotDetail);
        this.getPageCache().put("model", SerializationUtils.toJsonString((Object)paramModel));
        if (paramModel.isInit()) {
            this.setAmountVisible(Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE);
        }
        String appId = paramModel.getAppIds().toArray(new String[0])[0];
        Long orgId = paramModel.getOrgIds().toArray(new Long[0])[0];
        Long bookTypeId = paramModel.getBookTypeId();
        Long periodId = paramModel.getPeriodId();
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter bookTypeFilter = new QFilter("bookstype", "=", (Object)bookTypeId);
        DynamicObject bookType = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"accounttable.id,basecurrency.id,startperiod.id", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter});
        this.getModel().setValue("bizapp", (Object)appId);
        this.getModel().setValue("org", (Object)orgId);
        this.getModel().setValue("accounttable", bookType.get("accounttable.id"));
        this.getModel().setValue("booktype", (Object)bookTypeId);
        String title = String.format(ResManager.loadKDString((String)"\u5bf9\u8d26\u6c47\u603b\u8868-%1$s-%2$s", (String)"ReconciliactionAssistResultFormPlugin_13", (String)"fi-frm-formplugin", (Object[])new Object[0]), ((DynamicObject)this.getModel().getValue("org")).getString("number"), ((DynamicObject)this.getModel().getValue("bizapp")).getString("name"));
        this.getView().setFormTitle(new LocaleString(title));
        if (!paramModel.isApi() && paramModel.isInit()) {
            periodId = bookType.getLong("startperiod.id");
        }
        this.getModel().setValue("period", (Object)periodId);
        this.getModel().setValue("basecurrency", bookType.get("basecurrency.id"));
    }

    public void fillEntry(String taskId) {
        Map cacheIdMap = AppCacheHelper.getAll((String)taskId);
        if (cacheIdMap == null || cacheIdMap.size() == 0) {
            return;
        }
        HashMap<Long, RowMeta> detailRowMetaMap = new HashMap<Long, RowMeta>();
        List<Object> resultList = new ArrayList(1000);
        for (String cacheId : cacheIdMap.values()) {
            String usedcacheid = this.getPageCache().get("usedcacheid");
            if (usedcacheid != null && usedcacheid.contains(cacheId)) continue;
            this.getPageCache().put("usedcacheid", usedcacheid + "," + cacheId);
            CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cacheId);
            List _resultList = cacheDataSet.getList(0, cacheDataSet.getRowCount());
            if (_resultList == null || _resultList.size() <= 0) continue;
            resultList.addAll(_resultList);
            detailRowMetaMap.put(((Row)_resultList.get(0)).getLong("plandetailid"), cacheDataSet.getRowMeta());
        }
        if (resultList.size() == 0) {
            return;
        }
        Long recPlanId = ((DynamicObject)this.getModel().getValue("execplan")).getLong("id");
        BizReconPlanModel planModel = ReconModelCacheHelper.getPlanModel((String)String.valueOf(recPlanId));
        Map<Long, Map<String, Set<Long>>> originPlanEntryFilter = this.queryReconSchemeEntryFilterCfg(recPlanId);
        String param = (String)this.getView().getFormShowParameter().getCustomParam("model");
        ReconciliationParamModel paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
        boolean api = paramModel.isApi();
        boolean init = paramModel.isInit();
        BalanceBasisEnum headBalanceBasis = planModel.getBalanceBasis();
        boolean hideBalanceBasis = true;
        int size = planModel.getDetail().size();
        HashMap<Long, BizReconPlanDetailModel> detailInfoMap = new HashMap<Long, BizReconPlanDetailModel>(size);
        HashSet<Long> ignorePlanDetailIds = new HashSet<Long>(size);
        if (size > 0) {
            for (BizReconPlanDetailModel detailModel : planModel.getDetail()) {
                detailInfoMap.put(detailModel.getId(), detailModel);
                BalanceBasisEnum balanceBasis = detailModel.getBalanceBasis();
                if (headBalanceBasis != balanceBasis) {
                    hideBalanceBasis = false;
                }
                if (detailModel.isCloseParam() || !api || init) continue;
                ignorePlanDetailIds.add(detailModel.getId());
            }
        }
        if (ignorePlanDetailIds.size() > 0) {
            resultList = resultList.stream().filter(row -> !ignorePlanDetailIds.contains(row.getLong("plandetailid"))).collect(Collectors.toList());
        }
        if (init) {
            hideBalanceBasis = true;
        }
        this.getView().setVisible(Boolean.valueOf(!hideBalanceBasis && planModel.getReconAmountType() == ReconAmountTypeEnum.DEBIT_CREDIT_CLOSE), new String[]{"detailbalcbasis"});
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long orgId = org.getLong("id");
        HashMap needQueryBasedata = new HashMap(10);
        resultList.forEach(row -> {
            Long plandetailid = row.getLong("plandetailid");
            BizReconPlanDetailModel detailModel = (BizReconPlanDetailModel)detailInfoMap.get(plandetailid);
            ReconciliationUtil.planDetailAssist((BizReconPlanDetailModel)detailModel, (Long)orgId);
            int assistType = row.getInteger("assisttype");
            if (AssistTypeEnum.Acct.getValue() != assistType) {
                Map glAssistIndexMap = detailModel.getGlAssistIndexMap();
                Map bizAssistIndexMap = detailModel.getBizAssistIndexMap();
                Map asstTypeMappingIndex = detailModel.getAsstTypeMappingIndex();
                for (Map.Entry glAssist : glAssistIndexMap.entrySet()) {
                    String[] valGroups;
                    Map mappingBizAssistIndexMap;
                    Set glValSet = needQueryBasedata.computeIfAbsent(glAssist.getKey(), v -> new HashSet());
                    long assistVal = FrmRowUtil.getLongVal((Row)row, (String)("assist" + ((Integer)glAssist.getValue() + 1) + "_gl"), (long)0L);
                    if (assistVal != 0L) {
                        glValSet.add(assistVal);
                    }
                    if ((mappingBizAssistIndexMap = (Map)asstTypeMappingIndex.get(glAssist.getKey())) == null) {
                        Long val = row.getLong("app_show_assist" + ((Integer)glAssist.getValue() + 1));
                        if (val == null || val == 0L) continue;
                        Set bizValSet = needQueryBasedata.computeIfAbsent(glAssist.getKey(), v -> new HashSet());
                        bizValSet.add(val);
                        continue;
                    }
                    String appValGroup = row.getString("app_show_assist" + ((Integer)glAssist.getValue() + 1));
                    if (StringUtils.isEmpty((String)appValGroup)) {
                        for (Map.Entry bizAssist : bizAssistIndexMap.entrySet()) {
                            needQueryBasedata.computeIfAbsent(bizAssist.getKey(), v -> new HashSet());
                        }
                        continue;
                    }
                    for (String valGroup : valGroups = appValGroup.split(";")) {
                        String[] vals = valGroup.split(",");
                        for (Map.Entry bizAssist : bizAssistIndexMap.entrySet()) {
                            Set bizValSet = needQueryBasedata.computeIfAbsent(bizAssist.getKey(), v -> new HashSet());
                            try {
                                long val = Long.parseLong(vals[(Integer)bizAssist.getValue() - 1]);
                                bizValSet.add(val);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            } else {
                List bizFilterAssistMapList = detailModel.getBizFilterAssistMapList();
                for (Map bizFilterAssistMap : bizFilterAssistMapList) {
                    for (Map.Entry entry : bizFilterAssistMap.entrySet()) {
                        QFilter idFilter;
                        Set basedataIds;
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        Set vals = needQueryBasedata.computeIfAbsent(key, v -> new HashSet());
                        if (!StringUtils.isNotEmpty((String)value) || CollectionUtils.isEmpty((Collection)(basedataIds = (Set)(idFilter = QFilter.fromSerializedString((String)value)).getValue()))) continue;
                        vals.addAll(basedataIds);
                    }
                }
            }
        });
        Map baseDataName = ReconciliationUtil.getBaseDataName(needQueryBasedata);
        Map<String, String> baseDataTypeName = this.queryAssistEntityName(needQueryBasedata.keySet());
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        MulBasedataProp accountProp = (MulBasedataProp)model.getEntryEntity("entryentity").getDynamicObjectType().getProperty("account");
        DynamicObjectType accountPropertyType = accountProp.getDynamicCollectionItemPropertyType();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int assistType = 0;
        for (int seq = 0; seq < resultList.size(); ++seq) {
            boolean hasDealAssist = false;
            Row rowData = (Row)resultList.get(seq);
            Long plandetailid = rowData.getLong("plandetailid");
            BizReconPlanDetailModel detailModel = (BizReconPlanDetailModel)detailInfoMap.get(plandetailid);
            String[] fieldNames = ((RowMeta)detailRowMetaMap.get(plandetailid)).getFieldNames();
            vs.set("detailbalcbasis", (Object)String.valueOf(detailModel.getBalanceBasis().getValue()), seq);
            assistType = rowData.getInteger("assisttype");
            if (AssistTypeEnum.Acct.getValue() == assistType) {
                hasDealAssist = true;
                String assistShowName = this.fillAcctRowAssistName(baseDataName, baseDataTypeName, detailModel, originPlanEntryFilter);
                vs.set("assit_app", (Object)assistShowName, seq);
            }
            for (String fldName : fieldNames) {
                if ("rules".equals(fldName)) {
                    vs.set("ruleid", (Object)rowData.getString("rules"), seq);
                    continue;
                }
                if ("plandetailid".equals(fldName)) {
                    Set acctIds = detailModel.getAccountIds();
                    DynamicObjectCollection accountCol = new DynamicObjectCollection();
                    if (acctIds != null && acctIds.size() > 0) {
                        for (Long acctId : acctIds) {
                            DynamicObject instance = (DynamicObject)accountPropertyType.createInstance();
                            instance.set("fbasedataid_id", (Object)acctId);
                            accountCol.add((Object)instance);
                        }
                    } else {
                        String accountStr = rowData.getString("account");
                        if (StringUtils.isNotEmpty((String)accountStr)) {
                            DynamicObject accounts;
                            for (Object account : accounts = accountStr.split(",")) {
                                DynamicObject instance = (DynamicObject)accountPropertyType.createInstance();
                                instance.set("fbasedataid_id", (Object)Long.parseLong((String)account));
                                accountCol.add((Object)instance);
                            }
                        }
                    }
                    vs.set("account", (Object)accountCol, seq);
                    vs.set("plandetailid", (Object)plandetailid, seq);
                    continue;
                }
                if (fldName.contains("assisttype")) {
                    vs.set(fldName, rowData.get(fldName), seq);
                    continue;
                }
                if (fldName.contains("assist")) {
                    Object account;
                    if (hasDealAssist) continue;
                    hasDealAssist = true;
                    StringBuilder glAssistName = new StringBuilder();
                    StringBuilder appAssistName = new StringBuilder();
                    Map glAssistIndexMap = detailModel.getGlAssistIndexMap();
                    Map bizAssistIndexMap = detailModel.getBizAssistIndexMap();
                    Map asstTypeMappingIndex = detailModel.getAsstTypeMappingIndex();
                    ArrayList<Object[]> bizAssistGroup = new ArrayList<Object[]>();
                    HashMap<String, Set> assistMap = new HashMap<String, Set>(glAssistIndexMap.size());
                    account = glAssistIndexMap.entrySet().iterator();
                    while (account.hasNext()) {
                        String showName;
                        Map.Entry glAssist = (Map.Entry)account.next();
                        String assistVal = rowData.getString("assist" + ((Integer)glAssist.getValue() + 1) + "_gl");
                        assistMap.computeIfAbsent((String)glAssist.getKey(), p -> new HashSet()).add(Long.parseLong(assistVal));
                        glAssistName.append(baseDataTypeName.get(glAssist.getKey())).append(":");
                        if (StringUtils.isNotEmpty((String)assistVal) && !"null".equals(assistVal) && !"0".equals(assistVal) && StringUtils.isNotEmpty((String)(showName = (String)((Map)baseDataName.get(glAssist.getKey())).get(assistVal)))) {
                            glAssistName.append(showName);
                        }
                        glAssistName.append(";");
                        String appValGroup = rowData.getString("app_show_assist" + ((Integer)glAssist.getValue() + 1));
                        Map mappingBizAssistIndexMap = (Map)asstTypeMappingIndex.get(glAssist.getKey());
                        if (mappingBizAssistIndexMap == null) {
                            appAssistName.append(baseDataTypeName.get(glAssist.getKey())).append(":");
                            if (StringUtils.isEmpty((String)appValGroup)) {
                                appAssistName.append(";");
                                continue;
                            }
                            String bizShowName = (String)((Map)baseDataName.get(glAssist.getKey())).get(appValGroup);
                            appAssistName.append((String)(bizShowName == null ? "" : bizShowName)).append(";");
                            Integer bizAssistSeq = (Integer)bizAssistIndexMap.get(glAssist.getKey());
                            if (bizAssistGroup.isEmpty()) {
                                Object[] assistGroup = new Object[bizAssistIndexMap.size()];
                                assistGroup[bizAssistSeq.intValue() - 1] = appValGroup;
                                bizAssistGroup.add(assistGroup);
                                continue;
                            }
                            for (Object[] assistGroup : bizAssistGroup) {
                                assistGroup[bizAssistSeq.intValue() - 1] = appValGroup;
                            }
                            continue;
                        }
                        if (StringUtils.isEmpty((String)appValGroup)) {
                            for (Map.Entry bizAssist : mappingBizAssistIndexMap.entrySet()) {
                                appAssistName.append(baseDataTypeName.get(bizAssist.getKey())).append(":,");
                            }
                            continue;
                        }
                        String[] valGroups = appValGroup.split(";");
                        boolean needAppendNewRow = bizAssistGroup.size() < valGroups.length || bizAssistGroup.isEmpty();
                        for (String valGroup : valGroups) {
                            Object[] assistGroup = new Object[bizAssistIndexMap.size()];
                            String[] vals = valGroup.split(",");
                            for (Map.Entry bizAssist : mappingBizAssistIndexMap.entrySet()) {
                                appAssistName.append(baseDataTypeName.get(bizAssist.getKey())).append(":");
                                try {
                                    String val = vals[(Integer)bizAssist.getValue() - 1];
                                    String bizShowName = (String)((Map)baseDataName.get(bizAssist.getKey())).get(val);
                                    appAssistName.append(bizShowName == null ? "" : bizShowName).append(",");
                                    assistGroup[((Integer)bizAssist.getValue()).intValue() - 1] = val;
                                }
                                catch (Exception e) {
                                    logger.warn("\u4e1a\u52a1\u7ef4\u5ea6\u503c\u8bfb\u53d6\u5931\u8d25", (Throwable)e);
                                }
                            }
                            if (needAppendNewRow) {
                                bizAssistGroup.add(assistGroup);
                            } else {
                                for (Object[] orgAssistGroup : bizAssistGroup) {
                                    for (int i = 0; i < assistGroup.length; ++i) {
                                        Object copyVal = assistGroup[i];
                                        if (copyVal == null) continue;
                                        orgAssistGroup[i] = copyVal;
                                    }
                                }
                            }
                            if (appAssistName.lastIndexOf(",") <= -1) continue;
                            appAssistName.deleteCharAt(appAssistName.length() - 1);
                            appAssistName.append(";");
                        }
                    }
                    if (appAssistName.lastIndexOf(",") > -1) {
                        appAssistName.deleteCharAt(appAssistName.length() - 1);
                    }
                    if (appAssistName.lastIndexOf(";") > -1) {
                        appAssistName.deleteCharAt(appAssistName.length() - 1);
                    }
                    if (glAssistName.lastIndexOf(";") > -1) {
                        glAssistName.deleteCharAt(glAssistName.length() - 1);
                    }
                    vs.set("assit_app", (Object)appAssistName.toString(), seq);
                    vs.set("assist_gl", (Object)glAssistName.toString(), seq);
                    Object[] bizAssistHead = new Object[bizAssistIndexMap.size()];
                    for (Map.Entry bizAssistIndex : bizAssistIndexMap.entrySet()) {
                        bizAssistHead[((Integer)bizAssistIndex.getValue()).intValue() - 1] = bizAssistIndex.getKey();
                    }
                    bizAssistGroup.add(0, bizAssistHead);
                    vs.set("bizassist", (Object)SerializationUtils.toJsonString(bizAssistGroup), seq);
                    vs.set("assist", (Object)SerializationUtils.toJsonString(assistMap), seq);
                    continue;
                }
                vs.set(fldName, rowData.get(fldName), seq);
            }
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private String fillAcctRowAssistName(Map<String, Map<String, String>> baseDataName, Map<String, String> baseDataTypeName, BizReconPlanDetailModel detailModel, Map<Long, Map<String, Set<Long>>> originPlanEntryFilter) {
        StringBuilder appAssistName = new StringBuilder();
        List bizFilterAssistMapList = detailModel.getBizFilterAssistMapList();
        if (detailModel.isGroupAssistFilter()) {
            Map assistFilterRow = (Map)bizFilterAssistMapList.get(0);
            for (Map.Entry entry : assistFilterRow.entrySet()) {
                String key = (String)entry.getKey();
                appAssistName.append(baseDataTypeName.get(key)).append("+");
            }
            appAssistName.deleteCharAt(appAssistName.length() - 1);
        } else if (bizFilterAssistMapList.size() > 0) {
            Map<String, Set<Long>> detailModelFilterCfg = originPlanEntryFilter.get(detailModel.getId());
            if (detailModelFilterCfg == null) {
                return appAssistName.toString();
            }
            for (Map.Entry<String, Set<Long>> entry : detailModelFilterCfg.entrySet()) {
                String key = entry.getKey();
                appAssistName.append(baseDataTypeName.get(key)).append(":");
                Set<Long> basedataIds = entry.getValue();
                Map<String, String> nameMap = baseDataName.get(key);
                if (nameMap == null || basedataIds == null) continue;
                for (Long basedataId : basedataIds) {
                    String name = nameMap.get(String.valueOf(basedataId));
                    if (!StringUtils.isNotEmpty((String)name)) continue;
                    appAssistName.append(name).append(",");
                }
                if (appAssistName.indexOf(",") > -1) {
                    appAssistName.deleteCharAt(appAssistName.length() - 1);
                }
                appAssistName.append(";");
            }
        }
        if (appAssistName.lastIndexOf(";") > -1) {
            appAssistName.deleteCharAt(appAssistName.length() - 1);
        }
        return appAssistName.toString();
    }

    private Map<String, String> queryAssistEntityName(Set<String> entityKeySet) {
        DynamicObject[] load;
        HashMap<String, String> entityNameMap = new HashMap<String, String>();
        List bdEntity = entityKeySet.stream().filter(key -> AssistDataType.isBaseDataType((String)key.split("\\.")[0])).map(key -> key.split("\\.")[1]).collect(Collectors.toList());
        List adEntity = entityKeySet.stream().filter(key -> !AssistDataType.isBaseDataType((String)key.split("\\.")[0])).map(key -> Long.parseLong(key.split("\\.")[1])).collect(Collectors.toList());
        if (bdEntity.size() > 0) {
            for (DynamicObject entity : load = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("number", "in", bdEntity)})) {
                entityNameMap.put(AssistDataType.makeAssistKey((String)AssistDataType.BASEDATA.getBdType(), (String)entity.getString("number")), entity.getString("name"));
            }
        }
        if (adEntity.size() > 0) {
            for (DynamicObject entity : load = BusinessDataServiceHelper.load((String)"bos_assistantdatagroup", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", adEntity)})) {
                entityNameMap.put(AssistDataType.makeAssistKey((String)AssistDataType.ASSISTASNT.getBdType(), (String)entity.getString("id")), entity.getString("name"));
            }
        }
        return entityNameMap;
    }

    private Map<Long, Map<String, Set<Long>>> queryReconSchemeEntryFilterCfg(Long planId) {
        DynamicObject recPlan = BusinessDataServiceHelper.loadSingleFromCache((String)"frm_reconciliation_scheme", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)planId)});
        DynamicObjectCollection tab1Entry = recPlan.getDynamicObjectCollection("modularentryentity");
        DynamicObjectCollection fieldmapEntrys = recPlan.getDynamicObjectCollection("fieldmapentry");
        HashMap<Long, Map<String, Set<Long>>> resultMap = new HashMap<Long, Map<String, Set<Long>>>(tab1Entry.size(), 1.0f);
        for (DynamicObject acctEntryRow : tab1Entry) {
            long rowId = acctEntryRow.getLong("id");
            String assistFilter = acctEntryRow.getString("assistfilterinfo_tag");
            if (StringUtils.isNotEmpty((String)assistFilter)) continue;
            HashMap bizAssitmap = new HashMap(4);
            for (DynamicObject fieldmapEntry : fieldmapEntrys) {
                String entityId = fieldmapEntry.getString("entityid");
                String fieldKey = fieldmapEntry.getString("fieldkey");
                String bdtype = fieldmapEntry.getString("datatype");
                Object assits = null;
                if (AssistDataType.isBaseDataType((String)bdtype)) {
                    assits = acctEntryRow.getDynamicObjectCollection(fieldKey);
                } else {
                    DynamicObjectCollection acctassistentry = acctEntryRow.getDynamicObjectCollection("acctassistentry");
                    assits = acctassistentry.stream().filter(dyn -> fieldKey.equals(dyn.getString("assistfield"))).collect(Collectors.toList());
                }
                if (assits.isEmpty()) continue;
                HashSet<Long> assistIdSet = new HashSet<Long>(10);
                Iterator iterator = assits.iterator();
                while (iterator.hasNext()) {
                    DynamicObject row = (DynamicObject)iterator.next();
                    if (AssistDataType.isBaseDataType((String)bdtype)) {
                        assistIdSet.add(row.getLong("fbasedataid_id"));
                        continue;
                    }
                    assistIdSet.add(row.getLong("assistvalue"));
                }
                bizAssitmap.put(AssistDataType.makeAssistKey((String)bdtype, (String)entityId), assistIdSet);
            }
            resultMap.put(rowId, bizAssitmap);
        }
        return resultMap;
    }
}

