/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.frm.common.constant.ReconciliationFormConstant;
import kd.fi.frm.common.enums.AssistDataType;
import kd.fi.frm.common.model.bizdata.BizDataTypeEnum;
import kd.fi.frm.common.util.FrmStringUtil;
import kd.fi.frm.common.util.MetadataUtil;
import kd.fi.frm.formplugin.DSField;
import kd.fi.frm.formplugin.assist.AssistChangeTypeEnum;
import kd.fi.frm.formplugin.assist.FactorInfo;

public class ReconciliactionCommonFilterFormPlugin
extends AbstractFormPlugin
implements ReconciliationFormConstant {
    private static final String BIZ_ORG = "bizorg";
    private static final String PERIOD = "period";
    private static final String BIZDATE = "bizdate";
    public static final String BIZ_OBJ = "bizobj";
    public static final String ENTRY_ASSIST = "basedata";
    public static final String ITEMCLASS = "itemclass";
    public static final int ASSIST_SIZE = 8;
    private static final String KEY_ASSIST = "reconassist";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_ASSIST});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (KEY_ASSIST.equals(key)) {
            FormShowParameter assistF7Form = new FormShowParameter();
            assistF7Form.setFormId("frm_recon_assistf7");
            assistF7Form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_ASSIST));
            assistF7Form.getOpenStyle().setShowType(ShowType.Modal);
            String factorString = this.getPageCache().get("assist.factorInfo");
            assistF7Form.setCustomParam("info", (Object)factorString);
            this.getView().showForm(assistF7Form);
        }
    }

    public void afterBindData(EventObject e) {
        IFormView parentView;
        if (this.getView().getParentView() != null && (parentView = this.getView().getParentView().getParentView()) != null && "frm_recdatarule".equalsIgnoreCase(parentView.getEntityId())) {
            IDataModel commonFilterModel = parentView.getModel();
            int rowIndex = commonFilterModel.getEntryCurrentRowIndex("entryentity");
            DynamicObject selectedObj = (DynamicObject)commonFilterModel.getValue(BIZ_OBJ, rowIndex);
            this.getModel().setValue(BIZ_OBJ, (Object)selectedObj.getString("id"));
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"bar_new"});
        for (int i = 0; i < 8; ++i) {
            String field = ENTRY_ASSIST + i;
            this.getView().setVisible(Boolean.valueOf(this.getModel().getValue(field, 0) != "" && this.getModel().getValue(field, 0) != null), new String[]{field});
        }
        DynamicObject sourceBill = (DynamicObject)this.getModel().getValue(BIZ_OBJ);
        if (sourceBill != null) {
            String period = (String)this.getModel().getValue(PERIOD);
            String bizdate = (String)this.getModel().getValue(BIZDATE);
            String bozorg = (String)this.getModel().getValue(BIZ_ORG);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBill.getString("number"));
            this.initBaseDataItems("bos_org", BIZ_ORG, mainEntityType);
            this.initBaseDataItems("bd_period", PERIOD, mainEntityType);
            this.fillVchDateItems(mainEntityType);
            this.getModel().setValue(PERIOD, (Object)period);
            this.getModel().setValue(BIZDATE, (Object)bizdate);
            this.getModel().setValue(BIZ_ORG, (Object)bozorg);
        }
        DynamicObjectCollection assistEntry = this.getModel().getEntryEntity("fieldmapentry");
        HashMap<String, FactorInfo> factorInfoMap = new HashMap<String, FactorInfo>();
        ArrayList<String> showAssistName = new ArrayList<String>();
        ArrayList<DSField> dynamicCols = new ArrayList<DSField>();
        int fieldMapKeyIndex = 0;
        for (DynamicObject assist : assistEntry) {
            FactorInfo info = new FactorInfo();
            String entityId = assist.getString("entityid");
            if (StringUtils.isEmpty((CharSequence)entityId)) continue;
            String bdtype = assist.getString("datatype");
            String localeValue = "";
            if (AssistDataType.isBaseDataType((String)bdtype)) {
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
                if (dataEntityType == null) continue;
                localeValue = dataEntityType.getDisplayName().getLocaleValue();
            } else if (AssistDataType.isAssistantDataType((String)bdtype)) {
                DynamicObject assistGroup = BusinessDataServiceHelper.loadSingle((String)"bos_assistantdatagroup", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(entityId))});
                if (assistGroup == null) continue;
                localeValue = assistGroup.getString("name");
            }
            info.setFactorName(localeValue);
            info.setSrcEntityName(localeValue);
            showAssistName.add(localeValue);
            info.setSrcPropKey(entityId);
            info.setBDType(Integer.parseInt(bdtype) - 1);
            info.setSrcEntityNumber(entityId);
            factorInfoMap.put(entityId, info);
            DSField dsfield = new DSField();
            dsfield.setDataType("" + (1 + info.getBDType()));
            dsfield.setEntityId(entityId);
            dsfield.setFieldKey(ENTRY_ASSIST + fieldMapKeyIndex++);
            dsfield.setFieldName(new LocaleString(info.getSrcEntityName()));
            dynamicCols.add(dsfield);
        }
        if (sourceBill != null) {
            this.initDynamicAssistCol(sourceBill.getString("number"), dynamicCols, false);
        }
        this.getPageCache().put("assist.factorInfo", SerializationUtils.serializeToBase64(factorInfoMap));
        this.getModel().setValue(KEY_ASSIST, (Object)FrmStringUtil.substring((String)String.join((CharSequence)",", showAssistName), (int)100));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity.size() > 1) {
            int size = entryEntity.size();
            for (int i = 0; i < size - 1; ++i) {
                this.getModel().deleteEntryRow("entryentity", 1);
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (BIZ_OBJ.equals(key)) {
            this.bizObjChanged();
            for (int i = 0; i < 8; ++i) {
                String field = ENTRY_ASSIST + i;
                this.getView().setVisible(Boolean.FALSE, new String[]{field});
                this.getModel().setValue(field, null, 0);
            }
        } else if (BIZDATE.equals(key)) {
            if (this.getModel().getValue(BIZDATE) != null) {
                this.getModel().setValue(PERIOD, null);
            }
        } else if (PERIOD.equals(key)) {
            if (this.getModel().getValue(PERIOD) != null) {
                this.getModel().setValue(BIZDATE, null);
            }
        } else if (KEY_ASSIST.equals(key) && StringUtils.isBlank((Object)(changeData = e.getChangeSet()[0]).getNewValue())) {
            this.resetEntryEntity();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        Object data = event.getReturnData();
        if (data == null) {
            return;
        }
        if (KEY_ASSIST.equals(event.getActionId())) {
            void var10_16;
            Map returnData = (Map)data;
            Object closeType = returnData.get("closeType");
            if (!"ok".equalsIgnoreCase(closeType.toString())) {
                return;
            }
            Map factorInfoMap = (Map)returnData.get("factorInfoMap");
            if (factorInfoMap.size() > 8) {
                String errMsg = ResManager.loadKDString((String)"\u5bf9\u8d26\u7ef4\u5ea6\u4e0d\u80fd\u8d85\u8fc78\u4e2a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01", (String)"ReconciliactionCommonFilterFormPlugin_9", (String)"fi-frm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(errMsg);
                return;
            }
            if (factorInfoMap.size() == 0) {
                this.resetEntryEntity();
                return;
            }
            String cacheAssist = this.getPageCache().get("assist.factorInfo");
            if (StringUtils.isEmpty((CharSequence)cacheAssist)) {
                this.assistChangedAction(AssistChangeTypeEnum.CHANGED, factorInfoMap);
                return;
            }
            Map oldCacheAssist = (Map)SerializationUtils.deSerializeFromBase64((String)cacheAssist);
            HashSet<String> oldAssist = new HashSet<String>(oldCacheAssist.size());
            for (Map.Entry entry : oldCacheAssist.entrySet()) {
                oldAssist.add(((FactorInfo)entry.getValue()).getAssistKey());
            }
            HashSet<String> newAssist = new HashSet<String>(factorInfoMap.size());
            for (Map.Entry entry : factorInfoMap.entrySet()) {
                newAssist.add(((FactorInfo)entry.getValue()).getAssistKey());
            }
            AssistChangeTypeEnum assistChangeTypeEnum = AssistChangeTypeEnum.CHANGED;
            if (newAssist.isEmpty()) {
                AssistChangeTypeEnum assistChangeTypeEnum2 = AssistChangeTypeEnum.NO_ASSIST;
            } else if (newAssist.containsAll(oldAssist) && oldAssist.containsAll(newAssist)) {
                AssistChangeTypeEnum assistChangeTypeEnum3 = AssistChangeTypeEnum.NO_CHANGE;
            }
            this.assistChangedAction((AssistChangeTypeEnum)var10_16, factorInfoMap);
        }
    }

    private void assistChangedAction(AssistChangeTypeEnum changeType, Map<Object, FactorInfo> factorInfoMap) {
        if (AssistChangeTypeEnum.NO_CHANGE == changeType) {
            return;
        }
        if (AssistChangeTypeEnum.NO_ASSIST == changeType) {
            this.getModel().deleteEntryData("fieldmapentry");
            this.getModel().setValue(KEY_ASSIST, null);
            this.getModel().deleteEntryData("entryentity");
            this.getPageCache().remove("assist.factorInfo");
            this.getView().updateView();
            return;
        }
        DynamicObjectCollection fieldMapEntry = this.getModel().getEntryEntity("fieldmapentry");
        HashMap<String, Object> oldAssistValueMap = new HashMap<String, Object>(fieldMapEntry.size());
        for (DynamicObject fieldMap : fieldMapEntry) {
            String bdtype = fieldMap.getString("datatype");
            String entityId = fieldMap.getString("entityid");
            String fieldKey = fieldMap.getString("fieldkey");
            IDataEntityProperty property = this.getModel().getProperty(fieldKey);
            if (property == null) continue;
            Object fieldValue = this.getModel().getValue(fieldKey, 0);
            oldAssistValueMap.put(FrmStringUtil.dot((String[])new String[]{bdtype, entityId}), fieldValue);
        }
        this.getPageCache().put("assist.factorInfo", SerializationUtils.serializeToBase64(factorInfoMap));
        ArrayList<FactorInfo> selectAssists = new ArrayList<FactorInfo>(factorInfoMap.values());
        ArrayList<String> showAssistName = new ArrayList<String>(selectAssists.size());
        ArrayList<DSField> dynamicCols = new ArrayList<DSField>(selectAssists.size());
        int seqIndex = 0;
        for (FactorInfo factorInfo : selectAssists) {
            showAssistName.add(factorInfo.getSrcEntityName());
            DSField dsfield = new DSField();
            dsfield.setDataType("" + (1 + factorInfo.getBDType()));
            dsfield.setEntityId(factorInfo.getSrcPropKey());
            dsfield.setFieldKey(ENTRY_ASSIST + seqIndex++);
            dsfield.setFieldName(new LocaleString(factorInfo.getSrcEntityName()));
            dsfield.setFieldValue(oldAssistValueMap.get(factorInfo.getAssistKey()));
            dynamicCols.add(dsfield);
        }
        String showAssist = String.join((CharSequence)",", showAssistName);
        showAssist = showAssist.length() > 100 ? showAssist.substring(0, 100) : showAssist;
        this.getModel().setValue(KEY_ASSIST, (Object)showAssist);
        this.getModel().deleteEntryData("entryentity");
        DynamicObject sourceBill = (DynamicObject)this.getModel().getValue(BIZ_OBJ);
        this.initDynamicAssistCol(sourceBill.getString("number"), dynamicCols, true);
        if (this.getModel().getEntryRowCount("entryentity") == 0) {
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            for (DSField field : dynamicCols) {
                this.getModel().setValue(field.getFieldKey(), field.getFieldValue(), rowIndex);
            }
        }
    }

    private void initDynamicAssistCol(String entityNum, List<DSField> dsFields, boolean reFillAssistMap) {
        if (reFillAssistMap) {
            this.saveFactorDataToModel(dsFields);
            for (int i = 0; i < 8; ++i) {
                String field = ENTRY_ASSIST + i;
                this.getView().setVisible(Boolean.FALSE, new String[]{field});
            }
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        int width = dsFields.size() > 0 ? 95 / dsFields.size() : 95;
        for (DSField field : dsFields) {
            String fieldKey = field.getFieldKey();
            HashSet<String> entityIds = new HashSet<String>();
            if ("bos_adminorg".equals(field.getEntityId()) || "bos_org".equals(field.getEntityId())) {
                entityIds.add("bos_org");
                entityIds.add("bos_adminorg");
            } else {
                entityIds.add(field.getEntityId());
            }
            ArrayList items = new ArrayList(10);
            if (AssistDataType.isBaseDataType((String)field.getDataType())) {
                MetadataUtil.buildPropComboItemsV2(items, entityIds, (IDataEntityType)mainEntityType, (IDataEntityType)mainEntityType, (int)3, (int)1, (String)"", (String)"");
            } else if (AssistDataType.isAssistantDataType((String)field.getDataType())) {
                MetadataUtil.buildAssistPropComboItems(items, entityIds, (IDataEntityType)mainEntityType, (int)3, (int)1, (String)"", (String)"");
            }
            ComboEdit comboEditor = (ComboEdit)this.getView().getControl(fieldKey);
            comboEditor.setComboItems(items);
            this.getView().setVisible(Boolean.TRUE, new String[]{fieldKey});
            ((ComboEdit)this.getControl(fieldKey)).setMustInput(true);
            AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
            grid.setColumnProperty(fieldKey, "header", (Object)field.getFieldName());
            grid.setColumnProperty(fieldKey, "w", (Object)new LocaleString(width + "%"));
        }
    }

    private void resetEntryEntity() {
        this.getModel().deleteEntryData("entryentity");
        for (int i = 0; i < 8; ++i) {
            String field = ENTRY_ASSIST + i;
            ComboEdit comboEditor = (ComboEdit)this.getView().getControl(field);
            comboEditor.setComboItems(Collections.emptyList());
            this.getView().setVisible(Boolean.FALSE, new String[]{field});
            ((ComboEdit)this.getControl(field)).setMustInput(false);
            AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
            grid.setColumnProperty(field, "header", null);
        }
        this.getPageCache().remove("assist.factorInfo");
        this.getModel().deleteEntryData("fieldmapentry");
    }

    private void saveFactorDataToModel(List<DSField> refList) {
        IDataModel model = this.getModel();
        model.deleteEntryData("fieldmapentry");
        for (DSField field : refList) {
            int rowIndex = model.createNewEntryRow("fieldmapentry");
            model.setValue("datatype", (Object)field.getDataType(), rowIndex);
            model.setValue("entityid", (Object)field.getEntityId(), rowIndex);
            model.setValue("fieldname", (Object)field.getFieldName(), rowIndex);
            model.setValue("fieldkey", (Object)field.getFieldKey(), rowIndex);
        }
    }

    private void initCombox(MainEntityType mainEntityType) {
        this.initBaseDataItems("bos_org", BIZ_ORG, mainEntityType);
        this.initBaseDataItems("bd_period", PERIOD, mainEntityType);
        this.fillVchDateItems(mainEntityType);
    }

    private void bizObjChanged() {
        DynamicObject sourceBill = (DynamicObject)this.getModel().getValue(BIZ_OBJ);
        if (sourceBill != null) {
            String srcFormNumber = (String)sourceBill.getPkValue();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)srcFormNumber);
            this.initCombox(mainEntityType);
        } else {
            ArrayList items = new ArrayList();
            ComboEdit orgEditor = (ComboEdit)this.getView().getControl(BIZ_ORG);
            orgEditor.setComboItems(items);
            ComboEdit periodEditor = (ComboEdit)this.getView().getControl(PERIOD);
            periodEditor.setComboItems(items);
            ComboEdit bizdateEditor = (ComboEdit)this.getView().getControl(BIZDATE);
            bizdateEditor.setComboItems(items);
        }
    }

    private void initBaseDataItems(String prop, String field, MainEntityType mainEntityType) {
        HashSet<String> entityIds = new HashSet<String>();
        entityIds.add(prop);
        List items = MetadataUtil.buildPropComboItems(entityIds, (MainEntityType)mainEntityType, (boolean)true, (boolean)true, (boolean)true);
        ComboEdit orgEditor = (ComboEdit)this.getView().getControl(field);
        orgEditor.setComboItems(items);
    }

    private void fillVchDateItems(MainEntityType srcMainET) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        String currLCId = Lang.get().toString();
        if (srcMainET != null) {
            for (IDataEntityProperty prop : srcMainET.getProperties()) {
                if (!(prop instanceof DateTimeProp) || !StringUtils.isNotEmpty((CharSequence)prop.getAlias())) continue;
                DateTimeProp dateProp = (DateTimeProp)prop;
                ComboItem item = new ComboItem();
                item.setValue(dateProp.getName());
                item.setCaption(new LocaleString(currLCId, this.buildPropCaption((DynamicProperty)dateProp)));
                items.add(item);
            }
        }
        ComboEdit fieldEditor = (ComboEdit)this.getView().getControl(BIZDATE);
        fieldEditor.setComboItems(items);
    }

    private String buildPropCaption(DynamicProperty prop) {
        EntityType parentType = (EntityType)prop.getParent();
        String parentName = ResManager.loadKDString((String)"\u5355\u636e\u4f53", (String)"ReconciliactionCommonFilterFormPlugin_0", (String)"fi-frm-formplugin", (Object[])new Object[0]);
        if (parentType.getDisplayName() != null) {
            parentName = parentType.getDisplayName().toString();
        }
        String propName = prop.getDisplayName() != null ? prop.getDisplayName().toString() : this.getFieldSelector(prop);
        String caption = String.format("%s.%s", parentName, propName);
        return caption;
    }

    private String getFieldSelector(DynamicProperty rateProp) {
        String selector = rateProp.getName();
        if (rateProp.getParent() != null && rateProp.getParent().getParent() != null && rateProp.getParent().getParent().getParent() != null && rateProp.getParent().getParent().getParent().getParent() == null) {
            selector = rateProp.getParent().getParent().getName() + "." + rateProp.getParent().getName() + "." + selector;
        }
        return selector;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        if (e.getSource() instanceof Save) {
            Object periodFld = this.getModel().getValue(PERIOD);
            Object bizDateFld = this.getModel().getValue(BIZDATE);
            if (periodFld != null && StringUtils.isNotEmpty((CharSequence)periodFld.toString()) && bizDateFld != null && StringUtils.isNotEmpty((CharSequence)bizDateFld.toString())) {
                String errMsg = ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4\u548c\u4e1a\u52a1\u65e5\u671f\u5b57\u6bb5\u6700\u591a\u53ea\u80fd\u586b\u5199\u4e00\u4e2a", (String)"ReconciliactionCommonFilterFormPlugin_1", (String)"fi-frm-formplugin", (Object[])new Object[0]);
                e.setCancel(true);
                e.setCancelMessage(errMsg);
                this.getView().showErrorNotification(errMsg);
                return;
            }
            Object objDataType = this.getView().getFormShowParameter().getCustomParam("datatype");
            if (objDataType != null) {
                int dataType = Integer.parseInt(objDataType.toString());
                boolean isCancel = false;
                String msg = "";
                if (BizDataTypeEnum.Init.getValue() == dataType && (this.isNotNullAndEmpty(periodFld) || this.isNotNullAndEmpty(bizDateFld))) {
                    msg = ResManager.loadKDString((String)"\u53d6\u6570\u7c7b\u578b\u4e3a\u521d\u59cb\u5316\u65f6\uff0c\u4f1a\u8ba1\u671f\u95f4\u3001\u4e1a\u52a1\u65e5\u671f\u9700\u8bbe\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReconciliactionCommonFilterFormPlugin_6", (String)"fi-frm-formplugin", (Object[])new Object[0]);
                    isCancel = true;
                } else if ((BizDataTypeEnum.Debit.getValue() == dataType || BizDataTypeEnum.Credit.getValue() == dataType) && this.isNullAndEmpty(periodFld) && this.isNullAndEmpty(bizDateFld)) {
                    String name = "";
                    name = BizDataTypeEnum.Debit.getValue() == dataType ? BizDataTypeEnum.Debit.getName() : BizDataTypeEnum.Credit.getName();
                    msg = String.format(ResManager.loadKDString((String)"\u53d6\u6570\u7c7b\u578b\u4e3a%s\u65f6\uff0c\u4f1a\u8ba1\u671f\u95f4\u3001\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReconciliactionCommonFilterFormPlugin_7", (String)"fi-frm-formplugin", (Object[])new Object[0]), name);
                    isCancel = true;
                }
                if (isCancel) {
                    e.setCancel(true);
                    e.setCancelMessage(msg);
                    this.getView().showErrorNotification(msg);
                    return;
                }
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            Object idPk = this.getModel().getValue("id");
            if (idPk != null) {
                filters.add(new QFilter("id", "!=", idPk));
            }
            Object bizObj = this.getModel().getValue(BIZ_OBJ);
            String bizObjName = "";
            if (bizObj != null) {
                DynamicObject dyBizObj = (DynamicObject)bizObj;
                bizObjName = dyBizObj.getString("name");
                filters.add(new QFilter(BIZ_OBJ, "=", dyBizObj.get("number")));
            }
            Object number = this.getModel().getValue("number");
            filters.add(new QFilter("number", "=", number));
            QFilter[] filterArr = new QFilter[filters.size()];
            if (QueryServiceHelper.exists((String)"frm_rec_common_filter", (QFilter[])filters.toArray(filterArr))) {
                String msg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61[%1$s]\u5df2\u5b58\u5728\u7f16\u7801[%2$s]\u7684\u901a\u7528\u8bbe\u7f6e\uff0c\u8bf7\u68c0\u67e5", (String)"ReconciliactionCommonFilterFormPlugin_8", (String)"fi-frm-formplugin", (Object[])new Object[0]), bizObjName, number);
                e.setCancel(true);
                e.setCancelMessage(msg);
                this.getView().showErrorNotification(msg);
                return;
            }
            DynamicObjectCollection fieldMapEntry = this.getModel().getEntryEntity("fieldmapentry");
            DynamicObject assisObj = this.getModel().getEntryRowEntity("entryentity", 0);
            String fieldKey = null;
            String fieldName = null;
            ArrayList<String> assistMapFields = new ArrayList<String>(fieldMapEntry.size());
            for (Object fieldMap : fieldMapEntry) {
                fieldKey = fieldMap.getString("fieldkey");
                fieldName = assisObj.getString(fieldKey);
                if (StringUtils.isEmpty((CharSequence)fieldName)) {
                    String string = ResManager.loadKDString((String)"\u5b58\u5728\u672a\u6307\u5b9a\u7684\u5bf9\u8d26\u7ef4\u5ea6\u3002", (String)"ReconciliactionCommonFilterFormPlugin_3", (String)"fi-frm-formplugin", (Object[])new Object[0]);
                    e.setCancel(true);
                    e.setCancelMessage(string);
                    this.getView().showErrorNotification(string);
                    return;
                }
                if (fieldName.contains("(")) {
                    int n = fieldName.indexOf("(");
                    int endSplit = fieldName.indexOf(")");
                    String replaceStr = fieldName.substring(n, endSplit + 1);
                    fieldName = fieldName.replace(replaceStr, "");
                    assistMapFields.add(fieldName);
                    continue;
                }
                assistMapFields.add(fieldName);
            }
            this.getModel().setValue("itemclasstype", (Object)"");
            Map<String, List<String>> groupKeyMap = assistMapFields.stream().collect(Collectors.groupingBy(k -> k));
            for (Map.Entry entry : groupKeyMap.entrySet()) {
                if (((List)entry.getValue()).size() <= 1) continue;
                String errMsg = ResManager.loadKDString((String)"\u5b58\u5728\u591a\u4e2a\u7ef4\u5ea6\u53d6\u540c\u4e00\u5355\u636e\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u5bf9\u5e94\u5b57\u6bb5\u914d\u7f6e\u3002", (String)"ReconciliactionCommonFilterFormPlugin_10", (String)"fi-frm-formplugin", (Object[])new Object[0]);
                e.setCancel(true);
                e.setCancelMessage(errMsg);
                this.getView().showErrorNotification(errMsg);
                return;
            }
            Object amountTypeDims = this.getView().getFormShowParameter().getCustomParam("amountTypeDims");
            Object object = this.getView().getFormShowParameter().getCustomParam("amtTypePk");
            if (amountTypeDims != null && object != null) {
                String tipInfo;
                Map amountTypeMap = (Map)amountTypeDims;
                String amountTypePk = (String)object;
                Object objDim = amountTypeMap.get(amountTypePk);
                JSONArray dimArr = (JSONArray)objDim;
                HashSet<String> dimSet = new HashSet<String>();
                if (dimArr != null && !dimArr.isEmpty()) {
                    for (int i = 0; i < dimArr.size(); ++i) {
                        dimSet.add(dimArr.getString(i));
                    }
                }
                DynamicObjectCollection assistCols = this.getModel().getEntryEntity("fieldmapentry");
                HashSet<String> comDimSet = new HashSet<String>();
                for (DynamicObject dyAssit : assistCols) {
                    String bdtype = dyAssit.getString("datatype");
                    String dimEntityId = dyAssit.getString("entityid");
                    comDimSet.add(AssistDataType.makeAssistKey((String)bdtype, (String)dimEntityId));
                }
                if (comDimSet.size() < dimSet.size()) {
                    tipInfo = ResManager.loadKDString((String)"\u5bf9\u8d26\u901a\u7528\u8bbe\u7f6e\u5bf9\u8d26\u7ef4\u5ea6\u7684\u8303\u56f4\u4e0d\u80fd\u5c0f\u4e8e\u5bf9\u5e94\u53d6\u6570\u7c7b\u578b\u5bf9\u8d26\u7ef4\u5ea6\u7684\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5", (String)"ReconciliactionCommonFilterFormPlugin_4", (String)"fi-frm-formplugin", (Object[])new Object[0]);
                    e.setCancel(true);
                    e.setCancelMessage(tipInfo);
                    this.getView().showTipNotification(tipInfo);
                    return;
                }
                for (String curDim : dimSet) {
                    if (comDimSet.contains(curDim)) continue;
                    Map amountTypeIdNameCol = (Map)this.getView().getFormShowParameter().getCustomParam("amountTypeIdNameCol");
                    String tipName = (String)amountTypeIdNameCol.get(curDim);
                    tipInfo = String.format(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u5bf9\u8d26\u7ef4\u5ea6\u8303\u56f4\u5fc5\u987b\u5305\u542b\u5bf9\u5e94\u53d6\u6570\u7c7b\u578b\u7684\u5bf9\u8d26\u7ef4\u5ea6[%s]\uff0c\u8bf7\u68c0\u67e5", (String)"ReconciliactionCommonFilterFormPlugin_5", (String)"fi-frm-formplugin", (Object[])new Object[0]), tipName == null ? curDim : tipName);
                    e.setCancel(true);
                    e.setCancelMessage(tipInfo);
                    this.getView().showTipNotification(tipInfo);
                    return;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("save".equalsIgnoreCase(e.getOperateKey())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_new"});
        }
    }

    private boolean isNullAndEmpty(Object param) {
        return param == null || param.toString().trim().length() == 0;
    }

    private boolean isNotNullAndEmpty(Object param) {
        return param != null && param.toString().trim().length() > 0;
    }
}

