/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.fi.frm.common.cache.gl.CacheHelper;
import kd.fi.frm.common.enums.AmountDataTypeEnum;
import kd.fi.frm.common.util.FaBillParamUtils;
import kd.fi.frm.common.util.ThrowableHelper;
import kd.fi.frm.formplugin.util.ExportUtil;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class ReconciliationAssistDetailExportUtil {
    private static final String[] EXPORT_FIELD_LIST = new String[]{"groupIdx", "billorg", "billentity", "billno", "billassist", "billamount", "bizdc", "acctnum", "vchno", "dc", "bizamt", "glamt", "diff"};
    private DataEntityPropertyCollection propertyCol;
    private DynamicObject baseCurrency;

    private void openUrl(String url, IFormView formView) {
        formView.download(url);
    }

    public String export(List<Row> result, DataEntityPropertyCollection propetyCol, DynamicObject baseCurrency, Map<String, String> acctNameMap, Map<Long, DynamicObject> billOrgMap) {
        this.propertyCol = propetyCol;
        this.baseCurrency = baseCurrency;
        SXSSFWorkbook wb = new SXSSFWorkbook(1000);
        wb.setCompressTempFiles(true);
        int countPerSheet = FaBillParamUtils.getIntegerValue((Long)0L, (String)"frm_export_sheet_rowsize", (int)100000);
        int begin = 0;
        int end = begin + countPerSheet;
        if (end > result.size()) {
            end = result.size();
        }
        int sheetIndex = 1;
        do {
            SXSSFSheet sheet = wb.createSheet("sheet" + sheetIndex++);
            this.setTableHead(wb, sheet);
            this.setTableBody(wb, sheet, result.subList(begin, end), begin + 1, acctNameMap, billOrgMap);
            begin = end;
            end = begin + countPerSheet;
            if (end <= result.size()) continue;
            end = result.size();
        } while (begin != end);
        try {
            String url = this.writeFile(wb, ResManager.loadKDString((String)"\u5bf9\u8d26\u5dee\u5f02\u660e\u7ec6\u8868", (String)"ReconciliationAssistDetailExportUtil_0", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            return url;
        }
        catch (IOException e) {
            throw new KDException(ThrowableHelper.toString((Exception)e));
        }
    }

    private void setTableBody(SXSSFWorkbook wb, SXSSFSheet sheet, List<Row> result, int beginSeq, Map<String, String> acctNameMap, Map<Long, DynamicObject> billOrgMap) {
        CellStyle style = this.getHeadColumnStyle(wb);
        style.setAlignment(HorizontalAlignment.CENTER);
        DataFormat dataFormat = wb.createDataFormat();
        int groupRowIdx = 0;
        for (int h = 0; h < result.size(); ++h) {
            SXSSFRow createRow = sheet.createRow(h + 2);
            Row row = result.get(h);
            Long pid = row.getLong("pid");
            if (pid == 0L) {
                ++groupRowIdx;
            }
            SXSSFCell cell = createRow.createCell(0);
            cell.setCellStyle(style);
            cell.setCellValue("" + groupRowIdx);
            for (int i = 1; i < EXPORT_FIELD_LIST.length; ++i) {
                String number = EXPORT_FIELD_LIST[i];
                String value = "";
                Object rawValue = this.getValue(row, number, acctNameMap, billOrgMap);
                if (rawValue == null) {
                    value = "";
                } else if (rawValue instanceof String) {
                    value = rawValue.toString();
                } else if (rawValue instanceof BigDecimal) {
                    value = rawValue.toString();
                    if (StringUtils.isBlank((CharSequence)value) || value.equals("0E-10") || Double.parseDouble(value) == 0.0) {
                        value = "";
                    } else {
                        ExportUtil.setCurrencyFormat(dataFormat, style, this.baseCurrency);
                    }
                }
                cell = createRow.createCell(i);
                if (rawValue instanceof BigDecimal) {
                    if (BigDecimal.ZERO == rawValue) {
                        cell.setCellValue("");
                    } else {
                        double amount = StringUtils.isEmpty((CharSequence)value) ? 0.0 : Double.parseDouble(value);
                        cell.setCellValue(amount);
                    }
                } else {
                    cell.setCellValue(value);
                }
                cell.setCellStyle(style);
            }
        }
    }

    private Object getValue(Row row, String number, Map<String, String> acctNameMap, Map<Long, DynamicObject> billOrgMap) {
        if ("bizdc".equals(number) || "dc".equals(number)) {
            Integer bizDc = row.getInteger(number);
            if (bizDc != null) {
                return AmountDataTypeEnum.getName((int)bizDc);
            }
            return "";
        }
        if ("acctnum".equals(number)) {
            String acctnum = row.getString(number);
            if (acctNameMap != null && acctNameMap.containsKey(acctnum)) {
                acctnum = acctNameMap.get(acctnum);
            }
            return acctnum;
        }
        if ("billorg".equalsIgnoreCase(number)) {
            Long acctnum = row.getLong(number);
            DynamicObject org = billOrgMap.get(acctnum);
            if (org == null) {
                return acctnum;
            }
            String orgNum = org.getString("number");
            String orgName = org.getString("name");
            return orgNum + " " + orgName;
        }
        return row.get(number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(SXSSFWorkbook wb, String formName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheHelper.getTempFileCache().saveAsUrl(this.getTempFilename(formName), (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    private String getTempFilename(String formName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmssSSS");
        String currDateTime = dateFormat.format(new Date());
        String userName = RequestContext.get().getUserName();
        return formName + "-" + currDateTime + "-" + userName + ".xlsx";
    }

    private CellStyle getHeadColumnStyle(SXSSFWorkbook wb) {
        CellStyle headColumnStyle = wb.createCellStyle();
        if (headColumnStyle == null) {
            headColumnStyle = wb.createCellStyle();
            headColumnStyle.setBorderBottom(BorderStyle.THIN);
            headColumnStyle.setBorderTop(BorderStyle.THIN);
            headColumnStyle.setBorderLeft(BorderStyle.THIN);
            headColumnStyle.setBorderRight(BorderStyle.THIN);
            headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
            headColumnStyle.setHidden(false);
        }
        return headColumnStyle;
    }

    private void setTableHead(SXSSFWorkbook wb, SXSSFSheet sheet) {
        CellStyle style = this.getHeadColumnStyle(wb);
        style.setAlignment(HorizontalAlignment.CENTER);
        SXSSFRow row = sheet.createRow(0);
        SXSSFRow row1 = sheet.createRow(1);
        int[] cellRange = null;
        for (int i = 0; i < EXPORT_FIELD_LIST.length; ++i) {
            String number = EXPORT_FIELD_LIST[i];
            DynamicProperty property = (DynamicProperty)this.propertyCol.get((Object)number);
            SXSSFCell cell = row.createCell(i);
            switch (number) {
                case "groupIdx": {
                    cell.setCellValue((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"\u6279\u6b21\u53f7", (String)"ReconciliationAssistDetailExportUtil_3", (String)"fi-frm-formplugin", (Object[])new Object[0])));
                    CellRangeAddress cellRange0 = new CellRangeAddress(0, 1, i, i);
                    sheet.addMergedRegion(cellRange0);
                    break;
                }
                case "billorg": {
                    cell.setCellValue((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e", (String)"ReconciliationAssistDetailExportUtil_1", (String)"fi-frm-formplugin", (Object[])new Object[0])));
                    cellRange = new int[]{i, i + 5};
                    CellRangeAddress cellRange0 = new CellRangeAddress(0, 0, cellRange[0], cellRange[1]);
                    sheet.addMergedRegion(cellRange0);
                    break;
                }
                case "acctnum": {
                    cell.setCellValue((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"\u51ed\u8bc1", (String)"ReconciliationAssistDetailExportUtil_2", (String)"fi-frm-formplugin", (Object[])new Object[0])));
                    cellRange = new int[]{i, i + 2};
                    CellRangeAddress cellRange1 = new CellRangeAddress(0, 0, cellRange[0], cellRange[1]);
                    sheet.addMergedRegion(cellRange1);
                    break;
                }
            }
            if (property != null) {
                LocaleString name = property.getDisplayName();
                if (cellRange != null && i > cellRange[1]) {
                    cell.setCellValue(name.getLocaleValue());
                    CellRangeAddress cellRange3 = new CellRangeAddress(0, 1, (int)((short)i), (int)((short)i));
                    sheet.addMergedRegion(cellRange3);
                } else {
                    SXSSFCell cell1 = row1.createCell(i);
                    cell1.setCellValue(name.getLocaleValue());
                }
            }
            cell.setCellStyle(style);
        }
    }
}

