/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.frm.common.enums.AssistDataType;
import kd.fi.frm.common.enums.BalanceBasisEnum;
import kd.fi.frm.common.enums.BalanceDcEnum;
import kd.fi.frm.common.enums.ReconAmountTypeEnum;
import kd.fi.frm.common.model.ReturnData;
import kd.fi.frm.common.model.mulassist.MulassistArgs;
import kd.fi.frm.common.model.mulassist.MulassistConfigModel;
import kd.fi.frm.common.util.MetadataUtil;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.formplugin.DSField;
import kd.fi.frm.formplugin.assist.AssistChangeTypeEnum;
import kd.fi.frm.formplugin.importhandler.ImportCheckResult;
import kd.fi.frm.formplugin.util.AssistFieldUtil;

public class ReconciliationPlanEditPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog((String)ReconciliationPlanEditPlugin.class.getName());
    private static final String CACHE_DS_FIELDS = "ai_rec_editdsfield";
    private static final String ENTITY_AI_COMMONFILTER = "frm_rec_common_filter";
    private static final String FRM_RECONPLAN_MULASSIST = "frm_reconplan_mulassist";
    private static final String MUL_ASSIST_INFO_DESC = "mulassistinfodesc";
    private static final String MUL_ASSIST_2_INFO_DESC = "mulassist2infodesc";
    private static final String DYN_ASSISTANT_KEY_PREFIX = "assistanttext";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{MUL_ASSIST_INFO_DESC, MUL_ASSIST_2_INFO_DESC, "bizassist2", "bizassist3"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (int i = 0; i < 8; ++i) {
            this.addClickListeners(new String[]{DYN_ASSISTANT_KEY_PREFIX + i});
        }
        this.addClickListeners(new String[]{"assistfilter"});
        BasedataEdit accounts = (BasedataEdit)this.getControl("accounts");
        accounts.addBeforeF7SelectListener(evt -> this.accountF7Filter(evt));
        BasedataEdit assiAccount = (BasedataEdit)this.getControl("tab1_account");
        assiAccount.addBeforeF7SelectListener(evt -> this.accountF7Filter(evt));
        BasedataEdit assistAcct = (BasedataEdit)this.getControl("assistacct");
        assistAcct.addBeforeF7SelectListener(this::accountRangeFilter);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (null != filterContainer) {
            filterContainer.addBeforeF7SelectListener(new BeforeFilterF7SelectListener(){

                public void beforeF7Select(BeforeFilterF7SelectEvent e) {
                    String field = e.getFieldName();
                    if (field.startsWith("bizapp.")) {
                        e.getQfilters().add(new QFilter("id", "in", (Object)ReconciliationUtil.getAppIds()));
                    }
                }
            });
        }
        BasedataEdit amounttypeContainer = (BasedataEdit)this.getControl("amounttype");
        amounttypeContainer.addBeforeF7SelectListener(evt -> this.amountF7Filter(evt));
        BasedataEdit amounttype1Container = (BasedataEdit)this.getControl("amounttype1");
        amounttype1Container.addBeforeF7SelectListener(evt -> this.amountF7Filter(evt));
        BasedataEdit amounttype2Container = (BasedataEdit)this.getControl("amounttype2");
        amounttype2Container.addBeforeF7SelectListener(evt -> this.amountF7Filter(evt));
        BasedataEdit bizappContainer = (BasedataEdit)this.getControl("bizapp");
        bizappContainer.addBeforeF7SelectListener(evt -> {
            Set pkSet = ReconciliationUtil.getAppIds();
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            listFilterParameter.setFilter(new QFilter("id", "in", (Object)pkSet));
        });
        this.addClickListeners(new String[]{"dataruledesc"});
        BasedataEdit dataRuleContainer = (BasedataEdit)this.getControl("reconciliactionconfig");
        dataRuleContainer.addBeforeF7SelectListener(this::dataRuleF7Filter);
    }

    private void dataRuleF7Filter(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject bizApp = (DynamicObject)this.getModel().getValue("bizApp");
        Object useOrgIDObj = this.getModel().getValue("useorg_id");
        String useOrg = useOrgIDObj == null ? "0" : useOrgIDObj.toString();
        showParameter.getCustomParams().put("bizAppId", bizApp.getPkValue().toString());
        showParameter.getCustomParams().put("bizAppName", bizApp.get("name").toString());
        showParameter.getCustomParams().put("useorg", useOrg);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "reconciliactionconfig"));
        showParameter.setHasRight(true);
        Map<String, Set<String>> amountTypeMap = this.getAmountTypeDims();
        HashSet<String> dimKeys = new HashSet<String>();
        amountTypeMap.values().forEach(dimKeys::addAll);
        Map<String, String> assistNameMap = this.getAllDimsName(dimKeys);
        showParameter.setCustomParam("amountTypeIdNameCol", assistNameMap);
        showParameter.setCustomParam("amountTypeDims", amountTypeMap);
        DynamicObject reconciliactionconfig = (DynamicObject)this.getModel().getValue("reconciliactionconfig");
        if (reconciliactionconfig != null) {
            showParameter.setSelectedRow((Object)reconciliactionconfig.getLong("id"));
        }
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        listFilterParameter.setFilter(new QFilter("bizapp", "=", (Object)bizApp.getPkValue().toString()));
    }

    private void amountF7Filter(BeforeF7SelectEvent evt) {
        DynamicObject bizapp = (DynamicObject)this.getModel().getValue("bizapp");
        Long id = null;
        QFilter appFilter = new QFilter("bizapp", "=", (Object)bizapp.getPkValue().toString());
        DynamicObject amtTypeObj = QueryServiceHelper.queryOne((String)"frm_amount_type", (String)"id", (QFilter[])new QFilter[]{appFilter});
        if (amtTypeObj != null) {
            id = amtTypeObj.getLong("id");
        }
        QFilter filter = null;
        filter = id != null ? new QFilter("amounttype.id", "=", (Object)id) : new QFilter("amounttype.bizapp.number", "=", (Object)bizapp.getString("number"));
        ListShowParameter showParam = (ListShowParameter)evt.getFormShowParameter();
        List filters = showParam.getListFilterParameter().getQFilters();
        filters.add(filter);
    }

    private void accountF7Filter(BeforeF7SelectEvent evt) {
        Object userOrg = this.getModel().getValue("useorg");
        if (userOrg == null) {
            evt.setCancel(true);
            return;
        }
        this.updateAccountFilter(evt, userOrg);
    }

    private void accountRangeFilter(BeforeF7SelectEvent evt) {
        Object userOrg = this.getModel().getValue("useorg");
        if (userOrg == null) {
            evt.setCancel(true);
            return;
        }
        this.updateAccountFilter(evt, userOrg);
        List filters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bd_accountview", (String)"id, checkitementry.asstactitem.id as assistId", (QFilter[])filters.toArray(new QFilter[0]));
        if (accounts != null && accounts.size() > 0) {
            HashMap<Long, HashSet<Long>> accoutIdMap = new HashMap<Long, HashSet<Long>>(accounts.size());
            for (DynamicObject account : accounts) {
                HashSet<Long> assistIds = (HashSet<Long>)accoutIdMap.get(account.getLong("id"));
                if (assistIds == null) {
                    assistIds = new HashSet<Long>(1);
                }
                assistIds.add(account.getLong("assistId"));
                accoutIdMap.put(account.getLong("id"), assistIds);
            }
            String mulassist2infoTag = ((DynamicObject)this.getModel().getEntryEntity("basedataentry").get(this.getModel().getEntryCurrentRowIndex("basedataentry"))).getString("mulassist2info_tag");
            if (StringUtils.isNotEmpty((CharSequence)mulassist2infoTag)) {
                List list = (List)SerializationUtils.fromJsonString((String)mulassist2infoTag, List.class);
                HashSet<Long> accountIdSet = new HashSet<Long>(list.size());
                for (Map map : list) {
                    for (Map.Entry entry : map.entrySet()) {
                        if (!"assistId".equals(entry.getKey())) continue;
                        accountIdSet.add(Long.valueOf(String.valueOf(entry.getValue())));
                    }
                }
                if (accountIdSet.size() > 0) {
                    HashSet availableAccountIds = new HashSet();
                    for (Map.Entry entry : accoutIdMap.entrySet()) {
                        if (!((Set)entry.getValue()).containsAll(accountIdSet)) continue;
                        availableAccountIds.add(entry.getKey());
                    }
                    if (availableAccountIds.size() > 0) {
                        filters.add(new QFilter("id", "in", availableAccountIds));
                    } else {
                        filters.add(new QFilter("id", "=", (Object)0L));
                    }
                }
            }
        }
    }

    private void updateAccountFilter(BeforeF7SelectEvent evt, Object userOrg) {
        DynamicObject accountTable = (DynamicObject)this.getModel().getValue("accounttable");
        long accTableId = 0L;
        if (accountTable != null) {
            accTableId = accountTable.getLong("id");
        }
        QFilter tableFilter = new QFilter("accounttable", "=", (Object)accTableId);
        QFilter acctFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)((DynamicObject)userOrg).getLong("id"));
        ListShowParameter accTablePar = (ListShowParameter)evt.getFormShowParameter();
        List filters = accTablePar.getListFilterParameter().getQFilters();
        filters.add(tableFilter);
        filters.add(acctFilter);
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date time = simpleDateFormat.parse("2999-12-31");
            QFilter endDateFilter = new QFilter("enddate", "=", (Object)time);
            filters.add(endDateFilter);
        }
        catch (ParseException e) {
            log.error("Parse date error !" + e.getMessage());
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("dataruledesc".equalsIgnoreCase(key)) {
            String useOrg;
            DynamicObject dataRule = (DynamicObject)this.getModel().getValue("reconciliactionconfig");
            DynamicObject bizApp = (DynamicObject)this.getModel().getValue("bizApp");
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("frm_recdatarule");
            Object useOrgIDObj = this.getModel().getValue("useorg_id");
            String string = useOrg = useOrgIDObj == null ? "0" : useOrgIDObj.toString();
            if (dataRule == null) {
                showParameter.setStatus(OperationStatus.ADDNEW);
            } else {
                QFilter idFilter = new QFilter("id", "=", dataRule.getPkValue());
                DynamicObject rule = QueryServiceHelper.queryOne((String)"frm_recdatarule", (String)"createorg.id,preset", (QFilter[])new QFilter[]{idFilter});
                if (rule != null) {
                    String createOrgId = rule.getString("createorg.id");
                    Boolean preset = rule.getBoolean("preset");
                    if (useOrg.equals(createOrgId)) {
                        showParameter.setPkId((Object)dataRule.getString("id"));
                        showParameter.setStatus(OperationStatus.EDIT);
                        showParameter.setCustomParam("operate", (Object)"edit");
                    } else {
                        showParameter.getCustomParams().put("status", "COPY");
                        showParameter.getCustomParams().put("iscopy", Boolean.TRUE);
                        showParameter.getCustomParams().put("isCopyRelateEntity", Boolean.FALSE);
                        showParameter.setPkId((Object)dataRule.getString("id"));
                    }
                    showParameter.setCustomParam("preset", (Object)preset);
                } else {
                    showParameter.setStatus(OperationStatus.ADDNEW);
                }
            }
            showParameter.getCustomParams().put("bizApp", bizApp.getPkValue().toString());
            showParameter.getCustomParams().put("useOrg", useOrg);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "datarule"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setHasRight(true);
            Map<String, Set<String>> amountTypeMap = this.getAmountTypeDims();
            HashSet<String> dimKeys = new HashSet<String>();
            amountTypeMap.values().forEach(dimKeys::addAll);
            Map<String, String> assistNameMap = this.getAllDimsName(dimKeys);
            showParameter.setCustomParam("amountTypeIdNameCol", assistNameMap);
            showParameter.setCustomParam("amountTypeDims", amountTypeMap);
            this.getView().showForm((FormShowParameter)showParameter);
        } else if (MUL_ASSIST_INFO_DESC.equals(key) || MUL_ASSIST_2_INFO_DESC.equals(key)) {
            Long dataRuleId = (Long)this.getModel().getValue("reconciliactionconfig_id");
            int rowIndex = 0;
            HashSet<Object> mulassistIdSet = new HashSet<Object>();
            switch (key) {
                case "mulassistinfodesc": {
                    rowIndex = this.getModel().getEntryCurrentRowIndex("assistentry");
                    Object mulassistinfodesc = this.getModel().getEntryRowEntity("assistentry", rowIndex).get(MUL_ASSIST_INFO_DESC);
                    Object mulassistinfo = ObjectUtils.isEmpty((Object)mulassistinfodesc) ? "" : this.getModel().getEntryRowEntity("assistentry", rowIndex).get("mulassistinfo_tag");
                    DynamicObjectCollection amountTypeColl = (DynamicObjectCollection)this.getModel().getValue("amounttype1");
                    List amountTypes = ReconciliationUtil.getBaseDataIdList((DynamicObjectCollection)amountTypeColl);
                    DynamicObject acct = (DynamicObject)this.getModel().getValue("tab1_account", rowIndex);
                    if (acct != null) {
                        QFilter idFilter = new QFilter("id", "=", (Object)acct.getLong("id"));
                        Object userOrg = this.getModel().getValue("useorg");
                        QFilter acctFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)((DynamicObject)userOrg).getLong("id"));
                        DynamicObjectCollection accts = QueryServiceHelper.query((String)"bd_accountview", (String)"checkitementry.asstactitem", (QFilter[])new QFilter[]{idFilter, acctFilter});
                        for (DynamicObject col : accts) {
                            mulassistIdSet.add(col.get("checkitementry.asstactitem"));
                        }
                    }
                    this.showAccountDimensionForm(mulassistinfo, "mulassistinfo_tag", mulassistIdSet, amountTypes);
                    break;
                }
                case "mulassist2infodesc": {
                    rowIndex = this.getModel().getEntryCurrentRowIndex("basedataentry");
                    Object mulassistinfodesc = this.getModel().getEntryRowEntity("basedataentry", rowIndex).get(MUL_ASSIST_2_INFO_DESC);
                    Object mulassistinfo = ObjectUtils.isEmpty((Object)mulassistinfodesc) ? "" : this.getModel().getEntryRowEntity("basedataentry", rowIndex).get("mulassist2info_tag");
                    DynamicObjectCollection amountTypeColl = (DynamicObjectCollection)this.getModel().getValue("amounttype2");
                    List amountTypes = ReconciliationUtil.getBaseDataIdList((DynamicObjectCollection)amountTypeColl);
                    this.showAccountDimensionForm(mulassistinfo, "mulassist2info_tag", mulassistIdSet, amountTypes);
                    break;
                }
            }
        } else if ("bizassist2".equals(key) || "bizassist3".equals(key)) {
            switch (key) {
                case "bizassist2": {
                    this.showBizAssist("assistentry", "bizassist2", "bizassistinfo_tag", "amounttype1");
                    break;
                }
                case "bizassist3": {
                    this.showBizAssist("basedataentry", "bizassist3", "bizassist2info_tag", "amounttype2");
                    break;
                }
            }
        } else if (key.startsWith(DYN_ASSISTANT_KEY_PREFIX)) {
            this.showAssistDataF7Form(key);
        } else if ("assistfilter".equals(key)) {
            String cacheAssistStr = this.getPageCache().get(CACHE_DS_FIELDS);
            if (StringUtils.isEmpty((CharSequence)cacheAssistStr)) {
                return;
            }
            int rowIndex = this.getModel().getEntryCurrentRowIndex("modularentryentity");
            String assistfilterinfo = this.getModel().getEntryRowEntity("modularentryentity", rowIndex).getString("assistfilterinfo_tag");
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("frm_bizassist_filter");
            showParameter.getCustomParams().put("assists", cacheAssistStr);
            showParameter.getCustomParams().put("assistfilter", assistfilterinfo);
            showParameter.getCustomParams().put("useorg", this.getModel().getValue("useorg_id"));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "assistfilter"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    private void showBizAssist(String entryName, String assistFieldName, String assistInfoFieldName, String amountTypeFieldName) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(entryName);
        String bizAssist = this.getModel().getEntryRowEntity(entryName, rowIndex).getString(assistFieldName);
        ArrayList<DSField> selectedAssist = new ArrayList<DSField>(10);
        if (StringUtils.isNotEmpty((CharSequence)bizAssist)) {
            String bizAssistTag = this.getModel().getEntryRowEntity(entryName, rowIndex).getString(assistInfoFieldName);
            List selectedAssistData = JSONObject.parseArray((String)bizAssistTag, MulassistConfigModel.class);
            for (MulassistConfigModel model : selectedAssistData) {
                DSField field = new DSField();
                String assistId = model.getAssistId();
                if (!assistId.contains(".")) {
                    field.setDataType(AssistDataType.BASEDATA.getBdType());
                    field.setEntityId(assistId);
                } else {
                    String[] splitKey = assistId.split("\\.");
                    field.setDataType(splitKey[0]);
                    field.setEntityId(splitKey[1]);
                }
                field.setFieldKey(model.getConditionTag());
                selectedAssist.add(field);
            }
        }
        MulBasedataDynamicObjectCollection amountTypeCollection = (MulBasedataDynamicObjectCollection)this.getModel().getEntryRowEntity(entryName, rowIndex).get(amountTypeFieldName);
        HashSet<Long> amountTypes = new HashSet<Long>(amountTypeCollection.size());
        for (DynamicObject dynamicObject : amountTypeCollection) {
            amountTypes.add(dynamicObject.getLong("fbasedataid.id"));
        }
        Long dataRuleId = (Long)this.getModel().getValue("reconciliactionconfig_id");
        Set bizAssistNumber = ReconciliationUtil.getAssistKeyFromDataRule((Long)dataRuleId, amountTypes);
        this.showBizAssistForm(selectedAssist, bizAssistNumber, assistInfoFieldName);
    }

    private void showBizAssistForm(List<DSField> selectedAssist, Set<String> selectableAssist, String callbackAction) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("frm_biz_assist");
        showParameter.getCustomParams().put("bizSelectableDim", SerializationUtils.serializeToBase64(selectableAssist));
        showParameter.getCustomParams().put("selectedAssist", SerializationUtils.serializeToBase64(selectedAssist));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callbackAction));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showAccountDimensionForm(Object mulassistinfo, String sourceCtrlKey, Set<Object> mulassistIdSet, List<Long> amountTypes) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FRM_RECONPLAN_MULASSIST);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getCustomParams().put("useorg", this.getModel().getValue("useorg_id"));
        showParameter.getCustomParams().put("assistId", mulassistIdSet);
        showParameter.getCustomParams().put("entryData", mulassistinfo);
        showParameter.getCustomParams().put("dataRuleId", this.getModel().getValue("reconciliactionconfig_id"));
        showParameter.getCustomParams().put("amountTypes", amountTypes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if ("mulassist2info_tag".equals(e.getActionId()) || "mulassistinfo_tag".equals(e.getActionId())) {
            Object returnData = e.getReturnData();
            if (returnData != null) {
                String returnDataStr = (String)returnData;
                switch (e.getActionId()) {
                    case "mulassist2info_tag": {
                        this.receiveExpressionSet(returnDataStr, "basedataentry", "mulassist2info_tag", MUL_ASSIST_2_INFO_DESC);
                        break;
                    }
                    case "mulassistinfo_tag": {
                        this.receiveExpressionSet(returnDataStr, "assistentry", "mulassistinfo_tag", MUL_ASSIST_INFO_DESC);
                        break;
                    }
                }
            }
        } else if ("reconciliactionconfig".equals(e.getActionId()) && e.getReturnData() != null && StringUtils.isNotEmpty((CharSequence)e.getReturnData().toString())) {
            Long dataRuleId = e.getReturnData() instanceof ArrayList ? Long.valueOf(Long.parseLong(String.valueOf(((ArrayList)e.getReturnData()).get(0)))) : Long.valueOf(Long.parseLong(String.valueOf(e.getReturnData())));
            this.getModel().setValue("reconciliactionconfig", (Object)dataRuleId);
            DynamicObject recConfig = ReconciliationPlanEditPlugin.getrecConfigRule(dataRuleId);
            this.dataRuleChangedAction(recConfig, true);
        } else if ("bizassistinfo_tag".equals(e.getActionId()) || "bizassist2info_tag".equals(e.getActionId())) {
            Object returnData = e.getReturnData();
            if (returnData != null) {
                String returnDataStr = (String)returnData;
                switch (e.getActionId()) {
                    case "bizassist2info_tag": {
                        this.receiveExpressionSet(returnDataStr, "basedataentry", "bizassist2info_tag", "bizassist3");
                        break;
                    }
                    case "bizassistinfo_tag": {
                        this.receiveExpressionSet(returnDataStr, "assistentry", "bizassistinfo_tag", "bizassist2");
                        break;
                    }
                }
            }
        } else if (e.getActionId().startsWith("assist.callback.")) {
            Object returnData = e.getReturnData();
            if (returnData == null) {
                return;
            }
            String actionId = e.getActionId();
            String fieldKey = actionId.substring(actionId.lastIndexOf(".") + 1);
            ListSelectedRowCollection selectRows = (ListSelectedRowCollection)returnData;
            ArrayList<String> showName = new ArrayList<String>();
            int acctEntryCurRowIndex = this.getModel().getEntryCurrentRowIndex("modularentryentity");
            DynamicObject acctEntryCurRow = this.getModel().getEntryRowEntity("modularentryentity", acctEntryCurRowIndex);
            DynamicObjectCollection assistDataEntry = acctEntryCurRow.getDynamicObjectCollection("acctassistentry");
            assistDataEntry.clear();
            for (ListSelectedRow row : selectRows) {
                Object primaryKeyValue = row.getPrimaryKeyValue();
                String name = row.getName();
                showName.add(name);
                DynamicObject assistDataRow = assistDataEntry.addNew();
                assistDataRow.set("assistfield", (Object)fieldKey);
                assistDataRow.set("assistvalue", primaryKeyValue);
            }
            this.getModel().setValue(fieldKey, (Object)String.join((CharSequence)",", showName), acctEntryCurRowIndex);
            this.getView().updateView(fieldKey, acctEntryCurRowIndex);
        } else if ("assistfilter".equals(e.getActionId())) {
            ReturnData retData = (ReturnData)e.getReturnData();
            if (retData == null) {
                return;
            }
            if (retData.isStatus()) {
                int acctEntryCurRowIndex = this.getModel().getEntryCurrentRowIndex("modularentryentity");
                String message = retData.getMessage();
                this.getModel().setValue("assistfilter", (Object)message, acctEntryCurRowIndex);
                this.getModel().setValue("assistfilterinfo", (Object)message, acctEntryCurRowIndex);
                this.getModel().setValue("assistfilterinfo_tag", (Object)retData.getDataStr(), acctEntryCurRowIndex);
            }
        }
    }

    private void clearAllReconAssistEntry() {
        IDataModel model = this.getModel();
        model.deleteEntryData("fieldmapentry");
        if (model.getEntryRowCount("modularentryentity") > 0) {
            model.setValue("assistfilter", (Object)"");
            model.setValue("assistfilterinfo", (Object)"");
            model.setValue("assistfilterinfo_tag", (Object)"");
            for (int i = 0; i < 8; ++i) {
                model.setValue("basedata" + i, null);
                model.setValue("assistantfield" + i, null);
                model.setValue(DYN_ASSISTANT_KEY_PREFIX + i, (Object)"");
            }
        }
        model.deleteEntryData("acctassistentry");
        DynamicObjectCollection acctEntry = model.getEntryEntity("modularentryentity");
        acctEntry.forEach(row -> {
            DynamicObjectCollection acctassistentry = row.getDynamicObjectCollection("acctassistentry");
            acctassistentry.clear();
        });
    }

    private void dataRuleChangedAction(DynamicObject dataRuleDyn, boolean resetDynCols) {
        if (dataRuleDyn == null) {
            this.clearAllReconAssistEntry();
            this.getPageCache().remove(CACHE_DS_FIELDS);
            this.getPageCache().put("inited", "true");
            this.drawDynamicCols(Collections.emptyList());
            this.getView().updateView("modularentryentity");
            return;
        }
        dataRuleDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)dataRuleDyn.getPkValue(), (String)dataRuleDyn.getDataEntityType().getName(), (String)"id,number, assistentry.bdtype, assistentry.sourcenumber");
        List<DSField> dynFields = AssistFieldUtil.getSchemeAssistFromDataRule(dataRuleDyn.getLong("id"));
        HashMap<String, DSField> cacheAssistDataField = new HashMap<String, DSField>(dynFields.size(), 1.0f);
        for (DSField dsField : dynFields) {
            cacheAssistDataField.put(dsField.getFieldKey(), dsField);
        }
        this.getPageCache().put("assist.addListener", SerializationUtils.serializeToBase64(cacheAssistDataField));
        String oldFieldsStr = this.getPageCache().get(CACHE_DS_FIELDS);
        List oldDynFields = oldFieldsStr == null ? Collections.emptyList() : (List)SerializationUtils.deSerializeFromBase64((String)oldFieldsStr);
        AssistChangeTypeEnum reconAssistChangeType = this.compareAssist(oldDynFields, dynFields);
        this.getPageCache().put(CACHE_DS_FIELDS, SerializationUtils.serializeToBase64(dynFields));
        this.getPageCache().put("inited", "true");
        if (AssistChangeTypeEnum.NO_CHANGE == reconAssistChangeType) {
            return;
        }
        if (resetDynCols) {
            this.clearAllReconAssistEntry();
            for (DSField field : dynFields) {
                int rowIndex = this.getModel().createNewEntryRow("fieldmapentry");
                this.getModel().setValue("datatype", (Object)field.getDataType(), rowIndex);
                this.getModel().setValue("entityid", (Object)field.getEntityId(), rowIndex);
                this.getModel().setValue("fieldkey", (Object)field.getFieldKey(), rowIndex);
            }
        }
        if (AssistChangeTypeEnum.NO_ASSIST == reconAssistChangeType) {
            this.drawDynamicCols(Collections.emptyList());
        } else {
            this.drawDynamicCols(dynFields);
        }
        this.getView().updateView("modularentryentity");
    }

    /*
     * WARNING - void declaration
     */
    private AssistChangeTypeEnum compareAssist(List<DSField> oldCacheAssist, List<DSField> newAssist) {
        void var5_10;
        if (CollectionUtils.isEmpty(oldCacheAssist) && !CollectionUtils.isEmpty(newAssist)) {
            return AssistChangeTypeEnum.CHANGED;
        }
        HashSet<String> oldAssistSet = new HashSet<String>(oldCacheAssist.size());
        for (DSField dSField : oldCacheAssist) {
            oldAssistSet.add(AssistDataType.makeAssistKey((String)dSField.getDataType(), (String)dSField.getEntityId()));
        }
        HashSet<String> newAssistSet = new HashSet<String>(newAssist.size());
        for (DSField field : newAssist) {
            newAssistSet.add(AssistDataType.makeAssistKey((String)field.getDataType(), (String)field.getEntityId()));
        }
        AssistChangeTypeEnum assistChangeTypeEnum = AssistChangeTypeEnum.CHANGED;
        if (oldAssistSet.isEmpty()) {
            AssistChangeTypeEnum assistChangeTypeEnum2 = AssistChangeTypeEnum.NO_ASSIST;
        } else if (oldAssistSet.containsAll(newAssistSet) && newAssistSet.containsAll(oldAssistSet)) {
            AssistChangeTypeEnum assistChangeTypeEnum3 = AssistChangeTypeEnum.NO_CHANGE;
        }
        return var5_10;
    }

    private void receiveExpressionSet(String returnDataStr, String entityKey, String expressionFldKey, String descFldKey) {
        int row = this.getModel().getEntryCurrentRowIndex(entityKey);
        if (StringUtils.isBlank((CharSequence)returnDataStr)) {
            this.getModel().setValue(expressionFldKey, (Object)"", row);
            this.getModel().setValue(descFldKey, (Object)"", row);
        } else {
            ReturnData returnData = (ReturnData)SerializationUtils.fromJsonString((String)returnDataStr, ReturnData.class);
            MulassistArgs mulassistArgs = (MulassistArgs)JSONObject.parseObject((String)returnData.getDataStr(), MulassistArgs.class);
            List list = mulassistArgs.getList();
            this.getModel().setValue(expressionFldKey, (Object)JSON.toJSONString((Object)list), row);
            String desc = mulassistArgs.getDesc();
            this.getModel().setValue(descFldKey, (Object)desc, row);
        }
    }

    private static DynamicObject getrecConfigRule(Long dataRuleId) {
        DynamicObject rule = ReconciliationUtil.getDataRule((Long)dataRuleId, null);
        if (rule != null) {
            QFilter idf = new QFilter("id", "=", (Object)rule.getLong("id"));
            rule = BusinessDataServiceHelper.loadSingle((String)"frm_recdatarule", (String)"id,name,assistentry.bdtype,assistentry.sourcenumber", (QFilter[])new QFilter[]{idf});
        }
        return rule;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String name = e.getEntryProp().getName();
        RowDataEntity entryRow = e.getRowDataEntities()[0];
        int rowIndex = entryRow.getRowIndex();
        if ("assistentry".equals(name)) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"bizassist2"});
        } else if ("basedataentry".equals(name)) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"bizassist3"});
        }
        this.setDefaultEntryCloseParam(name, entryRow.getDataEntity(), rowIndex);
    }

    private void setDefaultEntryCloseParam(String entryEntityKey, DynamicObject entryRow, int rowIndex) {
        boolean headCloseParam = (Boolean)this.getModel().getValue("closeparam");
        if (headCloseParam) {
            String entryCloseParamKey = "";
            switch (entryEntityKey) {
                case "assistentry": {
                    entryCloseParamKey = "closeparam2";
                    break;
                }
                case "basedataentry": {
                    entryCloseParamKey = "closeparam3";
                    break;
                }
                case "modularentryentity": {
                    entryCloseParamKey = "closeparam1";
                }
            }
            if ("".equals(entryCloseParamKey)) {
                return;
            }
            entryRow.set(entryCloseParamKey, (Object)true);
            this.getModel().setDataChanged(false);
            this.getView().updateView(entryEntityKey, rowIndex);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IPageCache parentPageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String useOrg = parentPageCache.get("useOrg");
        this.getPageCache().put("useOrg", useOrg);
        DynamicObject usrOrgObj = (DynamicObject)this.getModel().getValue("useOrg");
        if (usrOrgObj != null) {
            QFilter orgFilter = new QFilter("org", "=", (Object)usrOrgObj.getLong("id"));
            QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
            DynamicObjectCollection acctBooksType = QueryServiceHelper.query((String)"gl_accountbook", (String)"bookstype.id, accounttable.id", (QFilter[])new QFilter[]{orgFilter, statusFilter});
            if (acctBooksType.size() == 1) {
                this.getModel().setValue("booktype", (Object)((DynamicObject)acctBooksType.get(0)).getLong("bookstype.id"));
                this.getModel().setValue("accounttable", ((DynamicObject)acctBooksType.get(0)).get("accounttable.id"));
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().beginInit();
        DynamicObjectCollection mapdatas = this.getModel().getEntryEntity("fieldmapentry");
        List<DSField> dynFields = AssistFieldUtil.getSchemeAssistFromDataRule(mapdatas);
        this.drawDynamicCols(dynFields);
        this.getPageCache().put(CACHE_DS_FIELDS, SerializationUtils.serializeToBase64(dynFields));
        HashMap<String, DSField> cacheAssistDataField = new HashMap<String, DSField>(dynFields.size(), 1.0f);
        for (DSField dsField : dynFields) {
            cacheAssistDataField.put(dsField.getFieldKey(), dsField);
        }
        this.getPageCache().put("assist.addListener", SerializationUtils.serializeToBase64(cacheAssistDataField));
        DynamicObjectCollection acctEntry = this.getModel().getEntryEntity("modularentryentity");
        int acctEntryIndex = -1;
        for (DynamicObject acctRow : acctEntry) {
            ++acctEntryIndex;
            DynamicObjectCollection acctAssistValueEntry = acctRow.getDynamicObjectCollection("acctassistentry");
            HashMap<String, List> assistFieldValue = new HashMap<String, List>();
            for (DynamicObject assistValueRow : acctAssistValueEntry) {
                String assistfield = assistValueRow.getString("assistfield");
                if (StringUtils.isEmpty((CharSequence)assistfield)) continue;
                Long assistvalue = assistValueRow.getLong("assistvalue");
                List longs = assistFieldValue.computeIfAbsent(assistfield, k -> new ArrayList(4));
                longs.add(assistvalue);
            }
            for (Map.Entry entry : assistFieldValue.entrySet()) {
                DynamicObject[] assistDetail = BusinessDataServiceHelper.load((String)"bos_assistantdata_detail", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", entry.getValue())});
                ArrayList<String> showName = new ArrayList<String>(assistDetail.length);
                for (DynamicObject assist : assistDetail) {
                    showName.add(assist.getString("name"));
                }
                acctRow.set((String)entry.getKey(), (Object)String.join((CharSequence)",", showName));
                this.getModel().setValue((String)entry.getKey(), (Object)String.join((CharSequence)",", showName), acctEntryIndex);
            }
            String assistfilterinfo = acctRow.getString("assistfilterinfo");
            if (!StringUtils.isNotEmpty((CharSequence)assistfilterinfo)) continue;
            this.getModel().setValue("assistfilter", (Object)assistfilterinfo, acctEntryIndex);
        }
        this.getModel().endInit();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject userOrg = (DynamicObject)this.getModel().getValue("useorg");
        this.getModel().beginInit();
        String useOrgId = userOrg.getString("id");
        this.getPageCache().put("useOrg", useOrgId);
        Object acctTable = this.getModel().getValue("accounttable");
        if (userOrg != null && acctTable != null) {
            int i;
            int i2;
            IFormView view = this.getView();
            if (this.getModel().getDataEntity().getLong("id") != 0L) {
                view.setEnable(Boolean.FALSE, new String[]{"booktype", "accounttable", "bizapp"});
            }
            int accountNumberSize = this.getModel().getEntryRowCount("modularentryentity") + this.getModel().getEntryRowCount("assistentry") + this.getModel().getEntryRowCount("basedataentry");
            HashSet<String> entryAccs = new HashSet<String>(accountNumberSize);
            DynamicObjectCollection accounts = null;
            Object acct = null;
            DynamicObject accountDynObj = null;
            int count = this.getModel().getEntryRowCount("modularentryentity");
            for (i2 = 0; i2 < count; ++i2) {
                accounts = (DynamicObjectCollection)this.getModel().getValue("accounts", i2);
                for (DynamicObject account : accounts) {
                    accountDynObj = (DynamicObject)account.get("fbasedataid");
                    if (accountDynObj == null || !StringUtils.isNotEmpty((CharSequence)accountDynObj.getString("number"))) continue;
                    entryAccs.add(accountDynObj.getString("number"));
                }
            }
            count = this.getModel().getEntryRowCount("assistentry");
            for (i2 = 0; i2 < count; ++i2) {
                acct = this.getModel().getValue("tab1_account", i2);
                if (acct == null) continue;
                entryAccs.add(((DynamicObject)acct).getString("number"));
            }
            count = this.getModel().getEntryRowCount("basedataentry");
            for (i2 = 0; i2 < count; ++i2) {
                accounts = (DynamicObjectCollection)this.getModel().getValue("assistacct", i2);
                for (DynamicObject account : accounts) {
                    accountDynObj = (DynamicObject)account.get("fbasedataid");
                    if (accountDynObj == null || !StringUtils.isNotEmpty((CharSequence)accountDynObj.getString("number"))) continue;
                    entryAccs.add(accountDynObj.getString("number"));
                }
            }
            long accountTableId = ((DynamicObject)this.getModel().getValue("accounttable")).getLong("id");
            QFilter tableFilter = new QFilter("accounttable", "=", (Object)accountTableId);
            QFilter acctFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)userOrg.getLong("id"));
            QFilter numberFilter = new QFilter("number", "in", entryAccs);
            Date endDate = AccountVersionUtil.getEndDate();
            QFilter dateFilter = new QFilter("enddate", "=", (Object)endDate);
            DynamicObjectCollection cols = QueryServiceHelper.query((String)"bd_accountview", (String)"id, number, name", (QFilter[])new QFilter[]{tableFilter, acctFilter, numberFilter, dateFilter});
            HashMap<String, Long> accountMap = new HashMap<String, Long>(cols.size());
            HashMap<String, String> accountNameMap = new HashMap<String, String>(cols.size());
            for (DynamicObject col : cols) {
                accountMap.put(col.getString("number"), col.getLong("id"));
                accountNameMap.put(col.getString("number"), col.getString("name"));
            }
            count = this.getModel().getEntryRowCount("modularentryentity");
            for (i = 0; i < count; ++i) {
                accounts = (DynamicObjectCollection)this.getModel().getValue("accounts", i);
                for (DynamicObject account : accounts) {
                    accountDynObj = (DynamicObject)account.get("fbasedataid");
                    if (accountDynObj == null) continue;
                    ((DynamicObject)account.get("fbasedataid")).set("name", accountNameMap.getOrDefault(((DynamicObject)account.get("fbasedataid")).getString("number"), null));
                }
            }
            count = this.getModel().getEntryRowCount("assistentry");
            for (i = 0; i < count; ++i) {
                acct = this.getModel().getValue("tab1_account", i);
                if (acct == null) continue;
                String accountNumber = ((DynamicObject)acct).getString("number");
                this.getModel().setValue("tab1_account", accountMap.getOrDefault(accountNumber, null), i);
            }
            count = this.getModel().getEntryRowCount("basedataentry");
            for (i = 0; i < count; ++i) {
                accounts = (DynamicObjectCollection)this.getModel().getValue("assistacct", i);
                for (DynamicObject account : accounts) {
                    accountDynObj = (DynamicObject)account.get("fbasedataid");
                    if (accountDynObj == null) continue;
                    ((DynamicObject)account.get("fbasedataid")).set("name", accountNameMap.getOrDefault(((DynamicObject)account.get("fbasedataid")).getString("number"), null));
                }
            }
            this.getModel().endInit();
        }
        this.getModel().setDataChanged(false);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        MainEntityType oldMainEntityType = e.getOriginalEntityType();
        MainEntityType newEntityType = null;
        try {
            newEntityType = (MainEntityType)oldMainEntityType.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("getEntityType", ex.getMessage()), new Object[0]);
        }
        String inited = this.getPageCache().get("inited");
        if (!StringUtils.isEmpty((CharSequence)inited)) {
            String dsFieldsStr = this.getPageCache().get(CACHE_DS_FIELDS);
            if (StringUtils.isNotEmpty((CharSequence)dsFieldsStr)) {
                List list = (List)SerializationUtils.deSerializeFromBase64((String)dsFieldsStr);
                this.registerDynamicCols(newEntityType, list);
            }
        } else {
            BaseShowParameter baseparam = (BaseShowParameter)this.getView().getFormShowParameter();
            Object pk = baseparam.getPkId();
            if (pk != null) {
                DynamicObject editdata = BusinessDataServiceHelper.loadSingle((Object)pk, (String)newEntityType.getName());
                DynamicObjectCollection mapdatas = editdata.getDynamicObjectCollection("fieldmapentry");
                List<DSField> list = AssistFieldUtil.getSchemeAssistFromDataRule(mapdatas);
                this.registerDynamicCols(newEntityType, list);
            }
        }
        e.setNewEntityType(newEntityType);
    }

    private void registerDynamicCols(MainEntityType newEntityType, List<DSField> dynFields) {
        EntityType acctEntryType = (EntityType)newEntityType.getAllEntities().get("modularentryentity");
        DataEntityPropertyCollection properties = acctEntryType.getProperties();
        for (DSField field : dynFields) {
            TextProp prop;
            if (AssistDataType.isBaseDataType((String)field.getDataType())) {
                prop = (MulBasedataProp)properties.get((Object)field.getFieldKey());
                prop.setBaseEntityId(field.getEntityId());
                prop.setDbIgnore(false);
                BasedataEntityType dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)field.getEntityId());
                String nameProperty = dataEntityType.getNameProperty();
                prop.setDisplayProp("id");
                BasedataProp bPropMul = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
                bPropMul.setBaseEntityId(field.getEntityId());
                MainEntityType newDT = EntityMetadataCache.getDataEntityType((String)field.getEntityId());
                bPropMul.setComplexType((IDataEntityType)newDT);
                bPropMul.setDisplayProp("id");
                DynamicProperty refProp = prop.getDynamicCollectionItemPropertyType().getProperty("fbasedataid_id");
                bPropMul.setRefIdProp((IDataEntityProperty)refProp);
                bPropMul.setRefIdPropName(refProp.getName());
                bPropMul.setDbIgnore(true);
                bPropMul.setOrgProp("useorg");
                continue;
            }
            prop = new TextProp();
            prop.setName(field.getFieldKey());
            prop.setDefValue((Object)"");
            prop.setDbIgnore(true);
            prop.setAlias("");
        }
    }

    private void drawDynamicCols(List<DSField> dynFields) {
        ArrayList<Map> cols = new ArrayList<Map>(8);
        cols.add(this.createSeqColumn());
        DSField accountsDS = new DSField("bd_accountview", "accounts", new LocaleString(ResManager.loadKDString((String)"\u79d1\u76ee", (String)"ReconciliationPlanEditPlugin_0", (String)"fi-frm-formplugin", (Object[])new Object[0])), "0");
        EntryFieldAp colAccounts = this.createMulBaseDataColumn(accountsDS, true, false, "number,name");
        Map acctCol = (Map)colAccounts.createColumns().get(0);
        cols.add(acctCol);
        EntryFieldAp balanceDc = this.createCombCol("balancedc1", true, true);
        balanceDc.setCtlTips(new Tips("text", null, new LocaleString(String.format(ResManager.loadKDString((String)"\u5f71\u54cd\u603b\u8d26\u671f\u521d\u3001\u671f\u672b\u4f59\u989d\u7684\u8ba1\u7b97\u3002%1$s\u501f\u65b9\uff1a\u603b\u8d26\u4f59\u989d=\u501f\u65b9\u4f59\u989d-\u8d37\u65b9\u4f59\u989d\uff1b%2$s\u8d37\u65b9\uff1a\u603b\u8d26\u4f59\u989d=\u8d37\u65b9\u4f59\u989d-\u501f\u65b9\u4f59\u989d\u3002", (String)"ReconciliationPlanEditPlugin_20", (String)"fi-frm-formplugin", (Object[])new Object[0]), System.lineSeparator(), System.lineSeparator())), false, new ArrayList(1)));
        Map dcCol = (Map)balanceDc.createColumns().get(0);
        cols.add(dcCol);
        DSField amountDS = new DSField("frm_amouttype_layout", "amounttype", new LocaleString(ResManager.loadKDString((String)"\u53d6\u6570\u7c7b\u578b", (String)"ReconciliationPlanEditPlugin_1", (String)"fi-frm-formplugin", (Object[])new Object[0])), "0");
        EntryFieldAp colamount = this.createMulBaseDataColumn(amountDS, true, false, "name");
        Map amountCol = (Map)colamount.createColumns().get(0);
        cols.add(amountCol);
        EntryFieldAp assistFilterAp = this.createAssistFilterAp();
        Map assistFilterCol = (Map)assistFilterAp.createColumns().get(0);
        cols.add(assistFilterCol);
        for (DSField bizassist : dynFields) {
            Object col;
            String dataType = bizassist.getDataType();
            if (AssistDataType.isBaseDataType((String)dataType)) {
                col = this.createMulBaseDataColumn(bizassist, false, true, "name");
                cols.add((Map)col.createColumns().get(0));
                continue;
            }
            col = this.createMulAssistDataColumn(bizassist, false);
            cols.add((Map)col.createColumns().get(0));
        }
        Map closeParam1 = null;
        String visible = MetadataUtil.getFormPropVisible((String)this.getModel().getDataEntityType().getName(), (String)"viewdetail");
        List items = ((EntryGrid)this.getView().getControl("modularentryentity")).getItems();
        for (Control item : items) {
            CheckBoxField checkBoxField;
            FieldEdit edit;
            EntryFieldAp f7Field;
            String key = item.getKey();
            if ("viewdetail".equals(key)) {
                f7Field = new EntryFieldAp();
                edit = (FieldEdit)item;
                f7Field.setKey(key);
                f7Field.setName(edit.getDisplayName());
                f7Field.setLock("");
                f7Field.setQuickAddNew(false);
                checkBoxField = new CheckBoxField();
                checkBoxField.setDefValue(true);
                f7Field.setField((Field)checkBoxField);
                f7Field.setVisible(visible);
                cols.add((Map)f7Field.createColumns().get(0));
                continue;
            }
            if (!"closeparam1".equals(key)) continue;
            f7Field = new EntryFieldAp();
            edit = (FieldEdit)item;
            f7Field.setKey(key);
            f7Field.setName(edit.getDisplayName());
            f7Field.setLock("");
            f7Field.setQuickAddNew(false);
            checkBoxField = new CheckBoxField();
            checkBoxField.setDefValue(true);
            f7Field.setField((Field)checkBoxField);
            closeParam1 = (Map)f7Field.createColumns().get(0);
        }
        EntryFieldAp balanceBasisAp = this.createCombCol("balancebasis1", true, true);
        Map balanceBasisCol = (Map)balanceBasisAp.createColumns().get(0);
        cols.add(balanceBasisCol);
        if (closeParam1 != null) {
            cols.add(closeParam1);
        }
        HashMap<String, Object> meta = new HashMap<String, Object>(6);
        meta.put("rk", "rk");
        meta.put("seq", "seq");
        meta.put("columns", cols);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.preInvokeControlMethod("modularentryentity", "createGridColumns", new Object[]{meta});
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeType = e.getProperty().getName();
        if (changeType.equals("booktype")) {
            DynamicObject useOrg = (DynamicObject)this.getModel().getValue("useorg");
            DynamicObject bookType = (DynamicObject)this.getModel().getValue("booktype");
            if (bookType != null) {
                QFilter orgFilter = new QFilter("org", "=", (Object)useOrg.getLong("id"));
                QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
                QFilter bookstypeFilter = new QFilter("bookstype", "=", (Object)bookType.getLong("id"));
                DynamicObject acctBooksType = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"accounttable.id", (QFilter[])new QFilter[]{orgFilter, bookstypeFilter, statusFilter});
                if (acctBooksType != null) {
                    this.getModel().setValue("accounttable", (Object)acctBooksType.getLong("accounttable.id"));
                }
            }
        } else if (changeType.equals("bizapp")) {
            this.getModel().deleteEntryData("modularentryentity");
            this.getModel().deleteEntryData("assistentry");
            this.getModel().deleteEntryData("basedataentry");
            this.getModel().createNewEntryRow("modularentryentity");
            this.getModel().createNewEntryRow("assistentry");
            this.getModel().createNewEntryRow("basedataentry");
            DynamicObject useOrg = (DynamicObject)this.getModel().getValue("useorg");
            DynamicObject bizApp = (DynamicObject)this.getModel().getValue("bizapp");
            if (bizApp == null) {
                this.getModel().setValue("reconciliactionconfig", null);
                this.getModel().setValue("dataruledesc", (Object)"");
            } else {
                QFilter orgFilter = new QFilter("useorg.id", "=", useOrg.getPkValue());
                QFilter appFilter = new QFilter("bizapp.id", "=", bizApp.getPkValue());
                QFilter enbleFilter = new QFilter("enable", "=", (Object)"1");
                DynamicObject[] rules = BusinessDataServiceHelper.load((String)"frm_recdatarule", (String)"id,bizassist", (QFilter[])new QFilter[]{orgFilter, appFilter, enbleFilter});
                DynamicObject rule = null;
                if (rules != null && rules.length > 0) {
                    rule = rules[0];
                }
                if (rule != null) {
                    this.getModel().setValue("reconciliactionconfig", (Object)rule.getString("id"));
                    this.getModel().setValue("dataruledesc", (Object)rule.getString("name"));
                } else {
                    Object ruleId = this.getModel().getValue("reconciliactionconfig");
                    if (ruleId != null && StringUtils.isNotEmpty((CharSequence)ruleId.toString()) && !"0".equals(ruleId.toString())) {
                        rules = BusinessDataServiceHelper.load((String)"frm_recdatarule", (String)"id,bizassist", (QFilter[])new QFilter[]{orgFilter, appFilter, enbleFilter});
                        if (rules != null && rules.length > 0) {
                            rule = rules[0];
                        }
                        if (rule != null) {
                            this.getModel().setValue("reconciliactionconfig", (Object)rule.getString("id"));
                            this.getModel().setValue("dataruledesc", (Object)rule.getString("name"));
                        }
                    } else {
                        orgFilter = new QFilter("useorg.id", "=", (Object)OrgUnitServiceHelper.getRootOrgId());
                        rules = BusinessDataServiceHelper.load((String)"frm_recdatarule", (String)"id,bizassist", (QFilter[])new QFilter[]{orgFilter, appFilter, enbleFilter});
                        if (rules != null && rules.length > 0) {
                            rule = rules[0];
                        }
                        if (rule != null) {
                            this.getModel().setValue("reconciliactionconfig", (Object)rule.getString("id"));
                            this.getModel().setValue("dataruledesc", (Object)rule.getString("name"));
                        }
                    }
                }
            }
        } else if ("reconciliactionconfig".equals(changeType)) {
            ChangeData[] changeSet = e.getChangeSet();
            Object newValue = changeSet[0].getNewValue();
            if (newValue == null) {
                this.dataRuleChangedAction(null, true);
            } else {
                DynamicObject dataRuleDyn = (DynamicObject)newValue;
                this.dataRuleChangedAction(dataRuleDyn, true);
            }
        } else if (changeType.equals("tab1_account")) {
            this.getModel().setValue(MUL_ASSIST_INFO_DESC, null, this.getModel().getEntryCurrentRowIndex("assistentry"));
            if (this.getModel().getValue("balancedc2").equals(BalanceDcEnum.EMPTY.getValue())) {
                return;
            }
            DynamicObject account = (DynamicObject)this.getModel().getValue("tab1_account");
            if (account != null) {
                BalanceDcEnum balanceDcEnum = ReconciliationUtil.getBalanceDc((int)account.getInt("dc"));
                this.getModel().setValue("balancedc2", (Object)balanceDcEnum.getValue());
            }
        } else if (changeType.equals("accounttable")) {
            int i;
            int count = this.getModel().getEntryRowCount("modularentryentity");
            for (i = 0; i < count; ++i) {
                this.getModel().setValue("accounts", null, i);
            }
            count = this.getModel().getEntryRowCount("assistentry");
            for (i = 0; i < count; ++i) {
                this.getModel().setValue("tab1_account", null, i);
            }
            this.getModel().deleteEntryData("modularentryentity");
            this.getModel().deleteEntryData("assistentry");
            this.getModel().deleteEntryData("basedataentry");
            this.getModel().createNewEntryRow("modularentryentity");
            this.getModel().createNewEntryRow("assistentry");
            this.getModel().createNewEntryRow("basedataentry");
        } else if (changeType.equals("reconamounttype")) {
            int reconAmountType = Integer.parseInt(String.valueOf(e.getChangeSet()[0].getNewValue()));
            if (reconAmountType == ReconAmountTypeEnum.DEBIT.getValue() || reconAmountType == ReconAmountTypeEnum.CREDIT.getValue() || reconAmountType == ReconAmountTypeEnum.DEBIT_CREDIT.getValue()) {
                this.getModel().setValue("balancebasis", (Object)BalanceBasisEnum.ALL.getValue());
                this.getView().setEnable(Boolean.FALSE, new String[]{"balancebasis"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"balancebasis1"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"balancebasis"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"balancebasis1"});
            }
        } else if (changeType.equals("amounttype1") || changeType.equals("amounttype2")) {
            MulBasedataDynamicObjectCollection newValue = (MulBasedataDynamicObjectCollection)e.getChangeSet()[0].getNewValue();
            if (changeType.equals("amounttype1")) {
                this.controlBizAssist("bizassist2", "assistentry", newValue);
            } else {
                this.controlBizAssist("bizassist3", "basedataentry", newValue);
            }
        } else if ((changeType.equals("bizassist2") || changeType.equals("bizassist3")) && StringUtils.isEmpty((CharSequence)String.valueOf(e.getChangeSet()[0].getNewValue()))) {
            if (changeType.equals("bizassist2")) {
                this.getModel().setValue("bizassistinfo_tag", (Object)" ", this.getModel().getEntryCurrentRowIndex("assistentry"));
            } else {
                this.getModel().setValue("bizassist2info_tag", (Object)" ", this.getModel().getEntryCurrentRowIndex("basedataentry"));
            }
        } else if (changeType.startsWith(DYN_ASSISTANT_KEY_PREFIX)) {
            ChangeData changeData = e.getChangeSet()[0];
            String newValue = (String)changeData.getNewValue();
            int curAcctEntryIndex = this.getModel().getEntryCurrentRowIndex("modularentryentity");
            if (newValue == null || StringUtils.isEmpty((CharSequence)newValue)) {
                DynamicObject acctRow = this.getModel().getEntryRowEntity("modularentryentity", curAcctEntryIndex);
                DynamicObjectCollection acctassistentry = acctRow.getDynamicObjectCollection("acctassistentry");
                Iterator it = acctassistentry.iterator();
                while (it.hasNext()) {
                    DynamicObject assistRow = (DynamicObject)it.next();
                    String assistfield = assistRow.getString("assistfield");
                    if (!changeType.equals(assistfield)) continue;
                    it.remove();
                }
                this.getView().updateView("acctassistentry");
            } else {
                this.getModel().beginInit();
                this.getModel().setValue("assistfilter", null, curAcctEntryIndex);
                this.getModel().setValue("assistfilterinfo", null, curAcctEntryIndex);
                this.getModel().setValue("assistfilterinfo_tag", null, curAcctEntryIndex);
                this.getModel().endInit();
                this.getModel().setDataChanged(false);
                this.getView().updateView("modularentryentity", curAcctEntryIndex);
            }
        } else if (changeType.equals("accounts")) {
            this.dealMulAccountPropertyChange(e, "balancedc1");
        } else if (changeType.equals("assistacct")) {
            this.dealMulAccountPropertyChange(e, "balancedc3");
        } else if ("assistfilter".equals(changeType)) {
            ChangeData changeData = e.getChangeSet()[0];
            String newValue = (String)changeData.getNewValue();
            int curAcctEntryIndex = this.getModel().getEntryCurrentRowIndex("modularentryentity");
            this.getModel().beginInit();
            if (StringUtils.isEmpty((CharSequence)newValue)) {
                this.getModel().setValue("assistfilterinfo", null, curAcctEntryIndex);
                this.getModel().setValue("assistfilterinfo_tag", null, curAcctEntryIndex);
            } else {
                for (int i = 0; i < 8; ++i) {
                    this.getModel().setValue("basedata" + i, null, curAcctEntryIndex);
                    this.getModel().setValue("assistantfield" + i, null, curAcctEntryIndex);
                    this.getModel().setValue(DYN_ASSISTANT_KEY_PREFIX + i, (Object)"", curAcctEntryIndex);
                }
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("modularentryentity", curAcctEntryIndex);
                DynamicObjectCollection acctassistentry = rowEntity.getDynamicObjectCollection("acctassistentry");
                acctassistentry.clear();
            }
            this.getModel().endInit();
            this.getModel().setDataChanged(false);
            this.getView().updateView("modularentryentity", curAcctEntryIndex);
        } else if (changeType.startsWith("basedata")) {
            ChangeData changeData = e.getChangeSet()[0];
            Object newValue = changeData.getNewValue();
            int curAcctEntryIndex = this.getModel().getEntryCurrentRowIndex("modularentryentity");
            if (newValue != null) {
                this.getModel().beginInit();
                this.getModel().setValue("assistfilter", null, curAcctEntryIndex);
                this.getModel().setValue("assistfilterinfo", null, curAcctEntryIndex);
                this.getModel().setValue("assistfilterinfo_tag", null, curAcctEntryIndex);
                this.getModel().endInit();
                this.getModel().setDataChanged(false);
                this.getView().updateView("modularentryentity", curAcctEntryIndex);
            }
        } else if ("closeparam".equals(changeType)) {
            ChangeData changeData = e.getChangeSet()[0];
            boolean newValue = (Boolean)changeData.getNewValue();
            this.closeParamOff("modularentryentity", "closeparam1", newValue);
            this.closeParamOff("assistentry", "closeparam2", newValue);
            this.closeParamOff("basedataentry", "closeparam3", newValue);
        }
    }

    private void closeParamOff(String entryEntityKey, String closeParamKey, Boolean enable) {
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryEntityKey);
        if (collection == null || collection.size() == 0) {
            return;
        }
        for (DynamicObject row : collection) {
            row.set(closeParamKey, (Object)enable);
        }
        this.getModel().setDataChanged(false);
        this.getView().updateView(entryEntityKey);
    }

    private void dealMulAccountPropertyChange(PropertyChangedArgs args, String balanceDcFieldName) {
        if (this.getModel().getValue(balanceDcFieldName).equals(BalanceDcEnum.EMPTY.getValue())) {
            return;
        }
        MulBasedataDynamicObjectCollection accountCollection = (MulBasedataDynamicObjectCollection)args.getChangeSet()[0].getNewValue();
        if (accountCollection != null && accountCollection.size() > 0) {
            DynamicObject account = (DynamicObject)((DynamicObject)accountCollection.get(0)).get("fbasedataid");
            BalanceDcEnum balanceDcEnum = ReconciliationUtil.getBalanceDc((int)account.getInt("dc"));
            String balanceDc = balanceDcEnum.getValue();
            this.getModel().setValue(balanceDcFieldName, (Object)balanceDc);
        }
    }

    private void controlBizAssist(String fieldName, String entryName, MulBasedataDynamicObjectCollection newValue) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(entryName);
        this.getModel().setValue(fieldName, null, rowIndex);
        if (newValue == null || newValue.size() == 0) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{fieldName});
        } else {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{fieldName});
        }
    }

    private EntryFieldAp createCombCol(String fieldKey, boolean mustInput, boolean visible) {
        ComboProp property = (ComboProp)((EntityType)this.getModel().getDataEntityType().getAllEntities().get("modularentryentity")).getProperty(fieldKey);
        EntryFieldAp f7Field = new EntryFieldAp();
        f7Field.setKey(fieldKey);
        f7Field.setName(property.getDisplayName());
        f7Field.setFieldTextAlign("left");
        f7Field.setTextAlign("left");
        f7Field.setAlignSelf("left");
        f7Field.setWidth(new LocaleString("150"));
        f7Field.setLock("");
        f7Field.setQuickAddNew(false);
        if (visible) {
            f7Field.setVisible(null);
        } else {
            f7Field.setVisible("");
        }
        ComboField comboField = new ComboField();
        comboField.setName(property.getDisplayName());
        comboField.setKey(fieldKey);
        List comboItems = property.getComboItems();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(comboItems.size());
        for (int i = 0; i < comboItems.size(); ++i) {
            ValueMapItem valueMapItem = (ValueMapItem)comboItems.get(i);
            ComboItem comboItem = new ComboItem();
            comboItem.setSeq(i + 1);
            comboItem.setValue(valueMapItem.getValue());
            comboItem.setItemVisible(valueMapItem.isItemVisible());
            comboItem.setImageKey(valueMapItem.getImageKey());
            comboItem.setCaption(new LocaleString(valueMapItem.getName().getLocaleValue()));
            items.add(comboItem);
        }
        comboField.setItems(items);
        comboField.setMustInput(mustInput);
        f7Field.setField((Field)comboField);
        return f7Field;
    }

    private EntryFieldAp createAssistFilterAp() {
        EntryFieldAp f7Field = new EntryFieldAp();
        f7Field.setKey("assistfilter");
        LocaleString name = new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u8fc7\u6ee4", (String)"ReconciliationPlanEditPlugin_22", (String)"fi-frm-formplugin", (Object[])new Object[0]));
        f7Field.setName(name);
        f7Field.setFieldTextAlign("left");
        f7Field.setTextAlign("left");
        f7Field.setAlignSelf("left");
        f7Field.setWidth(new LocaleString("150"));
        f7Field.setLock("");
        f7Field.setQuickAddNew(false);
        f7Field.setFireUpdEvt(true);
        TextField adField = new TextField();
        adField.setId("assistfilter");
        adField.setKey("assistfilter");
        adField.setEditStyle(2);
        f7Field.setField((Field)adField);
        return f7Field;
    }

    private Map<String, Object> createSeqColumn() {
        HashMap<String, Object> col = new HashMap<String, Object>(5, 1.0f);
        col.put("dataIndex", "seq");
        col.put("width", "20px");
        col.put("header", "#");
        col.put("type", "numberfield");
        return col;
    }

    private EntryFieldAp createMulBaseDataColumn(DSField ds, boolean mustInput, boolean appendFilterPrefix, String displayProp) {
        EntryFieldAp f7Field = new EntryFieldAp();
        f7Field.setKey(ds.getFieldKey());
        if (appendFilterPrefix) {
            LocaleString name = new LocaleString(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u8fc7\u6ee4:%s", (String)"ReconciliationPlanEditPlugin_21", (String)"fi-frm-formplugin", (Object[])new Object[0]), ds.getFieldName().getLocaleValue()));
            f7Field.setName(name);
        } else {
            f7Field.setName(ds.getFieldName());
        }
        f7Field.setFieldTextAlign("left");
        f7Field.setTextAlign("left");
        f7Field.setAlignSelf("left");
        f7Field.setWidth(new LocaleString("150"));
        f7Field.setLock("");
        f7Field.setQuickAddNew(false);
        MulBasedataField mulBasedata = new MulBasedataField();
        mulBasedata.setBaseEntityId(ds.getEntityId());
        mulBasedata.setKey(ds.getFieldKey());
        mulBasedata.setMustInput(mustInput);
        mulBasedata.setDisplayProp(displayProp);
        f7Field.setField((Field)mulBasedata);
        return f7Field;
    }

    private EntryFieldAp createMulAssistDataColumn(DSField ds, boolean mustInput) {
        EntryFieldAp f7Field = new EntryFieldAp();
        f7Field.setKey(ds.getFieldKey());
        LocaleString name = new LocaleString(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u8fc7\u6ee4:%s", (String)"ReconciliationPlanEditPlugin_21", (String)"fi-frm-formplugin", (Object[])new Object[0]), ds.getFieldName().getLocaleValue()));
        f7Field.setName(name);
        f7Field.setFieldTextAlign("left");
        f7Field.setTextAlign("left");
        f7Field.setAlignSelf("left");
        f7Field.setWidth(new LocaleString("150"));
        f7Field.setLock("");
        f7Field.setQuickAddNew(false);
        TextField adField = new TextField();
        adField.setId(ds.getFieldKey());
        adField.setKey(ds.getFieldKey());
        adField.setEditStyle(2);
        adField.setDefValue("");
        f7Field.setField((Field)adField);
        return f7Field;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ImportCheckResult checkResult;
        super.beforeDoOperation(args);
        if (!(args.getSource() instanceof Save)) {
            return;
        }
        this.getModel().setValue("status", (Object)"C");
        ImportCheckResult uniqeResult = this.getSaveCheckUniqueResult();
        if (!uniqeResult.getStatus().booleanValue()) {
            args.setCancel(true);
            args.setCancelMessage(uniqeResult.getMessage());
            this.getView().showErrorNotification(uniqeResult.getMessage());
            return;
        }
        DynamicObjectCollection firstEntry = this.getModel().getEntryEntity("modularentryentity");
        HashSet<Long> acctIds = new HashSet<Long>();
        DynamicObject acct = null;
        HashSet<String> acctEtyKey = new HashSet<String>(10);
        String acctNumber = null;
        Long accountId = null;
        Long amtId = null;
        String amtName = null;
        for (DynamicObject entryData : firstEntry) {
            DynamicObjectCollection dyAmts = entryData.getDynamicObjectCollection("amounttype");
            DynamicObjectCollection accounts = entryData.getDynamicObjectCollection("accounts");
            for (Object account : accounts) {
                accountId = account.getLong("fbasedataid_id");
                acctNumber = account.getDynamicObject(1).getString("number");
                acctIds.add(accountId);
                Iterator iterator = dyAmts.iterator();
                while (iterator.hasNext()) {
                    DynamicObject dyAmt = (DynamicObject)iterator.next();
                    amtId = dyAmt.getLong("fbasedataid_id");
                    amtName = dyAmt.getDynamicObject(1).getString("name");
                    StringBuilder accountAmt = new StringBuilder();
                    accountAmt.append(accountId).append(',').append(amtId);
                    for (String curKey : acctEtyKey) {
                        if (!curKey.equals(accountAmt.toString())) continue;
                        args.setCancel(true);
                        String msg = String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u5bf9\u8d26\u5206\u5f55\u884c\u4e2d\u79d1\u76ee[%1$s]+\u53d6\u6570\u7c7b\u578b[%2$s]\u9700\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5", (String)"ReconciliationPlanEditPlugin_11", (String)"fi-frm-formplugin", (Object[])new Object[0]), acctNumber, amtName);
                        args.setCancelMessage(msg);
                        this.getView().showErrorNotification(msg);
                        return;
                    }
                    acctEtyKey.add(accountAmt.toString());
                }
            }
        }
        DynamicObjectCollection secEntry = this.getModel().getEntryEntity("assistentry");
        StringBuilder dulpAcct = new StringBuilder();
        for (DynamicObject entryData : secEntry) {
            acct = entryData.getDynamicObject("tab1_account");
            if (acct == null || !acctIds.contains(acct.getLong("id"))) continue;
            acctIds.remove(acct.getLong("id"));
            if (dulpAcct.length() > 0) {
                dulpAcct.append(',');
            }
            dulpAcct.append(acct.getString("number")).append(' ').append(acct.getString("name"));
        }
        if (dulpAcct.length() > 0) {
            args.setCancel(true);
            String errMsg = String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u5bf9\u8d26\u4e0e\u6838\u7b97\u7ef4\u5ea6\u5bf9\u8d26\u4e2d\u5305\u542b\u76f8\u540c\u7684\u79d1\u76ee\uff1a%s\u3002", (String)"ReconciliationPlanEditPlugin_12", (String)"fi-frm-formplugin", (Object[])new Object[0]), dulpAcct);
            args.setCancelMessage(errMsg);
            this.getView().showErrorNotification(errMsg);
        }
        if (!(checkResult = this.getSaveCheckResult()).getStatus().booleanValue()) {
            args.setCancel(true);
            args.setCancelMessage(checkResult.getMessage());
            this.getView().showErrorNotification(checkResult.getMessage());
            return;
        }
        DynamicObjectCollection assistMappingEntry = this.getModel().getEntryEntity("assistmapentry");
        assistMappingEntry.clear();
        DynamicObjectCollection entryEntity2 = this.getModel().getEntryEntity("assistentry");
        for (DynamicObject entryRow : entryEntity2) {
            String assistCfgData = entryRow.getString("mulassistinfo_tag");
            if (StringUtils.isEmpty((CharSequence)assistCfgData)) continue;
            List assistCfgList = SerializationUtils.fromJsonStringToList((String)assistCfgData, MulassistConfigModel.class);
            for (MulassistConfigModel cfgModel : assistCfgList) {
                Long assistMapId = cfgModel.getAssistMapId();
                if (assistMapId == null || assistMapId == 0L) continue;
                DynamicObject row = assistMappingEntry.addNew();
                row.set("refassistmap", (Object)assistMapId);
            }
        }
        DynamicObjectCollection entryEntity3 = this.getModel().getEntryEntity("basedataentry");
        for (DynamicObject entryRow : entryEntity3) {
            String assistCfgData = entryRow.getString("mulassist2info_tag");
            if (StringUtils.isEmpty((CharSequence)assistCfgData)) continue;
            List assistCfgList = SerializationUtils.fromJsonStringToList((String)assistCfgData, MulassistConfigModel.class);
            for (MulassistConfigModel cfgModel : assistCfgList) {
                Long assistMapId = cfgModel.getAssistMapId();
                if (assistMapId == null || assistMapId == 0L) continue;
                DynamicObject row = assistMappingEntry.addNew();
                row.set("refassistmap", (Object)assistMapId);
            }
        }
    }

    private void collectTabEntryAssistKey(Set<Long> asstIds, Set<Long> asstMappingIds, String assTypeKey, DynamicObject entryRow) {
        String bigText = entryRow.getString(assTypeKey);
        if (StringUtils.isEmpty((CharSequence)bigText)) {
            return;
        }
        List assTypeCfgList = JSONArray.parseArray((String)bigText, MulassistConfigModel.class);
        for (MulassistConfigModel cfg : assTypeCfgList) {
            Long assistMapId = cfg.getAssistMapId();
            if (assistMapId == null) {
                asstIds.add(Long.valueOf(cfg.getAssistId()));
                continue;
            }
            asstMappingIds.add(cfg.getAssistMapId());
        }
    }

    private Map<Long, String> getAsstTypeDimsFromId(Set<Long> asstIds) {
        HashMap<Long, String> ret = new HashMap<Long, String>(asstIds.size(), 1.0f);
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", asstIds)};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getAsstTypeDimsFromId", (String)"bd_asstacttype", (String)"id, valuetype,valuesource,assistanttype", (QFilter[])filters, null);){
            Iterator iter = ds.iterator();
            String valuesource = "";
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                String valuetype = row.getString("valuetype");
                if (AssistDataType.isBaseDataType((String)valuetype)) {
                    valuesource = row.getString("valuesource");
                } else if (AssistDataType.isAssistantDataType((String)valuetype)) {
                    valuesource = row.getLong("assistanttype").toString();
                }
                ret.put(row.getLong("id"), AssistDataType.makeAssistKey((String)valuetype, (String)valuesource));
            }
        }
        return ret;
    }

    private Map<Long, Set<String>> getAsstTypeDimsFromMappingId(Set<Long> mappingIds) {
        if (CollectionUtils.isEmpty(mappingIds)) {
            return Collections.emptyMap();
        }
        HashMap<Long, Set<String>> retMap = new HashMap<Long, Set<String>>(16);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getAsstTypeDimsFromMappingId", (String)"ai_asstdimmaptype", (String)"id,fieldmapentry.datatype,fieldmapentry.entityid", (QFilter[])new QFilter[]{new QFilter("id", "in", mappingIds)}, null);
        for (Row row : dataSet) {
            Set dimKeys = retMap.computeIfAbsent(row.getLong("id"), key -> new HashSet());
            String bdType = row.getString("fieldmapentry.datatype");
            String entityId = row.getString("fieldmapentry.entityid");
            dimKeys.add(AssistDataType.makeAssistKey((String)(Integer.parseInt(bdType) + 1 + ""), (String)entityId));
        }
        return retMap;
    }

    private Map<String, Set<String>> getAmountTypeDims() {
        Set dimSet;
        String amountTypePk;
        DynamicObjectCollection dyAmountTypeCols;
        HashSet curDimSet;
        HashSet<Long> curAsstMappings;
        HashSet<Long> curAsstTypes;
        IDataModel model = this.getModel();
        DynamicObjectCollection mapdatas = model.getEntryEntity("fieldmapentry");
        if (mapdatas == null || mapdatas.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>(8);
        DynamicObjectCollection accountTabEntry = model.getEntryEntity("modularentryentity");
        for (DynamicObject acctEntry : accountTabEntry) {
            DynamicObjectCollection amountTypeCols = acctEntry.getDynamicObjectCollection("amounttype");
            String assistfilter = acctEntry.getString("assistfilterinfo_tag");
            List assistFilters = JSONArray.parseArray((String)assistfilter, Map.class);
            for (DynamicObject dyAmountType : amountTypeCols) {
                DynamicObject dyAmountLayout = dyAmountType.getDynamicObject("fbasedataid");
                String amountTypePk2 = dyAmountLayout.getPkValue().toString();
                Set dimSet2 = ret.computeIfAbsent(amountTypePk2, p -> new HashSet());
                if (assistFilters == null) {
                    for (DynamicObject map : mapdatas) {
                        DynamicObjectCollection acctassistentry;
                        List dimCols;
                        String dateType = map.getString("datatype");
                        String fieldKey = map.getString("fieldkey");
                        String entityId = map.getString("entityid");
                        if (AssistDataType.isBaseDataType((String)dateType)) {
                            DynamicObjectCollection dimCols2 = acctEntry.getDynamicObjectCollection(fieldKey);
                            if (dimCols2 == null || dimCols2.isEmpty()) continue;
                            dimSet2.add(AssistDataType.makeAssistKey((String)dateType, (String)entityId));
                            continue;
                        }
                        if (!AssistDataType.isAssistantDataType((String)dateType) || (dimCols = (acctassistentry = acctEntry.getDynamicObjectCollection("acctassistentry")).stream().filter(row -> fieldKey.equals(row.getString("assistfield"))).collect(Collectors.toList())).isEmpty()) continue;
                        dimSet2.add(AssistDataType.makeAssistKey((String)dateType, (String)entityId));
                    }
                    continue;
                }
                for (Map rowData : assistFilters) {
                    for (Map.Entry entry : rowData.entrySet()) {
                        String assistKey = (String)entry.getKey();
                        List assistVals = (List)entry.getValue();
                        if (assistVals == null || assistVals.size() <= 0) continue;
                        dimSet2.add(assistKey);
                    }
                }
            }
        }
        HashSet<Long> asstTypes = new HashSet<Long>(10);
        HashSet<Long> asstMappings = new HashSet<Long>(10);
        DynamicObjectCollection dyAssistEntries = model.getEntryEntity("assistentry");
        for (Object dyAssistEty : dyAssistEntries) {
            this.collectTabEntryAssistKey(asstTypes, asstMappings, "mulassistinfo_tag", (DynamicObject)dyAssistEty);
        }
        DynamicObjectCollection dyBaseDataEntries = model.getEntryEntity("basedataentry");
        for (DynamicObject dyAssistEty : dyBaseDataEntries) {
            this.collectTabEntryAssistKey(asstTypes, asstMappings, "mulassist2info_tag", dyAssistEty);
        }
        Map<Long, String> asstTypesMap = this.getAsstTypeDimsFromId(asstTypes);
        Map<Long, Set<String>> asstMappingsMap = this.getAsstTypeDimsFromMappingId(asstMappings);
        for (DynamicObject dyAssistEty : dyAssistEntries) {
            curAsstTypes = new HashSet<Long>();
            curAsstMappings = new HashSet<Long>();
            this.collectTabEntryAssistKey(curAsstTypes, curAsstMappings, "mulassistinfo_tag", dyAssistEty);
            curDimSet = new HashSet(curAsstTypes.size() + curAsstMappings.size());
            curAsstTypes.forEach(id -> curDimSet.add(asstTypesMap.get(id)));
            curAsstMappings.forEach(id -> curDimSet.addAll((Collection)asstMappingsMap.get(id)));
            dyAmountTypeCols = dyAssistEty.getDynamicObjectCollection("amounttype1");
            for (DynamicObject dyAmountType : dyAmountTypeCols) {
                amountTypePk = dyAmountType.getString("fbasedataid.id");
                dimSet = ret.computeIfAbsent(amountTypePk, p -> new HashSet());
                dimSet.addAll(curDimSet);
            }
        }
        for (DynamicObject dyAssistEty : dyBaseDataEntries) {
            curAsstTypes = new HashSet();
            curAsstMappings = new HashSet();
            this.collectTabEntryAssistKey(curAsstTypes, curAsstMappings, "mulassist2info_tag", dyAssistEty);
            curDimSet = new HashSet(curAsstTypes.size() + curAsstMappings.size());
            curAsstTypes.forEach(id -> curDimSet.add(asstTypesMap.get(id)));
            curAsstMappings.forEach(id -> curDimSet.addAll((Collection)asstMappingsMap.get(id)));
            dyAmountTypeCols = dyAssistEty.getDynamicObjectCollection("amounttype2");
            for (DynamicObject dyAmountType : dyAmountTypeCols) {
                amountTypePk = dyAmountType.getString("fbasedataid.id");
                dimSet = ret.computeIfAbsent(amountTypePk, p -> new HashSet());
                dimSet.addAll(curDimSet);
            }
        }
        return ret;
    }

    private Map<String, String> getAllDimsName(Set<String> assistKeys) {
        DynamicObject[] load;
        List bdEntityKeys = assistKeys.stream().filter(key -> AssistDataType.isBaseDataType((String)key.split("\\.")[0])).map(key -> key.split("\\.")[1]).collect(Collectors.toList());
        List adEntityKeys = assistKeys.stream().filter(key -> !AssistDataType.isBaseDataType((String)key.split("\\.")[0])).map(key -> Long.parseLong(key.split("\\.")[1])).collect(Collectors.toList());
        HashMap<String, String> entityNameMap = new HashMap<String, String>(assistKeys.size(), 1.0f);
        if (CollectionUtils.isNotEmpty(bdEntityKeys)) {
            for (DynamicObject entity : load = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("number", "in", bdEntityKeys)})) {
                entityNameMap.put(AssistDataType.makeAssistKey((String)AssistDataType.BASEDATA.getBdType(), (String)entity.getString("number")), entity.getString("name"));
            }
        }
        if (CollectionUtils.isNotEmpty(adEntityKeys)) {
            for (DynamicObject entity : load = BusinessDataServiceHelper.load((String)"bos_assistantdatagroup", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", adEntityKeys)})) {
                entityNameMap.put(AssistDataType.makeAssistKey((String)AssistDataType.ASSISTASNT.getBdType(), (String)entity.getString("id")), entity.getString("name"));
            }
        }
        return entityNameMap;
    }

    private ImportCheckResult getSaveCheckResult() {
        ImportCheckResult ret = new ImportCheckResult();
        Map<String, Set<String>> amountTypeMap = this.getAmountTypeDims();
        if (amountTypeMap.isEmpty()) {
            ret.setStatus(Boolean.TRUE);
        }
        DynamicObject appObj = (DynamicObject)this.getModel().getValue("bizapp");
        Long dataRuleId = (Long)this.getModel().getValue("reconciliactionconfig_id");
        if (appObj != null && dataRuleId != null) {
            DynamicObject dataRule = ReconciliationUtil.getDataRule((Long)dataRuleId, null);
            DynamicObjectCollection ruleEnties = dataRule.getDynamicObjectCollection("entryentity");
            String ruleName = dataRule.getString("name");
            Map<String, Set<String>> amountTypeDims = this.getAmountTypeDims();
            HashSet<String> dimKeys = new HashSet<String>();
            amountTypeDims.values().forEach(dimKeys::addAll);
            Map<String, String> assistNameMap = this.getAllDimsName(dimKeys);
            for (DynamicObject dyRuleEntry : ruleEnties) {
                String bizObjName = dyRuleEntry.getString("bizobj.name");
                String amtTypePk = dyRuleEntry.getString("amttype.id");
                String amtTypeName = dyRuleEntry.getString("amttype.name");
                Set<String> dimSet = amountTypeMap.get(amtTypePk);
                if (dimSet == null || dimSet.isEmpty()) continue;
                boolean materialCategoryValid = this.dataRuleHeaderAssistCheck(dimSet, dataRule.getDynamicObjectCollection("bizassist"), "bd_materialcategory");
                if (materialCategoryValid) {
                    dimSet.remove("1.bd_materialcategory");
                    if (dimSet.isEmpty()) {
                        continue;
                    }
                } else {
                    ret.setStatus(Boolean.FALSE);
                    ret.setMessage(String.format(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u5bf9\u8d26\u7ef4\u5ea6[%s]\u5fc5\u987b\u5728\u5bf9\u8d26\u901a\u7528\u8bbe\u7f6e\u5bf9\u8d26\u7ef4\u5ea6\u7684\u8303\u56f4\u5185\uff0c\u8bf7\u68c0\u67e5", (String)"ReconciliationPlanEditPlugin_7", (String)"fi-frm-formplugin", (Object[])new Object[0]), assistNameMap.get("1.bd_materialcategory")));
                    return ret;
                }
                DynamicObject dyCommonFilter = dyRuleEntry.getDynamicObject("commonfilter");
                DynamicObject dyComFilter = BusinessDataServiceHelper.loadSingleFromCache((Object)dyCommonFilter.getPkValue(), (String)ENTITY_AI_COMMONFILTER);
                DynamicObjectCollection dyAssistCols = dyComFilter.getDynamicObjectCollection("fieldmapentry");
                if (dyAssistCols == null || dyAssistCols.isEmpty()) {
                    ret.setStatus(Boolean.FALSE);
                    ret.setMessage(String.format(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u7684\u53d6\u6570\u89c4\u5219[%1$s]\u4e2d\u7684\u4e1a\u52a1\u5bf9\u8c61\u4e3a[%2$s]\u53d6\u6570\u7c7b\u578b\u4e3a[%3$s]\u7684\u5bf9\u8d26\u7ef4\u5ea6\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"ReconciliationPlanEditPlugin_13", (String)"fi-frm-formplugin", (Object[])new Object[0]), ruleName, bizObjName, amtTypeName));
                    return ret;
                }
                HashSet<String> currentDimSet = new HashSet<String>(dyAssistCols.size());
                for (DynamicObject dyAssist : dyAssistCols) {
                    String bdtype = dyAssist.getString("datatype");
                    String sourcenumber = dyAssist.getString("entityid");
                    currentDimSet.add(AssistDataType.makeAssistKey((String)bdtype, (String)sourcenumber));
                }
                int dimSetSize = dimSet.size();
                if (dimSet.contains("1.bos_org") && dimSet.contains("1.bos_adminorg")) {
                    --dimSetSize;
                }
                if (currentDimSet.size() < dimSetSize) {
                    ret.setStatus(Boolean.FALSE);
                    ret.setMessage(ResManager.loadKDString((String)"\u5bf9\u8d26\u901a\u7528\u8bbe\u7f6e\u5bf9\u8d26\u7ef4\u5ea6\u7684\u8303\u56f4\u4e0d\u80fd\u5c0f\u4e8e\u5bf9\u5e94\u53d6\u6570\u7c7b\u578b\u5bf9\u8d26\u7ef4\u5ea6\u7684\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5", (String)"ReconciliationPlanEditPlugin_6", (String)"fi-frm-formplugin", (Object[])new Object[0]));
                    return ret;
                }
                boolean hasOrg = currentDimSet.contains("1.bos_org") || currentDimSet.contains("1.bos_adminorg");
                for (String curDim : dimSet) {
                    boolean isOrg;
                    boolean bl = isOrg = "1.bos_org".equals(curDim) || "1.bos_adminorg".equals(curDim);
                    if (isOrg && hasOrg || currentDimSet.contains(curDim)) continue;
                    ret.setStatus(Boolean.FALSE);
                    ret.setMessage(String.format(ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u5bf9\u8d26\u7ef4\u5ea6[%s]\u5fc5\u987b\u5728\u5bf9\u8d26\u901a\u7528\u8bbe\u7f6e\u5bf9\u8d26\u7ef4\u5ea6\u7684\u8303\u56f4\u5185\uff0c\u8bf7\u68c0\u67e5", (String)"ReconciliationPlanEditPlugin_7", (String)"fi-frm-formplugin", (Object[])new Object[0]), assistNameMap.get(curDim)));
                    return ret;
                }
            }
        }
        ret.setStatus(Boolean.TRUE);
        return ret;
    }

    private boolean dataRuleHeaderAssistCheck(Set<String> dimSet, DynamicObjectCollection bizAssistCollection, String assist) {
        boolean assistValid = Boolean.FALSE;
        if (dimSet.contains(assist)) {
            for (DynamicObject dynamicObject : bizAssistCollection) {
                if (!assist.equals(dynamicObject.get("fbasedataid.id"))) continue;
                assistValid = Boolean.TRUE;
                break;
            }
        } else {
            assistValid = Boolean.TRUE;
        }
        return assistValid;
    }

    private ImportCheckResult getSaveCheckUniqueResult() {
        DynamicObject dyScheme;
        ImportCheckResult ret = new ImportCheckResult();
        IDataModel model = this.getModel();
        if ("0".equals(model.getValue("enable"))) {
            ret.setStatus(Boolean.TRUE);
            return ret;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject dyOrg = (DynamicObject)model.getValue("useorg");
        DynamicObject dyBookType = (DynamicObject)model.getValue("booktype");
        if (dyBookType == null) {
            ret.setStatus(Boolean.FALSE);
            ret.setMessage(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"ReconciliationPlanEditPlugin_8", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            return ret;
        }
        DynamicObject dyBizApp = (DynamicObject)model.getValue("bizapp");
        QFilter orgIdFilter = new QFilter("useorg", "=", dyOrg.getPkValue());
        QFilter bookTypeIdFilter = new QFilter("booktype", "=", dyBookType.getPkValue());
        QFilter appIdFilter = new QFilter("bizapp", "=", dyBizApp.getPkValue());
        QFilter billStatusFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter bakFilter = new QFilter("bak", "=", (Object)Boolean.FALSE);
        DynamicObject accountTable = (DynamicObject)model.getValue("accounttable");
        if (accountTable == null) {
            ret.setStatus(Boolean.FALSE);
            ret.setMessage(ResManager.loadKDString((String)"\u79d1\u76ee\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"ReconciliationPlanEditPlugin_15", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            return ret;
        }
        QFilter accountTableFilter = new QFilter("accounttable", "=", accountTable.getPkValue());
        filters.add(orgIdFilter);
        filters.add(bookTypeIdFilter);
        filters.add(appIdFilter);
        filters.add(billStatusFilter);
        filters.add(bakFilter);
        filters.add(accountTableFilter);
        Long id = (Long)model.getValue("id");
        if (id != null && id != 0L) {
            filters.add(new QFilter("id", "!=", (Object)id));
        }
        if ((dyScheme = QueryServiceHelper.queryOne((String)"frm_reconciliation_scheme", (String)"id,name", (QFilter[])filters.toArray(new QFilter[0]))) != null) {
            ret.setStatus(Boolean.FALSE);
            ret.setMessage(String.format(ResManager.loadKDString((String)"[%1$s]\u7684[%2$s]\u7684[%3$s]\u5df2\u5b58\u5728\u5bf9\u8d26\u65b9\u6848[%4$s]\uff0c\u4ec5\u5141\u8bb8\u5efa\u7acb\u4e00\u5957\u542f\u7528\u7684\u5bf9\u8d26\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReconciliationPlanEditPlugin_14", (String)"fi-frm-formplugin", (Object[])new Object[0]), dyOrg.getString("name"), dyBookType.getString("name"), dyBizApp.getString("name"), dyScheme.getString("name")));
            return ret;
        }
        ret.setStatus(Boolean.TRUE);
        return ret;
    }

    private void showAssistDataF7Form(String key) {
        String cacheAssistData = this.getPageCache().get("assist.addListener");
        Map dsFields = (Map)SerializationUtils.deSerializeFromBase64((String)cacheAssistData);
        DSField dsField = (DSField)dsFields.get(key);
        ListShowParameter para = ShowFormHelper.createShowListForm((String)"bos_assistantdata_detail", (boolean)true);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter filter = new QFilter("group", "=", (Object)Long.valueOf(dsField.getEntityId()));
        filters.add(filter);
        ListFilterParameter listFilterParameter = new ListFilterParameter(filters, null);
        para.setListFilterParameter(listFilterParameter);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCaption(dsField.getFieldName().getLocaleValue());
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "assist.callback." + key));
        this.getView().showForm((FormShowParameter)para);
    }
}

