/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.fi.frm.common.model.bizdata.BizReconPlanDetailModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanModel;
import kd.fi.frm.common.util.ReconciliationUtil;

public class ReconciliationPlanEntryF7FormPlugin
extends AbstractFormPlugin
implements CellClickListener {
    public static final String ENTRYID = "entryid";
    public static final String ASSISTTYPE = "assisttype";
    private static final String ACCOUNT = "account";
    private static final String AMOUNTTYPE = "amounttype";
    public static final String BIZASSIST = "bizassist";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel", "btnok"});
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.addCellClickListener((CellClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Button) {
            Button btn = (Button)evt.getSource();
            String itemKey = btn.getKey();
            if ("btnok".equals(itemKey)) {
                AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
                int[] rows = grid.getEntryState().getSelectedRows();
                if (rows != null && rows.length > 0) {
                    this.setReturnData(rows[0]);
                }
            } else if ("btncancel".equals(itemKey)) {
                // empty if block
            }
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    public void cellDoubleClick(CellClickEvent cellclickevent) {
    }

    public void cellClick(CellClickEvent evt) {
        if (evt.getFieldKey().equals(ACCOUNT)) {
            this.setReturnData(evt.getRow());
            this.getView().close();
        }
    }

    private void setReturnData(int rowIndex) {
        Object id = this.getModel().getValue(ENTRYID, rowIndex);
        DynamicObjectCollection accts = (DynamicObjectCollection)this.getModel().getValue(ACCOUNT, rowIndex);
        StringBuilder sb = new StringBuilder();
        for (DynamicObject acct : accts) {
            DynamicObject account = (DynamicObject)acct.get("fbasedataid");
            String number = account == null ? " " : account.getString("number");
            String name = account == null ? " " : account.getString("name");
            sb.append(number);
            sb.append(",");
            sb.append(name);
            sb.append(";");
        }
        DynamicObjectCollection amountTypes = (DynamicObjectCollection)this.getModel().getValue(AMOUNTTYPE, rowIndex);
        StringBuilder amountTypeSb = new StringBuilder();
        for (DynamicObject amountType : amountTypes) {
            DynamicObject baseData = amountType.getDynamicObject("fbasedataid");
            Long amountTypeId = baseData == null ? 0L : baseData.getLong("id");
            amountTypeSb.append(amountTypeId);
            amountTypeSb.append(",");
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        String accountStr = sb.toString();
        if (StringUtils.isEmpty((String)accountStr)) {
            accountStr = ResManager.loadKDString((String)"\u7a7a", (String)"ReconciliationPlanEntryF7FormPlugin_0", (String)"fi-frm-formplugin", (Object[])new Object[0]);
        }
        resultMap.put(ACCOUNT, accountStr);
        resultMap.put("id", id);
        resultMap.put("amountType", amountTypeSb.toString());
        this.getView().returnDataToParent(resultMap);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Long planId = (Long)this.getView().getFormShowParameter().getCustomParam("planId");
        if (planId == null) {
            return;
        }
        BizReconPlanModel planModel = ReconciliationUtil.loadPlanModel((Long)planId);
        List details = planModel.getDetail();
        if (details.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int rowIndex = 0;
        MulBasedataProp accountProp = (MulBasedataProp)model.getEntryEntity("entryentity").getDynamicObjectType().getProperty(ACCOUNT);
        DynamicObjectType accountPropertyType = accountProp.getDynamicCollectionItemPropertyType();
        MulBasedataProp amountTypeProp = (MulBasedataProp)model.getEntryEntity("entryentity").getDynamicObjectType().getProperty(AMOUNTTYPE);
        DynamicObjectType amountTypePropertyType = amountTypeProp.getDynamicCollectionItemPropertyType();
        for (BizReconPlanDetailModel detailModel : details) {
            vs.set(ENTRYID, (Object)detailModel.getId(), rowIndex);
            vs.set(ASSISTTYPE, (Object)detailModel.getAssistType().getValue(), rowIndex);
            DynamicObjectCollection accountCol = new DynamicObjectCollection();
            Set accountIds = detailModel.getAccountIds();
            if (accountIds != null && accountIds.size() > 0) {
                for (Long acctId : accountIds) {
                    DynamicObject instance = (DynamicObject)accountPropertyType.createInstance();
                    instance.set("fbasedataid_id", (Object)acctId);
                    accountCol.add((Object)instance);
                }
            }
            vs.set(ACCOUNT, (Object)accountCol, rowIndex);
            DynamicObjectCollection amountTypeCol = new DynamicObjectCollection();
            List amountTypeList = detailModel.getAmountTypeList();
            if (amountTypeList != null && amountTypeList.size() > 0) {
                for (Long amountType : amountTypeList) {
                    DynamicObject instance = (DynamicObject)amountTypePropertyType.createInstance();
                    instance.set("fbasedataid_id", (Object)amountType);
                    amountTypeCol.add((Object)instance);
                }
            }
            vs.set(AMOUNTTYPE, (Object)amountTypeCol, rowIndex);
            ++rowIndex;
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
    }
}

