/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.frm.common.util.ReconciliationFileUtil;
import kd.fi.frm.common.util.ReconciliationUtil;
import org.apache.commons.io.FilenameUtils;

public class ReconciliationPlanListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(ReconciliationPlanListPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (null != filterContainer) {
            filterContainer.addBeforeF7SelectListener(new BeforeFilterF7SelectListener(){

                public void beforeF7Select(BeforeFilterF7SelectEvent e) {
                    String field = e.getFieldName();
                    if (field.startsWith("bizapp.")) {
                        e.getQfilters().add(new QFilter("id", "in", (Object)ReconciliationUtil.getAppIds()));
                    }
                }
            });
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        if ("bizapp.name".equals(args.getFieldName())) {
            QFilter filter = new QFilter("id", "in", (Object)ReconciliationUtil.getAppIds());
            args.getQFilters().add(filter);
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().getPageCache().put("pageCacheShiftMBtn", "schemeupgrade,useorgrepair");
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("schemeupgrade".equals(key)) {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"frm", (String)"ReconPlanDataRuleIdUpgradeService", (String)"afterExecuteSqlWithResult", (Object[])new Object[]{"", "", "", ""});
        } else if ("useorgrepair".equals(key)) {
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"frm", (String)"SchemeUseOrgUpgradeService", (String)"afterExecuteSqlWithResult", (Object[])new Object[]{"", "", "", ""});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("export".equals(operateKey)) {
            this.export();
        } else if ("import".equals(operateKey)) {
            this.uploadFileAndImport();
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(new QFilter("bak", "=", (Object)false));
    }

    private void uploadFileAndImport() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("frm_recplan_impor");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "import");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("import".equals(closedCallBackEvent.getActionId())) {
            this.doImport((Map)closedCallBackEvent.getReturnData());
        }
    }

    private void doImport(Map<String, Object> importData) {
        if (importData == null) {
            return;
        }
        String importFile = (String)importData.get("files");
        if (StringUtils.isBlank((CharSequence)importFile)) {
            return;
        }
        String[] fieldUrls = StringUtils.split((String)importFile, (String)";");
        Long orgId = (Long)importData.get("org");
        boolean isCover = (Boolean)importData.get("isCover");
        logger.info("\u5bf9\u8d26\u5f15\u5165\u65b9\u5f0f\uff0c\u662f\u5426\u8986\u76d6 = {}", (Object)isCover);
        for (String fileUrl : fieldUrls) {
            Map result = ReconciliationFileUtil.uploadRule((String)fileUrl, (Long)orgId, (boolean)isCover);
            List errMessage = (List)result.get("ERROR");
            if (errMessage != null && errMessage.size() > 0) {
                StringBuilder sbError = new StringBuilder();
                for (String error : errMessage) {
                    sbError.append(error).append('\n');
                }
                this.getView().showConfirm(sbError.toString(), MessageBoxOptions.OK);
                continue;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"ReconciliationPlanListPlugin_0", (String)"fi-frm-formplugin", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export() {
        Map result;
        Object errMessage;
        BillList billList = (BillList)this.getControl("BillListAp");
        ListSelectedRowCollection rowes = billList.getSelectedRows();
        if (rowes == null || rowes.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u65b9\u6848", (String)"ReconciliationPlanListPlugin_1", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> selectIds = new HashSet<Long>();
        for (ListSelectedRow row : rowes) {
            selectIds.add((Long)row.getPrimaryKeyValue());
        }
        String property = System.getProperty("user.home");
        String localPath = property + File.separator + "KINGDEEDOWNLOAD" + File.separator + RequestContext.get().getAccountId() + RequestContext.get().getUserId();
        File file = new File(FilenameUtils.getFullPath((String)localPath), FilenameUtils.getName((String)localPath));
        if (!file.exists()) {
            file.mkdirs();
        }
        if (StringUtils.isNotBlank(errMessage = (result = ReconciliationFileUtil.exportPlan((String)localPath, selectIds)).get("error"))) {
            this.getView().showTipNotification((String)errMessage);
            return;
        }
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(FilenameUtils.getFullPath((String)((String)result.get("fileName"))) + FilenameUtils.getName((String)((String)result.get("fileName")))));
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(selectIds.iterator().next() + ".zip", in, 5000);
            this.getView().openUrl(urls);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        ReconciliationPlanListPlugin.deleteKd(file);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f", (String)"ReconciliationPlanListPlugin_2", (String)"fi-frm-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
    }

    public static void deleteKd(File file) {
        if (!file.delete() && file.isDirectory()) {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                File delfile = fileList[i];
                if (delfile.delete() || !delfile.isDirectory()) continue;
                ReconciliationPlanListPlugin.deleteKd(fileList[i]);
            }
        }
    }
}

