/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.function.DapFunctionTypes;
import kd.fi.frm.common.enums.AssistDataType;
import kd.fi.frm.common.enums.AssistTypeEnum;
import kd.fi.frm.common.enums.ReconAmountTypeEnum;
import kd.fi.frm.common.enums.ReconcilationResultEnum;
import kd.fi.frm.common.model.Expression;
import kd.fi.frm.common.model.FrmLogger;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model.ReturnData;
import kd.fi.frm.common.model.bizdata.BizDataParam;
import kd.fi.frm.common.model.bizdata.BizDataSourceConfig;
import kd.fi.frm.common.model.bizdata.BizReconPlanDetailModel;
import kd.fi.frm.common.model.bizdata.BizReconPlanModel;
import kd.fi.frm.common.util.DateUtil;
import kd.fi.frm.common.util.EntityFieldTreeOption;
import kd.fi.frm.common.util.EntityFieldTreeResult;
import kd.fi.frm.common.util.EntityTreeUtil;
import kd.fi.frm.common.util.ExpressionType;
import kd.fi.frm.common.util.RecAccountBookResult;
import kd.fi.frm.common.util.RecAccountBookUtil;
import kd.fi.frm.common.util.ReconciliationParmUtil;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.mservice.AssistMappingUtil;
import kd.fi.frm.mservice.bizdata.BizDataService;
import kd.fi.frm.mservice.bizdata.BizDataServicePreviewHandler;
import kd.fi.frm.mservice.bizdata.CommonFilterAnalyseUtil;
import kd.fi.frm.mservice.bizdata.ext.custom.AbstractCustomParamService;
import kd.fi.frm.mservice.bizdata.ext.custom.CustomParamUtil;

public class ReconciliationPreviewFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String DATA_FILTER_DESC = "datafilterdesc";
    private static final String DATA_FILTER = "datafilter";
    private static final String DIFF_DATA_FILTER_DESC = "diffdatafilterdesc";
    private static final String DIFF_DATA_FILTER = "diffdatafilter";
    private static final String PLAN_ENTRY_DESC = "planentrydesc";
    private static final String PLAN_ENTRY = "planentry";
    public static final String AMOUNT_DESC = "amountdesc";
    public static final String AMOUNT = "amount";
    private static final String BIZ_OBJ = "bizobj";
    private static final String TABLE_KEY_ENTRYENTITY = "entryentity";
    private static final String FSEQ_NAME = "fseq";
    private static final int PAGE_ROW = 50;
    public static final String KEY_ORG = "org";
    private static final String KEY_BOOKTYPE = "booktype";
    private static final String KEY_PERIODTYPE = "periodtype";
    public static final String KEY_CURRENCY = "currency";
    public static final String KEY_PERIOD = "period";
    private static final String KEY_APP = "bizapp";
    private static final String ENTITY_GL_ACCOUNTBOOK = "gl_accountbook";
    public static final String MODEL = "model";
    private static final String EXPR_DATE_REGEX = "DATE\\('(.+?)'\\)";
    private static final Pattern EXPR_DATE_PATTERN = Pattern.compile("DATE\\('(.+?)'\\)");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{DATA_FILTER_DESC, DIFF_DATA_FILTER_DESC, PLAN_ENTRY_DESC});
        BasedataEdit periodF7 = (BasedataEdit)this.getView().getControl(KEY_PERIOD);
        periodF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit booktype = (BasedataEdit)this.getView().getControl(KEY_BOOKTYPE);
        booktype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String itemKey = e.getOperateKey();
        if ("bar_queryall".equals(itemKey)) {
            this.exec(null);
        } else if ("bar_analyzediff".equals(itemKey)) {
            this.selectBills();
        }
    }

    private void selectBills() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityName = (String)formShowParameter.getCustomParam(BIZ_OBJ);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        if (ObjectUtils.isEmpty((Object)this.getModel().getValue(DIFF_DATA_FILTER_DESC))) {
            this.getModel().setValue("diffdatafilter_tag", null);
        }
        QFilter billFilter = null;
        String exp = (String)this.getModel().getValue("diffdatafilter_tag");
        if (!StringUtils.isEmpty((CharSequence)exp)) {
            String expression;
            CRCondition cdb = (CRCondition)SerializationUtils.fromJsonString((String)exp, CRCondition.class);
            FilterCondition filterCondition = cdb.getFilterCondition();
            List rows = filterCondition.getFilterRow();
            if (rows != null) {
                String fieldName = null;
                IDataEntityProperty prop = null;
                for (SimpleFilterRow each : rows) {
                    if (each == null) continue;
                    fieldName = each.getFieldName();
                    String[] names = fieldName.split("\\.");
                    prop = mainEntityType.findProperty(fieldName = names[0]);
                    if (prop == null) continue;
                    fieldName = CommonFilterAnalyseUtil.getFieldName((IDataEntityType)prop.getParent(), (String)mainEntityType.getName(), (String)fieldName);
                    StringBuilder fieldNameBuilder = new StringBuilder(fieldName);
                    for (int i = 1; i < names.length; ++i) {
                        fieldNameBuilder.append('.');
                        fieldNameBuilder.append(names[i]);
                    }
                    each.setFieldName(fieldNameBuilder.toString());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(expression = cdb.buildFullFormula(mainEntityType)))) {
                DynamicObject app = (DynamicObject)this.getModel().getValue(KEY_APP);
                BizDataParam bizDataParam = new BizDataParam();
                bizDataParam.setEntityKey(entityName);
                bizDataParam.setAppNumber(app.getString("number"));
                expression = (String)CommonFilterAnalyseUtil.dealLeafFormular(null, (String)expression, (BizDataParam)bizDataParam, (boolean)false, (String)"0", (String)"0", (int)2000, (boolean)false, (ReconciliationParamModel)this.getParamModel()).get(0);
                if (StringUtils.isNotBlank((CharSequence)expression)) {
                    billFilter = this.dealConFormular(expression);
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5dee\u5f02\u5206\u6790\u8fc7\u6ee4\u3002", (String)"ReconciliationPreviewFormPlugin_16", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.exec(billFilter);
    }

    public void click(EventObject evt) {
        String key;
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "datafilterdesc": {
                this.showConditionForm(DATA_FILTER);
                break;
            }
            case "diffdatafilterdesc": {
                this.showConditionForm(DIFF_DATA_FILTER);
                break;
            }
            case "planentrydesc": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("frm_recon_planentry");
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
                showParameter.setCustomParam("planId", this.getModel().getValue("execplan_id"));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
            }
        }
    }

    private void showConditionForm(String key) {
        if (ObjectUtils.isEmpty((Object)this.getModel().getValue(key + "desc"))) {
            this.getModel().setValue(key + "_tag", null);
        }
        String conditionJson = (String)this.getModel().getValue(key + "_TAG");
        String entityName = (String)this.getView().getFormShowParameter().getCustomParam(BIZ_OBJ);
        BillEntityType billEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityName);
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        option.setEntityType((IDataEntityType)billEntityType);
        option.setReadEntryEntity(false);
        option.setExprType(ExpressionType.Condition);
        option.setFieldType(null);
        EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
        TreeNode rootNode = new TreeNode("", "root", "");
        TreeNode conPeriodNode = new TreeNode("String", "con_period", ResManager.loadKDString((String)"\u5bf9\u8d26\u671f\u95f4", (String)"ReconciliationPreviewFormPlugin_6", (String)"fi-frm-formplugin", (Object[])new Object[0]));
        TreeNode conPeriodStart = new TreeNode("String", "con_startdate", ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f", (String)"ReconciliationPreviewFormPlugin_7", (String)"fi-frm-formplugin", (Object[])new Object[0]));
        TreeNode conPeriodEnd = new TreeNode("String", "con_enddata", ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f", (String)"ReconciliationPreviewFormPlugin_8", (String)"fi-frm-formplugin", (Object[])new Object[0]));
        TreeNode conPeriodYear = new TreeNode("String", "con_period_year", ResManager.loadKDString((String)"\u4f1a\u8ba1\u5e74\u5ea6", (String)"ReconciliationPreviewFormPlugin_9", (String)"fi-frm-formplugin", (Object[])new Object[0]));
        TreeNode conPeriodMonth = new TreeNode("String", "con_period_number", ResManager.loadKDString((String)"\u671f\u95f4\u6570", (String)"ReconciliationPreviewFormPlugin_10", (String)"fi-frm-formplugin", (Object[])new Object[0]));
        TreeNode prePeriodEndDate = new TreeNode("String", "con_preperiod_enddate", ResManager.loadKDString((String)"\u4e0a\u4e00\u671f\u95f4\u6700\u540e\u4e00\u5929", (String)"ReconciliationPreviewFormPlugin_5", (String)"fi-frm-formplugin", (Object[])new Object[0]));
        conPeriodNode.addChild(conPeriodStart);
        conPeriodNode.addChild(conPeriodEnd);
        conPeriodNode.addChild(conPeriodYear);
        conPeriodNode.addChild(conPeriodMonth);
        conPeriodNode.addChild(prePeriodEndDate);
        rootNode.addChild(conPeriodNode);
        TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
        rootNode.addChild(tree);
        rootNode.setIsOpened(true);
        result.getNonFields().add("root");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("frm_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("functiontypes", conditionJson);
        String srcFormNumber = (String)this.getView().getFormShowParameter().getCustomParam(BIZ_OBJ);
        showParameter.getCustomParams().put("entitynumber", srcFormNumber);
        String fieldNodes = SerializationUtils.toJsonString((Object)rootNode);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.getCustomParams().put("treeViewRootVisible", Boolean.FALSE);
        showParameter.setCustomParam("nonFields", (Object)SerializationUtils.toJsonString((Object)result.getNonFields()));
        String funcsXML = this.getPageCache().get("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML)) {
            FunctionTypes functionTypes = DapFunctionTypes.get();
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (DATA_FILTER.equals(e.getActionId())) {
            this.receiveExpressionSet(e, DATA_FILTER, DATA_FILTER_DESC, 0);
        } else if (DIFF_DATA_FILTER.equals(e.getActionId())) {
            this.receiveExpressionSet(e, DIFF_DATA_FILTER, DIFF_DATA_FILTER_DESC, 0);
        } else if (PLAN_ENTRY_DESC.equals(e.getActionId())) {
            Map strMap = (Map)e.getReturnData();
            if (strMap == null) {
                return;
            }
            Object amountTypes = strMap.get("amountType");
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object amttype = formShowParameter.getCustomParam("amttype");
            if (!String.valueOf(amountTypes).contains(String.valueOf(amttype))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u65b9\u6848\u5206\u5f55\u7684\u53d6\u6570\u7c7b\u578b\u4e0e\u9884\u89c8\u7684\u53d6\u6570\u89c4\u5219\u7684\u53d6\u6570\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ReconciliationPreviewFormPlugin_17", (String)"fi-frm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue(PLAN_ENTRY_DESC, strMap.get("account"));
            this.getModel().setValue(PLAN_ENTRY, strMap.get("id"));
            this.getView().updateView(PLAN_ENTRY_DESC);
            this.getView().updateView(PLAN_ENTRY);
        }
    }

    private List<Date> handleExprContainsDate(String expr) {
        Matcher m = EXPR_DATE_PATTERN.matcher(expr);
        ArrayList<Date> dateLst = new ArrayList<Date>();
        SimpleDateFormat dFormat_short = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dFormat_long = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (m.find()) {
            try {
                dateLst.add(dFormat_short.parse(m.group(1)));
            }
            catch (ParseException parseException) {
                try {
                    dateLst.add(dFormat_long.parse(m.group(1)));
                }
                catch (ParseException parseException2) {
                    throw new KDBizException((Throwable)parseException2, new ErrorCode(String.valueOf(ReconcilationResultEnum.error.getIndex()), parseException2.getMessage()), new Object[0]);
                }
            }
        }
        return dateLst;
    }

    private QFilter dealConFormular(String expr) {
        List<Date> dateLst;
        QFilter filter = null;
        DynamicObject period = (DynamicObject)this.getModel().getValue(KEY_PERIOD);
        if (expr.indexOf("con_period_year") > -1) {
            expr = expr.replaceAll("con_period_year", period.getString("periodyear"));
        }
        if (expr.indexOf("con_period_number") > -1) {
            expr = expr.replaceAll("con_period_number", period.getString("periodnumber"));
        }
        if (expr.indexOf("con_period") > -1) {
            expr = expr.replaceAll("con_period", period.getString("id"));
        }
        HashMap<String, Date> dateMap = new HashMap<String, Date>();
        dateMap.put("con_startdate", period.getDate("begindate"));
        dateMap.put("con_enddata", period.getDate("enddate"));
        dateMap.put("con_preperiod_enddate", DateUtil.addDay((Date)period.getDate("begindate"), (int)-1));
        List<Date> dateValues = this.buildDateParams(expr, dateMap);
        if (!dateValues.isEmpty()) {
            for (String key : dateMap.keySet()) {
                expr = expr.replace(key, "?");
            }
        }
        if (!(dateLst = this.handleExprContainsDate(expr)).isEmpty()) {
            String[] split = expr.split(EXPR_DATE_REGEX);
            int index = 0;
            for (int i = 0; i < dateLst.size(); ++i) {
                int count = split[i].split("\\?").length - 1;
                dateValues.add(index + count, dateLst.get(i));
                index += count + 1;
            }
            expr = expr.replaceAll(EXPR_DATE_REGEX, "?");
        }
        filter = dateValues.isEmpty() ? QFilter.of((String)expr, (Object[])new Object[0]) : QFilter.of((String)expr, (Object[])dateValues.toArray());
        return filter;
    }

    private List<Date> buildDateParams(String exp, Map<String, Date> dateMap) {
        ArrayList<Date> result = new ArrayList<Date>();
        while (!exp.isEmpty()) {
            String firstOccurKey = null;
            int firstOccurIndex = exp.length() - 1;
            for (String key : dateMap.keySet()) {
                int index = exp.indexOf(key);
                if (index < 0 || index >= firstOccurIndex) continue;
                firstOccurIndex = index;
                firstOccurKey = key;
            }
            if (firstOccurKey == null) break;
            result.add(dateMap.get(firstOccurKey));
            int nextBeginIndex = firstOccurIndex + firstOccurKey.length();
            if (nextBeginIndex >= exp.length()) break;
            exp = exp.substring(nextBeginIndex);
        }
        return result;
    }

    private void receiveExpressionSet(ClosedCallBackEvent closedCallBackEvent, String expressionFldKey, String descFldKey, int type) {
        if (closedCallBackEvent.getReturnData() != null) {
            String str = (String)closedCallBackEvent.getReturnData();
            if (StringUtils.isBlank((CharSequence)str)) {
                this.getModel().setValue(expressionFldKey + "_TAG", (Object)"");
                this.getModel().setValue(descFldKey, (Object)"");
            } else {
                ReturnData filter = (ReturnData)SerializationUtils.fromJsonString((String)str, ReturnData.class);
                Expression filterObj = (Expression)SerializationUtils.fromJsonString((String)filter.getDataStr(), Expression.class);
                if (type == 1) {
                    this.getModel().setValue(expressionFldKey + "_TAG", (Object)filterObj.getExpression());
                } else {
                    this.getModel().setValue(expressionFldKey + "_TAG", (Object)filter.getDataStr());
                }
                String desp = filterObj.getDescription().toString();
                desp = StringUtils.isNotEmpty((CharSequence)filterObj.getExprTran().trim()) ? filterObj.getExprTran() : "";
                if (desp.length() > 1000) {
                    desp = desp.substring(0, 999);
                }
                this.getModel().setValue(descFldKey, (Object)desp);
            }
        }
    }

    private void exec(QFilter diffFilter) {
        try {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long planDetailId = (Long)this.getModel().getValue(PLAN_ENTRY);
            long ruleEntryId = (Long)formShowParameter.getCustomParam("ruleEntryId");
            ReconciliationParamModel paramModel = this.getParamModel();
            DynamicObject org = (DynamicObject)this.getModel().getValue(KEY_ORG);
            DynamicObject period = (DynamicObject)this.getModel().getValue(KEY_PERIOD);
            DynamicObject bookType = (DynamicObject)this.getModel().getValue(KEY_BOOKTYPE);
            DynamicObject app = (DynamicObject)this.getModel().getValue(KEY_APP);
            HashSet<Long> orgIds = new HashSet<Long>();
            orgIds.add(org.getLong("id"));
            HashSet<String> appIds = new HashSet<String>();
            appIds.add(app.getString("id"));
            paramModel.setOrgIds(orgIds);
            paramModel.setPeriodId(Long.valueOf(period.getLong("id")));
            paramModel.setBookTypeId(Long.valueOf(bookType.getLong("id")));
            paramModel.setAppIds(appIds);
            paramModel.setPreviewMode(true);
            Long orgId = paramModel.getOrgIds().toArray(new Long[0])[0];
            String appId = paramModel.getAppIds().toArray(new String[0])[0];
            ReconciliationUtil.initFrmLoggerCache((FrmLogger)paramModel.getFrmLogger());
            BizReconPlanModel planModel = ReconciliationUtil.getPlanModel((Long)paramModel.getBookTypeId(), (Long)orgId, (String)appId, (Long)paramModel.getPeriodId(), (Long)planDetailId);
            if (planModel == null) {
                throw new _PreviewException(ResManager.loadKDString((String)"\u6839\u636e\u6838\u7b97\u7ec4\u7ec7\u83b7\u53d6\u7684\u53d6\u6570\u89c4\u5219\u4e0d\u5305\u542b\u9884\u89c8\u9009\u62e9\u7684\u53d6\u6570\u89c4\u5219\u3002", (String)"ReconciliationPreviewFormPlugin_11", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            }
            DynamicObject dataRule = ReconciliationUtil.getDataRule((Long)planModel.getRuleId(), (ReconAmountTypeEnum)planModel.getReconAmountType());
            Optional<DynamicObject> entityOpt = dataRule.getDynamicObjectCollection(TABLE_KEY_ENTRYENTITY).stream().filter(r -> (Long)r.getPkValue() == ruleEntryId).findFirst();
            if (Optional.empty().equals(entityOpt)) {
                throw new _PreviewException(ResManager.loadKDString((String)"\u6839\u636e\u6838\u7b97\u7ec4\u7ec7\u83b7\u53d6\u7684\u53d6\u6570\u89c4\u5219\u4e0d\u5305\u542b\u9884\u89c8\u9009\u62e9\u7684\u53d6\u6570\u89c4\u5219\u3002", (String)"ReconciliationPreviewFormPlugin_11", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            }
            DynamicObject ruleEntry = entityOpt.get();
            long commonfilterId = ruleEntry.getLong("commonfilter_id");
            dataRule.getDynamicObjectCollection(TABLE_KEY_ENTRYENTITY).removeIf(v -> (Long)v.getPkValue() != ruleEntryId);
            if (dataRule.getDynamicObjectCollection(TABLE_KEY_ENTRYENTITY).isEmpty()) {
                throw new _PreviewException(ResManager.loadKDString((String)"\u6839\u636e\u6838\u7b97\u7ec4\u7ec7\u83b7\u53d6\u7684\u53d6\u6570\u89c4\u5219\u4e0d\u5305\u542b\u9884\u89c8\u9009\u62e9\u7684\u53d6\u6570\u89c4\u5219\u3002", (String)"ReconciliationPreviewFormPlugin_11", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            }
            BizReconPlanDetailModel detail = ReconciliationUtil.getDetailModel((BizReconPlanModel)planModel, (Long)planDetailId);
            ReconciliationUtil.planDetailAssist((BizReconPlanDetailModel)detail, (Long)orgId);
            CustomParamUtil.setCustomParam((ReconciliationParamModel)paramModel, (DynamicObject)dataRule);
            AbstractCustomParamService customParamService = CustomParamUtil.paramConversion((ReconciliationParamModel)paramModel, (BizReconPlanDetailModel)detail, (Long)orgId);
            List bizDataParams = ReconciliationParmUtil.getDataRuleParam((BizReconPlanDetailModel)detail, (DynamicObject)dataRule, (List)detail.getAmountTypeList(), (ReconciliationParamModel)paramModel, (Long)orgId, (ReconAmountTypeEnum)planModel.getReconAmountType());
            bizDataParams = bizDataParams.stream().filter(bizDataParam -> bizDataParam.getSourceConfig().getRuleEntryId() == ruleEntryId).collect(Collectors.toList());
            if (bizDataParams.isEmpty() || ((BizDataParam)bizDataParams.get(0)).getSourceConfig() == null) {
                throw new _PreviewException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5185\u90e8\u9519\u8bef\uff1a\u83b7\u53d6BizDataParam\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReconciliationPreviewFormPlugin_13", (String)"fi-frm-formplugin", (Object[])new Object[0]), 1);
            }
            CustomParamUtil.setCustomParam((ReconciliationParamModel)paramModel, (DynamicObject)dataRule);
            CustomParamUtil.paramConversion((ReconciliationParamModel)paramModel, (BizReconPlanDetailModel)detail, (Long)orgId);
            BizDataParam bizDataParam2 = (BizDataParam)bizDataParams.get(0);
            BizDataSourceConfig sourceConfig = bizDataParam2.getSourceConfig();
            String exp = (String)this.getModel().getValue("datafilter_tag");
            CRCondition cdb = null;
            cdb = StringUtils.isEmpty((CharSequence)exp) ? new CRCondition() : (CRCondition)SerializationUtils.fromJsonString((String)exp, CRCondition.class);
            sourceConfig.setBillFilter(cdb);
            DynamicObject reconCommonFilter = BusinessDataServiceHelper.loadSingleFromCache((Object)commonfilterId, (String)"frm_rec_common_filter");
            ReconciliationParmUtil.buildDimsAndItemClassPropFilter((BizReconPlanDetailModel)detail, (ReconciliationParamModel)paramModel, (BizDataParam)bizDataParam2, (DynamicObject)reconCommonFilter);
            bizDataParam2.setAcctOrgID(orgId.longValue());
            String entityName = (String)formShowParameter.getCustomParam(BIZ_OBJ);
            String amountExpr = (String)formShowParameter.getCustomParam(AMOUNT);
            BizDataServicePreviewHandler previewHandler = new BizDataServicePreviewHandler(entityName, amountExpr);
            previewHandler.setDiffFilter(diffFilter);
            previewHandler.setQueryTop(((Integer)this.getModel().getValue("querytop")).intValue());
            if (paramModel.getBizOrgIds().size() == 0) {
                RecAccountBookResult accountBookResultFromFrm = RecAccountBookUtil.getAccountBookResultFromFRM((String)((DynamicObject)this.getModel().getValue(KEY_APP)).getString("number"), (Long)orgId, (Long)paramModel.getBookTypeId(), (boolean)false);
                if (accountBookResultFromFrm.getBizIds().size() > 0) {
                    paramModel.setBizOrgIds(accountBookResultFromFrm.getBizIds());
                } else {
                    paramModel.getBizOrgIds().add(orgId);
                }
            }
            paramModel.setPeriodId((Long)this.getModel().getValue("period_id"));
            BizDataService bizDataService = new BizDataService(bizDataParam2, paramModel);
            bizDataService.setCustomParamService(customParamService);
            List bizAssistIdSetMapList = new ArrayList(8);
            if (AssistTypeEnum.Acct == detail.getAssistType()) {
                bizAssistIdSetMapList = AssistMappingUtil.acctBizFilterToBizAssistMap((List)detail.getBizFilterAssistMapList());
                bizDataParam2.setBizAssistIdSetMapList(bizAssistIdSetMapList);
            } else {
                String bizAssist = (String)formShowParameter.getCustomParam("bizassist");
                if (StringUtils.isNotEmpty((CharSequence)bizAssist)) {
                    List bizAssistTable = (List)SerializationUtils.fromJsonString((String)bizAssist, List.class);
                    List head = (List)bizAssistTable.get(0);
                    boolean needJoinAssistGroup = bizAssistTable.size() > 2 && head.size() > 1;
                    HashMap<String, Set> assistMap = new HashMap<String, Set>(head.size());
                    for (int i = 1; i < bizAssistTable.size(); ++i) {
                        List bodyRow = (List)bizAssistTable.get(i);
                        for (int j = 0; j < bodyRow.size(); ++j) {
                            Set masterIdSet = assistMap.computeIfAbsent(head.get(j).toString(), coll -> new HashSet());
                            masterIdSet.add(Long.valueOf(bodyRow.get(j).toString()));
                        }
                    }
                    if (needJoinAssistGroup) {
                        ArrayList<Field> rowMetaField = new ArrayList<Field>(head.size());
                        ArrayList<String> orgSelectFields = new ArrayList<String>(10);
                        for (Object dimKey : head) {
                            String fieldkey = "f" + dimKey.toString().replace(".", "_") + "_mid";
                            rowMetaField.add(new Field(fieldkey, (DataType)DataType.LongType));
                            orgSelectFields.add(fieldkey);
                        }
                        RowMeta rowMeta = new RowMeta(rowMetaField.toArray(new Field[0]));
                        DataSetBuilder builder = Algo.create((String)"frm_preview_assistgroup").createDataSetBuilder(rowMeta);
                        for (int i = 1; i < bizAssistTable.size(); ++i) {
                            List bodyRow = (List)bizAssistTable.get(i);
                            Object[] valArray = bodyRow.stream().map(id -> Long.valueOf(id.toString())).toArray();
                            builder.append(valArray);
                        }
                        DataSet assistMasterDataSet = builder.build();
                        for (Object dimKey : head) {
                            String fieldkey = "f" + dimKey.toString().replace(".", "_");
                            String[] entitySplit = dimKey.toString().split("\\.");
                            String entityId = "";
                            entityId = AssistDataType.isBaseDataType((String)entitySplit[0]) ? entitySplit[1] : "bos_assistantdata_detail";
                            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"frm_preview_assistgroup", (String)entityId, (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("masterid", "in", assistMap.get(dimKey.toString()))}, (String)"");
                            assistMasterDataSet = assistMasterDataSet.join(dataSet).on(fieldkey + "_mid", "masterid").select(orgSelectFields.toArray(new String[0]), new String[]{"id " + fieldkey + "_id"}).finish();
                            orgSelectFields.add(fieldkey + "_id");
                        }
                        bizDataService.registerFilterByAssistGroup(assistMasterDataSet);
                    }
                    HashMap assistQueryMap = new HashMap(8);
                    String assist = (String)formShowParameter.getCustomParam("assist");
                    boolean needQuery = AssistMappingUtil.getAssistQueryMap((Long)orgId, (Map)detail.getAssistDataMapping(), (String)bizAssist, (String)assist, (List)bizDataParam2.getBizAssistIdSetMapList(), assistQueryMap);
                    bizAssistIdSetMapList.add(assistQueryMap);
                    bizDataParam2.setBizAssistIdSetMapList(bizAssistIdSetMapList);
                    bizDataParam2.setNeedQueryBiz(needQuery);
                }
            }
            bizDataService.preview(previewHandler);
            List columnLst = previewHandler.getColumns();
            this.createGrid(columnLst);
            this.setGridData(columnLst, previewHandler.getDataLst());
            StringBuilder explainFilter = new StringBuilder();
            List allExecFilters = previewHandler.getAllExecFilters();
            for (int i = 1; i <= allExecFilters.size(); ++i) {
                QFilter[] originalFilter = (QFilter[])allExecFilters.get(i - 1);
                QFilter perFilter = null;
                for (QFilter qFilter : originalFilter) {
                    perFilter = perFilter == null ? qFilter.copy() : perFilter.and(qFilter);
                }
                if (perFilter == null) continue;
                if (i == allExecFilters.size()) {
                    explainFilter.append("(").append(this.tranExpression(perFilter.toString())).append(") ");
                    continue;
                }
                explainFilter.append("(").append(this.tranExpression(perFilter.toString())).append(") OR\n");
            }
            this.getModel().setValue("recfilterdesc", (Object)explainFilter.toString());
        }
        catch (_PreviewException e) {
            if (e.getType() == 1) {
                this.getView().showErrorNotification(e.getMessage());
            } else {
                this.getView().showTipNotification(e.getMessage());
            }
        }
        catch (ParseException e) {
            this.getView().showTipNotification(e.getMessage());
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Object dataFilterTag = this.getModel().getValue("datafilter_tag");
        Object dataFilterDesc = this.getModel().getValue(DATA_FILTER_DESC);
        Object ruleEntryId = this.getView().getFormShowParameter().getCustomParam("ruleEntryId");
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("dataFilterTag", dataFilterTag);
        ret.put("dataFilterDesc", dataFilterDesc);
        ret.put("ruleEntryId", ruleEntryId);
        this.getView().returnDataToParent(ret);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long curOrgId = RequestContext.get().getOrgId();
        this.getModel().setValue(KEY_ORG, (Object)curOrgId);
        this.orgChanged();
    }

    public void beforeBindData(EventObject e) {
        ReconciliationParamModel paramModel = null;
        String param = (String)this.getView().getFormShowParameter().getCustomParam(MODEL);
        if (StringUtils.isEmpty((CharSequence)param)) {
            paramModel = new ReconciliationParamModel();
            this.getView().getPageCache().put(MODEL, SerializationUtils.toJsonString((Object)paramModel));
            this.getModel().setValue(KEY_APP, this.getView().getFormShowParameter().getCustomParam(KEY_APP));
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_CURRENCY});
        } else {
            paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
            this.getView().getPageCache().put(MODEL, param);
            String appId = paramModel.getAppIds().toArray(new String[0])[0];
            Long orgId = paramModel.getOrgIds().toArray(new Long[0])[0];
            Long bookTypeId = paramModel.getBookTypeId();
            Long periodId = paramModel.getPeriodId();
            this.getModel().setValue(KEY_APP, (Object)appId);
            this.getModel().setValue(KEY_ORG, (Object)orgId);
            this.getModel().setValue(KEY_BOOKTYPE, (Object)bookTypeId);
            this.getModel().setValue(KEY_PERIOD, (Object)periodId);
            this.getModel().setValue(KEY_CURRENCY, (Object)paramModel.getCurrency());
            this.getView().setEnable(Boolean.FALSE, new String[]{KEY_ORG, KEY_BOOKTYPE, KEY_PERIOD, PLAN_ENTRY_DESC, KEY_CURRENCY});
        }
        this.getModel().setValue("datafilter_TAG", this.getView().getFormShowParameter().getCustomParam(DATA_FILTER));
        this.getModel().setValue(DATA_FILTER_DESC, this.getView().getFormShowParameter().getCustomParam(DATA_FILTER_DESC));
        this.getModel().setValue(AMOUNT_DESC, this.getView().getFormShowParameter().getCustomParam(AMOUNT_DESC));
        Long planId = (Long)this.getView().getFormShowParameter().getCustomParam("planId");
        this.getModel().setValue("execplan", (Object)planId);
        this.getModel().setValue(PLAN_ENTRY, this.getView().getFormShowParameter().getCustomParam("planDetailId"));
        Object account = this.getView().getFormShowParameter().getCustomParam("account");
        if (account != null) {
            String accountStr = String.valueOf(account);
            if (StringUtils.isEmpty((CharSequence)accountStr)) {
                accountStr = ResManager.loadKDString((String)"\u7a7a", (String)"ReconciliationPlanEntryF7FormPlugin_0", (String)"fi-frm-formplugin", (Object[])new Object[0]);
            }
            this.getModel().setValue(PLAN_ENTRY_DESC, (Object)accountStr);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        int rowIndex = this.getModel().getEntryCurrentRowIndex(TABLE_KEY_ENTRYENTITY);
        if (KEY_ORG.equals(key)) {
            this.orgChanged();
        } else if (KEY_BOOKTYPE.equals(key)) {
            QFilter statusFilter;
            QFilter bookTypeIdFilter = new QFilter("bookstype", "=", this.getModel().getValue("booktype_id"));
            String acctorgSelectFields = "periodtype.id, curperiod.id, basecurrency.id, startperiod.id";
            QFilter idFilter = new QFilter(KEY_ORG, "=", this.getModel().getValue("org_id"));
            DynamicObjectCollection acctBooks = QueryServiceHelper.query((String)ENTITY_GL_ACCOUNTBOOK, (String)acctorgSelectFields, (QFilter[])new QFilter[]{idFilter, statusFilter = new QFilter("enable", "=", (Object)"1"), bookTypeIdFilter});
            if (acctBooks.size() == 0) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_PERIODTYPE, KEY_PERIOD});
            } else if (acctBooks.size() == 1) {
                DynamicObject acctBook = (DynamicObject)acctBooks.get(0);
                this.getModel().setValue(KEY_PERIODTYPE, (Object)acctBook.getLong("periodtype.id"));
                this.getModel().setValue(KEY_PERIOD, (Object)acctBook.getLong("curperiod.id"));
                this.getModel().setValue(KEY_CURRENCY, (Object)acctBook.getLong("basecurrency.id"));
                this.getModel().setValue("startperiod", (Object)acctBook.getLong("startperiod.id"));
                this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_PERIODTYPE, KEY_PERIOD});
            }
            this.getView().setEnable(Boolean.valueOf(true), new String[]{KEY_PERIOD});
        } else if (DATA_FILTER_DESC.equals(key) && StringUtils.isBlank((Object)(changeData = e.getChangeSet()[0]).getNewValue())) {
            this.getModel().setValue(DATA_FILTER, null);
            this.getModel().setValue("datafilter_tag", null);
        }
    }

    private void orgChanged() {
        QFilter idFilter = new QFilter(KEY_ORG, "=", this.getModel().getValue("org_id"));
        QFilter statusFilter = new QFilter("enable", "=", (Object)"1");
        String acctorgSelectFields = "bookstype.id, periodtype.id, curperiod.id, basecurrency.id, startperiod.id";
        DynamicObjectCollection acctBooks = QueryServiceHelper.query((String)ENTITY_GL_ACCOUNTBOOK, (String)acctorgSelectFields, (QFilter[])new QFilter[]{idFilter, statusFilter});
        if (acctBooks.size() == 0) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_BOOKTYPE, KEY_PERIODTYPE, KEY_PERIOD});
        } else if (acctBooks.size() == 1) {
            DynamicObject acctBook = (DynamicObject)acctBooks.get(0);
            this.getModel().setValue(KEY_BOOKTYPE, (Object)acctBook.getLong("bookstype.id"));
            this.getModel().setValue(KEY_PERIODTYPE, (Object)acctBook.getLong("periodtype.id"));
            this.getModel().setValue(KEY_PERIOD, (Object)acctBook.getLong("curperiod.id"));
            this.getModel().setValue(KEY_CURRENCY, (Object)acctBook.getLong("basecurrency.id"));
            this.getModel().setValue("startperiod", (Object)acctBook.getLong("startperiod.id"));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_BOOKTYPE, KEY_PERIODTYPE, KEY_PERIOD});
        } else {
            HashSet bookTypeIds = new HashSet();
            acctBooks.forEach(book -> bookTypeIds.add(book.getLong("bookstype.id")));
            this.getView().getPageCache().put(KEY_PERIODTYPE, SerializationUtils.serializeToBase64(bookTypeIds));
            this.getView().setEnable(Boolean.valueOf(true), new String[]{KEY_BOOKTYPE});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_PERIODTYPE, KEY_PERIOD});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Object typeId;
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)KEY_BOOKTYPE)) {
            Set ids;
            String cacheStr = this.getView().getPageCache().get(KEY_PERIODTYPE);
            if (kd.bos.util.StringUtils.isNotEmpty((String)cacheStr) && (ids = (Set)SerializationUtils.deSerializeFromBase64((String)cacheStr)).size() > 0) {
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
                listFilterParameter.setFilter(new QFilter("id", "in", (Object)ids));
            }
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)KEY_PERIOD) && (typeId = this.getModel().getValue("periodtype_id")) != null) {
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
            Object startPeriodId = this.getModel().getValue("startperiod_id");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            if (startPeriodId != null) {
                qFilters.add(new QFilter("id", ">=", startPeriodId));
            }
            qFilters.add(new QFilter(KEY_PERIODTYPE, "=", typeId));
            listFilterParameter.getQFilters().addAll(qFilters);
        }
    }

    private String tranExpression(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        String expressionDesc = expression;
        String[] vars = new String[]{};
        vars = FormulaEngine.extractVariables((String)expression);
        if (vars.length == 0 || StringUtils.isBlank((CharSequence)vars[0])) {
            return expressionDesc;
        }
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        String entityName = (String)this.getView().getFormShowParameter().getCustomParam(BIZ_OBJ);
        MainEntityType srcMainET = EntityMetadataCache.getDataEntityType((String)entityName);
        option.setEntityType((IDataEntityType)srcMainET);
        option.setReadEntryEntity(true);
        option.setExprType(ExpressionType.Condition);
        option.setFieldType(null);
        EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes((EntityFieldTreeOption)option);
        TreeNode rootNode = new TreeNode("", "root", "");
        TreeNode tree = EntityTreeUtil.buildBillTree((List)result.getNodes());
        rootNode.addChild(tree);
        ArrayList<String> orderVars = new ArrayList<String>(10);
        for (String string : vars) {
            orderVars.add(string);
        }
        orderVars.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() > o2.length()) {
                    return -1;
                }
                if (o1.length() < o2.length()) {
                    return 1;
                }
                return o2.compareTo(o1);
            }
        });
        HashMap<String, String> tmpVariables = new HashMap<String, String>(16);
        int i = 1;
        for (String string : orderVars) {
            String tempVariable = String.format("###%s###", String.valueOf(i));
            String varCaption = string;
            TreeNode node = rootNode.getTreeNode(string, 5);
            if (node != null) {
                varCaption = node.getText();
            }
            tmpVariables.put(tempVariable, varCaption);
            expressionDesc = expressionDesc.replace(string, tempVariable);
            ++i;
        }
        for (Map.Entry entry : tmpVariables.entrySet()) {
            expressionDesc = expressionDesc.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return expressionDesc;
    }

    private void createGrid(List<BizDataServicePreviewHandler.Column> colNames) {
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("key", TABLE_KEY_ENTRYENTITY);
        meta.put("methodname", "createGridColumns");
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("rk", "rk");
        args.put("seq", FSEQ_NAME);
        args.put("columns", this.createColumns(colNames));
        meta.put("args", new Map[]{args});
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("InvokeControlMethod", meta);
    }

    private List<Map<String, Object>> createColumns(List<BizDataServicePreviewHandler.Column> colNames) {
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>(2 + colNames.size());
        cols.add(this.genRKColumn());
        cols.add(this.genSeqColumn());
        Iterator<BizDataServicePreviewHandler.Column> colIt = colNames.iterator();
        while (colIt.hasNext()) {
            cols.add(this.createColumn(colIt.next()));
        }
        return cols;
    }

    private Map<String, Object> genSeqColumn() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataIndex", FSEQ_NAME);
        map.put("header", new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"ReconciliationPreviewFormPlugin_14", (String)"fi-frm-formplugin", (Object[])new Object[0])));
        map.put("isColPageFixed", Boolean.TRUE);
        map.put("type", "numberfield");
        map.put("width", 100);
        return map;
    }

    private Map<String, Object> genRKColumn() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataIndex", "rk");
        map.put("header", new LocaleString("rk"));
        map.put("visible", Boolean.FALSE);
        map.put("width", "50");
        return map;
    }

    private Map<String, Object> createColumn(BizDataServicePreviewHandler.Column column) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataIndex", column.name);
        map.put("header", column.displayName);
        map.put("visible", true);
        return map;
    }

    private void setGridData(List<BizDataServicePreviewHandler.Column> colNames, List<List<Object>> rs) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("dataindex", this.getDataIndex(colNames));
        data.put("rows", rs);
        data.put("datacount", rs.size());
        data.put("isSelectedAll", Boolean.FALSE);
        data.put("isSplitPage", Boolean.FALSE);
        data.put("pagerows", 50);
        data.put("pageindex", 1);
        int pageCount = this.getPageCount(50, rs.size());
        data.put("pagecount", pageCount);
        data.put("realPageCount", pageCount);
        data.put("rowcount", 50);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.setEntryProperty(TABLE_KEY_ENTRYENTITY, "data", data);
    }

    private int getPageCount(int pageRow, int total) {
        int pageCount = 0;
        pageCount = total / pageRow;
        if (total / pageRow > pageCount) {
            ++pageCount;
        }
        if (pageCount < 0) {
            pageCount = 0;
        }
        return pageCount;
    }

    private Map<String, Integer> getDataIndex(List<BizDataServicePreviewHandler.Column> colNames) {
        LinkedHashMap<String, Integer> dataIndex = new LinkedHashMap<String, Integer>(2 + colNames.size());
        dataIndex.put("rk", 0);
        dataIndex.put(FSEQ_NAME, 1);
        for (int i = 0; i < colNames.size(); ++i) {
            dataIndex.put(colNames.get((int)i).name, i + 2);
        }
        return dataIndex;
    }

    private ReconciliationParamModel getParamModel() {
        String param = this.getView().getPageCache().get(MODEL);
        ReconciliationParamModel paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
        return paramModel;
    }

    private static class _PreviewException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private int type = 0;

        public _PreviewException(String msg) {
            this(msg, 0);
        }

        public _PreviewException(String msg, int type) {
            super(msg);
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }
}

