/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.instance.Instance;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.constant.ReconciliationFormConstant;
import kd.fi.frm.common.enums.ReconcilationResultEnum;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.mq.ReconciliationPublish;
import kd.fi.frm.common.task.TaskDao;
import kd.fi.frm.common.task.TaskInfo;
import kd.fi.frm.common.task.TaskStatusEnum;
import kd.fi.frm.common.util.ShowConfirmUtil;
import kd.fi.frm.common.util.ThrowableHelper;

public class ReconciliationResultNewPlugin
extends AbstractFormPlugin
implements ClickListener,
CellClickListener,
ProgresssListener,
ReconciliationFormConstant {
    private static final String default_column_width = "defaultColumnWidth";
    private static final String default_OrgField_column_width = "defaultOrgFieldColumnWidth";
    private static final String KEY_PHOTO_YES = "/icons/pc/state/success_28_28.png";
    private static final String KEY_PHOTO_NO = "/icons/pc/state/fail_28_28.png";
    private static final String KEY_PHOTO_DOING = "/icons/pc/state/conduct.png";
    private static final String KEY_PHOTO_FAIL = "/icons/pc/state/refuse_13_13.png";
    private static final String KEY_PHOTO_IGNORE = "/icons/pc/state/weikaishi.png";
    private static final String KEY_PHOTO_NOT_START = "/icons/pc/state/queren_48_48.png";
    private static final String KEY_PHOTO_STOPPED = "/icons/pc/state/pc_icon_zz.png";
    private DynamicObjectCollection modulars;
    private static final String ORG_INDEX = "rowIndex";
    private final Map<Long, Integer> orgRowIndex = new HashMap<Long, Integer>();
    private List<String> fields = new ArrayList<String>();
    private static final String KEY_CACHE_SOTRED = "ai_recresultnew_cache";
    private static final String KEY_CACHE_MAINENTITYTYPE = "ai_recresultnew_mt_cache";
    private static final String KEY_CACHE_ENTITY = "ai_recresultnew_entry_cache";
    private static final String KEY_CACHE_FORMMETAID = "ai_recresultnew_fmid_cache";
    private static final String PAGE_CACHE_TASK_IDS = "pageCacheTaskIds";
    private static final String algoKey = ReconciliationResultNewPlugin.class.getName();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "tbmain"});
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.addCellClickListener((CellClickListener)this);
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
    }

    public void initialize() {
        super.initialize();
        String cacheStored = this.getPageCache().get(KEY_CACHE_SOTRED);
        if (StringUtils.isEmpty((CharSequence)cacheStored)) {
            this.getPageCache().put(default_column_width, "7%");
            this.getPageCache().put(default_OrgField_column_width, "9%");
            String param = (String)this.getView().getFormShowParameter().getCustomParam("model");
            ReconciliationParamModel paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
            this.getPageCache().put("model", param);
            this.getPageCache().put("period", paramModel.getPeriodId().toString());
            this.getPageCache().put(KEY_CACHE_SOTRED, "yes");
        }
        this.createColumn();
        this.refreshBuildColumnMeta();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refreshEntryentity();
        this.initProcessingnum();
        ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
        bar.start();
        String isFirstJob = this.getPageCache().get("isFist");
        if (StringUtils.isEmpty((CharSequence)isFirstJob)) {
            this.asynQuery();
            this.getView().setEnable(Boolean.FALSE, new String[]{"refresh"});
            this.getPageCache().put("isFist", "1");
        }
    }

    private void initProcessingnum() {
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        ((Label)this.getControl("processingnum")).setText(entryRowCount + "");
        ((Label)this.getControl("acctfinish")).setText("0");
    }

    public void cellDoubleClick(CellClickEvent cellclickevent) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cellClick(CellClickEvent evt) {
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        if (evt.getFieldKey().equals("seq") || evt.getFieldKey().equals("orgfield") || evt.getFieldKey().equals("0")) {
            return;
        }
        if (!"entryentity".equals(entryGrid.getEntryKey())) return;
        int rowIndex = evt.getRow();
        DynamicObject rowData = (DynamicObject)this.getView().getModel().getEntryEntity("entryentity").get(rowIndex);
        Map appNumberMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("app"), Map.class);
        String appNumber = evt.getFieldKey();
        String appId = null;
        for (Map.Entry app : appNumberMap.entrySet()) {
            if (!((String)app.getValue()).equalsIgnoreCase(appNumber)) continue;
            appId = (String)app.getKey();
            break;
        }
        DynamicObject orgfieldObj = rowData.getDynamicObject("orgfield");
        long orgId = orgfieldObj.getLong("id");
        String status = rowData.getString(appNumber);
        if ("3".equals(status) || "4".equals(status)) {
            String taskIdStr = this.getPageCache().get(PAGE_CACHE_TASK_IDS);
            Set taskIds = Stream.of(taskIdStr.split(",")).map(v -> Long.parseLong(v)).collect(Collectors.toSet());
            QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("bizapp", "=", (Object)appId), new QFilter("id", "in", taskIds)};
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)appNumber, (String)"frm_task", (String)"error_tag,error,reconresult", (QFilter[])filters, null);){
                if (!ds.iterator().hasNext()) return;
                Row row = (Row)ds.iterator().next();
                String message = row.getString("error");
                if (StringUtils.isEmpty((CharSequence)message)) {
                    int reconresult = row.getInteger("reconresult");
                    ReconcilationResultEnum code = ReconcilationResultEnum.getOrgTypeEnumByIndex((int)reconresult);
                    this.getView().showMessage(code.getName());
                    return;
                }
                String tracker = row.getString("error_tag");
                if (StringUtils.equals((CharSequence)message, (CharSequence)tracker)) {
                    this.getView().showMessage(message);
                    return;
                }
                this.getView().showMessage(message, tracker, MessageTypes.Default);
                return;
            }
        } else {
            if ("2".equals(status) || "5".equals(status)) {
                return;
            }
            String param = (String)this.getView().getFormShowParameter().getCustomParam("model");
            ReconciliationParamModel paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
            DynamicObjectCollection existTasks = TaskDao.getExistTasks((ReconciliationParamModel)paramModel);
            if (existTasks.size() == 0) {
                this.showBizAssistForm(appId, rowIndex, orgId);
                return;
            } else {
                ShowConfirmUtil.showTaskConfirm((IFormView)this.getView(), (IPageCache)this.getPageCache(), (DynamicObjectCollection)existTasks);
            }
        }
    }

    private void showBizAssistForm(String appId, int row, long orgId) {
        FormShowParameter parame = new FormShowParameter();
        parame.setFormId("frm_reconciliation_rst_fst");
        parame.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String param = (String)this.getView().getFormShowParameter().getCustomParam("model");
        ReconciliationParamModel paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
        paramModel.getAppIds().clear();
        paramModel.getAppIds().add(appId);
        paramModel.getOrgIds().clear();
        paramModel.getOrgIds().add(orgId);
        paramModel.setOriResult(Boolean.TRUE.booleanValue());
        parame.setCustomParam("model", (Object)SerializationUtils.toJsonString((Object)paramModel));
        this.getView().showForm(parame);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("refresh".equalsIgnoreCase(evt.getItemKey())) {
            String param = (String)this.getView().getFormShowParameter().getCustomParam("model");
            ReconciliationParamModel paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
            DynamicObjectCollection existTasks = TaskDao.getExistTasks((ReconciliationParamModel)paramModel);
            if (existTasks != null && existTasks.size() > 0) {
                ShowConfirmUtil.showTaskConfirm((IFormView)this.getView(), (IPageCache)this.getPageCache(), (DynamicObjectCollection)existTasks);
            } else {
                String endFlag = this.getPageCache().get("end");
                if (null != endFlag && endFlag.equals("end")) {
                    this.getPageCache().remove("end");
                    this.getPageCache().put("isFist", "1");
                    ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
                    bar.setPercent(0);
                    bar.start();
                    this.cleanPageCache();
                    this.getModel().deleteEntryData("entryentity");
                    this.refreshEntryentity();
                    this.getView().setEnable(Boolean.FALSE, new String[]{"refresh"});
                    this.asynQuery();
                }
            }
        }
    }

    public IPageCache getPageCache() {
        return new PageCache(this.getView().getPageId(), false);
    }

    private void refresh() {
        int i;
        this.getView().updateView("entryentity");
        if (this.getPageCache().get("batchno") == null) {
            return;
        }
        Map reconResultCache = AppCacheHelper.getBatchCache((String)this.getPageCache().get("batchno"));
        if (CollectionUtils.isEmpty((Map)reconResultCache)) {
            return;
        }
        Long orgId = null;
        int doingCount = 0;
        int finishCount = 0;
        int percent = 0;
        int total = Integer.parseInt(this.getPageCache().get("acctaccount"));
        HashMap<String, Integer> doingOrgs = new HashMap<String, Integer>(reconResultCache.size());
        HashMap<String, String> orgIdNameMap = new HashMap<String, String>(reconResultCache.size());
        Map orgRowIndex = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(ORG_INDEX), Map.class);
        Map appNumberMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("app"), Map.class);
        HashMap progressMap = new HashMap(orgRowIndex.size());
        for (Iterator _orgId : orgRowIndex.keySet()) {
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(appNumberMap.size());
            for (String _app : appNumberMap.keySet()) {
                hashMap.put(_app, false);
            }
            progressMap.put(_orgId, hashMap);
        }
        boolean notAllTaskOver = false;
        for (Map.Entry entry : reconResultCache.entrySet()) {
            String cache = (String)entry.getValue();
            TaskInfo taskInfo = (TaskInfo)SerializationUtils.deSerializeFromBase64((String)cache);
            orgId = taskInfo.getOrgId();
            Integer rowIndex = (Integer)orgRowIndex.get(orgId + "");
            DynamicObject orgDyn = this.getModel().getEntryRowEntity("entryentity", rowIndex.intValue()).getDynamicObject("orgfield");
            String orgName = orgDyn.getString("name");
            String appId = taskInfo.getAppId();
            Integer percent_app = taskInfo.getPercent();
            String taskStatus = taskInfo.getTaskStatus().getValue();
            ReconcilationResultEnum code = taskInfo.getCode();
            orgIdNameMap.put(orgId + "", orgName);
            Map _map = (Map)progressMap.get(orgId + "");
            String value = "";
            if (TaskStatusEnum.STOPPED.getValue().equals(taskStatus)) {
                value = "6";
                _map.put(appId, true);
            } else if (TaskStatusEnum.FINISHED.getValue().equals(taskStatus)) {
                value = ReconcilationResultEnum.Pass == code ? "1" : (ReconcilationResultEnum.fail == code ? "0" : (ReconcilationResultEnum.noExecPlan == code || ReconcilationResultEnum.noBook == code ? "4" : "3"));
                _map.put(appId, true);
            } else if (TaskStatusEnum.DOING.getValue().equals(taskStatus)) {
                value = "2";
                notAllTaskOver = true;
            } else if (TaskStatusEnum.NOT_START.getValue().equals(taskStatus)) {
                value = "5";
                notAllTaskOver = true;
            } else {
                value = "3";
                _map.put(appId, true);
            }
            String fieldKey = (String)appNumberMap.get(appId);
            this.getModel().setValue(fieldKey, (Object)value, rowIndex.intValue());
            if (percent_app != null && percent_app == 100) {
                _map.put(appId, true);
            }
            long count = _map.values().stream().filter(v -> v).count();
            percent = (int)(Float.parseFloat(count + "") / Float.parseFloat(_map.size() + "") * 100.0f);
            doingOrgs.put(orgName, percent);
        }
        for (Map.Entry entry : progressMap.entrySet()) {
            Map _map = (Map)entry.getValue();
            boolean notOver = _map.values().stream().anyMatch(v -> v == false);
            if (notOver) {
                ++doingCount;
                continue;
            }
            ++finishCount;
            doingOrgs.remove(orgIdNameMap.get(entry.getKey()));
        }
        int unilCount = total - finishCount - doingCount;
        ((Label)this.getControl("processingnum")).setText(unilCount + "");
        ((Label)this.getControl("acctfinish")).setText(finishCount + "");
        ((Label)this.getControl("acctorgtotal")).setText(doingCount + "");
        Object var14_21 = null;
        for (i = doingCount; i < 5; ++i) {
            String string = "flexprogress" + i;
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexprogress" + i});
        }
        i = 0;
        for (Map.Entry doing : doingOrgs.entrySet()) {
            if (i >= 5) break;
            String string = "flexprogress" + i;
            this.getView().setVisible(Boolean.TRUE, new String[]{string});
            ((Label)this.getControl("progresslabel" + i)).setText((String)doing.getKey());
            ((ProgressBar)this.getControl("progressbarap" + i)).setPercent(((Integer)doing.getValue()).intValue(), doing.getValue() + "%");
            ++i;
        }
        int taskNum = Integer.parseInt(this.getPageCache().get("taskNum"));
        if (!notAllTaskOver && reconResultCache.size() == taskNum) {
            this.getPageCache().put("isFist", "0");
        }
    }

    public void onProgress(ProgressEvent progressevent) {
        try {
            String isFirstJob = this.getPageCache().get("isFist");
            if ("0".equals(isFirstJob)) {
                ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
                bar.stop();
                progressevent.setProgress(100);
                this.getPageCache().put("end", "end");
                this.getView().setEnable(Boolean.TRUE, new String[]{"refresh"});
                return;
            }
            String isShowErrorFlag = this.getPageCache().get("isShowErrorFlag");
            if (null != isShowErrorFlag && "true".equals(isShowErrorFlag)) {
                return;
            }
            this.getResultErrorMessage();
            this.refresh();
        }
        catch (Exception e) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("closeCurrentPage", (IFormPlugin)this);
            this.getView().showConfirm(ThrowableHelper.toString((Exception)e), MessageBoxOptions.OK, confirmCallBacks);
            this.getPageCache().put("isFist", "0");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent arg0) {
        super.confirmCallBack(arg0);
        if (arg0.getCallBackId().equals("closeCurrentPage") && MessageBoxResult.Cancel.equals((Object)arg0.getResult())) {
            this.getView().close();
        }
        if ("stopTask".equals(arg0.getCallBackId())) {
            ShowConfirmUtil.taskConfirm((MessageBoxClosedEvent)arg0, (String)this.getPageCache().get("existTaskIds"), (IFormView)this.getView());
        }
    }

    private void getResultErrorMessage() {
        String errorMessage = this.getPageCache().get("fi_ai_reconciliationError");
        if (null == errorMessage || errorMessage.trim().length() == 0) {
            return;
        }
        this.getPageCache().put("isShowErrorFlag", "true");
        throw new KDBizException(errorMessage);
    }

    private void asynQuery() {
        try {
            this.buildTasks();
        }
        catch (Throwable e) {
            IPageCache pageCache = this.getPageCache();
            pageCache.remove("isShowErrorFlag");
            pageCache.put("fi_ai_reconciliationError", ThrowableHelper.toString((Throwable)e));
        }
    }

    private void buildTasks() {
        String param = (String)this.getView().getFormShowParameter().getCustomParam("model");
        ReconciliationParamModel paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
        Set orgIds = paramModel.getOrgIds();
        Set appIds = paramModel.getAppIds();
        MainEntityType taskMetaType = EntityMetadataCache.getDataEntityType((String)"frm_task");
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        String instanceNumber = Instance.getInstanceId();
        ArrayList<DynamicObject> tasks = new ArrayList<DynamicObject>(orgIds.size() * appIds.size());
        Iterator iterator = orgIds.iterator();
        while (iterator.hasNext()) {
            long orgId = (Long)iterator.next();
            for (String appId : appIds) {
                DynamicObject task = TaskDao.buildTask((long)orgId, (String)appId, (ReconciliationParamModel)paramModel, (MainEntityType)taskMetaType, (long)currUserId, (Date)now, (String)instanceNumber);
                tasks.add(task);
            }
        }
        TaskDao.addNew(tasks, () -> {
            ReconciliationPublish publish = new ReconciliationPublish();
            publish.setParamModel(paramModel);
            return publish;
        });
        String taskIds = tasks.stream().map(v -> v.getPkValue().toString()).collect(Collectors.joining(","));
        this.getPageCache().put(PAGE_CACHE_TASK_IDS, taskIds);
        this.getPageCache().put("batchno", ((DynamicObject)tasks.get(0)).getString("batchno"));
        this.getPageCache().put("taskNum", String.valueOf(tasks.size()));
    }

    private void refreshEntryentity() {
        String param = (String)this.getView().getFormShowParameter().getCustomParam("model");
        ReconciliationParamModel paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
        Set orgList = paramModel.getOrgIds();
        this.getPageCache().put("acctaccount", orgList.size() + "");
        ((Label)this.getControl("acctaccount")).setText(orgList.size() + "");
        Map appmap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("app"), Map.class);
        for (Long orgId : orgList) {
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            this.orgRowIndex.put(orgId, rowIndex);
            this.getModel().setValue("orgfield", (Object)orgId, rowIndex);
            for (Map.Entry ety : appmap.entrySet()) {
                this.getModel().setValue((String)appmap.get(ety.getKey()), (Object)"5", rowIndex);
            }
        }
        this.getPageCache().put(ORG_INDEX, SerializationUtils.toJsonString(this.orgRowIndex));
    }

    private void cleanPageCache() {
        for (int i = 0; i < 5; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexprogress" + i});
        }
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        ((Label)this.getControl("processingnum")).setText(entryRowCount + "");
        ((Label)this.getControl("acctfinish")).setText("0");
        this.getPageCache().remove("flexprogressMap");
        this.getPageCache().remove("progressbarMap");
        this.getPageCache().remove("progresslabelMap");
        this.getPageCache().remove("processingnum");
        this.getPageCache().remove("acctfinish");
        this.getModel().deleteEntryData("entryentity");
    }

    private void getFields() {
        this.fields = null;
        this.fields = new ArrayList<String>();
        this.fields.add("orgfield");
        this.fields.add("accountbook");
        String cacheValue = this.getPageCache().get("app");
        if (StringUtils.isNotEmpty((CharSequence)cacheValue)) {
            Map appNumberMap = (Map)SerializationUtils.fromJsonString((String)cacheValue, Map.class);
            for (Map.Entry ety : appNumberMap.entrySet()) {
                this.fields.add((String)ety.getValue());
            }
        }
    }

    private void createColumn() {
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.preInvokeControlMethod("entryentity", "createGridColumns", new Object[]{this.genEntryEntity()});
    }

    private Map<String, Object> genEntryEntity() {
        HashMap<String, Object> map;
        String cacheValue = this.getPageCache().get(KEY_CACHE_ENTITY);
        if (StringUtils.isEmpty((CharSequence)cacheValue)) {
            map = new HashMap<String, String>();
            map.put("rk", "rk");
            map.put("seq", "seq");
            map.put("columns", this.getAllColumn());
            map.put("mergerow", Boolean.TRUE);
            cacheValue = SerializationUtils.toJsonString(map);
            this.getPageCache().put(KEY_CACHE_ENTITY, cacheValue);
        } else {
            map = (Map)SerializationUtils.fromJsonString((String)cacheValue, Map.class);
        }
        return map;
    }

    private List<Map<String, Object>> getAllColumn() {
        Map<String, String> columnsMap = this.getColumns();
        this.countColumnWidth(columnsMap);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(columnsMap.size());
        list.add(this.createRowKeyColumn());
        list.add(this.createSeqColumn());
        list.add(this.createOrgFieldColumn());
        for (Map.Entry<String, String> ety : columnsMap.entrySet()) {
            list.add(this.createColumnFieldInfo(ety.getKey(), ety.getValue()));
        }
        return list;
    }

    public Map<String, String> getColumns() {
        String param = (String)this.getView().getFormShowParameter().getCustomParam("model");
        ReconciliationParamModel paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)param, ReconciliationParamModel.class);
        QFilter idFilter = new QFilter("id", "in", (Object)paramModel.getAppIds());
        this.modulars = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id,number,name", (QFilter[])new QFilter[]{idFilter}, null);
        HashMap<String, String> appNumberMap = new HashMap<String, String>();
        LinkedHashMap<String, String> columnMap = new LinkedHashMap<String, String>();
        for (DynamicObject dynamicObject : this.modulars) {
            columnMap.put(dynamicObject.getString("name"), dynamicObject.getString("number"));
            appNumberMap.put(dynamicObject.getString("id"), dynamicObject.getString("number"));
        }
        this.getPageCache().put("app", SerializationUtils.toJsonString(appNumberMap));
        return columnMap;
    }

    private Map<String, Object> createRowKeyColumn() {
        HashMap<String, Object> col = new HashMap<String, Object>();
        col.put("dataIndex", "rk");
        col.put("width", 50);
        col.put("header", new LocaleString("rk"));
        col.put("visible", Boolean.FALSE);
        return col;
    }

    private Map<String, Object> createSeqColumn() {
        HashMap<String, Object> col = new HashMap<String, Object>();
        col.put("dataIndex", "seq");
        col.put("w", 50);
        col.put("header", new LocaleString(ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"ReconciliationResultNewPlugin_1", (String)"fi-frm-formplugin", (Object[])new Object[0])));
        col.put("type", "numberfield");
        col.put("isColPageFixed", Boolean.TRUE);
        return col;
    }

    private Map<String, Object> createOrgFieldColumn() {
        HashMap<String, Object> col = new HashMap<String, Object>();
        col.put("dataIndex", "orgfield");
        col.put("header", new LocaleString(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7", (String)"ReconciliationResultNewPlugin_2", (String)"fi-frm-formplugin", (Object[])new Object[0])));
        col.put("filter", Boolean.TRUE);
        col.put("vi", "63");
        col.put("l", "7");
        col.put("sort", Boolean.TRUE);
        col.put("w", new LocaleString(this.getPageCache().get(default_OrgField_column_width)));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dsp", "name");
        map.put("dst", 0);
        map.put("mi", Boolean.FALSE);
        map.put("type", "org");
        col.put("editor", map);
        return col;
    }

    private Map<String, Object> createColumnFieldInfo(String name, String number) {
        EntryFieldAp f7Field = new EntryFieldAp();
        f7Field.setKey(number);
        f7Field.setName(new LocaleString(name));
        f7Field.setLock("new,edit,view,submit,audit");
        f7Field.setComboShowStyle(1);
        f7Field.setQuickAddNew(false);
        ComboField comboField = new ComboField();
        comboField.setName(new LocaleString(name));
        comboField.setKey(number);
        ArrayList<ComboItem> listItems = new ArrayList<ComboItem>(10);
        listItems.add(new ComboItem(0, new LocaleString(ReconcilationResultEnum.Pass.getName()), "1", KEY_PHOTO_YES));
        listItems.add(new ComboItem(1, new LocaleString(ReconcilationResultEnum.fail.getName()), "0", KEY_PHOTO_NO));
        listItems.add(new ComboItem(2, new LocaleString(TaskStatusEnum.DOING.getDisplayName()), "2", KEY_PHOTO_DOING));
        listItems.add(new ComboItem(3, new LocaleString(ReconcilationResultEnum.error.getName()), "3", KEY_PHOTO_FAIL));
        listItems.add(new ComboItem(4, new LocaleString(ReconcilationResultEnum.ignore.getName()), "4", KEY_PHOTO_IGNORE));
        listItems.add(new ComboItem(5, new LocaleString(TaskStatusEnum.NOT_START.getDisplayName()), "5", KEY_PHOTO_NOT_START));
        comboField.setItems(listItems);
        f7Field.setField((Field)comboField);
        return (Map)f7Field.createColumns().get(0);
    }

    private List<Map<String, Object>> createComboValue() {
        ArrayList<Map<String, Object>> combo = new ArrayList<Map<String, Object>>();
        HashMap<String, String> mapComboO = new HashMap<String, String>();
        mapComboO.put("0", "1");
        mapComboO.put("1", (String)new LocaleString(ReconcilationResultEnum.Pass.getName()));
        mapComboO.put("2", KEY_PHOTO_YES);
        combo.add(mapComboO);
        HashMap<String, String> mapComboT = new HashMap<String, String>();
        mapComboT.put("0", "0");
        mapComboT.put("1", (String)new LocaleString(ReconcilationResultEnum.fail.getName()));
        mapComboT.put("2", KEY_PHOTO_NO);
        combo.add(mapComboT);
        HashMap<String, String> mapComboD = new HashMap<String, String>();
        mapComboD.put("0", "2");
        mapComboD.put("1", (String)new LocaleString(TaskStatusEnum.DOING.getDisplayName()));
        mapComboD.put("2", KEY_PHOTO_DOING);
        combo.add(mapComboD);
        HashMap<String, String> mapComboF = new HashMap<String, String>();
        mapComboF.put("0", "3");
        mapComboF.put("1", (String)new LocaleString(ReconcilationResultEnum.error.getName()));
        mapComboF.put("2", KEY_PHOTO_FAIL);
        combo.add(mapComboF);
        HashMap<String, String> mapComboN = new HashMap<String, String>();
        mapComboN.put("0", "4");
        mapComboN.put("1", (String)new LocaleString(ReconcilationResultEnum.ignore.getName()));
        mapComboN.put("2", KEY_PHOTO_IGNORE);
        combo.add(mapComboN);
        HashMap<String, String> mapComboW = new HashMap<String, String>();
        mapComboW.put("0", "5");
        mapComboW.put("1", (String)new LocaleString(TaskStatusEnum.NOT_START.getDisplayName()));
        mapComboW.put("2", KEY_PHOTO_NOT_START);
        combo.add(mapComboW);
        HashMap<String, String> mapComboStopped = new HashMap<String, String>();
        mapComboStopped.put("0", "6");
        mapComboStopped.put("1", (String)new LocaleString(TaskStatusEnum.STOPPED.getDisplayName()));
        mapComboStopped.put("2", KEY_PHOTO_STOPPED);
        combo.add(mapComboStopped);
        return combo;
    }

    private void countColumnWidth(Map<String, String> columnsMap) {
        int width = 0;
        int orgColumnW = 92;
        if (null != columnsMap && columnsMap.size() > 0) {
            width = 83 / (columnsMap.size() * 2);
            orgColumnW = 9 + 83 % (columnsMap.size() * 2);
        }
        this.getPageCache().put(default_column_width, width + "%");
        this.getPageCache().put(default_OrgField_column_width, orgColumnW + "%");
    }

    private Control addCombox(Container entryCon, String key, LocaleString name, String entityId, IDataModel dataModel, IFormView view, EntityMetadata entityMeta) {
        EntryFieldAp basedataAp = new EntryFieldAp();
        basedataAp.setKey(key);
        basedataAp.setWidth(new LocaleString("100px"));
        basedataAp.setName(name);
        ComboField comboField = new ComboField();
        comboField.setName(name);
        comboField.setKey(key);
        comboField.setEntityMetadata(entityMeta);
        entityMeta.getItems().add(comboField);
        basedataAp.setField((Field)comboField);
        FieldEdit bsEdit = basedataAp.buildRuntimeControl();
        bsEdit.setFieldKey(key);
        bsEdit.setModel(dataModel);
        bsEdit.setView(view);
        entryCon.getItems().add(bsEdit);
        return bsEdit;
    }

    private void buildColumnMeta() throws CloneNotSupportedException {
        Container entryCon = (Container)this.getControl("entryentity");
        IDataModel dataModel = this.getModel();
        IFormView view = this.getView();
        ArrayList<Control> list = new ArrayList<Control>();
        MainEntityType mainType = this.getModel().getDataEntityType();
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)this.getFormMetadataId(mainType), (MetaCategory)MetaCategory.Entity);
        this.getFields();
        for (int i = 0; i < this.fields.size(); ++i) {
            LocaleString name = new LocaleString(this.fields.get(i));
            String key = this.fields.get(i);
            String entityId = "entryentity";
            if (key.equalsIgnoreCase("orgfield") || key.equalsIgnoreCase("accountbook")) continue;
            list.add(this.addCombox(entryCon, key, name, entityId, dataModel, view, entityMeta));
        }
        if (!list.isEmpty()) {
            view.createControlIndex(list);
        }
    }

    private String getFormMetadataId(MainEntityType mainType) {
        String cacheValue = this.getPageCache().get(KEY_CACHE_FORMMETAID);
        if (StringUtils.isEmpty((CharSequence)cacheValue)) {
            FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
            cacheValue = formMeta.getEntityId();
            this.getPageCache().put(KEY_CACHE_FORMMETAID, cacheValue);
        }
        return cacheValue;
    }

    public void getEntityType(GetEntityTypeEventArgs evt) {
        super.getEntityType(evt);
        try {
            MainEntityType newType;
            String cacheValue = this.getPageCache().get(KEY_CACHE_MAINENTITYTYPE);
            MainEntityType type = evt.getOriginalEntityType();
            if (StringUtils.isEmpty((CharSequence)cacheValue)) {
                newType = (MainEntityType)type.clone();
                EntryProp entry = (EntryProp)newType.getProperty("entryentity");
                DynamicObjectType entryType = entry.getDynamicCollectionItemPropertyType();
                this.getFields();
                for (int i = 0; i < this.fields.size(); ++i) {
                    LocaleString name = new LocaleString(this.fields.get(i));
                    String key = this.fields.get(i);
                    if (key.equalsIgnoreCase("orgfield") || key.equalsIgnoreCase("accountbook")) continue;
                    ComboProp comboProp = new ComboProp();
                    comboProp.setName(key);
                    ArrayList<ValueMapItem> listItems = new ArrayList<ValueMapItem>();
                    listItems.add(new ValueMapItem(KEY_PHOTO_YES, "1", new LocaleString(ReconcilationResultEnum.Pass.getName())));
                    listItems.add(new ValueMapItem(KEY_PHOTO_NO, "0", new LocaleString(ReconcilationResultEnum.fail.getName())));
                    listItems.add(new ValueMapItem(KEY_PHOTO_DOING, "2", new LocaleString(TaskStatusEnum.DOING.getDisplayName())));
                    listItems.add(new ValueMapItem(KEY_PHOTO_FAIL, "3", new LocaleString(ReconcilationResultEnum.error.getName())));
                    listItems.add(new ValueMapItem(KEY_PHOTO_IGNORE, "4", new LocaleString(ReconcilationResultEnum.ignore.getName())));
                    listItems.add(new ValueMapItem(KEY_PHOTO_NOT_START, "5", new LocaleString(TaskStatusEnum.NOT_START.getDisplayName())));
                    comboProp.setComboItems(listItems);
                    comboProp.setDisplayName(name);
                    entryType.addProperty((DynamicProperty)comboProp);
                }
                String newTypeStr = SerializationUtils.serializeToBase64((Object)newType);
                this.getPageCache().put(KEY_CACHE_MAINENTITYTYPE, newTypeStr);
            } else {
                newType = (MainEntityType)SerializationUtils.deSerializeFromBase64((String)cacheValue);
            }
            newType.createPropIndexsNoCache();
            evt.setNewEntityType(newType);
        }
        catch (CloneNotSupportedException e) {
            throw new KDBizException((Throwable)e, new ErrorCode(String.valueOf(ReconcilationResultEnum.error.getIndex()), e.getMessage()), new Object[0]);
        }
    }

    private void refreshBuildColumnMeta() {
        String isFirstJob = this.getPageCache().get("isFist");
        if (isFirstJob == null || "1".equals(isFirstJob)) {
            try {
                this.buildColumnMeta();
            }
            catch (CloneNotSupportedException e) {
                throw new KDBizException((Throwable)e, new ErrorCode(String.valueOf(ReconcilationResultEnum.error.getIndex()), e.getMessage()), new Object[0]);
            }
        }
    }
}

