/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.enums.DataTypeEnum;
import kd.fi.frm.common.enums.ReconcilationResultEnum;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model2.RelationDataParam3;
import kd.fi.frm.common.task.TaskDao;
import kd.fi.frm.common.task.TaskInfo;
import kd.fi.frm.common.task.TaskStatusEnum;
import kd.fi.frm.common.util.FaBillParamUtils;
import kd.fi.frm.common.util.ThrowableHelper;
import kd.fi.frm.mservice.impl.ReconciliationInitService;
import kd.fi.frm.mservice.impl.ReconciliationPeriodCloseService;
import kd.fi.frm.mservice.impl.detail.ReconDetailService;
import kd.fi.frm.mservice.impl.detail.ReconciliationDetailService;

public class ReconciliationService
implements MessageConsumer {
    private static final Log log = LogFactory.getLog(ReconciliationService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        log.info("receive task message: {}", message);
        if (message == null) {
            log.warn("\u5bf9\u8d26\u4efb\u52a1\u63a5\u6536\u7684\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a, messageId = {}", (Object)messageId);
            acker.ack(messageId);
            return;
        }
        RelationDataParam3 glParam = null;
        ReconciliationParamModel paramModel = null;
        Object taskId = null;
        String batchNo = null;
        TaskInfo taskInfo = null;
        boolean deny = false;
        try {
            Object reconParamModel;
            log.info("################################# \u5bf9\u8d26\uff0cAbstractTask  \u5f00\u59cb\u6267\u884c ################################# pageId:{}", message);
            Map params = (Map)message;
            taskId = params.get("taskId");
            batchNo = String.valueOf(params.get("batchNo"));
            taskInfo = TaskDao.getTaskInfo((Long)Long.parseLong(String.valueOf(taskId)));
            if (taskInfo == null) {
                log.info("\u5bf9\u8d26\u4efb\u52a1\u5df2\u88ab\u5220\u9664\uff0c\u65e0\u9700\u8fdb\u884c\u5bf9\u8d26");
                return;
            }
            if (TaskStatusEnum.NOT_START != taskInfo.getTaskStatus()) {
                TaskStatusEnum taskStatus = taskInfo.getTaskStatus();
                if (TaskStatusEnum.FINISHED == taskStatus || TaskStatusEnum.STOPPED == taskStatus || TaskStatusEnum.ERROR == taskStatus) {
                    log.info("\u4efb\u52a1\u5df2\u5b8c\u6210\uff0c\u6d88\u606f\u91cd\u590d\u63a8\u9001\u6216\u8005\u7cfb\u7edf\u505c\u6b62\u670d\u52a1\u5bfc\u81f4\u6d88\u606f\u91cd\u65b0\u63a8\u9001\uff0c\u5e94\u7b54\u6d88\u606f\uff01");
                    return;
                }
                if (TaskStatusEnum.DOING == taskStatus) {
                    log.info("\u6d88\u606f\u91cd\u590d\u63a8\u9001\u6216\u8005\u7cfb\u7edf\u505c\u6b62\u670d\u52a1\u5bfc\u81f4\u6d88\u606f\u91cd\u65b0\u63a8\u9001\uff0c\u7b49\u5f8510\u79d2\u540e\u62d2\u7edd\u6d88\u606f\uff01");
                    deny = true;
                    Thread.sleep(10000L);
                    return;
                }
            }
            String instanceId = Instance.getInstanceId();
            Object objGlParam = params.get("glparam");
            if (objGlParam != null) {
                glParam = (RelationDataParam3)objGlParam;
            }
            if ((reconParamModel = params.get("paramModel")) == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bf9\u8d26\u4efb\u52a1\u53c2\u6570\u5728\u4f20\u9012\u4e2d\u4e22\u5931", (String)"ReconciliationService_4", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            }
            paramModel = (ReconciliationParamModel)reconParamModel;
            Set orgIds = paramModel.getOrgIds();
            orgIds.clear();
            orgIds.add(taskInfo.getOrgId());
            Set appIds = paramModel.getAppIds();
            appIds.clear();
            appIds.add(taskInfo.getAppId());
            paramModel.setTaskInfo(taskInfo);
            Date beginTime = new Date();
            TaskDao.startTask((TaskInfo)taskInfo, (String)instanceId, (Date)beginTime, (String)SerializationUtils.toJsonString((Object)params));
            AppCacheHelper.updateTaskStatusWithDB((String)batchNo, (String)taskId.toString(), null, null, (TaskStatusEnum)TaskStatusEnum.DOING, null, null);
            this.execute(paramModel, glParam);
            log.info("################################# \u5bf9\u8d26\uff0cAbstractTask  \u6267\u884c\u7ed3\u675f ## \u7ed3\u679c\u96c6");
        }
        catch (Throwable exception) {
            log.error("################################# \u5bf9\u8d26\uff0cAbstractTask ", exception);
            try {
                if (taskInfo != null) {
                    taskInfo.setConsumed(true);
                    taskInfo.setTaskStatus(TaskStatusEnum.ERROR);
                    taskInfo.setError(new String[]{exception.getMessage(), ThrowableHelper.toString((Throwable)exception)});
                    AppCacheHelper.updateTaskStatusWithDB((String)taskInfo.getBatchNo(), (String)String.valueOf(taskInfo.getId()), (ReconcilationResultEnum)ReconcilationResultEnum.error, null, (TaskStatusEnum)TaskStatusEnum.ERROR, null, (String[])taskInfo.getError());
                }
                AppCacheHelper.putResultCache((String)("fi_ai_reconciliationError_" + taskId), (Object)exception.getMessage());
            }
            catch (Exception e) {
                log.error("################################# \u5bf9\u8d26\uff0c\u65e0\u6cd5\u5199\u5165\u7f13\u5b58 ", exception);
            }
        }
        finally {
            if (deny) {
                acker.deny(messageId);
            } else {
                acker.ack(messageId);
            }
        }
    }

    private void execute(ReconciliationParamModel paramModel, RelationDataParam3 glParam) {
        boolean dapMulEnable;
        Boolean isInit = paramModel.isInit();
        Object service = null;
        service = paramModel.getDataType().getValue() == DataTypeEnum.Detail.getValue() ? ((dapMulEnable = FaBillParamUtils.getBooleanValue((Long)glParam.getAcctOrgID(), (String)"frm_detail_dapmul")) ? new ReconDetailService(paramModel, glParam) : new ReconciliationDetailService(paramModel, glParam)) : (isInit != false ? new ReconciliationInitService(paramModel) : new ReconciliationPeriodCloseService(paramModel));
        service.execute();
    }
}

