/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin.assist;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.frm.common.enums.AssistDataType;
import kd.fi.frm.common.model.ReturnData;
import kd.fi.frm.formplugin.DSField;

public class AssistGroupFilterFormPlugin
extends AbstractFormPlugin {
    private static final String KEY_ENTRY = "entryentity";
    private static final String KEY_SUB_ENTRY = "entryvalentity";
    private static final String KEY_BASEDATA_PREFIX = "basedata";
    private static final String KEY_ASSISTANT_PREFIX = "assistanttext";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        for (int i = 0; i < 5; ++i) {
            this.addClickListeners(new String[]{KEY_ASSISTANT_PREFIX + i});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.startsWith(KEY_ASSISTANT_PREFIX)) {
            this.showAssistDataF7Form(key);
        } else if ("btnok".equals(key)) {
            this.checkAndReturnData();
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String assistStr = (String)this.getView().getFormShowParameter().getCustomParam("assists");
        if (StringUtils.isEmpty((Object)assistStr)) {
            return;
        }
        List dycCols = (List)SerializationUtils.deSerializeFromBase64((String)assistStr);
        String assistfilter = (String)this.getView().getFormShowParameter().getCustomParam("assistfilter");
        Object useorgObj = this.getView().getFormShowParameter().getCustomParam("useorg");
        if (useorgObj != null) {
            Long useorg = Long.parseLong(useorgObj.toString());
            this.getModel().setValue("useorg", (Object)useorg);
        }
        this.redrawColumns(dycCols, true);
        if (!StringUtils.isEmpty((Object)assistfilter)) {
            Map dynMap;
            List entryData = JSONArray.parseArray((String)assistfilter, Map.class);
            HashMap<String, Set> bdEntityQuery = new HashMap<String, Set>(4);
            HashMap<String, Set> adEntityQuery = new HashMap<String, Set>(4);
            for (Iterator rowData : entryData) {
                for (Map.Entry entry : rowData.entrySet()) {
                    Set valSet;
                    String assistKey = (String)entry.getKey();
                    String[] split = assistKey.split("\\.");
                    if (AssistDataType.isBaseDataType((String)split[0])) {
                        valSet = bdEntityQuery.computeIfAbsent(split[1], v -> new HashSet());
                        valSet.addAll(((List)entry.getValue()).stream().mapToLong(d -> Long.parseLong(d.toString())).boxed().collect(Collectors.toSet()));
                        continue;
                    }
                    valSet = adEntityQuery.computeIfAbsent(split[1], v -> new HashSet());
                    valSet.addAll(((List)entry.getValue()).stream().mapToLong(d -> Long.parseLong(d.toString())).boxed().collect(Collectors.toSet()));
                }
            }
            HashMap<String, Map> assistDynMap = new HashMap<String, Map>();
            if (bdEntityQuery.size() > 0) {
                for (Map.Entry entry : bdEntityQuery.entrySet()) {
                    dynMap = BusinessDataServiceHelper.loadFromCache((String)((String)entry.getKey()), (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", entry.getValue())});
                    assistDynMap.put(AssistDataType.makeAssistKey((String)AssistDataType.BASEDATA.getBdType(), (String)((String)entry.getKey())), dynMap);
                }
            }
            if (adEntityQuery.size() > 0) {
                for (Map.Entry entry : adEntityQuery.entrySet()) {
                    dynMap = BusinessDataServiceHelper.loadFromCache((String)"bos_assistantdata_detail", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", entry.getValue())});
                    assistDynMap.put(AssistDataType.makeAssistKey((String)AssistDataType.ASSISTASNT.getBdType(), (String)((String)entry.getKey())), dynMap);
                }
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(KEY_ENTRY);
            entryEntity.clear();
            for (Map rowData : entryData) {
                DynamicObject entryRow = entryEntity.addNew();
                for (DSField dycCol : dycCols) {
                    DynamicObject baseData;
                    String assistKey = AssistDataType.makeAssistKey((String)dycCol.getDataType(), (String)dycCol.getEntityId());
                    List valIds = ((List)rowData.get(assistKey)).stream().mapToLong(d -> Long.parseLong(d.toString())).boxed().collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(valIds)) continue;
                    ArrayList<String> assistDataShowName = new ArrayList<String>();
                    if (AssistDataType.isBaseDataType((String)dycCol.getDataType())) {
                        DynamicObjectCollection mulBaseData = entryRow.getDynamicObjectCollection(dycCol.getFieldKey());
                        for (Long id : valIds) {
                            baseData = mulBaseData.addNew();
                            baseData.set("fbasedataid_id", (Object)id);
                            baseData.set("fbasedataid", ((Map)assistDynMap.get(assistKey)).get(id));
                        }
                    } else {
                        DynamicObjectCollection assistantEntry = entryRow.getDynamicObjectCollection(KEY_SUB_ENTRY);
                        for (Long id : valIds) {
                            baseData = assistantEntry.addNew();
                            baseData.set("assistkey", (Object)dycCol.getEntityId());
                            baseData.set("assistval", (Object)id);
                            String name = ((DynamicObject)((Map)assistDynMap.get(assistKey)).get(id)).getString("name");
                            assistDataShowName.add(name);
                            baseData.set("assistname", (Object)name);
                        }
                    }
                    if (!AssistDataType.isAssistantDataType((String)dycCol.getDataType())) continue;
                    entryRow.set(dycCol.getFieldKey(), (Object)String.join((CharSequence)",", assistDataShowName));
                }
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW == status) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_addentry", "bar_delentry"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_ENTRY});
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (key.startsWith(KEY_BASEDATA_PREFIX)) {
            MulBasedataEdit textEdit = new MulBasedataEdit();
            textEdit.setKey(key);
            textEdit.setFieldKey(key);
            textEdit.setEntryControlKey(KEY_ENTRY);
            textEdit.setView(this.getView());
            e.setControl((Control)textEdit);
        } else if (key.startsWith(KEY_ASSISTANT_PREFIX)) {
            TextEdit textEdit = new TextEdit();
            textEdit.setKey(key);
            textEdit.setId(key);
            textEdit.setEntryControlKey(KEY_ENTRY);
            textEdit.setView(this.getView());
            e.setControl((Control)textEdit);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        super.getEntityType(e);
        MainEntityType oldMainEntityType = e.getOriginalEntityType();
        MainEntityType newEntityType = null;
        String assistStr = (String)this.getView().getFormShowParameter().getCustomParam("assists");
        if (StringUtils.isEmpty((Object)assistStr)) {
            return;
        }
        try {
            newEntityType = (MainEntityType)oldMainEntityType.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("getEntityType", ex.getMessage()), new Object[0]);
        }
        List dycCols = (List)SerializationUtils.deSerializeFromBase64((String)assistStr);
        if (!CollectionUtils.isEmpty((Collection)dycCols)) {
            this.registerDynamicCol(newEntityType, dycCols);
        }
        e.setNewEntityType(newEntityType);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (actionId.startsWith("assistant.callback.")) {
            ListSelectedRowCollection selectRows;
            Object returnData = evt.getReturnData();
            if (returnData == null) {
                return;
            }
            String fieldKey = actionId.substring(actionId.lastIndexOf(".") + 1);
            String assistStr = (String)this.getView().getFormShowParameter().getCustomParam("assists");
            List dsFields = (List)SerializationUtils.deSerializeFromBase64((String)assistStr);
            DSField dsField = dsFields.stream().filter(f -> f.getFieldKey().equals(fieldKey)).findFirst().get();
            int currentRowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRY);
            DynamicObject subEntryEntity = this.getModel().getEntryRowEntity(KEY_ENTRY, currentRowIndex);
            DynamicObjectCollection assistDataEntry = subEntryEntity.getDynamicObjectCollection(KEY_SUB_ENTRY);
            if (AssistDataType.isAssistantDataType((String)dsField.getDataType())) {
                Iterator dataEntryIt = assistDataEntry.iterator();
                while (dataEntryIt.hasNext()) {
                    DynamicObject dataRow = (DynamicObject)dataEntryIt.next();
                    String assistkey = dataRow.getString("assistkey");
                    if (!assistkey.equals(dsField.getEntityId())) continue;
                    dataEntryIt.remove();
                }
            }
            if ((selectRows = (ListSelectedRowCollection)returnData).size() == 0) {
                return;
            }
            HashSet<String> assistVals = new HashSet<String>(selectRows.size());
            HashSet<String> assistNames = new HashSet<String>(selectRows.size());
            ArrayList<String> showName = new ArrayList<String>(selectRows.size());
            for (ListSelectedRow row : selectRows) {
                Object primaryKeyValue = row.getPrimaryKeyValue();
                assistVals.add(primaryKeyValue.toString());
                assistNames.add(row.getName());
                String name = row.getName();
                showName.add(name);
            }
            DynamicObject rowData = assistDataEntry.addNew();
            rowData.set("assistkey", (Object)dsField.getEntityId());
            rowData.set("assistval", (Object)String.join((CharSequence)",", assistVals));
            rowData.set("assistname", (Object)String.join((CharSequence)",", assistNames));
            this.getModel().setValue(fieldKey, (Object)String.join((CharSequence)"\uff1b", showName), currentRowIndex);
            this.getView().updateView(fieldKey, currentRowIndex);
        }
    }

    private void showAssistDataF7Form(String key) {
        String assistStr = (String)this.getView().getFormShowParameter().getCustomParam("assists");
        List dsFields = (List)SerializationUtils.deSerializeFromBase64((String)assistStr);
        DSField dsField = dsFields.stream().filter(f -> f.getFieldKey().equals(key)).findAny().get();
        ListShowParameter para = ShowFormHelper.createShowListForm((String)"bos_assistantdata_detail", (boolean)true);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        Long groupId = Long.valueOf(dsField.getEntityId());
        QFilter filter = new QFilter("group", "=", (Object)groupId);
        filters.add(filter);
        ListFilterParameter listFilterParameter = new ListFilterParameter(filters, null);
        para.setListFilterParameter(listFilterParameter);
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCaption(dsField.getFieldName().getLocaleValue());
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "assistant.callback." + key));
        this.getView().showForm((FormShowParameter)para);
    }

    private void checkAndReturnData() {
        String collect;
        String assistStr = (String)this.getView().getFormShowParameter().getCustomParam("assists");
        List dycCols = (List)SerializationUtils.deSerializeFromBase64((String)assistStr);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(KEY_ENTRY);
        Map<String, String> assistNameMap = dycCols.stream().collect(Collectors.toMap(f -> AssistDataType.makeAssistKey((String)f.getDataType(), (String)f.getEntityId()), f -> f.getFieldName().getLocaleValue()));
        String resultShowName = collect = dycCols.stream().map(f -> f.getFieldName().getLocaleValue()).collect(Collectors.joining("+"));
        HashSet<String> hasValAssists = new HashSet<String>(dycCols.size());
        ArrayList<String> errorList = new ArrayList<String>(10);
        ArrayList resultList = new ArrayList(entryEntity.size());
        int rowIndex = 0;
        for (DynamicObject entryRow : entryEntity) {
            ++rowIndex;
            HashMap<String, Set> rowData = new HashMap<String, Set>(4);
            boolean rowHasData = false;
            ArrayList<String> currentRowErrors = new ArrayList<String>(dycCols.size());
            for (DSField dSField : dycCols) {
                DynamicObjectCollection bdColl;
                Set valIds = rowData.computeIfAbsent(AssistDataType.makeAssistKey((String)dSField.getDataType(), (String)dSField.getEntityId()), list -> new HashSet());
                if (AssistDataType.isBaseDataType((String)dSField.getDataType())) {
                    bdColl = entryRow.getDynamicObjectCollection(dSField.getFieldKey());
                    if (CollectionUtils.isEmpty((Collection)bdColl)) {
                        currentRowErrors.add(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4e1a\u52a1\u8fc7\u6ee4\u201d\u7b2c%1$s\u884c\uff1a\u201c%2$s\u201d\u3002", (String)"AssistGroupFilterFormPlugin_3", (String)"fi-frm-formplugin", (Object[])new Object[0]), rowIndex, dSField.getFieldName().getLocaleValue()));
                        continue;
                    }
                    rowHasData = true;
                    hasValAssists.add(AssistDataType.makeAssistKey((String)dSField.getDataType(), (String)dSField.getEntityId()));
                    for (DynamicObject baseData : bdColl) {
                        valIds.add(baseData.getLong("fbasedataid_id"));
                    }
                    continue;
                }
                bdColl = entryRow.getDynamicObjectCollection(KEY_SUB_ENTRY);
                List matchList = bdColl.stream().filter(k -> k.getString("assistkey").equalsIgnoreCase(dycCol.getEntityId())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(matchList)) {
                    currentRowErrors.add(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4e1a\u52a1\u8fc7\u6ee4\u201d\u7b2c%1$s\u884c\uff1a\u201c%2$s\u201d\u3002", (String)"AssistGroupFilterFormPlugin_3", (String)"fi-frm-formplugin", (Object[])new Object[0]), rowIndex, dSField.getFieldName().getLocaleValue()));
                    continue;
                }
                for (DynamicObject baseData : matchList) {
                    String assistval = baseData.getString("assistval");
                    String[] split = assistval.split(",");
                    if (split.length > 0) {
                        rowHasData = true;
                        hasValAssists.add(AssistDataType.makeAssistKey((String)dSField.getDataType(), (String)dSField.getEntityId()));
                    }
                    for (String id : split) {
                        valIds.add(Long.valueOf(id));
                    }
                }
            }
            if (!rowHasData) continue;
            if (currentRowErrors.size() > 0) {
                errorList.addAll(currentRowErrors);
                continue;
            }
            resultList.add(rowData);
        }
        if (errorList.size() > 0) {
            FormShowParameter showParameter = AssistGroupFilterFormPlugin.buildFormShowParameter(errorList);
            this.getView().showForm(showParameter);
            return;
        }
        for (int i = 0; i < resultList.size(); ++i) {
            Map curRow = (Map)resultList.get(i);
            for (Map.Entry rowItem : curRow.entrySet()) {
                Set valSet = (Set)rowItem.getValue();
                if (!hasValAssists.contains(rowItem.getKey()) || !CollectionUtils.isEmpty((Collection)valSet)) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u914d\u7f6e\u201c%2$s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AssistGroupFilterFormPlugin_2", (String)"fi-frm-formplugin", (Object[])new Object[0]), i + 1, assistNameMap.get(rowItem.getKey())));
            }
            for (int j = 0; j < resultList.size(); ++j) {
                if (i == j) continue;
                Map compareRow = (Map)resultList.get(j);
                int duplicateCount = 0;
                for (Map.Entry entry : curRow.entrySet()) {
                    Set compVal;
                    String key = (String)entry.getKey();
                    Set value = (Set)entry.getValue();
                    if (!CollectionUtils.containsAny((Collection)value, (Collection)(compVal = (Set)compareRow.get(key)))) break;
                    ++duplicateCount;
                }
                if (duplicateCount < compareRow.size()) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5e8f\u53f7%1$s\u548c%2$s\u5b58\u5728\u90e8\u5206\u6216\u5168\u90e8\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AssistGroupFilterFormPlugin_1", (String)"fi-frm-formplugin", (Object[])new Object[0]), i + 1, j + 1));
            }
        }
        ReturnData returnData = new ReturnData();
        returnData.setStatus(true);
        if (resultList.size() > 0) {
            returnData.setDataStr(SerializationUtils.toJsonString(resultList));
            returnData.setMessage(resultShowName);
        }
        this.getView().returnDataToParent((Object)returnData);
        this.getView().close();
    }

    private void registerDynamicCol(MainEntityType mainEntityType, List<DSField> bizFields) {
        EntityType entryType = (EntityType)mainEntityType.getAllEntities().get(KEY_ENTRY);
        DataEntityPropertyCollection properties = entryType.getProperties();
        for (DSField field : bizFields) {
            if (AssistDataType.isBaseDataType((String)field.getDataType())) {
                MulBasedataProp prop = (MulBasedataProp)properties.get((Object)field.getFieldKey());
                prop.setBaseEntityId(field.getEntityId());
                prop.setDbIgnore(false);
                BasedataProp bPropMul = (BasedataProp)prop.getItemType().getProperties().get((Object)"fbasedataid");
                bPropMul.setBaseEntityId(field.getEntityId());
                MainEntityType newDT = EntityMetadataCache.getDataEntityType((String)field.getEntityId());
                bPropMul.setComplexType((IDataEntityType)newDT);
                DynamicProperty refProp = prop.getDynamicCollectionItemPropertyType().getProperty("fbasedataid_id");
                bPropMul.setRefIdProp((IDataEntityProperty)refProp);
                bPropMul.setRefIdPropName(refProp.getName());
                bPropMul.setDbIgnore(true);
                continue;
            }
            TextProp textProp = this.createAssistantProp(field);
        }
    }

    private void redrawColumns(List<DSField> bizFields, boolean needCreateProp) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(KEY_ENTRY);
        ArrayList<Map> cols = new ArrayList<Map>(6);
        cols.add(this.createSeqColumn());
        if (bizFields != null) {
            for (DSField field : bizFields) {
                EntryFieldAp col;
                if (AssistDataType.isBaseDataType((String)field.getDataType())) {
                    col = this.createBaseDataColumn(field);
                    cols.add((Map)col.createColumns().get(0));
                    continue;
                }
                col = this.createAsstantDataColumn(field);
                cols.add((Map)col.createColumns().get(0));
            }
        }
        if (needCreateProp) {
            HashMap<String, Object> meta = new HashMap<String, Object>(6);
            meta.put("rk", "rk");
            meta.put("seq", "seq");
            meta.put("columns", cols);
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.preInvokeControlMethod(KEY_ENTRY, "createGridColumns", new Object[]{meta});
        }
    }

    private EntryFieldAp createBaseDataColumn(DSField field) {
        EntryFieldAp f7Field = new EntryFieldAp();
        f7Field.setKey(field.getFieldKey());
        f7Field.setName(field.getFieldName());
        f7Field.setFieldTextAlign("left");
        f7Field.setTextAlign("left");
        f7Field.setAlignSelf("left");
        f7Field.setWidth(new LocaleString("150"));
        f7Field.setLock("");
        f7Field.setQuickAddNew(false);
        MulBasedataField bdField = new MulBasedataField();
        bdField.setId(field.getFieldKey());
        bdField.setKey(field.getFieldKey());
        bdField.setBaseEntityId(MetadataDao.getIdByNumber((String)field.getEntityId(), (MetaCategory)MetaCategory.Entity));
        bdField.setCacheLookUpList(true);
        bdField.setAllowAutoList(true);
        bdField.setMustInput(true);
        f7Field.setField((Field)bdField);
        List refProps = bdField.getRefProps();
        return f7Field;
    }

    private EntryFieldAp createAsstantDataColumn(DSField field) {
        EntryFieldAp f7Field = new EntryFieldAp();
        f7Field.setKey(field.getFieldKey());
        f7Field.setName(field.getFieldName());
        f7Field.setFieldTextAlign("left");
        f7Field.setTextAlign("left");
        f7Field.setAlignSelf("left");
        f7Field.setWidth(new LocaleString("150"));
        f7Field.setLock("");
        TextField adField = new TextField();
        adField.setId(field.getFieldKey());
        adField.setKey(field.getFieldKey());
        adField.setEditStyle(2);
        adField.setDefValue(" ");
        adField.setMustInput(true);
        f7Field.setField((Field)adField);
        return f7Field;
    }

    private TextProp createAssistantProp(DSField field) {
        TextProp prop = new TextProp();
        prop.setName(field.getFieldKey());
        prop.setDefValue((Object)"");
        prop.setDbIgnore(true);
        prop.setAlias("");
        prop.setMustInput(true);
        return prop;
    }

    private Map<String, Object> createSeqColumn() {
        HashMap<String, Object> col = new HashMap<String, Object>(5, 1.0f);
        col.put("dataIndex", "seq");
        col.put("width", "20px");
        col.put("header", "#");
        col.put("type", "numberfield");
        return col;
    }

    private static FormShowParameter buildFormShowParameter(List<String> messages) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(1);
        customParams.put("errorMsg", messages);
        customParams.put("title", ResManager.loadKDString((String)"\u4e1a\u52a1\u8fc7\u6ee4\u6821\u9a8c\u5931\u8d25", (String)"AssistGroupFilterFormPlugin_4", (String)"fi-frm-formplugin", (Object[])new Object[0]));
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("bos_operationresult");
        parameter.setCustomParams(customParams);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setShowTitle(false);
        return parameter;
    }
}

