/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin.export;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.util.StringUtils;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.enums.ReconcilationResultEnum;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.task.TaskStatusEnum;
import kd.fi.frm.common.util.MapUtil;
import kd.fi.frm.formplugin.util.ExportDetailService;
import org.apache.commons.collections4.MapUtils;

public class ExportTaskDownTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(ExportTaskDownTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> param) throws KDException {
        Object langObj = param.get("lang");
        if (langObj != null) {
            RequestContext.get().setLang(Lang.valueOf((String)langObj.toString()));
        }
        String paramModelStr = MapUtils.getString(param, (Object)"paramModel");
        ReconciliationParamModel paramModel = (ReconciliationParamModel)SerializationUtils.fromJsonString((String)paramModelStr, ReconciliationParamModel.class);
        String glassgrps = (String)param.get("glassgrps");
        boolean showAll = MapUtils.getBoolean(param, (Object)"showAll");
        boolean export = MapUtils.getBoolean(param, (Object)"export");
        boolean enableMore = MapUtils.getBoolean(param, (Object)"enableMore");
        long recPlanId = MapUtils.getLong(param, (Object)"recPlanId");
        String isRelation = MapUtils.getString(param, (Object)"isRelation");
        DynamicObject task = ExportDetailService.begin(paramModel, glassgrps, showAll, export, isRelation);
        String batchNo = task.getString("batchno");
        long recTaskId = task.getLong("id");
        int retryTimes = 0;
        while (!this.isUserStop() && retryTimes < 20) {
            int percent;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                logger.error("InterruptedException", (Throwable)e);
            }
            String taskCache = AppCacheHelper.getTaskCache((String)batchNo, (String)("" + recTaskId));
            if (StringUtils.isEmpty((String)taskCache)) {
                ++retryTimes;
                continue;
            }
            kd.fi.frm.common.task.TaskInfo taskInfo = (kd.fi.frm.common.task.TaskInfo)SerializationUtils.deSerializeFromBase64((String)taskCache);
            TaskStatusEnum taskStatus = taskInfo.getTaskStatus();
            int n = percent = taskInfo.getPercent() == null ? 0 : taskInfo.getPercent();
            if (percent >= 100) {
                percent = 98;
            }
            if (TaskStatusEnum.NOT_START == taskStatus) {
                this.feedbackProgress(0, taskStatus.getDisplayName(), null);
                continue;
            }
            if (TaskStatusEnum.ERROR == taskStatus || ReconcilationResultEnum.error == taskInfo.getCode()) {
                String[] error = taskInfo.getError();
                String errorDesc = ResManager.loadKDString((String)"\u5bfc\u51fa\u5f02\u5e38", (String)"ExportTaskDownTask_2", (String)"fi-frm-formplugin", (Object[])new Object[0]);
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("success", "false");
                if (error != null) {
                    result.put("msg", error[1]);
                } else {
                    result.put("msg", errorDesc);
                }
                this.feedbackProgress(taskInfo.getPercent(), errorDesc, result);
                return;
            }
            if (TaskStatusEnum.STOPPED == taskStatus) {
                this.feedbackProgress(percent, taskStatus.getDisplayName(), null);
                return;
            }
            if (TaskStatusEnum.DOING == taskStatus) {
                this.feedbackProgress(percent, taskStatus.getDisplayName(), null);
                continue;
            }
            HashMap result = MapUtil.newHashMap();
            try {
                String fileUrl = "";
                fileUrl = enableMore ? AppCacheHelper.getTaskCache((String)batchNo, (String)(recTaskId + ".detail.export")) : ExportDetailService.finish(paramModel, batchNo, String.valueOf(recTaskId), recPlanId, showAll);
                result.put("success", "true");
                result.put("downUrl", fileUrl);
            }
            catch (Throwable t) {
                result.put("success", "false");
                result.put("msg", t.getMessage());
            }
            this.feedbackCustomdata(result);
            return;
        }
    }

    protected boolean isUserStop() {
        boolean stop = this.isStop();
        if (stop) {
            this.stop();
        }
        return stop;
    }

    protected void feedbackProgress(int progress, String desc, Map<String, Object> customData) {
        super.feedbackProgress(progress, desc, customData);
    }

    public static void createAndDispatchTask(Map<String, Object> paramMap, IFormPlugin formPlugin, IFormView view) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("frm");
        jobInfo.setJobType(JobType.REALTIME);
        String jobId = String.valueOf(DB.genGlobalLongId());
        jobInfo.setName(ResManager.loadKDString((String)"\u5bf9\u8d26\u5dee\u5f02\u660e\u7ec6\u8868\u5bfc\u51fa", (String)"ExportTaskDownTask_3", (String)"fi-frm-formplugin", (Object[])new Object[0]));
        jobInfo.setId(jobId);
        jobInfo.setTaskClassname("kd.fi.frm.formplugin.export.ExportTaskDownTask");
        jobInfo.setCanStop(Boolean.valueOf(true));
        jobInfo.setParams(paramMap);
        CloseCallBack closeCallBack = new CloseCallBack(formPlugin, "taskcloseback");
        JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
        clientJobInfo.setCanBackground(true);
        clientJobInfo.setCanStop(true);
        clientJobInfo.setCloseCallBack(closeCallBack);
        clientJobInfo.setClickClassName("kd.fi.frm.formplugin.export.ExportTaskDownClick");
        JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)view);
    }

    public static void download(Map<String, Object> exportTaskResult, IFormView view) {
        TaskInfo taskInfo;
        String taskInfoStr;
        if (exportTaskResult == null) {
            return;
        }
        if (exportTaskResult.containsKey("taskinfo") && StringUtils.isNotEmpty((String)(taskInfoStr = (String)exportTaskResult.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
            String data = taskInfo.getData();
            if (StringUtils.isEmpty((String)data)) {
                logger.error("\u5bfc\u51fa\u4efb\u52a1\u8fd4\u56dedata\u4e3a\u7a7a\uff0ctaskInfo = {}", (Object)taskInfoStr);
                view.showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u8d26\u5dee\u5f02\u660e\u7ec6\u8868\u5bfc\u51fa\u5f02\u5e38\uff0c\u6253\u5f00\u5bf9\u8d26\u4efb\u52a1\u67e5\u770b\u539f\u56e0", (String)"ExportTaskDownTask_4", (String)"fi-frm-formplugin", (Object[])new Object[0]));
                return;
            }
            Map downData = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
            String success = (String)downData.get("success");
            if (StringUtils.isNotEmpty((String)success) && "false".equalsIgnoreCase(success)) {
                String msg = (String)downData.get("msg");
                if (StringUtils.isEmpty((String)msg)) {
                    msg = ResManager.loadKDString((String)"\u5bf9\u8d26\u5dee\u5f02\u660e\u7ec6\u8868\u5bfc\u51fa\u5f02\u5e38\uff0c\u6253\u5f00\u5bf9\u8d26\u4efb\u52a1\u67e5\u770b\u539f\u56e0", (String)"ExportTaskDownTask_4", (String)"fi-frm-formplugin", (Object[])new Object[0]);
                }
                view.showMessage(msg);
                return;
            }
            String downUrl = (String)downData.get("downUrl");
            if (StringUtils.isNotEmpty((String)downUrl)) {
                view.download(downUrl);
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"\u5bf9\u8d26\u5dee\u5f02\u660e\u7ec6\u8868\u5bfc\u51fa\u5f02\u5e38\uff0c\u6253\u5f00\u5bf9\u8d26\u4efb\u52a1\u67e5\u770b\u539f\u56e0", (String)"ExportTaskDownTask_4", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

