/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin.reportcfg;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.frm.mservice.rpt.RptApplyType;

public class RptReconAppEditPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        BasedataEdit assistAcct = (BasedataEdit)this.getControl("bizapp");
        assistAcct.addBeforeF7SelectListener(this::bizAppF7Filter);
    }

    private void bizAppF7Filter(BeforeF7SelectEvent evt) {
        boolean isGl = (Boolean)this.getModel().getValue("isgl");
        if (!isGl) {
            List filters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
            filters.add(new QFilter("number", "!=", (Object)"gl"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        boolean isgl = false;
        if (parentView != null) {
            String isglStr = parentView.getPageCache().get("isgl");
            isgl = Boolean.parseBoolean(isglStr);
        }
        this.getModel().setValue("isgl", (Object)isgl);
        if (!isgl) {
            String appid = (String)this.getModel().getValue("appid");
            this.getModel().setValue("bizapp", (Object)appid);
        } else {
            this.setAndLockGlNumber(isgl);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        boolean isgl = (Boolean)this.getModel().getValue("isgl");
        String appid = (String)this.getModel().getValue("appid");
        this.getModel().beginInit();
        this.getModel().setValue("bizapp", (Object)appid);
        this.getModel().endInit();
        this.getModel().setDataChanged(false);
        this.buildApplyTypeItems(isgl);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        if ("bizapp".equals(key)) {
            if (newValue == null) {
                this.getModel().setValue("number", null);
                this.getModel().setValue("name", null);
                this.getModel().setValue("appid", null);
            } else {
                DynamicObject originsys = (DynamicObject)this.getModel().getValue("originsys");
                String prefix = "";
                if (originsys != null) {
                    prefix = originsys.getString("number") + "_";
                }
                DynamicObject bizApp = (DynamicObject)newValue;
                this.getModel().setValue("number", (Object)bizApp.getString("number"));
                this.getModel().setValue("name", (Object)bizApp.getString("name"));
                this.getModel().setValue("appid", (Object)bizApp.getString("id"));
                Object originSys = this.getModel().getValue("originsys");
                Object originSysPkObj = ((DynamicObject)originSys).getPkValue();
                long originSysId = Long.parseLong(String.valueOf(originSysPkObj));
                if (100000L == originSysId) {
                    this.getModel().setValue("number", (Object)bizApp.getString("number"));
                    this.updateNumber(bizApp.getString("number"), false);
                } else {
                    this.updateNumber(prefix + bizApp.getString("number"), true);
                }
            }
        } else if ("isgl".equals(key)) {
            boolean isGlFlag = (Boolean)newValue;
            this.buildApplyTypeItems(isGlFlag);
            this.setAndLockGlNumber(isGlFlag);
        } else if ("originsys".equals(key)) {
            this.setAndLockGlNumberByOrginSys();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operateInfo = (FormOperate)args.getSource();
        String keyName = operateInfo.getOperateKey();
        if ("deleteentry".equals(keyName)) {
            int[] selectRows;
            EntryGrid grid = (EntryGrid)this.getView().getControl("pluginentry");
            for (int rowIndex : selectRows = grid.getSelectRows()) {
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("pluginentry", rowIndex);
                boolean pluginpreset = rowEntity.getBoolean("pluginpreset");
                if (!pluginpreset) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"RptReconAppEditPlugin_1", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void setAndLockGlNumberByOrginSys() {
        Object originSys = this.getModel().getValue("originsys");
        if (originSys == null) {
            this.updateNumber(null, true);
            return;
        }
        Object originSysPkObj = ((DynamicObject)originSys).getPkValue();
        long originSysId = Long.parseLong(String.valueOf(originSysPkObj));
        boolean isGlFlag = (Boolean)this.getModel().getValue("isgl");
        if (100000L == originSysId && isGlFlag) {
            this.updateNumber("gl", false);
        } else if (isGlFlag) {
            String oldNumber = (String)this.getModel().getValue("number");
            this.updateNumber(oldNumber, true);
        } else if (100000L == originSysId) {
            Object bizApp = this.getModel().getValue("bizapp");
            if (bizApp != null) {
                Object number = ((DynamicObject)bizApp).get("number");
                this.updateNumber(String.valueOf(number), false);
            }
        } else {
            this.updateNumber(null, true);
        }
    }

    private void updateNumber(String value, boolean enable) {
        this.getModel().setValue("number", (Object)value);
        this.getView().setEnable(Boolean.valueOf(enable), new String[]{"number"});
    }

    private void buildApplyTypeItems(boolean isgl) {
        ComboEdit applyTypeEdit = (ComboEdit)this.getControl("applytype");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(4);
        for (RptApplyType item : RptApplyType.getItems((boolean)isgl)) {
            ComboItem comboItem = new ComboItem(new LocaleString(item.getDisplayName()), item.getVal());
            items.add(comboItem);
        }
        applyTypeEdit.setComboItems(items);
    }

    private void setAndLockGlNumber(boolean isGlFlag) {
        Object originSys = this.getModel().getValue("originsys");
        if (originSys == null) {
            this.updateNumber(null, true);
            return;
        }
        Object originSysPkObj = ((DynamicObject)originSys).getPkValue();
        long originSysId = Long.parseLong(String.valueOf(originSysPkObj));
        if (100000L == originSysId && isGlFlag) {
            this.updateNumber("gl", false);
        } else if (100000L == originSysId) {
            Object bizApp = this.getModel().getValue("bizapp");
            if (bizApp != null) {
                Object number = ((DynamicObject)bizApp).get("number");
                this.updateNumber(String.valueOf(number), false);
            }
        } else {
            this.updateNumber(null, true);
        }
    }
}

