/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin.task;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.task.TaskInfo;
import kd.fi.frm.common.task.TaskStatusEnum;
import kd.fi.frm.common.util.DateUtil;
import kd.fi.frm.formplugin.task.StartNewTaskHandler;

public class FrmTaskFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid planEntry = (EntryGrid)this.getControl("planentry");
        final IDataModel model = this.getModel();
        final IFormView view = this.getView();
        planEntry.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                FrmTaskFormPlugin.this.getModel().beginInit();
                FrmTaskFormPlugin.this.calculateEntrySpendTime("ruleentry", "detailbegin", "detailend", "detaitime");
                FrmTaskFormPlugin.this.getModel().endInit();
                view.updateView("ruleentry");
                model.setDataChanged(false);
            }
        });
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().beginInit();
        this.calculateSpendTime(this.getModel().getDataEntity(), "begintime", "endtime", "timespentdesc");
        this.calculateEntrySpendTime("planentry", "entrybegin", "entryend", "entrytime");
        this.calculateEntrySpendTime("ruleentry", "detailbegin", "detailend", "detaitime");
        this.updatePercent();
        this.getModel().endInit();
        this.getView().updateView("fs_baseinfo");
        this.getView().updateView("planentry");
        this.getView().updateView("ruleentry");
        this.getView().updateView("task_detail");
        this.getModel().setDataChanged(false);
    }

    private void calculateEntrySpendTime(String entryName, String beginField, String endField, String spendField) {
        DynamicObjectCollection planEntity = this.getModel().getEntryEntity(entryName);
        if (planEntity == null || planEntity.size() == 0) {
            return;
        }
        for (DynamicObject dynamicObject : planEntity) {
            this.calculateSpendTime(dynamicObject, beginField, endField, spendField);
        }
    }

    private void calculateSpendTime(DynamicObject dynamicObject, String beginField, String endField, String spendField) {
        Date startTime = dynamicObject.getDate(beginField) != null ? dynamicObject.getDate(beginField) : new Date();
        Date endTime = dynamicObject.getDate(endField) != null ? dynamicObject.getDate(endField) : new Date();
        dynamicObject.set(spendField, (Object)DateUtil.getPeriodStr((Date)startTime, (Date)endTime));
    }

    private void updatePercent() {
        String taskStatus = String.valueOf(this.getModel().getValue("taskstatus"));
        if (TaskStatusEnum.DOING.getValue().equals(taskStatus)) {
            String taskId = String.valueOf(this.getModel().getValue("id"));
            String batchNo = String.valueOf(this.getModel().getValue("batchno"));
            if (batchNo == null || taskId == null) {
                return;
            }
            String cacheTaskStr = AppCacheHelper.getTaskCache((String)batchNo, (String)taskId);
            if (StringUtils.isEmpty((String)cacheTaskStr)) {
                return;
            }
            TaskInfo cacheTaskInfo = (TaskInfo)SerializationUtils.deSerializeFromBase64((String)cacheTaskStr);
            Integer taskPercent = cacheTaskInfo.getPercent();
            this.getModel().setValue("percent", (Object)taskPercent);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("bar_recon".equals(key)) {
            this.startNewTask();
        }
    }

    private void startNewTask() {
        IDataModel model = this.getModel();
        DynamicObject reconPlan = (DynamicObject)model.getValue("reconplan");
        DynamicObject bizApp = (DynamicObject)model.getValue("bizapp");
        DynamicObject period = (DynamicObject)model.getValue("period");
        StartNewTaskHandler startNewTaskHandler = new StartNewTaskHandler(this.getView(), model.getValue("apiparam_tag"), String.valueOf(model.getValue("batchno")), Long.parseLong(String.valueOf(model.getValue("id"))), String.valueOf(model.getValue("reconresulttype")), period, bizApp, reconPlan);
        startNewTaskHandler.startNewTask();
    }
}

