/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin.task;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.frm.formplugin.task.FrmTaskProvider;
import kd.fi.frm.formplugin.task.StartNewTaskHandler;

public class FrmTaskListPlugin
extends AbstractListPlugin {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new FrmTaskProvider());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().getPageCache().put("pageCacheShiftMBtn", "frmfunction,faparam,loadjarinfo,bar_recon");
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("frmfunction".equals(key)) {
            this.showFrmFunction();
        } else if ("faparam".equals(key)) {
            this.showFaParam();
        } else if ("loadjarinfo".equals(key)) {
            this.showJarInfo();
        } else if ("bar_recon".equals(key)) {
            this.startNewTask();
        }
    }

    private void showJarInfo() {
        Manifest jarManifest = this.getJarManifest(((Object)((Object)this)).getClass());
        String message = "";
        if (jarManifest != null) {
            Attributes mainAttributes = jarManifest.getMainAttributes();
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<Object, Object> entry : mainAttributes.entrySet()) {
                stringBuilder.append(entry.getKey()).append(":").append(entry.getValue()).append("\r\n");
            }
            message = stringBuilder.toString();
        } else {
            message = "Jar info is null";
        }
        HashMap<String, String> customParams = new HashMap<String, String>(1);
        customParams.put("errorMsg", message);
        customParams.put("title", "Jar info");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_operationresult");
        showParameter.setCustomParams(customParams);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setShowTitle(false);
        this.getView().showForm(showParameter);
    }

    private Manifest getJarManifest(Class<?> clazz) {
        ArrayList<URL> resourceUrls = new ArrayList<URL>();
        ClassLoader classLoader = clazz.getClassLoader();
        String sourceName = clazz.getName().replace('.', '/').concat(".class");
        try {
            Enumeration<URL> resources = classLoader.getResources(sourceName);
            while (resources.hasMoreElements()) {
                resourceUrls.add(resources.nextElement());
            }
            if (resourceUrls.size() > 1) {
                return null;
            }
            if (resourceUrls.size() > 0) {
                URL url = (URL)resourceUrls.get(0);
                URLConnection urlConnection = url.openConnection();
                if (urlConnection instanceof JarURLConnection) {
                    JarURLConnection jarUrl = (JarURLConnection)urlConnection;
                    JarFile jarFile = jarUrl.getJarFile();
                    Manifest manifest = jarFile.getManifest();
                    jarFile.close();
                    return manifest;
                }
                return null;
            }
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        return null;
    }

    private void showFrmFunction() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("frm_function");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showFaParam() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("fa_billparam");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setHasRight(true);
        showParameter.setCustomParam("bizcloud", (Object)"83bfebc8000002ac");
        showParameter.setCustomParam("bizapp", (Object)"1VUEMJU4W57X");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void startNewTask() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        if (selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u5bf9\u8d26\u4efb\u52a1\uff0c\u518d\u53d1\u8d77\u91cd\u65b0\u5bf9\u8d26\u3002", (String)"FrmTaskListPlugin_0", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
        String selectFields = "apiparam_tag,batchno,id,reconresulttype,period,bizapp,reconplan";
        DynamicObject task = BusinessDataServiceHelper.loadSingleFromCache((String)"frm_task", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
        if (task == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bf9\u8d26\u4efb\u52a1\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u8bd5\u3002", (String)"FrmTaskListPlugin_1", (String)"fi-frm-formplugin", (Object[])new Object[0]));
            return;
        }
        StartNewTaskHandler startNewTaskHandler = new StartNewTaskHandler(this.getView(), task.get("apiparam_tag"), task.getString("batchno"), task.getLong("id"), task.getString("reconresulttype"), task.getDynamicObject("period"), task.getDynamicObject("bizapp"), task.getDynamicObject("reconplan"));
        startNewTaskHandler.startNewTask();
    }
}

