/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin.task;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.util.StringUtils;
import kd.fi.frm.common.cache.frm.AppCacheHelper;
import kd.fi.frm.common.task.TaskInfo;
import kd.fi.frm.common.task.TaskStatusEnum;
import kd.fi.frm.common.util.DateUtil;

public class FrmTaskProvider
extends ListDataProvider {
    private static final String TIME_SPENT_DESC = "timespentdesc";

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection rows = super.getData(start, limit);
        rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty(TIME_SPENT_DESC, String.class, (Object)""));
        for (DynamicObject row : rows) {
            String cacheTaskStr;
            if (TaskStatusEnum.STOPPED.getValue().equals(row.getString("taskstatus")) && row.getDate("endtime") == null) continue;
            Date startTime = row.getDate("begintime") != null ? row.getDate("begintime") : (row.getDate("createtime") != null ? row.getDate("createtime") : new Date());
            Date endTime = row.getDate("endtime") != null ? row.getDate("endtime") : new Date();
            row.set(TIME_SPENT_DESC, (Object)DateUtil.getPeriodStr((Date)startTime, (Date)endTime));
            String taskStatus = row.getString("taskstatus");
            if (!TaskStatusEnum.DOING.getValue().equals(taskStatus)) continue;
            String taskId = row.getString("id");
            String batchNo = row.getString("batchno");
            if (batchNo == null || taskId == null || StringUtils.isEmpty((String)(cacheTaskStr = AppCacheHelper.getTaskCache((String)batchNo, (String)taskId)))) continue;
            TaskInfo cacheTaskInfo = (TaskInfo)SerializationUtils.deSerializeFromBase64((String)cacheTaskStr);
            Integer taskPercent = cacheTaskInfo.getPercent();
            row.set("percent", (Object)taskPercent);
        }
        return rows;
    }
}

