/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.fi.frm.common.cache.gl.CacheHelper;
import kd.fi.frm.common.util.ThrowableHelper;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExportDataSetUtil {
    private static final DateFormat SHORT_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat LONG_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static void export(DataSet ds, IFormView formView) {
        RowMeta rowMeta = ds.getRowMeta();
        Iterator iterator = ds.iterator();
        ExportDataSetUtil.export(rowMeta, iterator, formView);
    }

    public static void export(RowMeta rowMeta, Iterator<Row> rowIterator, IFormView formView) {
        SXSSFWorkbook wb = new SXSSFWorkbook(1000);
        wb.setCompressTempFiles(true);
        CellStyle CELL_STYLE_LEFT = wb.createCellStyle();
        CellStyle CELL_STYLE_RIGHT = wb.createCellStyle();
        CELL_STYLE_LEFT.setAlignment(HorizontalAlignment.LEFT);
        CELL_STYLE_RIGHT.setAlignment(HorizontalAlignment.RIGHT);
        int countPerSheet = 100000;
        int sheetIndex = 1;
        int i = 0;
        Field[] fields = rowMeta.getFields();
        SXSSFSheet sheet = null;
        while (rowIterator.hasNext()) {
            Row row = rowIterator.next();
            int j = i % countPerSheet;
            if (j == 0) {
                sheet = wb.createSheet("sheet" + sheetIndex++);
                ExportDataSetUtil.setTableHead(wb, sheet, fields, CELL_STYLE_LEFT);
            }
            ExportDataSetUtil.setTableBody(wb, sheet, fields, row, j + 1, CELL_STYLE_LEFT, CELL_STYLE_RIGHT);
            ++i;
        }
        try {
            String url = ExportDataSetUtil.writeFile(wb, "DataSet");
            ExportDataSetUtil.openUrl(url, formView);
        }
        catch (IOException e) {
            throw new KDException(ThrowableHelper.toString((Exception)e));
        }
    }

    private static void setTableBody(SXSSFWorkbook wb, SXSSFSheet sheet, Field[] fields, Row dataRow, int rowIndex, CellStyle CELL_STYLE_CENTER, CellStyle CELL_STYLE_RIGHT) {
        SXSSFRow row = sheet.createRow(rowIndex);
        SXSSFCell seqSell = row.createCell(0);
        seqSell.setCellValue(rowIndex + "");
        seqSell.setCellStyle(CELL_STYLE_CENTER);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int cellIndex = i + 1;
            SXSSFCell cell = row.createCell(cellIndex);
            Object value = dataRow.get(field.getName());
            CellStyle cellStyle = CELL_STYLE_CENTER;
            DataType dataType = field.getDataType();
            if (DataType.IntegerType.equals((Object)dataType)) {
                cellStyle = CELL_STYLE_RIGHT;
                if (value != null) {
                    cell.setCellValue(Double.parseDouble(value.toString()));
                }
            } else if (DataType.LongType.equals((Object)dataType)) {
                cellStyle = CELL_STYLE_RIGHT;
                if (value != null) {
                    cell.setCellValue(value.toString());
                }
            } else if (DataType.BigDecimalType.equals((Object)dataType)) {
                cellStyle = CELL_STYLE_RIGHT;
                if (value != null) {
                    cell.setCellValue(Double.parseDouble(value.toString()));
                }
            } else if (DataType.DateType.equals((Object)dataType)) {
                if ((value = SHORT_DATE_FORMATTER.format((Date)value)) != null) {
                    cell.setCellValue(value.toString());
                }
            } else if (DataType.TimestampType.equals((Object)dataType)) {
                if ((value = LONG_DATE_FORMATTER.format((Date)value)) != null) {
                    cell.setCellValue(value.toString());
                }
            } else if (value != null) {
                cell.setCellValue(value.toString());
            }
            cell.setCellStyle(cellStyle);
        }
    }

    private static void setTableHead(SXSSFWorkbook wb, SXSSFSheet sheet, Field[] fields, CellStyle CELL_STYLE_CENTER) {
        SXSSFRow row = sheet.createRow(0);
        SXSSFCell seqSell = row.createCell(0);
        seqSell.setCellValue("#");
        seqSell.setCellStyle(CELL_STYLE_CENTER);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int cellIndex = i + 1;
            SXSSFCell cell = row.createCell(cellIndex);
            cell.setCellValue(field.getName());
            cell.setCellStyle(CELL_STYLE_CENTER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String writeFile(SXSSFWorkbook wb, String formName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheHelper.getTempFileCache().saveAsUrl(ExportDataSetUtil.getTempFilename(formName), (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    private static String getTempFilename(String formName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmssSSS");
        String currDateTime = dateFormat.format(new Date());
        String userName = RequestContext.get().getUserName();
        return formName + "-" + currDateTime + "-" + userName + ".xlsx";
    }

    private static void openUrl(String url, IFormView formView) {
        formView.download(url);
    }
}

