/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.property.TreeEntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.frm.common.enums.DataTypeEnum;
import kd.fi.frm.common.model.ReconciliationParamModel;
import kd.fi.frm.common.model2.RelationDataParam3;
import kd.fi.frm.common.mq.ReconciliationPublish;
import kd.fi.frm.common.task.TaskDao;
import kd.fi.frm.common.util.ReconciliationUtil;
import kd.fi.frm.formplugin.ReconciliationAssistDetailExportUtil;
import kd.fi.frm.mservice.gldata.DetailDataFormat;

public class ExportDetailService {
    public static DynamicObject begin(ReconciliationParamModel paramModel, String glassgrps, boolean showAll, boolean export, Object isRelation) {
        RelationDataParam3 glParam = ExportDetailService.getGLParam(paramModel, glassgrps);
        glParam.setShowAll(showAll);
        glParam.setExport(export);
        glParam.setRelation(isRelation != null && "1".equals(isRelation.toString()));
        long orgId = (Long)paramModel.getOrgIds().iterator().next();
        String appId = (String)paramModel.getAppIds().iterator().next();
        DynamicObject task = TaskDao.buildTask((long)orgId, (String)appId, (ReconciliationParamModel)paramModel);
        TaskDao.addNew((DynamicObject)task, () -> {
            ReconciliationPublish publish = new ReconciliationPublish();
            publish.setParamModel(paramModel);
            publish.setGlParam(glParam);
            return publish;
        });
        return task;
    }

    public static RelationDataParam3 getGLParam(ReconciliationParamModel paramModel, String glassgrps) {
        paramModel.setDataType(DataTypeEnum.Detail);
        String appId = paramModel.getAppIds().toArray(new String[0])[0];
        Long orgId = paramModel.getOrgIds().toArray(new Long[0])[0];
        Long bookTypeId = paramModel.getBookTypeId();
        Long periodId = paramModel.getPeriodId();
        Set accountIds = paramModel.getAccountIds();
        Long planDetailId = paramModel.getPlanDetailId();
        RelationDataParam3 glParam = new RelationDataParam3();
        glParam.setId(planDetailId.longValue());
        glParam.setAccountIds(accountIds);
        glParam.setAcctBookTypeID(bookTypeId.longValue());
        glParam.setAcctOrgID(orgId.longValue());
        glParam.setAppId(appId);
        glParam.setPeriodid(periodId.longValue());
        glParam.setCurrency(paramModel.getCurrency());
        String assist = paramModel.getAssist();
        if (StringUtils.isNotEmpty((String)assist)) {
            Map map = (Map)SerializationUtils.fromJsonString((String)assist, Map.class);
            HashMap assistMap = new HashMap(map.size());
            for (Map.Entry entry : map.entrySet()) {
                HashSet<Long> assistIdSet = new HashSet<Long>(((List)entry.getValue()).size());
                for (Object idObj : (List)entry.getValue()) {
                    assistIdSet.add(Long.parseLong(String.valueOf(idObj)));
                }
                assistMap.put(entry.getKey(), assistIdSet);
            }
            glParam.setAssistMap(assistMap);
        }
        if (StringUtils.isNotEmpty((String)glassgrps)) {
            String[] split = glassgrps.split(",");
            HashSet<Long> assgrpSet = new HashSet<Long>(split.length);
            for (String id : split) {
                assgrpSet.add(Long.valueOf(id));
            }
            glParam.setAssgrpSet(assgrpSet);
        }
        Map bizAssistMap = ReconciliationUtil.getBizAssistMap((String)paramModel.getBizAssistTable());
        glParam.setBizAssistMap(bizAssistMap);
        glParam.setAccountTableId(paramModel.getAccountTable());
        return glParam;
    }

    public static String finish(ReconciliationParamModel paramModel, String batchNo, String taskId, Long recPlanId, boolean showAll) {
        Map<String, String> acctNameMap = ExportDetailService.getAcctNameMap(paramModel);
        DataSet exportDataSet = DetailDataFormat.getExportDataSet((boolean)false, (String)taskId, (String)batchNo, (Long)recPlanId, (ReconciliationParamModel)paramModel, (boolean)showAll);
        if (exportDataSet == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u5dee\u5f02\u6570\u636e\uff0c\u4e0d\u80fd\u5bfc\u51fa\u3002", (String)"ReconciliactionAssistResultFormPlugin_20", (String)"fi-frm-formplugin", (Object[])new Object[0]));
        }
        ReconciliationAssistDetailExportUtil exportUtil = new ReconciliationAssistDetailExportUtil();
        DataEntityPropertyCollection propetyCol = ((TreeEntryProp)MetadataServiceHelper.getDataEntityType((String)"frm_rec_detail").getProperty("entryentity")).getDynamicCollectionItemPropertyType().getProperties();
        Long currencyId = paramModel.getCurrency();
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
        ArrayList<Row> exportRow = new ArrayList<Row>(1000);
        Map<Long, DynamicObject> billOrgMap = ExportDetailService.getBillOrgMap(exportDataSet, exportRow);
        String url = exportUtil.export(exportRow, propetyCol, currency, acctNameMap, billOrgMap);
        return url;
    }

    public static Map<String, String> getAcctNameMap(ReconciliationParamModel paramModel) {
        HashMap<String, String> acctNameMap = null;
        Set acctIds = paramModel.getAccountIds();
        if (acctIds.size() > 0) {
            HashSet acctMasterSet = new HashSet(12);
            ReconciliationUtil.getDetailAccountId((Long)paramModel.getOrgIds().toArray(new Long[0])[0], (Long)paramModel.getAccountTable(), (Long)paramModel.getPeriodId(), (Set)acctIds, new HashSet(12), acctMasterSet);
            Set accountIdSet = ReconciliationUtil.getAccountIdByMasterId(acctMasterSet);
            acctNameMap = new HashMap<String, String>(accountIdSet.size());
            QFilter accountIdFilter = new QFilter("id", "in", (Object)accountIdSet);
            DataSet accountDataSet = QueryServiceHelper.queryDataSet((String)ReconciliationUtil.class.getName(), (String)"bd_accountview", (String)"id,number,name", (QFilter[])new QFilter[]{accountIdFilter}, null);
            while (accountDataSet.hasNext()) {
                Row row = accountDataSet.next();
                acctNameMap.put(row.getString("id"), row.getString("number") + "," + row.getString("name"));
            }
        }
        return acctNameMap;
    }

    public static Map<Long, DynamicObject> getBillOrgMap(DataSet exportDataSet, List<Row> exportRow) {
        HashSet<Long> queryBillOrgIds = new HashSet<Long>(10);
        for (Row row : exportDataSet) {
            exportRow.add(row);
            Long billorg = row.getLong("billorg");
            if (billorg == null || billorg == 0L) continue;
            queryBillOrgIds.add(billorg);
        }
        DynamicObject[] billOrgs = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", queryBillOrgIds)});
        return Arrays.stream(billOrgs).collect(Collectors.toMap(org -> org.getLong("id"), org -> org));
    }
}

