/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.frm.formplugin.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.util.ExceptionUtils;
import kd.fi.frm.common.cache.gl.CacheHelper;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class ExportUtil {
    public void openUrl(String url, IFormView formView) {
        formView.download(url);
    }

    public String export(DynamicObjectCollection dataRows, List<String> fieldList, String caption) {
        SXSSFWorkbook wb = new SXSSFWorkbook(1000);
        wb.setCompressTempFiles(true);
        SXSSFSheet sheet = wb.createSheet("sheet1");
        this.setTable(wb, sheet, dataRows, fieldList);
        try {
            return this.writeFile(wb, caption);
        }
        catch (IOException e) {
            throw new KDBizException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    public void setTable(SXSSFWorkbook wb, SXSSFSheet sheet, DynamicObjectCollection dataRows, List<String> fieldList) {
        ArrayList typeList = new ArrayList(fieldList.size());
        CellStyle style = this.getHeadColumnStyle(wb);
        style.setAlignment(HorizontalAlignment.CENTER);
        SXSSFRow row = sheet.createRow(0);
        SXSSFRow row1 = sheet.createRow(1);
        DataEntityPropertyCollection propetyCol = dataRows.getDynamicObjectType().getProperties();
        DataFormat dataFormat = wb.createDataFormat();
        boolean flag = false;
        for (int i = 0; i < fieldList.size(); ++i) {
            String number = fieldList.get(i);
            DynamicProperty property = (DynamicProperty)propetyCol.get((Object)number);
            if (property == null && "accountnumber".equals(number)) {
                property = new FieldProp();
                property.setDisplayName(new LocaleString(ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801", (String)"ExportUtil_6", (String)"fi-frm-formplugin", (Object[])new Object[0])));
            }
            SXSSFCell cell = row.createCell(i);
            switch (number) {
                case "init_app": {
                    cell.setCellValue((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4f59\u989d", (String)"ExportUtil_7", (String)"fi-frm-formplugin", (Object[])new Object[0])));
                    CellRangeAddress cellRange0 = new CellRangeAddress(0, 0, (int)((short)i), (short)i + 2);
                    sheet.addMergedRegion(cellRange0);
                    flag = true;
                    break;
                }
                case "openingbalance_app": {
                    cell.setCellValue((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d", (String)"ExportUtil_8", (String)"fi-frm-formplugin", (Object[])new Object[0])));
                    CellRangeAddress cellRange1 = new CellRangeAddress(0, 0, (int)((short)i), (short)i + 2);
                    sheet.addMergedRegion(cellRange1);
                    flag = true;
                    break;
                }
                case "debitamount_app": {
                    cell.setCellValue((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"\u501f\u65b9\u91d1\u989d", (String)"ExportUtil_9", (String)"fi-frm-formplugin", (Object[])new Object[0])));
                    CellRangeAddress cellRange2 = new CellRangeAddress(0, 0, (int)((short)i), (short)i + 2);
                    sheet.addMergedRegion(cellRange2);
                    if (flag) break;
                    flag = true;
                    break;
                }
                case "creditamount_app": {
                    cell.setCellValue((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"\u8d37\u65b9\u91d1\u989d", (String)"ExportUtil_10", (String)"fi-frm-formplugin", (Object[])new Object[0])));
                    CellRangeAddress cellRange3 = new CellRangeAddress(0, 0, (int)((short)i), (short)i + 2);
                    sheet.addMergedRegion(cellRange3);
                    if (flag) break;
                    flag = true;
                    break;
                }
                case "closingbalance_app": {
                    cell.setCellValue((RichTextString)new XSSFRichTextString(ResManager.loadKDString((String)"\u671f\u672b\u4f59\u989d", (String)"ExportUtil_11", (String)"fi-frm-formplugin", (Object[])new Object[0])));
                    CellRangeAddress cellRange4 = new CellRangeAddress(0, 0, (int)((short)i), (short)i + 2);
                    sheet.addMergedRegion(cellRange4);
                    break;
                }
            }
            if (property != null) {
                LocaleString name = property.getDisplayName();
                if (flag) {
                    SXSSFCell cell1 = row1.createCell(i);
                    cell1.setCellValue(name.getLocaleValue());
                } else {
                    cell.setCellValue(name.getLocaleValue());
                    CellRangeAddress cellRange = new CellRangeAddress(0, 1, (int)((short)i), (int)((short)i));
                    sheet.addMergedRegion(cellRange);
                }
            }
            HashMap<String, String> typeMap = new HashMap<String, String>(2);
            if (property instanceof AmountProp) {
                typeMap.put("type", "AmountProp");
            } else if (property instanceof ComboProp) {
                typeMap.put("type", "ComboProp");
            } else if (property instanceof BasedataProp) {
                typeMap.put("type", "BasedataProp");
            } else if (property instanceof FieldProp) {
                typeMap.put("type", "FieldProp");
            } else if (property instanceof MulBasedataProp) {
                typeMap.put("type", "MulBasedataProp");
            }
            typeMap.put("number", number);
            typeList.add(typeMap);
            cell.setCellStyle(style);
        }
        for (int h = 0; h < dataRows.size(); ++h) {
            SXSSFRow createRow = sheet.createRow(h + 2);
            DynamicObject dyn = (DynamicObject)dataRows.get(h);
            DynamicObject currency = dyn.getDynamicObject("currency");
            for (int i = 0; i < typeList.size(); ++i) {
                StringBuilder sbValue;
                DynamicObjectCollection dyAccount;
                SXSSFCell cell = createRow.createCell(i);
                String number = (String)((Map)typeList.get(i)).get("number");
                String type = (String)((Map)typeList.get(i)).get("type");
                String value = "";
                if ("FieldProp".equals(type)) {
                    if ("accountnumber".equals(number)) {
                        dyAccount = dyn.getDynamicObjectCollection("account");
                        if (dyAccount != null && !dyAccount.isEmpty()) {
                            sbValue = new StringBuilder();
                            dyAccount.forEach(p -> sbValue.append(p.getDynamicObject("fbasedataid").getString("number")).append(','));
                            if (sbValue.length() > 0) {
                                sbValue.deleteCharAt(sbValue.length() - 1);
                            }
                            value = sbValue.toString();
                        }
                    } else {
                        value = dyn.getString(number);
                    }
                } else if ("BasedataProp".equals(type)) {
                    DynamicObject dynamicObject = dyn.getDynamicObject(number);
                    value = dynamicObject == null ? "" : dynamicObject.getString("name");
                } else if ("AmountProp".equals(type)) {
                    value = dyn.getString(number);
                    if (StringUtils.isBlank((CharSequence)value) || "0E-10".equals(value) || Double.parseDouble(value) == 0.0) {
                        value = "";
                    } else if (currency != null) {
                        ExportUtil.setCurrencyFormat(dataFormat, style, currency);
                    }
                } else if ("ComboProp".equals(type)) {
                    value = dyn.getString(number);
                    ComboProp comboProp = (ComboProp)propetyCol.get((Object)number);
                    List comboItems = comboProp.getComboItems();
                    String name = value;
                    for (ValueMapItem comboItem : comboItems) {
                        if (!comboItem.getValue().equals(value)) continue;
                        name = comboItem.getName().getLocaleValue();
                    }
                    value = name;
                } else if ("MulBasedataProp".equals(type) && (dyAccount = dyn.getDynamicObjectCollection(number)) != null && !dyAccount.isEmpty()) {
                    sbValue = new StringBuilder();
                    dyAccount.forEach(p -> sbValue.append(p.getDynamicObject("fbasedataid").getString("name")).append(','));
                    if (sbValue.length() > 0) {
                        sbValue.deleteCharAt(sbValue.length() - 1);
                    }
                    value = sbValue.toString();
                }
                if ("AmountProp".equals(type) && !StringUtils.isEmpty((CharSequence)value)) {
                    cell.setCellValue(Double.parseDouble(value));
                } else {
                    cell.setCellValue(value);
                }
                cell.setCellStyle(style);
            }
        }
    }

    public static void setCurrencyFormat(DataFormat dataFormat, CellStyle style, DynamicObject currency) {
        int amt = 2;
        if (currency != null) {
            amt = currency.getInt("amtprecision");
        }
        StringBuilder formatBuilder = new StringBuilder("#,##0.");
        for (int i = 0; i < amt; ++i) {
            formatBuilder.append(0);
        }
        style.setDataFormat(dataFormat.getFormat(formatBuilder.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(SXSSFWorkbook wb, String formName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheHelper.getTempFileCache().saveAsUrl(this.getTempFilename(formName), (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    protected String getTempFilename(String formName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmssSSS");
        String currDateTime = dateFormat.format(new Date());
        String userName = RequestContext.get().getUserName();
        return formName + "-" + currDateTime + "-" + userName + ".xlsx";
    }

    public CellStyle getHeadColumnStyle(SXSSFWorkbook wb) {
        CellStyle headColumnStyle = wb.createCellStyle();
        if (headColumnStyle == null) {
            headColumnStyle = wb.createCellStyle();
            headColumnStyle.setBorderBottom(BorderStyle.THIN);
            headColumnStyle.setBorderTop(BorderStyle.THIN);
            headColumnStyle.setBorderLeft(BorderStyle.THIN);
            headColumnStyle.setBorderRight(BorderStyle.THIN);
            headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
            headColumnStyle.setHidden(false);
        }
        return headColumnStyle;
    }
}

