/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.JSONUtils;

public class AssgrpDefValUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result;
        block22: {
            result = new UpgradeResult();
            try (TXHandle handle = TX.requiresNew();){
                try {
                    DBRoute gl = DBRoute.of((String)"gl");
                    String querySql = "SELECT B.FVALUE VALUE, A.FID ID, A.FENTRYID ENTRYID, A.FACCOUNTID ACCOUNTID, C.FUSERID USERID FROM (T_GL_ASSGRPDEFVALENTRY A LEFT JOIN T_GL_ASSIST B ON (A.FASSGRPID = B.FID)) LEFT JOIN T_GL_ASSGRPDEFVAL C ON (A.FID = C.FID) WHERE A.FASSGRPID > 0";
                    final HashMap fidToUserid = new HashMap();
                    final HashMap fidToEntryids = new HashMap();
                    final HashMap entryToAccount = new HashMap();
                    Map queryResult = (Map)DB.query((DBRoute)gl, (String)querySql, (ResultSetHandler)new ResultSetHandler<Map<Long, String>>(){

                        public Map<Long, String> handle(ResultSet rs) throws Exception {
                            HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
                            while (rs.next()) {
                                long fid = rs.getLong("id");
                                long entryid = rs.getLong("entryid");
                                if (fidToEntryids.get(fid) == null) {
                                    ArrayList<Long> entryids = new ArrayList<Long>();
                                    entryids.add(entryid);
                                    fidToEntryids.put(fid, entryids);
                                } else {
                                    ((List)fidToEntryids.get(fid)).add(entryid);
                                }
                                entryToAccount.put(entryid, rs.getLong("accountid"));
                                fidToUserid.put(fid, rs.getLong("userid"));
                                resultMap.put(entryid, rs.getString("value"));
                            }
                            return resultMap;
                        }
                    });
                    if (!fidToEntryids.isEmpty()) {
                        Object[] objs;
                        ArrayList<Object[]> params = new ArrayList<Object[]>(fidToEntryids.size());
                        for (Map.Entry entries : fidToEntryids.entrySet()) {
                            int seq = 1;
                            for (Object entryid : (List)entries.getValue()) {
                                Long accountid = (Long)entryToAccount.get(entryid);
                                String jsonStr = (String)queryResult.get(entryid);
                                if (!StringUtils.isNotBlank((CharSequence)jsonStr)) continue;
                                Map valueMap = (Map)JSONUtils.cast((String)jsonStr, HashMap.class);
                                Map<Long, Tuple2<String, Object>> idToVal = this.handelAssgrpMap(valueMap);
                                for (Map.Entry<Long, Tuple2<String, Object>> entry : idToVal.entrySet()) {
                                    objs = new Object[7];
                                    objs[1] = seq++;
                                    objs[2] = accountid;
                                    objs[3] = entry.getKey();
                                    objs[4] = entries.getKey();
                                    Tuple2<String, Object> value = entry.getValue();
                                    if ("3".equalsIgnoreCase((String)value.t1)) {
                                        objs[5] = value.t2;
                                        objs[6] = 0L;
                                        params.add(objs);
                                        continue;
                                    }
                                    if ("1".equalsIgnoreCase((String)value.t1) || "2".equalsIgnoreCase((String)value.t1)) {
                                        objs[5] = "";
                                        objs[6] = value.t2;
                                        params.add(objs);
                                        continue;
                                    }
                                    --seq;
                                }
                            }
                        }
                        String delSeq = "DELETE FROM T_GL_ASSGRPDEFVALENTRY WHERE FENTRYID IN (" + StringUtils.join((Object[])queryResult.keySet().toArray(), (String)",") + ")";
                        boolean delRs = DB.execute((DBRoute)gl, (String)delSeq);
                        result.setLog("assgrp defval assgrpval entry delete  " + delRs);
                        long[] entryPks = DB.genLongIds((String)"T_GL_ASSGRPDEFVALENTRY", (int)params.size());
                        int pkIndex = 0;
                        for (Object[] objs2 : params) {
                            objs2[0] = entryPks[pkIndex++];
                        }
                        String sql = "INSERT INTO T_GL_ASSGRPDEFVALENTRY(FENTRYID,FSEQ,FACCOUNTID,FASSGRPTYPEID,FID,FTXTVAL,FBASEPK) VALUES (?,?,?,?,?,?,?)";
                        int[] executeBatch = DB.executeBatch((DBRoute)gl, (String)sql, params);
                        result.setLog("assgrp defval assgrpval update success count " + executeBatch.length);
                        String updateSql = "UPDATE T_GL_ASSGRPDEFVAL SET FUSERTYPE = '1', FNUMBER = 'DATA UPDATE' WHERE FID IN (" + StringUtils.join((Object[])fidToEntryids.keySet().toArray(), (String)",") + ")";
                        boolean execute = DB.execute((DBRoute)gl, (String)updateSql);
                        result.setLog("assgrp defval usertype update successinfo " + execute);
                        long[] userpks = DB.genLongIds((String)"T_GL_ASSGRPDEFVALUSER", (int)fidToUserid.size());
                        pkIndex = 0;
                        params.clear();
                        for (Map.Entry<Long, Object> entry : fidToUserid.entrySet()) {
                            objs = new Object[]{userpks[pkIndex++], entry.getKey(), entry.getValue()};
                            params.add(objs);
                        }
                        String userSql = "INSERT INTO T_GL_ASSGRPDEFVALUSER(FPKID,FID,FBASEDATAID) VALUES (?,?,?)";
                        int[] nArray = DB.executeBatch((DBRoute)gl, (String)userSql, params);
                        result.setLog("assgrp defval user update success count " + nArray.length);
                        result.setSuccess(true);
                        break block22;
                    }
                    result.setLog("assgrp defval don not need update");
                    result.setSuccess(true);
                }
                catch (Exception e) {
                    result.setSuccess(false);
                    result.setErrorInfo(e.getMessage());
                    result.setLog("assgrp defval update faild :" + e.getMessage());
                    handle.markRollback();
                }
            }
        }
        return result;
    }

    private Map<Long, Tuple2<String, Object>> handelAssgrpMap(Map<String, Object> valueMap) {
        DynamicObject[] assgrps;
        HashMap<Long, Tuple2<String, Object>> idToVal = new HashMap<Long, Tuple2<String, Object>>(valueMap.size());
        for (DynamicObject assgrp : assgrps = BusinessDataServiceHelper.load((String)"bd_asstacttype", (String)"id, flexfield, valuetype", (QFilter[])new QFilter("flexfield", "in", valueMap.keySet()).toArray())) {
            String type = assgrp.getString("valuetype");
            long id = assgrp.getLong("id");
            String key = assgrp.getString("flexfield");
            Object val = valueMap.get(key);
            if (val == null) continue;
            idToVal.put(id, (Tuple2<String, Object>)new Tuple2((Object)type, val));
        }
        return idToVal;
    }
}

