/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.util.GLUtil;

public class CashflowInitPeriodUpgraedService
implements IUpgradeService {
    private static final String updateSql = "update t_bd_accountbooks set fcashinitperiodid =? where fid = ?";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        String sql = "select fid,forgid,fbookstypeid,fstartperiodid,fcurperiodid from t_bd_accountbooks where fstartperiodid > 0 and fcashinitperiodid = 0 ";
        try (DataSet ds = DB.queryDataSet((String)"CashflowInitPeriodUpgraedService", (DBRoute)DBRoute.of((String)"gl"), (String)sql);){
            ArrayList<Object[]> params = new ArrayList<Object[]>(16);
            for (Row row : ds) {
                long cashflowInitPeriod = CashflowInitPeriodUpgraedService.getFirstCashflowPeriod(row.getLong("forgid"), row.getLong("fbookstypeid"), row.getLong("fstartperiodid"), row.getLong("fcurperiodid"));
                if (cashflowInitPeriod <= 0L) continue;
                params.add(new Object[]{cashflowInitPeriod, row.getLong("fid")});
                if (params.size() < 999) continue;
                CashflowInitPeriodUpgraedService.updateBook(params);
            }
            if (params.size() > 0) {
                CashflowInitPeriodUpgraedService.updateBook(params);
            }
        }
        catch (Exception e) {
            result.setErrorInfo(GLUtil.printError((Throwable)e));
            result.setSuccess(false);
        }
        return result;
    }

    public static long getFirstCashflowPeriod(long org, long bookType, long startPeriod, long curperiod) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select top 1 v.fperiodid from t_gl_voucher v inner join t_gl_voucherentry ve on v.fid = ve.fid ", new Object[0]);
        sqlBuilder.append(" where v.forgid = ?", new Object[]{org});
        sqlBuilder.append(" and v.fbooktypeid = ? ", new Object[]{bookType});
        sqlBuilder.append(" and v.fperiodid >= ? ", new Object[]{startPeriod});
        sqlBuilder.append(" and (ve.fmaincfitemid > 0 or ve.fsuppcfitemid > 0) ", new Object[0]);
        sqlBuilder.append(" order by v.fperiodid", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"CashflowInitPeriodUpgraedService", (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);){
            QFilter deletedF;
            QFilter bookTypeF;
            QFilter orgF;
            long voucherFirstPeriod = 0L;
            if (dataSet.hasNext()) {
                voucherFirstPeriod = dataSet.next().getLong("fperiodid");
            }
            if ((curperiod < voucherFirstPeriod || voucherFirstPeriod == 0L) && QueryServiceHelper.exists((String)"gl_initcashflow", (QFilter[])new QFilter[]{orgF = new QFilter("org", "=", (Object)org), bookTypeF = new QFilter("booktype", "=", (Object)bookType), deletedF = new QFilter("tabdelete", "=", (Object)false)})) {
                long l = curperiod;
                return l;
            }
            long l = voucherFirstPeriod;
            return l;
        }
    }

    private static void updateBook(List<Object[]> params) {
        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)updateSql, params);
        params.clear();
    }
}

