/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.fi.gl.util.GLUtil;

public class FaDepreSplitDetailUpgradeService
implements IUpgradeService {
    private static final String FA_APPID = "83bfebc800001aac";
    private static final String T_AI_RECDATARULEENTRY = "INSERT INTO t_ai_recdataruleentry (FID, FSEQ, FENTRYID, FDATATYPE, FBIZOBJ, FAMOUNTTYPE, FDETAILRULE, FDATAFILTER, FCOMMONFILTER, FAMOUNT, FAMOUNTEXP, FAMOUNTEXP_TAG, FDISABLE, FDATAFILTERDESC, FDATAFILTER_TAG) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String BIZ_AMOUNTEXP = "fa_depre_sum_splitamount";
    private static final String algoKey = FaDepreSplitDetailUpgradeService.class.getName();

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle txHandle = TX.requiresNew();){
            UpgradeResult result = new UpgradeResult();
            try {
                this.upgrade();
                result.setSuccess(true);
            }
            catch (Exception e) {
                txHandle.markRollback();
                result.setErrorInfo(GLUtil.printError((Throwable)e));
                result.setSuccess(false);
            }
            UpgradeResult upgradeResult = result;
            return upgradeResult;
        }
    }

    public void upgrade() {
        HashSet<Long> needUpdateIds = new HashSet<Long>();
        DBRoute route = new DBRoute("ai");
        String sql = "select fid from t_ai_recdatarule where fbizapp = '83bfebc800001aac'";
        String esql = "select fid from t_ai_recdataruleentry where fbizobj = 'fa_depre_sum' and 'splitamount' = to_char(FAMOUNTEXP_TAG)";
        DataSet queryDataSet = DB.queryDataSet((String)algoKey, (DBRoute)route, (String)sql);
        DataSet excDataSet = DB.queryDataSet((String)algoKey, (DBRoute)route, (String)esql);
        ArrayList<Long> lsIds = new ArrayList<Long>();
        for (Row next : excDataSet) {
            lsIds.add(next.getLong("fid"));
        }
        for (Row next : queryDataSet) {
            if (lsIds.contains(next.get("fid"))) continue;
            needUpdateIds.add(next.getLong("fid"));
        }
        if (needUpdateIds.size() > 0) {
            ArrayList<Object[]> rs = new ArrayList<Object[]>(needUpdateIds.size());
            for (Long fid : needUpdateIds) {
                long entryid = DBServiceHelper.genLongIds((String)"t_ai_recdataruleentry", (int)1)[0];
                rs.add(new Object[]{fid, 13, entryid, "3", "fa_depre_sum", 731601043674138626L, " ", " ", 1068822656121622528L, ResManager.loadKDString((String)"\u5206\u644a\u91d1\u989d", (String)"FaDepreSplitDetailUpgradeService_1", (String)"fi-gl-upgradeservice", (Object[])new Object[0]), " ", "splitamount", 0, " ", " "});
            }
            DB.executeBatch((DBRoute)route, (String)T_AI_RECDATARULEENTRY, rs);
        }
    }
}

