/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.Arrays;
import kd.bos.context.RequestContextCreator;
import kd.bos.ext.permission.mservice.PermissionUpgradeServiceImpl;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class GLFPPermissionUpgradeService
implements IUpgradeService {
    private static final String GL = "83bfebc8000017ac";
    private static final String PERM_VIEW = "47150e89000000ac";
    private static final String PREM_CREATEVOUCHER = "/LRTO/JV2TYZ";
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"GLFPPermissionUpgradeService", (int)3);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            threadPool.submit(() -> {
                PermissionUpgradeServiceImpl permissionUpgradeService = new PermissionUpgradeServiceImpl();
                this.addPermission(permissionUpgradeService, PERM_VIEW, "gl_transplprogram", "gl_transplprogram", PREM_CREATEVOUCHER);
                this.addPermission(permissionUpgradeService, PERM_VIEW, "gl_autotrans", "gl_autotrans", PREM_CREATEVOUCHER);
                this.addPermission(permissionUpgradeService, PERM_VIEW, "gl_voucheramortacheme", "gl_voucheramortacheme", PREM_CREATEVOUCHER);
                return Boolean.TRUE;
            }, RequestContextCreator.createForThreadPool());
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setLog(e.getMessage());
        }
        return result;
    }

    private void addPermission(PermissionUpgradeServiceImpl permissionUpgradeService, String existPermItemID, String existEntityTypeID, String newEntityTypeID, String ... newPermItemIds) {
        if (newPermItemIds == null || newPermItemIds.length == 0) {
            return;
        }
        permissionUpgradeService.addPermItemsByExistPermItem(existPermItemID, existEntityTypeID, GL, newEntityTypeID, GL, Arrays.asList(newPermItemIds));
    }
}

