/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class GLVoucherAmortUpgradeService
implements IUpgradeService {
    private static final DBRoute gl = DBRoute.of((String)"gl");
    private static final String QUERY_AMORT_SCHEME = "SELECT FID, FAMORTSTATUS, FENABLE, FBILLSTATUS FROM T_GL_VOUCHERAMORTSCHEME WHERE FID <> 0 ";
    private static final String UPDATE_AMORT_STATUS_PRE = "UPDATE T_GL_VOUCHERAMORTSCHEME SET FAMORTSTATUS=FENABLE WHERE FID in ( ";
    private static final String UPDATE_AMORT_STATUS_TAIL = " ) AND FAMORTSTATUS = '4' ";
    private static final String UPDATE_ENABLE_STATUS_PRE = "UPDATE T_GL_VOUCHERAMORTSCHEME SET FENABLE = ? WHERE FID in ( ";
    private static final String UPDATE_ENABLE_STATUS_TAIL = " )";
    private static final String UPDATE_BILL_STATUS_PRE = "UPDATE T_GL_VOUCHERAMORTSCHEME SET FBILLSTATUS = ? WHERE FID in ( ";
    private static final String UPDATE_BILL_STATUS_TAIL = " )";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        List originalInfoList;
        Throwable throwable;
        TXHandle handle;
        UpgradeResult result;
        block23: {
            UpgradeResult upgradeResult;
            block24: {
                block25: {
                    block20: {
                        UpgradeResult upgradeResult2;
                        block21: {
                            block22: {
                                result = new UpgradeResult();
                                handle = TX.requiresNew();
                                throwable = null;
                                originalInfoList = (List)DB.query((DBRoute)gl, (String)QUERY_AMORT_SCHEME, rs -> {
                                    LinkedList<OriginalStatusInfo> res = new LinkedList<OriginalStatusInfo>();
                                    try {
                                        while (rs.next()) {
                                            res.add(new OriginalStatusInfo(rs.getLong("fid"), rs.getString("fenable"), rs.getString("fbillstatus"), rs.getString("famortstatus")));
                                        }
                                        LinkedList<OriginalStatusInfo> linkedList = res;
                                        return linkedList;
                                    }
                                    finally {
                                        rs.close();
                                    }
                                });
                                if (originalInfoList.size() > 0) break block20;
                                upgradeResult2 = this.buildNoNeedUpgradeResult(result);
                                if (handle == null) break block21;
                                if (throwable == null) break block22;
                                try {
                                    handle.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block21;
                            }
                            handle.close();
                        }
                        return upgradeResult2;
                    }
                    if (originalInfoList.stream().allMatch(data -> "4".equals(data.getNewAmortStatus()))) break block23;
                    upgradeResult = this.buildNoNeedUpgradeResult(result);
                    if (handle == null) break block24;
                    if (throwable == null) break block25;
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block24;
                }
                handle.close();
            }
            return upgradeResult;
        }
        try {
            try {
                this.doUpgrade(originalInfoList);
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                Arrays.toString(e.getStackTrace());
                result.setLog("amort scheme status update faild :" + e.getMessage());
                handle.markRollback();
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        catch (Throwable throwable5) {
            throw throwable5;
        }
        finally {
            if (handle != null) {
                if (throwable != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                } else {
                    handle.close();
                }
            }
        }
        return result;
    }

    private void doUpgrade(List<OriginalStatusInfo> originalInfos) {
        List ids = originalInfos.stream().map(data -> data.getID()).collect(Collectors.toList());
        List enableIDs = originalInfos.stream().filter(data -> "A".equals(data.getEnableStatus())).map(data -> data.getID()).collect(Collectors.toList());
        List disableIDs = originalInfos.stream().filter(data -> "D".equals(data.getEnableStatus())).map(data -> data.getID()).collect(Collectors.toList());
        if (ids.size() != 0) {
            DB.update((DBRoute)gl, (String)(UPDATE_AMORT_STATUS_PRE + StringUtils.join((Object[])ids.toArray(), (String)",") + UPDATE_AMORT_STATUS_TAIL));
        }
        if (enableIDs.size() != 0) {
            DB.update((DBRoute)gl, (String)(UPDATE_ENABLE_STATUS_PRE + StringUtils.join((Object[])enableIDs.toArray(), (String)",") + " )"), (Object[])new Object[]{"1"});
        }
        if (disableIDs.size() != 0) {
            DB.update((DBRoute)gl, (String)(UPDATE_ENABLE_STATUS_PRE + StringUtils.join((Object[])disableIDs.toArray(), (String)",") + " )"), (Object[])new Object[]{"0"});
        }
        if (ids.size() != 0) {
            DB.update((DBRoute)gl, (String)(UPDATE_BILL_STATUS_PRE + StringUtils.join((Object[])ids.toArray(), (String)",") + " )"), (Object[])new Object[]{"C"});
        }
    }

    private UpgradeResult buildNoNeedUpgradeResult(UpgradeResult result) {
        result.setSuccess(true);
        result.setLog(ResManager.loadKDString((String)"\u65e0\u9700\u4fee\u590d", (String)"GLVoucherAmortUpgradeService_0", (String)"fi-gl-upgradeservice", (Object[])new Object[0]));
        return result;
    }

    private static class OriginalStatusInfo {
        private final Long fid;
        private final String amortStatus;
        private final String newAmortStatus;
        private final String enableStatus;

        public OriginalStatusInfo(Long id, String amortStatus, String enableStatus, String newAmortStatus) {
            this.fid = id;
            this.amortStatus = amortStatus;
            this.enableStatus = enableStatus;
            this.newAmortStatus = newAmortStatus;
        }

        public String getAmortStatus() {
            return this.amortStatus;
        }

        public String getEnableStatus() {
            return this.enableStatus;
        }

        public Long getID() {
            return this.fid;
        }

        public String getNewAmortStatus() {
            return this.newAmortStatus;
        }
    }
}

