/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.service.GLThreadService;
import kd.fi.gl.voucher.count.VoucherCountUpgradeEngine;

public class GLVoucherCountUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(GLVoucherCountUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            logger.info("GLVoucherCountUpgradeService upgrade begin");
            result.setSuccess(this.doUpgrade());
        }
        catch (Exception e) {
            logger.error("GLVoucherCountUpgradeService error: " + e.getMessage(), (Throwable)e);
            result.setSuccess(false);
        }
        logger.info("GLVoucherCountUpgradeService upgrade end");
        return result;
    }

    private boolean doUpgrade() {
        boolean isUpgradeSuccess = true;
        DataSet balanceDS = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (String)"select distinct forgid,fbooktypeid,fperiodid from t_gl_acctbalance");
        DataSet voucherDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (String)"select forgid,fbooktypeid,fperiodid from t_gl_voucher where fid in (select distinct fvoucherid from t_gl_tempvoucher_index)");
        DataSet dataSet = balanceDS.union(voucherDs).distinct();
        ArrayList<Future> resultList = new ArrayList<Future>();
        for (Row row : dataSet) {
            long org = row.getLong("forgid");
            long booktype = row.getLong("fbooktypeid");
            long period = row.getLong("fperiodid");
            Future future = GLThreadService.submitAndGetResult((String)"GLVoucherCountUpgradeService", (Callable)new VoucherCountUpgradeEngine(org, booktype, period, true));
            resultList.add(future);
            if (resultList.size() > 100) {
                for (Future taskResult : resultList) {
                    try {
                        if (((Boolean)((Tuple)taskResult.get()).item1).booleanValue()) continue;
                        isUpgradeSuccess = false;
                        logger.error("GLVoucherCountUpgradeService error data : " + (String)((Tuple)taskResult.get()).item2);
                        break;
                    }
                    catch (Exception e) {
                        logger.error("voucher_count_upgrade_failed on " + e.getMessage(), (Throwable)e);
                        isUpgradeSuccess = false;
                    }
                }
                resultList.clear();
            }
            if (isUpgradeSuccess) continue;
            break;
        }
        if (isUpgradeSuccess) {
            for (Future taskResult : resultList) {
                try {
                    if (((Boolean)((Tuple)taskResult.get()).item1).booleanValue()) continue;
                    isUpgradeSuccess = false;
                    logger.error("GLVoucherCountUpgradeService error data : " + (String)((Tuple)taskResult.get()).item2);
                    break;
                }
                catch (Exception e) {
                    logger.error("voucher_count_upgrade_failed on " + e.getMessage(), (Throwable)e);
                    isUpgradeSuccess = false;
                }
            }
        }
        if (isUpgradeSuccess) {
            DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)"delete from t_gl_vouchercount where fbookeddate is null ");
        }
        return isUpgradeSuccess;
    }
}

