/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.gl.util.GLUtil;

public class InitAcccurrentPeriodUpgradeService
implements IUpgradeService {
    private static final String UPDATE_SQL = "update t_gl_acccurrent set fperiodid = ? where fvchentryid = 0 and fvoucherid = 0 and forgid = ? and fbooktypeid = ? and facctableid = ? and faccountid = ?";
    private static final String UPDATE_RECIPROCAL_LOG_SQL = "update t_gl_reciprocal_log set fperiodid  = ? where fbuyerentryid = ?";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle txHandle = TX.requiresNew();){
            UpgradeResult upgradeResult = new UpgradeResult();
            try {
                this.updateInitAcccurrentPeriod();
                upgradeResult.setSuccess(true);
            }
            catch (Exception e) {
                txHandle.markRollback();
                upgradeResult.setErrorInfo(GLUtil.printError((Throwable)e));
                upgradeResult.setSuccess(false);
            }
            UpgradeResult upgradeResult2 = upgradeResult;
            return upgradeResult2;
        }
    }

    private void updateInitAcccurrentPeriod() {
        ArrayList<Object[]> params = new ArrayList<Object[]>(64);
        DBRoute dbRoute = DBRoute.of((String)"fi");
        String sql = "select rint.forgid org, rint.fbooktypeid booktype, rint.faccounttableid accounttable, rint.fendinitperiod endinitperiod, acc.fmasterid masterid from t_gl_reci_init_state rint  inner join t_bd_account acc on rint.faccountid = acc.fid";
        try (DataSet initStateSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (String)sql);){
            Iterator iterator = initStateSet.iterator();
            while (initStateSet.hasNext()) {
                Row row = (Row)iterator.next();
                Long org = row.getLong("org");
                Long bookType = row.getLong("booktype");
                Long accountMasterId = row.getLong("masterid");
                Long accountTable = row.getLong("accounttable");
                Long endInitPeriod = row.getLong("endinitperiod");
                params.add(new Object[]{endInitPeriod, org, bookType, accountTable, accountMasterId});
                if (params.size() < 999) continue;
                DB.executeBatch((DBRoute)dbRoute, (String)UPDATE_SQL, params);
                params.clear();
            }
            if (!params.isEmpty()) {
                DB.executeBatch((DBRoute)dbRoute, (String)UPDATE_SQL, params);
            }
            String reciprocalLogSql = "select fid id, fbuyerentryid buyerentry from t_gl_reciprocal_log where fperiodid = 0";
            DataSet reciLogsDt = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)dbRoute, (String)reciprocalLogSql);
            ArrayList<Object> buyerEntryIds = new ArrayList<Object>(999);
            reciLogsDt.forEach(v -> {
                long buyerEntry = v.getLong("buyerentry");
                buyerEntryIds.add(buyerEntry);
                if (buyerEntryIds.size() >= 999) {
                    this.updateReciprocalLogs(buyerEntryIds);
                    buyerEntryIds.clear();
                }
            });
            if (!buyerEntryIds.isEmpty()) {
                this.updateReciprocalLogs(buyerEntryIds);
            }
        }
    }

    private void updateReciprocalLogs(List<Object> buyerEntryIds) {
        SqlBuilder acccuSql = new SqlBuilder();
        acccuSql.append("select fid id, fperiodid period from t_gl_acccurrent where ", new Object[0]);
        acccuSql.appendIn("fid", buyerEntryIds);
        DataSet acccuDt = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)acccuSql);
        HashMap acccuToPeriodMap = new HashMap(999);
        acccuDt.forEach(v -> acccuToPeriodMap.put(v.getLong("id"), v.getLong("period")));
        HashSet<Object> buyerEntryIdSet = new HashSet<Object>(buyerEntryIds);
        ArrayList<Object[]> reciLogParams = new ArrayList<Object[]>(buyerEntryIdSet.size());
        for (Object e : buyerEntryIdSet) {
            Long acccuPeroid = (Long)acccuToPeriodMap.get(e);
            if (acccuPeroid == null) continue;
            reciLogParams.add(new Object[]{acccuPeroid, e});
        }
        if (!reciLogParams.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)UPDATE_RECIPROCAL_LOG_SQL, reciLogParams);
        }
    }
}

