/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.lang.STConverter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class IntellExecSchemaDescUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DynamicProperty findProperty = MetadataServiceHelper.getDataEntityType((String)"gl_intellexecschema").getProperty("exceplanlang");
        if (findProperty == null) {
            result.setSuccess(true);
            result.setLog(ResManager.loadKDString((String)"\u65e0\u9700\u4fee\u590d", (String)"IntellExecSchemaDescUpgradeService_0", (String)"fi-iep-upgradeservice", (Object[])new Object[0]));
            return result;
        }
        try (TXHandle handle = TX.requiresNew();){
            try {
                DynamicObject[] datas;
                QFilter filter = new QFilter("id", "!=", (Object)0L);
                for (DynamicObject dynamicObject : datas = BusinessDataServiceHelper.load((String)"gl_intellexecschema", (String)"exceplan, exceplanlang", (QFilter[])filter.toArray())) {
                    String desc = dynamicObject.getString("exceplan");
                    LocaleString localeString = new LocaleString(desc);
                    localeString.setLocaleValue_zh_TW(STConverter.sc2tc((String)desc));
                    dynamicObject.set("exceplanlang", (Object)localeString);
                }
                Object[] save = SaveServiceHelper.save((DynamicObject[])datas);
                result.setSuccess(true);
                result.setLog(String.format(ResManager.loadKDString((String)"\u4fee\u590d\u6210\u529f%s\u6761\u6570\u636e", (String)"IntellExecSchemaDescUpgradeService_1\u3002", (String)"fi-iep-upgradeservice", (Object[])new Object[0]), save.length + ""));
            }
            catch (Throwable e) {
                result.setSuccess(false);
                result.setErrorInfo(e.getMessage());
                result.setLog(ResManager.loadKDString((String)"\u4fee\u590d\u5931\u8d25%s", (String)"IntellExecSchemaDescUpgradeService_2", (String)"fi-iep-upgradeservice", (Object[])new Object[]{e.getMessage()}));
                handle.markRollback();
                throw e;
            }
        }
        return result;
    }
}

