/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.notice.NoticeUtils;
import kd.fi.gl.util.GLUtil;

public class NoticeOpdescUpgradeService
implements IUpgradeService {
    private final Map<Long, Map<Long, String>> fid2entryid2desc = new HashMap<Long, Map<Long, String>>();
    private final Map<Long, Map<Long, String>> fid2opentryid2desc = new HashMap<Long, Map<Long, String>>();
    private static final DBRoute FI = new DBRoute("fi");
    private static final int BATCH_SIZE = 3000;
    private static final String SQL_SELECT_SELF = "select a.fid, fvchentryid, fdescription from t_gl_acnotice_logentry a inner join t_gl_voucherentry b on a.fvchentryid=b.fentryid where a.fid > ? and a.fid <= ?";
    private static final String SQL_SELECT_OPPO = "select a.fid, fopvchentryid, fdescription from t_gl_acnotice_oplogentry a inner join t_gl_voucherentry b on a.fopvchentryid=b.fentryid where a.fid > ? and a.fid <= ?";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.doUpgrade();
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setErrorInfo(GLUtil.printError((Throwable)e));
            result.setSuccess(false);
        }
        return result;
    }

    private void doUpgrade() {
        long startIndex = 0L;
        int maxBatch = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"prop.fi.gl.acnotice.opdesc.upgrade.maxbatch", (int)50000);
        for (int batchCount = 0; batchCount < maxBatch; ++batchCount) {
            long endIndex = this.getEndIndex(startIndex);
            if (endIndex <= 0L) {
                return;
            }
            this.batchUpdate(startIndex, endIndex);
            startIndex = endIndex;
        }
    }

    private void batchUpdate(long startIndex, long endIndex) {
        this.genMap(startIndex, endIndex);
        ArrayList params = new ArrayList();
        this.fid2entryid2desc.forEach((fid, entryid2desc) -> {
            ArrayList entryIds = new ArrayList(entryid2desc.keySet());
            Map<Long, String> opentryid2desc = this.fid2opentryid2desc.get(fid);
            if (null == opentryid2desc) {
                return;
            }
            ArrayList<Long> opEntryIds = new ArrayList<Long>(opentryid2desc.keySet());
            String desc = entryIds.stream().map(entryid2desc::get).reduce((x, y) -> x + ";" + y).orElseThrow(() -> new IllegalStateException("fail to get desc"));
            desc = NoticeUtils.getChineseStrLen((String)desc) > 666 ? desc.substring(0, 666) : desc;
            String opDesc = opEntryIds.stream().map(opentryid2desc::get).reduce((x, y) -> x + ";" + y).orElseThrow(() -> new IllegalStateException("fail to get desc"));
            opDesc = NoticeUtils.getChineseStrLen((String)opDesc) > 666 ? opDesc.substring(0, 666) : opDesc;
            params.add(new Object[]{opDesc, entryIds});
            params.add(new Object[]{desc, opEntryIds});
        });
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                params.forEach(param -> {
                    SqlBuilder sql = new SqlBuilder();
                    sql.append("update t_gl_acnotice set fpeerdesc=? where", new Object[]{param[0]}).appendIn("fvoucherentryid", (List)param[1]);
                    DB.execute((DBRoute)new DBRoute("fi"), (SqlBuilder)sql);
                });
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
        this.fid2entryid2desc.clear();
        this.fid2opentryid2desc.clear();
    }

    private void genMap(long startIndex, long endIndex) {
        DB.query((DBRoute)FI, (String)SQL_SELECT_SELF, (Object[])new Object[]{startIndex, endIndex}, result -> {
            while (result.next()) {
                Long fid = result.getLong("fid");
                Long entryid = result.getLong("fvchentryid");
                String desc = result.getString("fdescription");
                if (this.fid2entryid2desc.containsKey(fid)) {
                    this.fid2entryid2desc.get(fid).put(entryid, desc);
                    continue;
                }
                HashMap<Long, String> entryid2desc = new HashMap<Long, String>();
                entryid2desc.put(entryid, desc);
                this.fid2entryid2desc.put(fid, entryid2desc);
            }
            return null;
        });
        DB.query((DBRoute)FI, (String)SQL_SELECT_OPPO, (Object[])new Object[]{startIndex, endIndex}, result -> {
            while (result.next()) {
                Long fid = result.getLong("fid");
                Long opentryid = result.getLong("fopvchentryid");
                String desc = result.getString("fdescription");
                if (this.fid2opentryid2desc.containsKey(fid)) {
                    this.fid2opentryid2desc.get(fid).put(opentryid, desc);
                    continue;
                }
                HashMap<Long, String> entryid2desc = new HashMap<Long, String>();
                entryid2desc.put(opentryid, desc);
                this.fid2opentryid2desc.put(fid, entryid2desc);
            }
            return null;
        });
    }

    private long getEndIndex(long startIndex) {
        return (Long)DB.query((DBRoute)FI, (String)"select max(fid) fid from(select top 3000 fid from t_gl_acnotice_relation where fid > ? order by fid asc) a", (Object[])new Object[]{startIndex}, resultSet -> resultSet.next() ? resultSet.getLong("fid") : 0L);
    }
}

