/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.fi.gl.util.GLUtil;

public class NoticeUpgradeService
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try (TXHandle txHandle = TX.requiresNew();){
            UpgradeResult result = new UpgradeResult();
            try {
                NoticeUpgradeService.upgradeCheckLog("t_gl_acnotice", "t_gl_acnotice_checklog");
                NoticeUpgradeService.upgradeCheckLog("t_gl_cfnotice", "t_gl_cfnotice_checklog");
                result.setSuccess(true);
            }
            catch (Exception e) {
                txHandle.markRollback();
                result.setErrorInfo(GLUtil.printError((Throwable)e));
                result.setSuccess(false);
            }
            UpgradeResult upgradeResult = result;
            return upgradeResult;
        }
    }

    private static void upgradeCheckLog(String noticeTableName, String checkLogTableName) {
        String queryNoticeSql;
        DBRoute gl = DBRoute.of((String)"fi");
        Map entryId2opEntryId = (Map)DB.query((DBRoute)gl, (String)(queryNoticeSql = "select a.fvoucherentryid, a.fvoucherid, a.fpeerentryid, a.fsendorgid, a.freceiveorgid, a.fentrydc, a.famount, a.fcurrencyid from " + noticeTableName + " a where a.fvoucherentryid > 0 and a.fpeerentryid > 0 and not exists (select 1 from " + checkLogTableName + " b where b.fentryid = a.fvoucherentryid or b.fopentryid = a.fvoucherentryid)"), rs -> {
            HashMap<Long, Object[]> result = new HashMap<Long, Object[]>(16);
            while (rs.next()) {
                result.put(rs.getLong("fvoucherentryid"), new Object[]{rs.getLong("fvoucherid"), rs.getLong("fpeerentryid")});
            }
            return result;
        });
        if (entryId2opEntryId.isEmpty()) {
            return;
        }
        long[] logIds = DB.genLongIds((String)checkLogTableName, (int)entryId2opEntryId.size());
        ArrayList<Object[]> params = new ArrayList<Object[]>(entryId2opEntryId.size());
        int idIndex = 0;
        for (Map.Entry entry : entryId2opEntryId.entrySet()) {
            Long entryId = (Long)entry.getKey();
            Object[] opEntryId = (Object[])entry.getValue();
            params.add(new Object[]{logIds[idIndex++], entryId, opEntryId[0], opEntryId[1]});
        }
        if (params.isEmpty()) {
            return;
        }
        String insertLogSql = "insert into " + checkLogTableName + "(fid, fentryid, fvoucherid, fopentryid) values (?,?,?,?)";
        DB.executeBatch((DBRoute)gl, (String)insertLogSql, params);
    }
}

