/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.gl.util.DateUtil;

public class PeriodDateFormtUpgradeService
implements IUpgradeService {
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        DynamicObject[] periods;
        DynamicObject[] periodoutlines;
        UpgradeResult result = new UpgradeResult();
        for (DynamicObject outline : periodoutlines = BusinessDataServiceHelper.load((String)"bd_periodoutline_tree", (String)"id,outlinebegindate,outlineenddate", null)) {
            Date beginDate = outline.getDate("outlinebegindate");
            Date endDate = outline.getDate("outlineenddate");
            if (beginDate == null || endDate == null) continue;
            outline.set("outlinebegindate", (Object)DateUtil.makeDateOnDayStrart((Date)beginDate));
            outline.set("outlineenddate", (Object)this.getFormatEndDate(endDate).getTime());
        }
        SaveServiceHelper.save((DynamicObject[])periodoutlines);
        for (DynamicObject period : periods = BusinessDataServiceHelper.load((String)"bd_period", (String)"id,begindate,enddate,isadjustperiod", null)) {
            Date beginDate;
            boolean isadjust = period.getBoolean("isadjustperiod");
            if (isadjust) {
                beginDate = period.getDate("begindate");
                period.set("begindate", (Object)this.getFormatEndDate(beginDate).getTime());
            } else {
                beginDate = period.getDate("begindate");
                period.set("begindate", (Object)DateUtil.makeDateOnDayStrart((Date)beginDate));
            }
            Date endDate = period.getDate("enddate");
            period.set("enddate", (Object)this.getFormatEndDate(endDate).getTime());
        }
        SaveServiceHelper.save((DynamicObject[])periods);
        result.setSuccess(true);
        result.setLog("period date update success");
        return result;
    }

    private Calendar getFormatEndDate(Date endDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(endDate);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c;
    }
}

