/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlObject;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.util.GLUtil;

public class ReorderFlexDataUpgradeService
implements IUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(ReorderFlexDataUpgradeService.class);
    private List<String> logList;
    private static String[] entityName = new String[]{"gl_initacccurrent", "gl_acccurrent", "gl_reciprocal_log"};
    private final String sumTag = "begin#,debit#,credit#,yeardebit#,yearcredit#,end#";
    private final String sumField = "begin#,debit#,credit#,yeardebit#,yearcredit#,end#".replace("#", "for") + "," + "begin#,debit#,credit#,yeardebit#,yearcredit#,end#".replace("#", "local") + "," + "begin#,debit#,credit#,yeardebit#,yearcredit#,end#".replace("#", "qty") + ",count";
    private final String initSumTag = "begindebit#,begincredit#,yeardebit#,yearcredit#,yearprofitdebit#,yearprofitcredit#";
    private final String initSumField = "begindebit#,begincredit#,yeardebit#,yearcredit#,yearprofitdebit#,yearprofitcredit#".replace("#", "for") + "," + "begindebit#,begincredit#,yeardebit#,yearcredit#,yearprofitdebit#,yearprofitcredit#".replace("#", "local") + "," + "begindebit#,begincredit#,yeardebit#,yearcredit#,yearprofitdebit#,yearprofitcredit#".replace("#", "qty");
    private Map<String, Integer> flexKeyIndexes = new HashMap<String, Integer>();

    private static DataSet queryDataSet(String algoKey, DBRoute dbRoute, String sql, Object[] p) {
        return DB.queryDataSet((String)algoKey, (DBRoute)dbRoute, (String)sql, (Object[])p);
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        this.logList = new ArrayList<String>();
        UpgradeResult result = new UpgradeResult();
        String sql = "select fid, fvalue from t_gl_assist";
        ArrayList<SqlObject> sqlObjs = new ArrayList<SqlObject>();
        DBRoute dbRoute = new DBRoute(dbKey);
        try (DataSet ds = ReorderFlexDataUpgradeService.queryDataSet("ReorderFlexDataUpgradeService.beforeExecuteSql", dbRoute, sql, null);){
            for (Row row : ds) {
                SqlParameter[] params = new SqlParameter[]{new SqlParameter("fvalue", -9, (Object)row.getString("fvalue")), new SqlParameter("fid", -5, (Object)row.getLong("fid"))};
                sqlObjs.add(new SqlObject("update t_gl_assist set fvalue = ? where fid = ?", params));
            }
        }
        catch (Throwable e) {
            result.setSuccess(false);
            String err = ResManager.loadKDString((String)"\u5347\u7ea7\u6838\u7b97\u7ef4\u5ea6\u6570\u636e\u8bfb\u53d6t_gl_assist\u8868\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"ReorderFlexDataUpgradeService_0", (String)"fi-gl-upgradeservice", (Object[])new Object[]{e.getMessage()});
            result.setErrorInfo(err);
            result.setLog(err);
            return result;
        }
        TreeMap map = new TreeMap((o1, o2) -> {
            int o1idx = this.getFlexPropertyIndex((String)o1);
            int o2idx = this.getFlexPropertyIndex((String)o2);
            return o1idx - o2idx;
        });
        HashMap<String, Long> allFlexDatas = new HashMap<String, Long>();
        HashMap<String, List> repeatFlexDatas = new HashMap<String, List>();
        for (int i = sqlObjs.size() - 1; i >= 0; --i) {
            map.clear();
            SqlParameter param = ((SqlObject)sqlObjs.get(i)).getParams()[0];
            String string = (String)param.getValue();
            try {
                Map map2 = (Map)JSONUtils.cast((String)string, LinkedHashMap.class);
                for (Map.Entry entry : map2.entrySet()) {
                    map.put(entry.getKey(), entry.getValue());
                }
                String newVal = JSONUtils.toString(map);
                Long id = (Long)((SqlObject)sqlObjs.get(i)).getParams()[1].getValue();
                if (allFlexDatas.containsKey(newVal)) {
                    List ids = repeatFlexDatas.computeIfAbsent(newVal, k -> new ArrayList());
                    ids.add(id);
                } else {
                    allFlexDatas.put(newVal, id);
                }
                if (newVal.equals(string)) {
                    sqlObjs.remove(i);
                    continue;
                }
                param.setValue((Object)newVal);
                continue;
            }
            catch (IOException e) {
                result.setSuccess(true);
                String err = String.format(ResManager.loadKDString((String)"\u5347\u7ea7\u6838\u7b97\u7ef4\u5ea6\u6570\u636e\u503c\u8f6c\u6362\u9519\u8bef\uff0cvalue=\u201c%1$s\u201d\uff0c \u9519\u8bef\u4fe1\u606f\uff1a%2$s", (String)"ReorderFlexDataUpgradeService_1", (String)"fi-gl-upgradeservice", (Object[])new Object[0]), string, e.getMessage());
                result.setErrorInfo(err);
                result.setLog(err);
                return result;
            }
        }
        HashMap<Long, List<Long>> idMap = new HashMap<Long, List<Long>>(repeatFlexDatas.size());
        for (Map.Entry entry : repeatFlexDatas.entrySet()) {
            idMap.put((Long)allFlexDatas.get(entry.getKey()), (List<Long>)entry.getValue());
        }
        if (DebugTrace.enable()) {
            LOGGER.info(ResManager.loadKDString((String)"\u66f4\u65b0\u524d\uff1aidMap:", (String)"ReorderFlexDataUpgradeService_2", (String)"fi-gl-upgradeservice", (Object[])new Object[0]) + idMap);
        }
        Throwable throwable = null;
        try (TXHandle h = TX.required((String)this.getClass().getName());){
            try {
                this.updateBalanceAndVoucher(idMap);
                for (SqlObject sqlObject : sqlObjs) {
                    this.executeMethod(dbRoute, sqlObject.getSql(), sqlObject.getParams());
                }
            }
            catch (Throwable e) {
                h.markRollback();
                result.setSuccess(false);
                result.setErrorInfo(ResManager.loadKDString((String)"\u5347\u7ea7\u6838\u7b97\u7ef4\u5ea6\u6570\u636e\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"ReorderFlexDataUpgradeService_3", (String)"fi-gl-upgradeservice", (Object[])new Object[]{e.getMessage()}));
                result.setLog(ResManager.loadKDString((String)"\u5347\u7ea7\u6838\u7b97\u7ef4\u5ea6\u6570\u636e\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%1$slogList:%2$s", (String)"ReorderFlexDataUpgradeService_13", (String)"fi-gl-upgradeservice", (Object[])new Object[]{e.getMessage(), this.logList}));
                UpgradeResult upgradeResult = result;
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        h.close();
                    }
                }
                return upgradeResult;
            }
        }
        catch (Throwable throwable3) {
            Throwable throwable4 = throwable3;
            throw throwable3;
        }
        if (DebugTrace.enable()) {
            LOGGER.info(String.format("%1$s%2$s", ResManager.loadKDString((String)"\u66f4\u65b0\u540e\uff1aidMap\uff1a", (String)"ReorderFlexDataUpgradeService_4", (String)"fi-gl-upgradeservice", (Object[])new Object[0]), idMap));
        }
        result.setSuccess(true);
        result.setLog(ResManager.loadKDString((String)"\u5347\u7ea7\u6838\u7b97\u7ef4\u5ea6\u6570\u636e\u5b8c\u6210\u3002%1$s%2$s", (String)"ReorderFlexDataUpgradeService_5", (String)"fi-gl-upgradeservice", (Object[])new Object[]{"logList:", this.logList}));
        return result;
    }

    private void executeMethod(DBRoute dbRoute, String sql, SqlParameter[] params) {
        DB.execute((DBRoute)dbRoute, (String)sql, (Object[])params);
    }

    private void updateBalanceAndVoucher(Map<Long, List<Long>> idMap) {
        this.deleteAssist(idMap);
        this.updateVoucher(idMap);
        this.updateReci(idMap);
        this.updateBalance(idMap);
        this.updateInitBalance(idMap);
    }

    private void deleteAssist(Map<Long, List<Long>> idMap) {
        ArrayList<Long> repeatIds = new ArrayList<Long>();
        for (List<Long> value : idMap.values()) {
            repeatIds.addAll(value);
        }
        MainEntityType assType = MetadataServiceHelper.getDataEntityType((String)"gl_assist");
        BusinessDataWriter.delete((IDataEntityType)assType, (Object[])repeatIds.toArray());
        String info = String.format(ResManager.loadKDString((String)"\u5220\u9664\u7684\u6838\u7b97\u7ef4\u5ea6id\uff1a%s", (String)"ReorderFlexDataUpgradeService_6", (String)"fi-gl-upgradeservice", (Object[])new Object[0]), repeatIds);
        LOGGER.info(info);
        this.logList.add(info);
    }

    private void updateInitBalance(Map<Long, List<Long>> idMap) {
        MainEntityType balType = MetadataServiceHelper.getDataEntityType((String)"gl_initbalance");
        Set fieldSet = balType.getAllFields().keySet();
        String fieldStr = fieldSet.toString().replace("[", "").replace("]", "");
        ArrayList<Object> needRemovedBals = new ArrayList<Object>();
        ArrayList<DynamicObject> needUpdateBals = new ArrayList<DynamicObject>();
        for (Map.Entry<Long, List<Long>> entry : idMap.entrySet()) {
            List<Long> oldAssIds = entry.getValue();
            Long newAssId = entry.getKey();
            ArrayList<Long> allIds = new ArrayList<Long>(oldAssIds);
            allIds.add(newAssId);
            QFilter assgrpFilter = new QFilter("assgrp", "in", allIds);
            DynamicObject[] balDyns = BusinessDataServiceHelper.load((String)"gl_initbalance", (String)fieldStr, (QFilter[])new QFilter[]{assgrpFilter}, (String)"org,booktype,accounttable,account,currency,measureunit");
            this.setInitBalanceValue(needRemovedBals, needUpdateBals, newAssId, balDyns);
        }
        List pkList = needUpdateBals.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        String info2 = String.format(ResManager.loadKDString((String)"\u5220\u9664\u7684\u521d\u59cb\u5316\u4f59\u989d\u8868\uff1a%s", (String)"ReorderFlexDataUpgradeService_7", (String)"fi-gl-upgradeservice", (Object[])new Object[0]), needRemovedBals);
        String info1 = String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u7684\u521d\u59cb\u5316\u4f59\u989d\u8868\uff1a%s", (String)"ReorderFlexDataUpgradeService_8", (String)"fi-gl-upgradeservice", (Object[])new Object[0]), pkList);
        this.logList.add(info1);
        this.logList.add(info2);
        LOGGER.info(info1);
        LOGGER.info(info2);
        BusinessDataWriter.delete((IDataEntityType)balType, (Object[])needRemovedBals.toArray());
        SaveServiceHelper.save((DynamicObject[])needUpdateBals.toArray(new DynamicObject[0]));
    }

    private void setInitBalanceValue(List<Object> needRemovedBals, List<DynamicObject> needUpdateBals, Long newAssId, DynamicObject[] balDyns) {
        HashMap<String, DynamicObject> keyDynMap = new HashMap<String, DynamicObject>();
        for (DynamicObject balDyn : balDyns) {
            balDyn.set("assgrp", (Object)newAssId);
            String key = this.getKey(balDyn);
            DynamicObject preBalDyn = (DynamicObject)keyDynMap.get(key);
            if (preBalDyn == null) {
                keyDynMap.put(key, balDyn);
                continue;
            }
            for (String field : this.initSumField.split(",")) {
                preBalDyn.set(field, ReorderFlexDataUpgradeService.sum(preBalDyn.get(field), balDyn.get(field)));
            }
            if (!balDyn.getBoolean("isdeleted")) {
                preBalDyn.set("isdeleted", (Object)false);
            }
            needRemovedBals.add(balDyn.getPkValue());
        }
        needUpdateBals.addAll(keyDynMap.values());
    }

    private void updateReci(Map<Long, List<Long>> idMap) {
        HashSet oldAssSet = new HashSet();
        HashMap<Long, Long> oldToNewMap = new HashMap<Long, Long>();
        for (Map.Entry<Long, List<Long>> entry : idMap.entrySet()) {
            oldAssSet.addAll(entry.getValue());
            for (Long val : entry.getValue()) {
                oldToNewMap.put(val, entry.getKey());
            }
        }
        for (String entity : entityName) {
            DynamicObject[] dyns;
            QFilter assFilter = new QFilter("assgrp", "in", oldAssSet);
            for (DynamicObject entry : dyns = BusinessDataServiceHelper.load((String)entity, (String)"assgrp", (QFilter[])new QFilter[]{assFilter})) {
                Long assgrp = (Long)oldToNewMap.get(entry.getLong(GLField.id_((String)"assgrp")));
                if (assgrp == null) continue;
                entry.set("assgrp", (Object)assgrp);
            }
            List pkList = Arrays.stream(dyns).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            String info = String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u7684\u5f80\u6765id\uff1a%1$s%2$s", (String)"ReorderFlexDataUpgradeService_9", (String)"fi-gl-upgradeservice", (Object[])new Object[0]), entity, pkList);
            this.logList.add(info);
            LOGGER.info(info);
            SaveServiceHelper.save((DynamicObject[])dyns);
        }
    }

    private void updateVoucher(Map<Long, List<Long>> idMap) {
        DynamicObject[] vouchers;
        HashSet oldAssSet = new HashSet();
        HashMap<Long, Long> oldToNewMap = new HashMap<Long, Long>();
        for (Map.Entry<Long, List<Long>> entry : idMap.entrySet()) {
            oldAssSet.addAll(entry.getValue());
            for (Long val : entry.getValue()) {
                oldToNewMap.put(val, entry.getKey());
            }
        }
        QFilter assFilter = new QFilter("entries.assgrp", "in", oldAssSet);
        for (DynamicObject voucher : vouchers = BusinessDataServiceHelper.load((String)"gl_voucher", (String)"entries.assgrp", (QFilter[])new QFilter[]{assFilter})) {
            DynamicObjectCollection entries = voucher.getDynamicObjectCollection("entries");
            for (DynamicObject entry : entries) {
                Long assgrp = (Long)oldToNewMap.get(entry.getLong(GLField.id_((String)"assgrp")));
                if (assgrp == null) continue;
                entry.set("assgrp", (Object)assgrp);
            }
        }
        List pkList = Arrays.stream(vouchers).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        String info = String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u7684\u51ed\u8bc1id\uff1a%s", (String)"ReorderFlexDataUpgradeService_10", (String)"fi-gl-upgradeservice", (Object[])new Object[0]), pkList);
        this.logList.add(info);
        LOGGER.info(info);
        SaveServiceHelper.save((DynamicObject[])vouchers);
    }

    private void updateBalance(Map<Long, List<Long>> idMap) {
        MainEntityType balType = MetadataServiceHelper.getDataEntityType((String)"gl_balance");
        Set fieldSet = balType.getAllFields().keySet();
        String fieldStr = fieldSet.toString().replace("[", "").replace("]", "");
        ArrayList<Object> needRemovedBals = new ArrayList<Object>();
        LinkedHashMap<Integer, List<DynamicObject>> needUpdateBals = new LinkedHashMap<Integer, List<DynamicObject>>();
        for (Map.Entry<Long, List<Long>> entry : idMap.entrySet()) {
            List<Long> oldAssIds = entry.getValue();
            Long newAssId = entry.getKey();
            ArrayList<Long> allIds = new ArrayList<Long>(oldAssIds);
            allIds.add(newAssId);
            QFilter assgrpFilter = new QFilter("assgrp", "in", allIds);
            DynamicObject[] balDyns = BusinessDataServiceHelper.load((String)"gl_balance", (String)fieldStr, (QFilter[])new QFilter[]{assgrpFilter}, (String)"org,booktype,accounttable,account,currency,measureunit,period");
            this.setBalanceValue(needRemovedBals, needUpdateBals, newAssId, balDyns);
        }
        ArrayList pkList = new ArrayList();
        for (List list : needUpdateBals.values()) {
            pkList.addAll(list.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        String string = String.format(ResManager.loadKDString((String)"\u5220\u9664\u7684\u4f59\u989d\u8868\uff1a%s", (String)"ReorderFlexDataUpgradeService_11", (String)"fi-gl-upgradeservice", (Object[])new Object[0]), needRemovedBals);
        String info1 = String.format(ResManager.loadKDString((String)"\u66f4\u65b0\u7684\u4f59\u989d\u8868\uff1a%s", (String)"ReorderFlexDataUpgradeService_12", (String)"fi-gl-upgradeservice", (Object[])new Object[0]), pkList);
        LOGGER.info(info1);
        LOGGER.info(string);
        this.logList.add(info1);
        this.logList.add(string);
        BusinessDataWriter.delete((IDataEntityType)balType, (Object[])needRemovedBals.toArray());
        for (List values : needUpdateBals.values()) {
            SaveServiceHelper.save((DynamicObject[])values.toArray(new DynamicObject[0]));
        }
    }

    private void setBalanceValue(List<Object> needRemovedBals, Map<Integer, List<DynamicObject>> needUpdateBals, Long newAssId, DynamicObject[] balDyns) {
        HashMap keyDynMap = new HashMap();
        for (int i = 0; i < balDyns.length; ++i) {
            long prePeriod;
            DynamicObject preBalDyn;
            DynamicObject nextBalDyn;
            String nextKey;
            DynamicObject balDyn = balDyns[i];
            balDyn.set("assgrp", (Object)newAssId);
            String key = this.getKey(balDyn);
            long period = balDyn.getLong(GLField.id_((String)"period"));
            long endPeriod = i == balDyns.length - 1 ? GLUtil.MAX_PERIOD : (key.equals(nextKey = this.getKey(nextBalDyn = balDyns[i + 1])) ? nextBalDyn.getLong(GLField.id_((String)"period")) : GLUtil.MAX_PERIOD.longValue());
            balDyn.set("endperiod", (Object)endPeriod);
            List dynList = (List)keyDynMap.get(key);
            if (dynList == null) {
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
                list.add(balDyn);
                keyDynMap.put(key, list);
                continue;
            }
            if (dynList.size() == 1) {
                preBalDyn = (DynamicObject)dynList.get(0);
                prePeriod = preBalDyn.getLong(GLField.id_((String)"period"));
                if (period == prePeriod) {
                    for (String field : this.sumField.split(",")) {
                        preBalDyn.set(field, ReorderFlexDataUpgradeService.sum(preBalDyn.get(field), balDyn.get(field)));
                    }
                    preBalDyn.set("endperiod", (Object)endPeriod);
                    needRemovedBals.add(balDyn.getPkValue());
                    continue;
                }
                this.calBalDyn(balDyn, preBalDyn);
                dynList.add(balDyn);
                continue;
            }
            preBalDyn = (DynamicObject)dynList.get(dynList.size() - 1);
            prePeriod = preBalDyn.getLong(GLField.id_((String)"period"));
            if (period == prePeriod) {
                for (String field : this.sumField.split(",")) {
                    if (field.startsWith("end")) {
                        BigDecimal end = balDyn.getBigDecimal(field.replace("end", "debit")).subtract(balDyn.getBigDecimal(field.replace("end", "credit")));
                        preBalDyn.set(field, (Object)preBalDyn.getBigDecimal(field).add(end));
                        continue;
                    }
                    if (field.startsWith("year")) {
                        BigDecimal year = balDyn.getBigDecimal(field.replace("year", ""));
                        preBalDyn.set(field, (Object)preBalDyn.getBigDecimal(field).add(year));
                        continue;
                    }
                    if (field.startsWith("debit") || field.startsWith("credit")) {
                        preBalDyn.set(field, (Object)preBalDyn.getBigDecimal(field).add(balDyn.getBigDecimal(field)));
                        continue;
                    }
                    if (!field.startsWith("count")) continue;
                    preBalDyn.set(field, (Object)(preBalDyn.getInt(field) + balDyn.getInt(field)));
                }
                preBalDyn.set("endperiod", (Object)endPeriod);
                needRemovedBals.add(balDyn.getPkValue());
                continue;
            }
            this.calBalDyn(balDyn, preBalDyn);
            dynList.add(balDyn);
        }
        for (List value : keyDynMap.values()) {
            int i = 0;
            for (DynamicObject dyn : value) {
                List<Object> updates;
                if (needUpdateBals.get(i) == null) {
                    updates = new ArrayList<DynamicObject>();
                    updates.add(dyn);
                    needUpdateBals.put(i, updates);
                } else {
                    updates = needUpdateBals.get(i);
                    updates.add(dyn);
                }
                ++i;
            }
        }
    }

    private void calBalDyn(DynamicObject balDyn, DynamicObject preBalDyn) {
        long period = balDyn.getLong(GLField.id_((String)"period"));
        long prePeriod = preBalDyn.getLong(GLField.id_((String)"period"));
        for (String field : this.sumField.split(",")) {
            if (field.startsWith("begin")) {
                balDyn.set(field, preBalDyn.get(field.replace("begin", "end")));
                continue;
            }
            if (field.startsWith("end")) {
                BigDecimal end = balDyn.getBigDecimal(field.replace("end", "debit")).subtract(balDyn.getBigDecimal(field.replace("end", "credit")));
                balDyn.set(field, (Object)preBalDyn.getBigDecimal(field).add(end));
                continue;
            }
            if (!field.startsWith("year")) continue;
            if (this.isSameYear(period, prePeriod)) {
                BigDecimal year = balDyn.getBigDecimal(field.replace("year", ""));
                balDyn.set(field, (Object)preBalDyn.getBigDecimal(field).add(year));
                continue;
            }
            balDyn.set(field, balDyn.get(field.replace("year", "")));
        }
    }

    private boolean isSameYear(long period, long prePeriod) {
        return period / GLUtil.YEAR_PERIOD_L == prePeriod / GLUtil.YEAR_PERIOD_L;
    }

    private String getKey(DynamicObject balDyn) {
        String keys = "org,booktype,accounttable,account,currency,measureunit";
        StringBuilder sb = new StringBuilder();
        for (String key : keys.split(",")) {
            sb.append(balDyn.getLong(GLField.id_((String)key))).append("-");
        }
        return sb.toString();
    }

    private int getFlexPropertyIndex(String key) {
        if (this.flexKeyIndexes.containsKey(key)) {
            return this.flexKeyIndexes.get(key);
        }
        int idx = -1;
        try {
            idx = FlexEntityMetaUtils.getFlexProperty((String)key).getIndex();
            this.flexKeyIndexes.put(key, idx);
        }
        catch (Exception e) {
            LOGGER.error(key + " not exist. " + e.getMessage());
        }
        return idx;
    }

    private static Object sum(Object val1, Object val2) {
        if (val1 == null) {
            return val2;
        }
        if (val2 == null) {
            return val1;
        }
        if (val1 instanceof BigDecimal) {
            return ((BigDecimal)val1).add((BigDecimal)val2);
        }
        if (val1 instanceof Integer) {
            return (Integer)val1 + (Integer)val2;
        }
        if (val1 instanceof Double || val1 instanceof Float || val1 instanceof Long) {
            return new BigDecimal(val1.toString()).add(new BigDecimal(val2.toString()));
        }
        return null;
    }
}

