/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.fi.bd.service.balance.AppHelper;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.util.threads.Consumer;
import kd.fi.gl.util.threads.Producer;

public class VoucherBreakPointUpgradeService
implements IUpgradeService {
    private static final String UPGRADE_TASKNAME = "VoucherBreakPointUpgradeServiceTask";
    private static final int THREAD_PARALLELISM = 8;
    private static final int DEFAULT_CAPACITY = 64;
    private static final Log LOG = LogFactory.getLog(VoucherBreakPointUpgradeService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Class<VoucherBreakPointUpgradeService> clazz = VoucherBreakPointUpgradeService.class;
        synchronized (VoucherBreakPointUpgradeService.class) {
            UpgradeResult result = this.doUpgrade();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return result;
        }
    }

    private UpgradeResult doUpgrade() {
        UpgradeResult result;
        this.deleteNotAdjustData();
        boolean isNeedUpgrade = this.checkVoucherBreakPointHasData();
        if (!isNeedUpgrade) {
            LOG.info("VoucherBreakPointUpgradeServiceTask upgrade no need.");
            UpgradeResult result2 = new UpgradeResult();
            result2.setSuccess(true);
            long updateRowCount = 0L;
            long deleteRowCount = 0L;
            String log = String.format(this.getSuccessMsgPattern(), updateRowCount, deleteRowCount);
            LOG.info(log);
            result2.setLog(log);
            return result2;
        }
        long start = System.currentTimeMillis();
        try {
            result = this.doUpgradeParallel();
        }
        catch (Exception e) {
            result = new UpgradeResult();
            result.setSuccess(false);
            result.setErrorInfo(e.getMessage());
            result.setLog(this.getFailedMsg());
            LOG.error("VoucherBreakPointUpgradeServiceTask upgrade failed:" + e.getMessage(), (Throwable)e);
        }
        long end = System.currentTimeMillis();
        LOG.info("doUpgradeParallel cost: {} ms", (Object)(end - start));
        return result;
    }

    private String getFailedMsg() {
        return ResManager.loadKDString((String)"\u51ed\u8bc1\u65ad\u53f7\u8c03\u6574\u65e5\u5fd7\uff1a\u5347\u7ea7\u8d26\u7c3f\u7c7b\u578b\u548c\u5f53\u524d\u51ed\u8bc1\u53f7\u5b57\u6bb5\u5931\u8d25\u3002", (String)"VoucherBreakPointUpgradeService_1", (String)"fi-gl-upgradeservice", (Object[])new Object[0]);
    }

    private String getSuccessMsgPattern() {
        return ResManager.loadKDString((String)"\u51ed\u8bc1\u65ad\u53f7\u8c03\u6574\u65e5\u5fd7\uff1a\u5347\u7ea7\u8d26\u7c3f\u7c7b\u578b\u548c\u5f53\u524d\u51ed\u8bc1\u53f7\u5b57\u6bb5\u6210\u529f\u3002\u66f4\u65b0\u884c\u6570\uff1a%1$s\uff0c\u5220\u9664\u884c\u6570\uff1a%2$s\u3002", (String)"VoucherBreakPointUpgradeService_0", (String)"fi-gl-upgradeservice", (Object[])new Object[0]);
    }

    private void deleteNotAdjustData() {
        long start = System.currentTimeMillis();
        LOG.info("voucherbreakpoint notadjust data clear start");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -1);
    }

    private UpgradeResult doUpgradeParallel() {
        Tuple<VoucherBreakPointUpgradeProducer, Consumer> producerAndConsumer = this.prepareProducerAndConsumer();
        VoucherBreakPointUpgradeProducer producer = (VoucherBreakPointUpgradeProducer)((Object)producerAndConsumer.item1);
        Consumer consumer = (Consumer)producerAndConsumer.item2;
        ThreadPools.executeOnceIncludeRequestContext((String)"fi-gl-updatevoucherbreakpoint-producer", (Runnable)((Object)producer), (OperationContext)OperationContext.get());
        ThreadPools.executeOnceIncludeRequestContext((String)"fi-gl-updatevoucherbreakpoint-consumer", (Runnable)consumer, (OperationContext)OperationContext.get());
        String taskIdentifier = producer.getTaskIdentifier();
        try {
            consumer.getFinishLatch().await();
            LOG.info(taskIdentifier + " upgrade success");
        }
        catch (InterruptedException e) {
            LOG.error(taskIdentifier + " failed to upgrade on " + e.getMessage(), (Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        long updateRowCount = producer.getUpdateRowCount();
        long deleteRowCount = producer.getDeleteRowCount();
        String log = String.format(this.getSuccessMsgPattern(), updateRowCount, deleteRowCount);
        LOG.info(log);
        result.setLog(log);
        return result;
    }

    private Tuple<VoucherBreakPointUpgradeProducer, Consumer> prepareProducerAndConsumer() {
        ArrayBlockingQueue<Callable> taskQueue = new ArrayBlockingQueue<Callable>(64, true);
        AtomicBoolean isAbort = new AtomicBoolean(false);
        String taskIdentifier = UPGRADE_TASKNAME + RequestContext.getOrCreate().getRequestId();
        VoucherBreakPointUpgradeProducer producer = new VoucherBreakPointUpgradeProducer(taskQueue, taskIdentifier, isAbort);
        Consumer consumer = new Consumer(taskQueue, taskIdentifier, 8, (Producer)producer, isAbort);
        producer.setConsumer(consumer);
        return Tuple.create((Object)((Object)producer), (Object)consumer);
    }

    private boolean checkVoucherBreakPointHasData() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select TOP 1 fid from t_gl_voucherbreakpoint where 1 = 1", new Object[0]);
        boolean isNeedUpgrade = (Boolean)DB.query((DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder, rs -> rs.next());
        return isNeedUpgrade;
    }

    private static class VoucherBreakPointUpgradeProducer
    extends Producer {
        private long voucherBKIdCursor = -1L;
        private static String voucherBreakPoint_formId = "gl_voucherbreakpoint";
        private static String voucherBreakPoint_SelectFields = "id,voucherid,newvoucherno,booktypeid,curvoucherno";
        private static String voucher_SelectFields = "id,booktype,billno";
        private static String isForceCancel_Task_Key = "fi.gl.voucherbp.task.iscancel";
        private static String isForceCancel_BatchPorcess_Key_Pattern = "fi.gl.batchprocess.%s.iscancel";
        private AtomicLong totalUpdateCnt = new AtomicLong(0L);
        private AtomicLong totalDeleteCnt = new AtomicLong(0L);
        private final String producerLogPrefix = "producer for " + this.taskIdentifier;

        public VoucherBreakPointUpgradeProducer(BlockingQueue<Callable> sharedQueue, String taskIdentifier, AtomicBoolean isAbort) {
            super(sharedQueue, taskIdentifier, isAbort);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.startTick = System.currentTimeMillis();
            this.voucherBKIdCursor = BillParamUtil.getLongValue((String)"83bfebc8000017ac", (String)"fi.gl.voucherbreakpoint.initstartid", (long)-1L);
            int cycle = 0;
            try {
                int batchUpdateSize;
                int batchQuerySize;
                boolean allFinishProduced;
                do {
                    String keyOfForceCancel = String.format(isForceCancel_BatchPorcess_Key_Pattern, this.taskIdentifier);
                    LOG.info(this.producerLogPrefix + ", force cancel property key:" + keyOfForceCancel);
                    boolean isForceCancel = VoucherBreakPointUpgradeProducer.isForceCancel(keyOfForceCancel);
                    if (!isForceCancel) continue;
                    LOG.error(this.producerLogPrefix + "producer: ABORT on force cancel");
                    break;
                } while (!(allFinishProduced = this.produceTask(cycle, batchQuerySize = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.voucherbreakpoint.batchidscnt", (int)100000), batchUpdateSize = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.voucherbreakpoint.update.batchidscnt", (int)999))));
            }
            catch (Exception e) {
                LOG.error(this.producerLogPrefix + "producer: ABORT on error:" + e.getMessage(), (Throwable)e);
                this.consumer.getIsAbort().getAndSet(true);
            }
            finally {
                this.isAllTaskProduced.getAndSet(true);
                LOG.info(this.producerLogPrefix + "producer keep alive during: " + (System.currentTimeMillis() - this.startTick));
            }
        }

        private boolean produceTask(int cycle, int batchQuerySize, int batchUpdateSize) throws InterruptedException {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select top " + batchQuerySize + " fid,fvoucherid,fnewvoucherno,fbooktypeid,fcurvoucherno ", new Object[0]).append(" from t_gl_voucherbreakpoint ", new Object[0]).append(" where fid > ? ", new Object[]{this.voucherBKIdCursor}).append(" order by fid ", new Object[0]);
            try (DataSet voucherBreakPointDs = DB.queryDataSet((String)(Producer.class + ".fullBatchUpdate"), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);){
                ++cycle;
                if (!voucherBreakPointDs.hasNext()) {
                    LOG.info(this.producerLogPrefix + "producer: end, cost:" + (System.currentTimeMillis() - this.startTick));
                    boolean bl = true;
                    return bl;
                }
                LOG.info(this.producerLogPrefix + "producer: batch:" + cycle);
                HashMap<Long, VoucherBPUpdateParam> params = new HashMap<Long, VoucherBPUpdateParam>(batchUpdateSize);
                while (voucherBreakPointDs.hasNext()) {
                    Row row = voucherBreakPointDs.next();
                    long vbkId = row.getLong("fid");
                    params.put(vbkId, new VoucherBPUpdateParam(vbkId, row.getLong("fvoucherid"), row.getString("fnewvoucherno"), row.getLong("fbooktypeid"), row.getString("fcurvoucherno")));
                    if (vbkId > this.voucherBKIdCursor) {
                        this.voucherBKIdCursor = vbkId;
                    }
                    if (params.size() < batchUpdateSize) continue;
                    this.addTaskQueue(params, cycle, this.voucherBKIdCursor);
                }
                this.addTaskQueue(params, cycle, this.voucherBKIdCursor);
            }
            return false;
        }

        private void addTaskQueue(Map<Long, VoucherBPUpdateParam> params, int cycle, long voucherBKIdCursor) throws InterruptedException {
            if (!params.isEmpty()) {
                int curTaskIndex = this.produceTaskCnt.incrementAndGet();
                ArrayList<VoucherBPUpdateParam> voucherBpUpdateParams = new ArrayList<VoucherBPUpdateParam>(params.values());
                VoucherBPUpdateTask newTask = new VoucherBPUpdateTask(voucherBpUpdateParams, this.consumer, this, this.taskIdentifier, curTaskIndex);
                params.clear();
                while (!this.taskQueue.offer(newTask)) {
                    Thread.sleep(2000L);
                }
                LOG.info(String.format(this.producerLogPrefix + "producer: generate task index: %s with %s in cycle: %s, voucherBP id cursor: %s", this.produceTaskCnt.get(), voucherBpUpdateParams.size(), cycle, voucherBKIdCursor));
            }
        }

        public String getTaskIdentifier() {
            return this.taskIdentifier;
        }

        public long getUpdateRowCount() {
            return this.totalUpdateCnt.get();
        }

        public long getDeleteRowCount() {
            return this.totalDeleteCnt.get();
        }

        private static boolean isForceCancel(String key) {
            boolean isForceCancel = Boolean.parseBoolean(AppHelper.getSystemProperty((String)key, (String)"false"));
            return isForceCancel;
        }

        private static class VoucherBPUpdateTask
        implements Callable {
            private final List<VoucherBPUpdateParam> batchUpdateParams;
            private final Consumer consumer;
            private final VoucherBreakPointUpgradeProducer producer;
            private final String taskIdentifier;
            private final int curTaskIndex;

            public VoucherBPUpdateTask(List<VoucherBPUpdateParam> batchUpdateParams, Consumer consumer, VoucherBreakPointUpgradeProducer producer, String taskIdentifier, int curTaskIndex) {
                this.batchUpdateParams = batchUpdateParams;
                this.consumer = consumer;
                this.producer = producer;
                this.taskIdentifier = taskIdentifier;
                this.curTaskIndex = curTaskIndex;
            }

            public Object call() throws Exception {
                String taskLogPrefix = "producer for " + this.taskIdentifier;
                long taskTick = System.currentTimeMillis();
                boolean isForceCancel = VoucherBreakPointUpgradeProducer.isForceCancel(isForceCancel_Task_Key);
                if (isForceCancel) {
                    LOG.error(taskLogPrefix + "consumer,ABORT on force cancel");
                    this.consumer.getIsAbort().getAndSet(true);
                }
                if (this.consumer.getIsAbort().get()) {
                    LOG.info(taskLogPrefix + "consumer,worker aborted.");
                    return null;
                }
                try (TXHandle tx = TX.requiresNew();){
                    try {
                        int updateRowsCnt = this.batchUpdate(this.batchUpdateParams);
                        this.consumer.getTotalHandleItemCnt().getAndAdd(updateRowsCnt);
                        LOG.info(taskLogPrefix + String.format("consumer,worker task index: %s, update voucher size: %s, update entry rows: %s, cost: %s.", this.curTaskIndex, this.batchUpdateParams.size(), updateRowsCnt, System.currentTimeMillis() - taskTick));
                        this.batchUpdateParams.clear();
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        this.consumer.getIsAbort().getAndSet(true);
                        LOG.error(taskLogPrefix + String.format("consumer,worker update voucher size: %s, failed on : %s", this.batchUpdateParams.size(), e.getMessage()), (Throwable)e);
                    }
                }
                return null;
            }

            private int batchUpdate(List<VoucherBPUpdateParam> batchUpdateParams) {
                ArrayList<VoucherBPUpdateParam> notAdjustList = new ArrayList<VoucherBPUpdateParam>(8);
                ArrayList<VoucherBPUpdateParam> isAdjustAndNoComlunValueList = new ArrayList<VoucherBPUpdateParam>(8);
                ArrayList<VoucherBPUpdateParam> isAdjustAndHasComlunValueList = new ArrayList<VoucherBPUpdateParam>(8);
                for (VoucherBPUpdateParam voucherBPUpdateParam : batchUpdateParams) {
                    if (StringUtils.isEmpty((String)voucherBPUpdateParam.getNewvoucherno())) {
                        notAdjustList.add(voucherBPUpdateParam);
                        continue;
                    }
                    if (StringUtils.isEmpty((String)voucherBPUpdateParam.getCurvoucherno()) || voucherBPUpdateParam.getBooktypeid() == null || voucherBPUpdateParam.getBooktypeid() == 0L) {
                        isAdjustAndNoComlunValueList.add(voucherBPUpdateParam);
                        continue;
                    }
                    isAdjustAndHasComlunValueList.add(voucherBPUpdateParam);
                }
                this.deleteNotAdjustData(notAdjustList);
                this.queryVoucherDataAndUpdate(isAdjustAndNoComlunValueList);
                this.logSummaryIsAdjustAndHasComlunValueList(isAdjustAndHasComlunValueList);
                return batchUpdateParams.size();
            }

            private void queryVoucherDataAndUpdate(List<VoucherBPUpdateParam> isAdjustAndNoComlunValueList) {
                if (isAdjustAndNoComlunValueList.isEmpty()) {
                    return;
                }
                List<VoucherBPUpdateParam> updateParamList = this.queryVoucherData(isAdjustAndNoComlunValueList);
                this.updateAdjustData(updateParamList);
            }

            private List<VoucherBPUpdateParam> queryVoucherData(List<VoucherBPUpdateParam> isAdjustAndNoComlunValueList) {
                Set voucherIdList = isAdjustAndNoComlunValueList.stream().map(VoucherBPUpdateParam::getVoucherid).collect(Collectors.toSet());
                HashMap<Long, VoucherBPUpdateParam> voucherIdMap = new HashMap<Long, VoucherBPUpdateParam>(8);
                ArrayList<VoucherBPUpdateParam> updateParamList = new ArrayList<VoucherBPUpdateParam>(8);
                HashSet<Long> notFoundVoucherIdSet = new HashSet<Long>(8);
                try (DataSet voucherDs = QueryServiceHelper.queryDataSet((String)(Producer.class + ".queryVoucherData"), (String)"gl_voucher", (String)voucher_SelectFields, (QFilter[])new QFilter("id", "in", voucherIdList).toArray(), null);){
                    while (voucherDs.hasNext()) {
                        Row voucherRow = voucherDs.next();
                        long vid = voucherRow.getLong("id");
                        String voucherno = voucherRow.getString("billno");
                        Long booktypeid = voucherRow.getLong("booktype");
                        VoucherBPUpdateParam voucherInfo = new VoucherBPUpdateParam(vid, booktypeid, voucherno);
                        voucherIdMap.put(vid, voucherInfo);
                    }
                }
                for (VoucherBPUpdateParam voucherBPUpdateParam : isAdjustAndNoComlunValueList) {
                    VoucherBPUpdateParam voucherInfo = (VoucherBPUpdateParam)voucherIdMap.get(voucherBPUpdateParam.getVoucherid());
                    if (null != voucherInfo) {
                        voucherBPUpdateParam.setBooktypeid(voucherInfo.getBooktypeid());
                        voucherBPUpdateParam.setCurvoucherno(voucherInfo.getCurvoucherno());
                        updateParamList.add(voucherBPUpdateParam);
                        continue;
                    }
                    notFoundVoucherIdSet.add(voucherBPUpdateParam.getVoucherid());
                }
                this.logNotFoundVoucherIdList(notFoundVoucherIdSet);
                return updateParamList;
            }

            private void deleteNotAdjustData(List<VoucherBPUpdateParam> notAdjustList) {
                if (notAdjustList.isEmpty()) {
                    return;
                }
                int[] deleteRowCnts = DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"delete from t_gl_voucherbreakpoint where fid = ? ", notAdjustList.stream().map(x -> x.buildDeleteParamArray()).collect(Collectors.toList()));
                int sum = Arrays.stream(deleteRowCnts).sum();
                this.producer.totalDeleteCnt.getAndAdd(sum);
            }

            private void updateAdjustData(List<VoucherBPUpdateParam> updateParamList) {
                if (updateParamList.isEmpty()) {
                    return;
                }
                int[] updateRowCnts = DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"update t_gl_voucherbreakpoint set fbooktypeid = ?, fcurvoucherno = ? where fid = ? ", updateParamList.stream().map(x -> x.buildUpdateParamArray()).collect(Collectors.toList()));
                int sum = Arrays.stream(updateRowCnts).sum();
                this.producer.totalUpdateCnt.getAndAdd(sum);
            }

            private void logSummaryIsAdjustAndHasComlunValueList(List<VoucherBPUpdateParam> isAdjustAndHasComlunValueList) {
                int size = isAdjustAndHasComlunValueList.size();
                if (size > 0) {
                    VoucherBPUpdateParam voucherBPUpdateParam = isAdjustAndHasComlunValueList.get(0);
                    LOG.info("IsAdjustAndHasComlunValueList size: {}, one sample: {}", (Object)size, (Object)voucherBPUpdateParam);
                }
            }

            private void logNotFoundVoucherIdList(Set<Long> notFoundVoucherIdSet) {
                int size = notFoundVoucherIdSet.size();
                if (size > 0) {
                    LOG.info("notFoundVoucherIdSet size: {}, one sample VoucherId: {}", (Object)size, (Object)notFoundVoucherIdSet.iterator().next());
                }
            }
        }

        private static class VoucherBPUpdateParam {
            private Long vbkId;
            private Long voucherid;
            private String newvoucherno;
            private Long booktypeid;
            private String curvoucherno;

            public VoucherBPUpdateParam(Long vbkId, long voucherid, String newvoucherno, long booktypeid, String curvoucherno) {
                this.vbkId = vbkId;
                this.voucherid = voucherid;
                this.newvoucherno = newvoucherno;
                this.booktypeid = booktypeid;
                this.curvoucherno = curvoucherno;
            }

            public VoucherBPUpdateParam(Long voucherid, Long booktypeid, String curvoucherno) {
                this.voucherid = voucherid;
                this.booktypeid = booktypeid;
                this.curvoucherno = curvoucherno;
            }

            public Long getVoucherid() {
                return this.voucherid;
            }

            public String getNewvoucherno() {
                return this.newvoucherno;
            }

            public Long getBooktypeid() {
                return this.booktypeid;
            }

            public void setBooktypeid(Long booktypeid) {
                this.booktypeid = booktypeid;
            }

            public String getCurvoucherno() {
                return this.curvoucherno;
            }

            public void setCurvoucherno(String curvoucherno) {
                this.curvoucherno = curvoucherno;
            }

            public Object[] buildDeleteParamArray() {
                return new Object[]{this.vbkId};
            }

            public Object[] buildUpdateParamArray() {
                return new Object[]{this.booktypeid, this.curvoucherno, this.vbkId};
            }

            public String toString() {
                return "VoucherBPUpdateParam{vbkId=" + this.vbkId + ", voucherid=" + this.voucherid + ", newvoucherno='" + this.newvoucherno + '\'' + ", booktypeid=" + this.booktypeid + ", curvoucherno='" + this.curvoucherno + '\'' + '}';
            }
        }
    }
}

