/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;

public class VoucherSupAjustUpgrade
implements IUpgradeService {
    String SETECT_CF_VOUCHER = "select v.fid cfvid from t_gl_voucher v left join t_gl_voucherentry ve on v.fid=ve.fid where v.forgid=? and ve.faccountid in (select fid from t_bd_account where fiscash = '1' or fisbank ='1' or fiscashequivalent= '1' or fpltype <> '0') group by cfvid";
    String SELECT_ALL_VOUCHER = "select v.fid id,ve.fsuppcfitemid suppcf,ve.fsuppcfamount suppcfamount from t_gl_voucher v left join t_gl_voucherentry ve on v.fid=ve.fid  where  v.forgid = ? and v.fsuppstatus not in ('a','b','c') and v.fbillstatus <> 'A'  order by v.fbooktypeid,v.fperiodid,v.fid";
    String UPDATE_VOUCHER_SUPPSTATUS = "update t_gl_voucher set fsuppstatus = ? where fid in (?";
    private static final Log log = LogFactory.getLog((String)"VoucherSupAjustUpgrade");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        ThreadPools.executeOnce((String)"fi/gl/VoucherSupAjustUpgrade", () -> {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_accountbook", (String)"org", (QFilter[])new QFilter[]{new QFilter("isbizunit", "=", (Object)"1")}, null);){
                for (Row row : ds) {
                    this.update(row.getLong("org"));
                    log.info("VoucherSupAjustUpgrade------success" + row.getLong("org"));
                }
            }
        });
        result.setSuccess(true);
        return result;
    }

    private void update(Long orgId) {
        DBRoute gl = DBRoute.of((String)"gl");
        DataSet cfVoucherDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)gl, (String)this.SETECT_CF_VOUCHER, (Object[])new Object[]{orgId});
        DataSet allVoucherDs = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)gl, (String)this.SELECT_ALL_VOUCHER, (Object[])new Object[]{orgId});
        DataSet joinDs = allVoucherDs.join(cfVoucherDs, JoinType.LEFT).on("id", "cfvid").select(new String[]{"id", "suppcf", "suppcfamount"}, new String[]{"cfvid"}).finish();
        try (DataSet voucherDs = joinDs.filter("cfvid is null");){
            long voucherid = 0L;
            boolean hasSuppCf = false;
            BigDecimal suppCfAmount = BigDecimal.ZERO;
            HashSet<Long> notyet = new HashSet<Long>(1000);
            HashSet<Long> part = new HashSet<Long>(1000);
            HashSet<Long> yes = new HashSet<Long>(1000);
            for (Row row : voucherDs) {
                long suppCfItem;
                if (voucherid != 0L && voucherid != row.getLong("id")) {
                    if (hasSuppCf && suppCfAmount.compareTo(BigDecimal.ZERO) == 0) {
                        yes.add(voucherid);
                        this.updateVoucher(yes, "c", false);
                    } else if (hasSuppCf && suppCfAmount.compareTo(BigDecimal.ZERO) != 0) {
                        part.add(voucherid);
                        this.updateVoucher(part, "b", false);
                    } else if (!hasSuppCf) {
                        notyet.add(voucherid);
                        this.updateVoucher(notyet, "a", false);
                    }
                    voucherid = row.getLong("id");
                    suppCfAmount = BigDecimal.ZERO;
                    hasSuppCf = false;
                } else if (voucherid == 0L) {
                    voucherid = row.getLong("id");
                }
                if ((suppCfItem = row.getLong("suppcf").longValue()) == 0L) continue;
                hasSuppCf = true;
                suppCfAmount = suppCfAmount.add(row.getBigDecimal("suppcfamount"));
            }
            if (hasSuppCf && suppCfAmount.compareTo(BigDecimal.ZERO) == 0) {
                yes.add(voucherid);
            } else if (hasSuppCf && suppCfAmount.compareTo(BigDecimal.ZERO) != 0) {
                part.add(voucherid);
            } else if (!hasSuppCf) {
                notyet.add(voucherid);
            }
            if (notyet.size() != 0) {
                this.updateVoucher(notyet, "a", true);
            }
            if (part.size() != 0) {
                this.updateVoucher(part, "b", true);
            }
            if (yes.size() != 0) {
                this.updateVoucher(yes, "c", true);
            }
        }
        log.info("VoucherSupAjustUpgrade ---success-- org\uff1a" + orgId);
    }

    private void updateVoucher(Set<Long> voucherIds, String status, boolean last) {
        if (last || !last && voucherIds.size() == 1000) {
            try (TXHandle txHandle = TX.requiresNew();){
                try {
                    ArrayList<Object> paramList = new ArrayList<Object>(voucherIds.size());
                    paramList.add(status);
                    paramList.addAll(voucherIds);
                    Object[] param = paramList.toArray();
                    DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)this.getSql(this.UPDATE_VOUCHER_SUPPSTATUS, voucherIds.size()), (Object[])param);
                    voucherIds.clear();
                }
                catch (Exception e) {
                    txHandle.markRollback();
                    log.info("VoucherSupAjustUpgrade --- error -- voucherid=:" + voucherIds.iterator().next());
                }
            }
        }
    }

    private String getSql(String sql, int size) {
        StringBuilder sb = new StringBuilder(sql);
        for (int i = 1; i < size; ++i) {
            sb.append(",?");
        }
        sb.append(")");
        return sb.toString();
    }
}

