/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.upgradeservice;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class YearProfitAcctUpgradeService
implements IUpgradeService {
    private static final String QUERY_TRANS_PL_PROGRAM = "SELECT FORGID, FBOOKID, MAX(FYEARPROFITACCT) AS FYEARPROFITACCT FROM T_GL_TRANSPLPROGRAM GROUP BY FORGID, FBOOKID;";
    private static final String UPDATE_ACCOUNT_BOOK = "UPDATE T_BD_ACCOUNTBOOKS SET FYEARPROFITACCTID = ? WHERE FORGID = ? AND FBOOKSTYPEID = ?";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try (TXHandle handle = TX.requiresNew();){
            try {
                DBRoute gl = DBRoute.of((String)"gl");
                List updateBookParams = (List)DB.query((DBRoute)gl, (String)QUERY_TRANS_PL_PROGRAM, (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

                    public List<Object[]> handle(ResultSet rs) throws Exception {
                        ArrayList<Object[]> result = new ArrayList<Object[]>(16);
                        while (rs.next()) {
                            Object[] params = new Object[]{rs.getLong("fyearprofitacct"), rs.getLong("forgid"), rs.getLong("fbookid")};
                            result.add(params);
                        }
                        return result;
                    }
                });
                if (updateBookParams != null && !updateBookParams.isEmpty()) {
                    int[] exeRes = DB.executeBatch((DBRoute)gl, (String)UPDATE_ACCOUNT_BOOK, (List)updateBookParams);
                    result.setLog("year profit account update success count: " + exeRes.length);
                }
                result.setSuccess(true);
            }
            catch (Exception e) {
                result.setSuccess(false);
                result.setErrorInfo(e.getMessage());
                result.setLog("year profit account update faild :" + e.getMessage());
                handle.markRollback();
            }
        }
        return result;
    }
}

