/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.api;

import java.util.concurrent.Future;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.util.JSONUtils;
import kd.fi.gl.api.AgingApiQueryParam;
import kd.fi.gl.common.CommonResult;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.reciprocal.agingservice.AgingQueryParam;
import kd.fi.gl.reciprocal.agingservice.util.AgingApiUtil;

@ApiController(value="gl", desc="\u603b\u8d26\u8d26\u9f84\u63a5\u53e3")
public class AgingApiHelper
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(AgingApiHelper.class);

    @ApiPostMapping(value="/getAging")
    public CustomApiResult<String> getAging(@ApiRequestBody AgingApiQueryParam model) {
        String strData;
        try {
            AgingQueryParam agingQueryParam = model.toAgingQueryParam();
            Future future = ThreadService.submit(() -> {
                try {
                    CommonResult agingData = AgingApiUtil.getAgingData((AgingQueryParam)agingQueryParam);
                    return JSONUtils.toString((Object)agingData);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    throw new KDBizException(e.getMessage());
                }
            }, (TaskType)TaskType.GL_RECIPROCAL_AGINGSERVICE);
            strData = (String)future.get();
        }
        catch (Exception e) {
            log.error("get aging fail \uff1a " + e.getMessage(), (Throwable)e);
            GLException glException = new GLException(e instanceof GLException ? ((GLException)e).getErrorCode() : new ErrorCode("999", "Unknown"), new Object[]{e.getMessage()});
            ApiResult apiResult = ApiResult.ex((Throwable)glException);
            return CustomApiResult.fail((String)apiResult.getErrorCode(), (String)apiResult.getMessage());
        }
        return CustomApiResult.success((Object)strData);
    }
}

