/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;

@ApiController(value="gl", desc="\u79d1\u76ee\u4f59\u989d\u53cd\u7ed3\u675f\u521d\u59cb\u5316")
public class AntiCloseInitBalanceApiHelper {
    private static final String SUCCESS_KEY = "success";
    private static final String ORG_KEY = "org";
    private static final String MESSAGE_KEY = "message";

    @ApiPostMapping(value="/anticloseinit")
    public CustomApiResult<String> antiCloseInitBalance(@ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", example="[\"53461\"]", required=true) @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", example="[\"53461\"]", required=true) List<String> orgNumList, @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", example="\"HY001\"", required=true) @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", example="\"HY001\"", required=true) String bookTypeNum) {
        long booksTypeId = 0L;
        DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bos_org", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", orgNumList)}, null);
        HashMap<String, Long> orgNumToIdMap = new HashMap<String, Long>(8);
        while (orgDataSet.hasNext()) {
            Row row = orgDataSet.next();
            orgNumToIdMap.put(row.getString("number"), row.getLong("id"));
        }
        DataSet bookTypeDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bookTypeNum)}, null);
        if (bookTypeDataSet.hasNext()) {
            booksTypeId = bookTypeDataSet.next().getLong("id");
        }
        return this.buildResult(this.batchAntiCloseInit(orgNumList, orgNumToIdMap, booksTypeId));
    }

    private CustomApiResult<String> buildResult(List<Map<String, Object>> resultList) {
        boolean hasFail = false;
        int failCount = 0;
        int successCount = 0;
        StringBuilder errorMsgSb = new StringBuilder();
        for (Map<String, Object> result : resultList) {
            boolean success = (Boolean)result.getOrDefault(SUCCESS_KEY, false);
            if (success) {
                ++successCount;
                continue;
            }
            hasFail = true;
            ++failCount;
            errorMsgSb.append(result.getOrDefault(ORG_KEY, "")).append(":").append(result.getOrDefault(MESSAGE_KEY, ""));
        }
        if (hasFail) {
            String countMessage = ResManager.loadResFormat((String)"\u5171\u64cd\u4f5c%1\u9879\uff0c\u6210\u529f%2\u9879\uff0c\u5931\u8d25%3\u9879\u3002", (String)"AntiCloseInitBalanceApiHelper_4", (String)"fi-gl-webapi", (Object[])new Object[]{resultList.size(), successCount, failCount});
            return CustomApiResult.fail((String)"500", (String)(countMessage + errorMsgSb));
        }
        return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u53cd\u7ed3\u675f\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"AntiCloseInitBalanceApiHelper_2", (String)"fi-gl-webapi", (Object[])new Object[0]));
    }

    private List<Map<String, Object>> batchAntiCloseInit(Collection<String> orgNums, Map<String, Long> orgNumToIdMap, long booksTypeId) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(8);
        for (String orgNum : orgNums) {
            Map<String, Object> result = this.antiCloseInit(orgNumToIdMap.getOrDefault(orgNum, 0L), booksTypeId);
            result.put(ORG_KEY, orgNum);
            resultList.add(result);
        }
        return resultList;
    }

    private Map<String, Object> antiCloseInit(long orgId, long booksTypeId) {
        if (!this.checkUserPermission(orgId)) {
            return this.buildFailResult(ResManager.loadKDString((String)"\u65e0\u201c\u79d1\u76ee\u4f59\u989d\u521d\u59cb\u5316\u201d\u7684\u201c\u53cd\u7ed3\u675f\u521d\u59cb\u5316\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AntiCloseInitBalanceApiHelper_5", (String)"fi-gl-webapi", (Object[])new Object[0]));
        }
        if (orgId == 0L || booksTypeId == 0L) {
            return this.buildFailResult(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6216\u8d26\u7c3f\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"AntiCloseInitBalanceApiHelper_0", (String)"fi-gl-webapi", (Object[])new Object[0]));
        }
        DynamicObject book = AccSysUtil.loadSingleBook((Object)orgId, (Object)booksTypeId, (String)"id");
        if (Objects.isNull(book)) {
            return this.buildFailResult(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u8d26\u7c3f\u4fe1\u606f\u3002", (String)"AntiCloseInitBalanceApiHelper_1", (String)"fi-gl-webapi", (Object[])new Object[0]));
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"anticloseinitbalance", (String)"gl_endinit", (DynamicObject[])new DynamicObject[]{book = BusinessDataServiceHelper.loadSingle((Object)book.getLong("id"), (String)"gl_endinit")}, (OperateOption)OperateOption.create());
        if (result.isSuccess()) {
            return this.buildSuccessResult(ResManager.loadKDString((String)"\u53cd\u7ed3\u675f\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"AntiCloseInitBalanceApiHelper_2", (String)"fi-gl-webapi", (Object[])new Object[0]));
        }
        if (!result.getValidateResult().getValidateErrors().isEmpty() && !((ValidateResult)result.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().isEmpty()) {
            return this.buildFailResult(((OperateErrorInfo)((ValidateResult)result.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage());
        }
        return this.buildFailResult(ResManager.loadKDString((String)"\u53cd\u7ed3\u675f\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"AntiCloseInitBalanceApiHelper_3", (String)"fi-gl-webapi", (Object[])new Object[0]));
    }

    private Map<String, Object> buildFailResult(String errorMessage) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put(SUCCESS_KEY, false);
        result.put(MESSAGE_KEY, errorMessage);
        return result;
    }

    private Map<String, Object> buildSuccessResult(String successMessage) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put(SUCCESS_KEY, true);
        result.put(MESSAGE_KEY, successMessage);
        return result;
    }

    private boolean checkUserPermission(long orgId) {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)orgId, (String)"gl", (String)"gl_initbalance", (String)"4730fc9f000006ae") == 1;
    }
}

