/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.api;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.closeperiod.breakpoint.BreakPointCommonUtil;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLBreakPointUtil;
import kd.fi.gl.util.voucher.VoucherNumberUtils;

@ApiController(value="gl", desc="\u51ed\u8bc1\u65ad\u53f7\u81ea\u52a8\u8c03\u6574")
public class BreakNumberAdjustmentApiHelper
implements IBillWebApiPlugin {
    private static final Log LOG = LogFactory.getLog(BreakNumberAdjustmentApiHelper.class);

    @ApiPostMapping(value="/breakNumberAdjustment")
    public CustomApiResult<Map<String, String>> adjustment(@ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", example="[\"org-001\",\"org-002\"]", required=true) @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", example="[\"org-001\",\"org-002\"]", required=true) List<String> orgNumbers, @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", example="100001", required=true) @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", example="100001", required=true) String bookTypeNumber, @ApiParam(value="\u671f\u95f4\u7f16\u7801", example="202308", required=true) @ApiParam(value="\u671f\u95f4\u7f16\u7801", example="202308", required=true) String periodNumber, @ApiParam(value="\u8c03\u6574\u7c7b\u578b\uff0c0:\u81ea\u52a8\u8c03\u6574\uff0c1:\u6309\u8bb0\u8d26\u65e5\u671f\u6392\u5e8f\u8c03\u6574\uff0c2:\u6309\u4e1a\u52a1\u65e5\u671f\u6392\u5e8f\u8c03\u6574", example="0", required=true) @ApiParam(value="\u8c03\u6574\u7c7b\u578b\uff0c0:\u81ea\u52a8\u8c03\u6574\uff0c1:\u6309\u8bb0\u8d26\u65e5\u671f\u6392\u5e8f\u8c03\u6574\uff0c2:\u6309\u4e1a\u52a1\u65e5\u671f\u6392\u5e8f\u8c03\u6574", example="0", required=true) String adjustmentTypeCode) {
        AdjustmentType adjustmentType;
        if (DebugTrace.enable()) {
            LOG.info("breakNumberAdjustment_param org: {}, bookType: {}, period: {}, type: {}.", new Object[]{orgNumbers, bookTypeNumber, periodNumber, adjustmentTypeCode});
        }
        if ((adjustmentType = AdjustmentType.of(adjustmentTypeCode)) == null) {
            return CustomApiResult.fail((String)"500", (String)ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u5408\u9002\u7684\u8c03\u6574\u7c7b\u578b\u3002", (String)"BreakNumberAdjustmentApiHelper_0", (String)GLApp.instance.webapiModule(), (Object[])new Object[0]));
        }
        if (CollectionUtils.isEmpty(orgNumbers)) {
            return CustomApiResult.fail((String)"500", (String)ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u9700\u8981\u8c03\u6574\u7684\u7ec4\u7ec7\u7f16\u7801\u3002", (String)"BreakNumberAdjustmentApiHelper_9", (String)GLApp.instance.webapiModule(), (Object[])new Object[0]));
        }
        DynamicObject bookType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter("number", "=", (Object)bookTypeNumber).toArray());
        if (bookType == null) {
            return CustomApiResult.fail((String)"500", (String)String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u8d26\u7c3f\u7c7b\u578b\u6570\u636e%1$s\u3002", (String)"BreakNumberAdjustmentApiHelper_2", (String)GLApp.instance.webapiModule(), (Object[])new Object[0]), bookTypeNumber));
        }
        HashMap<String, CustomApiResult<String>> orgResultMap = new HashMap<String, CustomApiResult<String>>(orgNumbers.size());
        for (String orgNumber : orgNumbers) {
            CustomApiResult<String> orgResult = this.doAdjustment(orgNumber, bookTypeNumber, bookType.getLong("id"), periodNumber, adjustmentType);
            orgResultMap.put(orgNumber, orgResult);
        }
        boolean existsFailed = orgResultMap.values().stream().anyMatch(x -> !x.isStatus());
        Map<String, String> orgMsgMap = orgResultMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> ((CustomApiResult)x.getValue()).isStatus() ? (String)((CustomApiResult)x.getValue()).getData() : ((CustomApiResult)x.getValue()).getMessage()));
        if (existsFailed) {
            CustomApiResult result = CustomApiResult.fail((String)"500", (String)ResManager.loadKDString((String)"\u65ad\u53f7\u81ea\u52a8\u8c03\u6574\u5931\u8d25\u3002", (String)"BreakNumberAdjustmentApiHelper_10", (String)GLApp.instance.webapiModule(), (Object[])new Object[0]));
            result.setData(orgMsgMap);
            return result;
        }
        return CustomApiResult.success(orgMsgMap);
    }

    private CustomApiResult<String> doAdjustment(String orgNumber, String bookTypeNumber, Long bookTypeId, String periodNumber, AdjustmentType adjustmentType) {
        try {
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter("number", "=", (Object)orgNumber).toArray());
            if (org == null) {
                return CustomApiResult.fail((String)"500", (String)String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7ec4\u7ec7\u6570\u636e\u201c%1$s\u201d\u3002", (String)"BreakNumberAdjustmentApiHelper_1", (String)GLApp.instance.webapiModule(), (Object[])new Object[0]), orgNumber));
            }
            DynamicObject book = AccSysUtil.loadSingleBook((Object)org.getPkValue(), (Object)bookTypeId, (String)"periodtype.id");
            if (book == null) {
                return CustomApiResult.fail((String)"500", (String)String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u7ec4\u7ec7%1$s\u548c\u8d26\u7c3f\u7c7b\u578b%2$s\u5bf9\u5e94\u7684\u4f1a\u8ba1\u8d26\u7c3f\u3002", (String)"BreakNumberAdjustmentApiHelper_3", (String)GLApp.instance.webapiModule(), (Object[])new Object[0]), orgNumber, bookTypeNumber));
            }
            DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"id", (QFilter[])new QFilter("number", "=", (Object)periodNumber).and("periodtype", "=", (Object)book.getLong("periodtype.id")).toArray());
            if (period == null) {
                return CustomApiResult.fail((String)"500", (String)String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u671f\u95f4\u6570\u636e%1$s\u3002", (String)"BreakNumberAdjustmentApiHelper_4", (String)GLApp.instance.webapiModule(), (Object[])new Object[0]), periodNumber));
            }
            Long orgId = org.getLong("id");
            int permission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)orgId, (String)"gl", (String)"gl_voucherbreakpoint", (String)"0KVV7K8G7=01");
            if (permission == 0) {
                return CustomApiResult.fail((String)"500", (String)ResManager.loadKDString((String)"\u65e0\u201c\u65ad\u53f7\u8c03\u6574\u201d\u7684\u201d\u81ea\u52a8\u8c03\u6574\u201c\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BreakNumberAdjustmentApiHelper_5", (String)GLApp.instance.webapiModule(), (Object[])new Object[0]));
            }
            Long periodId = period.getLong("id");
            boolean isInterno = this.isInterno(orgId.toString(), orgNumber, bookTypeId.toString(), periodId.toString(), adjustmentType);
            if (!isInterno) {
                return CustomApiResult.fail((String)"500", (String)ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u4e0d\u5b58\u5728\u65ad\u53f7\u3002", (String)"BreakNumberAdjustmentApiHelper_6", (String)GLApp.instance.webapiModule(), (Object[])new Object[0]));
            }
            DynamicObject operationData = BusinessDataServiceHelper.newDynamicObject((String)"gl_voucher");
            operationData.set("org", (Object)orgId);
            operationData.set("booktype", (Object)bookTypeId);
            operationData.set("period", (Object)periodId);
            OperateOption option = OperateOption.create();
            option.setVariableValue("bookeddateorder", adjustmentType.code);
            if (DebugTrace.enable()) {
                LOG.info("breakNumberAdjustment_opParam org: {}, bookType: {}, period: {}, type: {}.", new Object[]{orgId, bookTypeId, periodId, adjustmentType.code});
            }
            OperationResult result = OperationServiceHelper.executeOperate((String)"checkbreakpoint", (String)"gl_voucher", (DynamicObject[])new DynamicObject[]{operationData}, (OperateOption)option);
            if (DebugTrace.enable()) {
                LOG.info("breakNumberAdjustment_opResult org: {}, bookType: {}, period: {}, type: {}, result: {}.", new Object[]{orgId, bookTypeId, periodId, adjustmentType.code, result.isSuccess()});
            }
            if (!result.isSuccess()) {
                String error = !result.getAllErrorInfo().isEmpty() ? result.getAllErrorInfo().stream().map(OperateInfo::getMessage).collect(Collectors.joining("\n")) : result.getMessage();
                return CustomApiResult.fail((String)"500", (String)String.format(ResManager.loadKDString((String)"\u65ad\u53f7\u81ea\u52a8\u8c03\u6574\u5931\u8d25\uff1a%1$s", (String)"BreakNumberAdjustmentApiHelper_7", (String)GLApp.instance.webapiModule(), (Object[])new Object[0]), error));
            }
            return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u65ad\u53f7\u81ea\u52a8\u8c03\u6574\u6210\u529f\u3002", (String)"BreakNumberAdjustmentApiHelper_8", (String)GLApp.instance.webapiModule(), (Object[])new Object[0]));
        }
        catch (Exception e) {
            LOG.error(String.format("breakNumberAdjustment_failed org: %s, bookType: %s, period: %s, type: %s, error: %s.", orgNumber, bookTypeNumber, periodNumber, adjustmentType.code, e.getMessage()), (Throwable)e);
            return CustomApiResult.fail((String)"500", (String)String.format(ResManager.loadKDString((String)"\u65ad\u53f7\u81ea\u52a8\u8c03\u6574\u5931\u8d25\uff1a%1$s", (String)"BreakNumberAdjustmentApiHelper_7", (String)GLApp.instance.webapiModule(), (Object[])new Object[0]), e.getMessage()));
        }
    }

    private boolean isInterno(String orgId, String orgNumber, String booksTypeId, String periodId, AdjustmentType adjustmentType) {
        boolean result = false;
        CodeRuleInfo coderule = BreakPointCommonUtil.getCodeRuleInfo((String)orgId);
        DynamicObjectCollection ruleEntry = GLBreakPointUtil.getCodeRuleEntry((CodeRuleInfo)coderule);
        List codeRuleEntryAttributes = GLBreakPointUtil.getAttributeFromCodeRuleEntry((DynamicObjectCollection)ruleEntry);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("orgId", orgId);
        paramMap.put("booktype", booksTypeId);
        paramMap.put("period", periodId);
        paramMap.put("orgName", orgNumber);
        paramMap.put("condition", VoucherNumberUtils.isOnlyForSubmit((CodeRuleInfo)coderule));
        String[] consistent = GLBreakPointUtil.checkConsistent((String)coderule.getId(), (List)codeRuleEntryAttributes, paramMap, (int)Integer.parseInt(adjustmentType.code), (boolean)coderule.getIsNonBreak());
        if ("0".equals(consistent[0])) {
            result = true;
        }
        return result;
    }

    private static enum AdjustmentType {
        AUTO("0"),
        BOOKEDDATE_ORDER("1"),
        BIZDATE_ORDER("2");

        private final String code;

        private AdjustmentType(String code) {
            this.code = code;
        }

        public static AdjustmentType of(String code) {
            return Arrays.stream(AdjustmentType.values()).filter(x -> x.code.equals(code)).findAny().orElse(null);
        }
    }
}

