/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.api;

import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.openapi.common.custom.annotation.ApiModel;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.acct.AcctUtil;
import kd.fi.gl.exception.BOSException;
import kd.fi.gl.exception.GLErrorCode;
import kd.fi.gl.exception.GLException;
import kd.fi.gl.service.CashflowQueryParam;
import kd.fi.gl.util.AsstUtil;
import kd.fi.gl.util.InterfacePermissionService;
import kd.fi.gl.util.PermissionType;

@ApiModel
public class CashflowQueryParamApi {
    @ApiParam(value="\u67e5\u8be2\u5b57\u6bb5", required=true, example="[\"org\",\"amount\",\"yearamount\"]")
    private @ApiParam(value="\u67e5\u8be2\u5b57\u6bb5", required=true, example="[\"org\",\"amount\",\"yearamount\"]") List<String> selectors = new ArrayList<String>();
    @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", required=true, example="\"org1\"")
    private @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", required=true, example="\"org1\"") String orgNumber;
    @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", required=true, example="\"100001\"")
    private @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", required=true, example="\"100001\"") String bookTypeNumber;
    @ApiParam(value="\u671f\u95f4\u7f16\u7801", required=true, example="\"202303\"")
    private @ApiParam(value="\u671f\u95f4\u7f16\u7801", required=true, example="\"202303\"") String periodNumber;
    @ApiParam(value="\u5e01\u522b\u7f16\u7801", example="\"CNY\"")
    private @ApiParam(value="\u5e01\u522b\u7f16\u7801", example="\"CNY\"") String currencyNumber;
    @ApiParam(value="\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7f16\u7801", required=true, example="[\"CI01\",\"CI02\"]")
    private @ApiParam(value="\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u7f16\u7801", required=true, example="[\"CI01\",\"CI02\"]") String[] cfitemNumbers;
    @ApiParam(value="\u6838\u7b97\u7ef4\u5ea6", example="{\"0001\":\"value1\"}")
    private @ApiParam(value="\u6838\u7b97\u7ef4\u5ea6", example="{\"0001\":\"value1\"}") Map<String, Object> assgrps = new HashMap<String, Object>();
    @ApiParam(value="\u5206\u7ec4\u5b57\u6bb5", required=true, example="[\"org\",\"amount\",\"yearamount\"]")
    private @ApiParam(value="\u5206\u7ec4\u5b57\u6bb5", required=true, example="[\"org\",\"amount\",\"yearamount\"]") List<String> groupBys = new ArrayList<String>();
    private Map<String, String> flexToNumberMap = new HashMap<String, String>();
    @ApiParam(value="\u516c\u5171\u7ef4\u5ea6", example="{\"comassist1\":[\"value1\",\"value2\"]}")
    private @ApiParam(value="\u516c\u5171\u7ef4\u5ea6", example="{\"comassist1\":[\"value1\",\"value2\"]}") Map<String, List<String>> comassist = new HashMap<String, List<String>>(1);
    @ApiParam(value="\u67e5\u8be2\u6240\u6709", example="\"true\"")
    private @ApiParam(value="\u67e5\u8be2\u6240\u6709", example="\"true\"") String queryAll;

    public Map<String, List<String>> getComassist() {
        return this.comassist;
    }

    public void setComassist(Map<String, List<String>> comassist) {
        this.comassist = comassist;
    }

    public List<String> getSelector() {
        return this.selectors;
    }

    public void addSelector(String selector) {
        this.selectors.add(selector);
    }

    public String getOrgNumber() {
        return this.orgNumber;
    }

    public void setOrgNumber(String orgNumber) {
        this.orgNumber = orgNumber;
    }

    public String getBookTypeNumber() {
        return this.bookTypeNumber;
    }

    public void setBookTypeNumber(String bookTypeNumber) {
        this.bookTypeNumber = bookTypeNumber;
    }

    public String getPeriodNumber() {
        return this.periodNumber;
    }

    public void setPeriodNumber(String periodNumber) {
        this.periodNumber = periodNumber;
    }

    public String getCurrencyNumber() {
        return this.currencyNumber;
    }

    public void setCurrencyNumber(String currencyNumber) {
        this.currencyNumber = currencyNumber;
    }

    public String[] getCfitemNumbers() {
        return this.cfitemNumbers;
    }

    public void setCfitemNumbers(String[] cfitemNumbers) {
        this.cfitemNumbers = cfitemNumbers;
    }

    public Map<String, Object> getAssgrp() {
        return this.assgrps;
    }

    public void setAssgrp(String asstType, Object asstValue) {
        this.assgrps.put(asstType, asstValue);
    }

    public List<String> getGroupBy() {
        return this.groupBys;
    }

    public void addGroupBy(String groupBy) {
        this.groupBys.add(groupBy);
    }

    public List<String> getSelectors() {
        return this.selectors;
    }

    public void setSelectors(List<String> selectors) {
        this.selectors = selectors;
    }

    public Map<String, Object> getAssgrps() {
        return this.assgrps;
    }

    public void setAssgrps(Map<String, Object> assgrps) {
        this.assgrps = assgrps;
    }

    public List<String> getGroupBys() {
        return this.groupBys;
    }

    public void setGroupBys(List<String> groupBys) {
        this.groupBys = groupBys;
    }

    public Map<String, String> getFlexToNumberMap() {
        return this.flexToNumberMap;
    }

    public void setFlexToNumberMap(Map<String, String> flexToNumberMap) {
        this.flexToNumberMap = flexToNumberMap;
    }

    public String getQueryAll() {
        return this.queryAll;
    }

    public void setQueryAll(String queryAll) {
        this.queryAll = queryAll;
    }

    public String toString() {
        try {
            return JSONUtils.toString((Object)this);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected CashflowQueryParam toCashflowQueryParam() {
        long orgId;
        String orgTable = "bos_org";
        String bookTypeTable = "bd_accountbookstype";
        String periodTable = "bd_period";
        String currencyTable = "bd_currency";
        String itemTable = "gl_cashflowitem";
        CashflowQueryParam param = new CashflowQueryParam();
        DynamicObject orgDyn = QueryServiceHelper.queryOne((String)orgTable, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.getOrgNumber())});
        long l = orgId = orgDyn == null ? 0L : orgDyn.getLong("id");
        if (orgId == 0L) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u6838\u7b97\u4e3b\u4f53\u4e3a\u7a7a", (String)"CashflowQueryParamApi_0", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        HasPermOrgResult permOrgResult = InterfacePermissionService.getAllPermOrgs((PermissionType)PermissionType.API);
        String permName = InterfacePermissionService.getPermName((PermissionType)PermissionType.API);
        String errorMsg = AcctUtil.checkPermByOrgId((String)this.orgNumber, (String)permName, (long)orgId, (HasPermOrgResult)permOrgResult);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            throw new GLException(GLErrorCode.common, new Object[]{errorMsg});
        }
        param.setOrgId(orgId);
        DynamicObject bookTypeDyn = QueryServiceHelper.queryOne((String)bookTypeTable, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.getBookTypeNumber())});
        long bookTypeId = bookTypeDyn == null ? 0L : bookTypeDyn.getLong("id");
        param.setBookTypeId(bookTypeId);
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
        if (bookInfo == null) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u8d26\u7c3f\u4e3a\u7a7a\u3002", (String)"BalanceQueryParamApi_1", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        DynamicObject periodDyn = AsstUtil.queryPeriodIdByNumber(bookInfo.getPeriodTypeId(), this.getPeriodNumber());
        param.setPeriodId(periodDyn == null ? 0L : periodDyn.getLong("id"));
        DynamicObject currencyDyn = QueryServiceHelper.queryOne((String)currencyTable, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.getCurrencyNumber())});
        param.setCurrencyId(currencyDyn == null ? 0L : currencyDyn.getLong("id"));
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
        DataSet itemSet = QueryServiceHelper.queryDataSet((String)"toCashflowQueryParam", (String)itemTable, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)this.getCfitemNumbers()), baseDataFilter}, null);
        ArrayList<Long> itemList = new ArrayList<Long>();
        for (Row item : itemSet) {
            long itemId = item.getLong("id");
            itemList.add(itemId);
        }
        param.setCfitemIds(itemList.stream().mapToLong(t -> t).toArray());
        Map<String, Object> assgrpMap = this.getAssgrp();
        HashMap<String, List<String>> assgrpNumbersMap = new HashMap<String, List<String>>(16);
        for (Map.Entry<String, Object> entry : assgrpMap.entrySet()) {
            Object value = entry.getValue();
            if (!StringUtils.isBlank((Object)value)) {
                ArrayList<String> numberList = new ArrayList<String>();
                numberList.add(value.toString());
                assgrpNumbersMap.put(entry.getKey(), (List<String>)numberList);
                continue;
            }
            assgrpNumbersMap.put(entry.getKey(), null);
        }
        Map<String, Map<String, ?>> assistIDMap = AsstUtil.assgrpNumberToID(assgrpNumbersMap);
        Map<String, ?> flexfieldMap = assistIDMap.get("flexfieldMap");
        Map<String, ?> assgrpIdMap = assistIDMap.get("assgrpIdMap");
        for (Map.Entry entry : assgrpMap.entrySet()) {
            String string = (String)flexfieldMap.get(entry.getKey());
            Object value = entry.getValue();
            if (!StringUtils.isBlank(value)) {
                long id = (Long)((Map)assgrpIdMap.get(string)).get(value.toString());
                param.setAssgrp(string, (Object)id);
                continue;
            }
            param.setAssgrp(string, null);
        }
        param.setComassit(AsstUtil.transComassist(bookInfo.getAccountTableId(), this.getComassist()));
        List<String> selectFields = this.getSelector();
        for (String string : selectFields) {
            param.addSelector(string);
        }
        List<String> list = this.getGroupBy();
        for (String field : list) {
            if (flexfieldMap.get(field) != null) {
                param.addGroupBy((String)flexfieldMap.get(field));
                this.flexToNumberMap.put((String)flexfieldMap.get(field), field);
                continue;
            }
            if (field.startsWith("comassist")) {
                this.flexToNumberMap.put(field, field);
                param.addGroupBy(field);
                continue;
            }
            param.addGroupBy(field);
        }
        Set<String> set = this.flexToNumberMap.keySet().stream().filter(key -> key.startsWith("comassist")).collect(Collectors.toSet());
        if (!AsstUtil.checkComAssistFieldIsExist(set, bookInfo.getAccountTableId())) {
            throw new GLException(GLErrorCode.common, new Object[]{ResManager.loadKDString((String)"\u67e5\u8be2\u5b57\u6bb5\u6216\u5206\u7ec4\u5b57\u6bb5\u4e2d\u5b58\u5728\u65e0\u6548\u7684\u516c\u5171\u7ef4\u5ea6\u5b57\u6bb5\u3002", (String)"BalanceQueryParamApi_5", (String)"fi-gl-webapi", (Object[])new Object[0])});
        }
        param.setQueryAll(this.queryAll);
        return param;
    }

    public List<Map<String, Object>> flexToNumberData(List<Map<String, Object>> flexDataList, long accountTableId) {
        if (!this.flexToNumberMap.isEmpty()) {
            HashMap flexToIdsMap = new HashMap();
            HashMap<String, Set<Long>> comAssistToIdsMap = new HashMap<String, Set<Long>>(8);
            Set<String> flexs = this.flexToNumberMap.keySet();
            for (Map<String, Object> map : flexDataList) {
                for (String flex : flexs) {
                    if (flex.startsWith("comassist")) {
                        Set allComAssistIdSet = comAssistToIdsMap.computeIfAbsent(flex, key -> new HashSet());
                        allComAssistIdSet.add((Long)map.get(flex));
                        continue;
                    }
                    long id = map.get(flex) == null ? 0L : (Long)map.get(flex);
                    Set<Long> set = flexToIdsMap.get(flex) == null ? new HashSet() : (Set)flexToIdsMap.get(flex);
                    set.add(id);
                    flexToIdsMap.put(flex, set);
                }
            }
            HashMap<String, String> flexToEntityIdMap = new HashMap<String, String>();
            HashMap<String, String> flexToNumberMap = new HashMap<String, String>();
            QFilter fflexs = new QFilter("flexfield", "in", flexToIdsMap.keySet());
            DataSet assistSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_asstacttype", (String)"flexfield,number,valuesource,valuetype", (QFilter[])fflexs.toArray(), null);
            for (Object row : assistSet) {
                String string = row.getString("valuetype");
                String entityId = null;
                switch (string) {
                    case "1": {
                        entityId = row.getString("valuesource");
                        break;
                    }
                    case "2": {
                        entityId = "bos_assistantdata_detail";
                    }
                }
                String flex = row.getString("flexfield");
                String number = row.getString("number");
                flexToEntityIdMap.put(flex, entityId);
                flexToNumberMap.put(flex, number);
            }
            HashMap flexMap = new HashMap(flexToIdsMap.size());
            for (Map.Entry entry : flexToIdsMap.entrySet()) {
                String flex = (String)entry.getKey();
                Set ids = (Set)entry.getValue();
                DataSet dataSet = AsstUtil.queryEntityId((String)flexToEntityIdMap.get(flex), ids);
                HashMap idToEntityMap = new HashMap();
                for (Row row : dataSet) {
                    String number = row.getString("number");
                    String name = row.getString("name");
                    long id = row.getLong("id");
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("number", number);
                    map.put("name", name);
                    idToEntityMap.put(id, map);
                }
                flexMap.put(flex, idToEntityMap);
            }
            Table<String, Long, Map<String, String>> comAssistIdToNumTable = AsstUtil.queryComAssistIdToNum(comAssistToIdsMap, accountTableId);
            for (Map<String, Object> map : flexDataList) {
                HashMap assgrpMap = new HashMap(flexs.size());
                Set comAssistKeySet = comAssistToIdsMap.keySet();
                HashMap<String, Object> comAssistMap = new HashMap<String, Object>(comAssistKeySet.size());
                for (String flex : flexs) {
                    Object value = map.remove(flex);
                    if (!Objects.nonNull(value)) continue;
                    long id = Long.parseLong(value.toString());
                    if (flex.startsWith("comassist")) {
                        comAssistMap.put(flex, comAssistIdToNumTable.get((Object)flex, (Object)id));
                        continue;
                    }
                    Map idToEntityMap = (Map)flexMap.get(flex);
                    Map numberMap = (Map)idToEntityMap.get(id);
                    assgrpMap.put(flexToNumberMap.get(flex), numberMap);
                }
                if (!comAssistKeySet.isEmpty()) {
                    map.put("comassist", comAssistMap);
                }
                if (assgrpMap.isEmpty()) continue;
                map.put("assgrp", assgrpMap);
            }
            return flexDataList;
        }
        return flexDataList;
    }
}

