/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.ext.fi.entity.property.AccountProp;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.bd.model.schema.property.BaseDataProp;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.reciprocal.ReciprocalInitUtils;
import kd.fi.gl.reciprocal.ReciprocalUtils;

@ApiController(value="gl", desc="\u5f80\u6765\u4f59\u989d\u7ed3\u675f\u521d\u59cb\u5316")
public class ReciprocalEndInitApiHelper {
    private static final String SUCCESS_KEY = "success";
    private static final String MESSAGE_KEY = "message";
    private static final String ANTIENDINIT = "antiendinit";
    private static final String ENDINIT = "endinit";
    private static final String ENDINITPERIOD = "endinitperiod";

    @ApiPostMapping(value="/importBalance")
    public CustomApiResult<String> importBalance(@ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", example="\"110220101\"", required=true) @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", example="\"110220101\"", required=true) String orgNum, @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", example="\"2000001\"", required=true) @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", example="\"2000001\"", required=true) String bookTypeNum, @ApiParam(value="\u79d1\u76ee\u7f16\u7801,\u4e3a\u7a7a\u5219\u5f15\u5165\u5168\u90e8\u79d1\u76ee\u6838\u7b97\u7ef4\u5ea6\u4f59\u989d", example="[\"1001\",\"1002\"]") @ApiParam(value="\u79d1\u76ee\u7f16\u7801,\u4e3a\u7a7a\u5219\u5f15\u5165\u5168\u90e8\u79d1\u76ee\u6838\u7b97\u7ef4\u5ea6\u4f59\u989d", example="[\"1001\",\"1002\"]") List<String> acctNums) {
        Map<String, Object> buildResult;
        long bookTypeId;
        long orgId;
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(8);
        DynamicObject orgDyn = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNum)});
        long l = orgId = orgDyn == null ? 0L : orgDyn.getLong("id");
        if (orgId == 0L) {
            resultList.add(this.buildFailResult(ResManager.loadKDString((String)"\u6838\u7b97\u4e3b\u4f53\u4e3a\u7a7a", (String)"CashflowQueryParamApi_0", (String)"fi-gl-webapi", (Object[])new Object[0])));
            return this.buildResult(resultList, 0);
        }
        DynamicObject bookTypeDyn = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bookTypeNum)});
        long l2 = bookTypeId = bookTypeDyn == null ? 0L : bookTypeDyn.getLong("id");
        if (bookTypeId == 0L) {
            resultList.add(this.buildFailResult(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"ReciprocalEndInitApiHelper_0", (String)"fi-gl-webapi", (Object[])new Object[0])));
            return this.buildResult(resultList, 0);
        }
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
        if (bookInfo == null) {
            resultList.add(this.buildFailResult(ResManager.loadKDString((String)"\u8d26\u7c3f\u4e3a\u7a7a\u3002", (String)"BalanceQueryParamApi_1", (String)"fi-gl-webapi", (Object[])new Object[0])));
            return this.buildResult(resultList, 0);
        }
        if (!bookInfo.isIsbizunit()) {
            resultList.add(this.buildFailResult(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b9e\u4f53\u7ec4\u7ec7\u3002", (String)"ReciprocalEndInitApiHelper_13", (String)"fi-gl-webapi", (Object[])new Object[0])));
            return this.buildResult(resultList, 0);
        }
        boolean isImportAll = false;
        if (acctNums == null || acctNums.isEmpty()) {
            isImportAll = true;
        }
        List accountFilter = ReciprocalUtils.getAccAccountFilter((Long)bookInfo.getOrgId(), (Long)bookInfo.getBookTypeId(), (Long)bookInfo.getAccountTableId());
        accountFilter.add(new QFilter("masterid", "not in", this.endInitAccount(bookInfo)));
        if (!isImportAll) {
            accountFilter.add(new QFilter("number", "in", acctNums));
        }
        DynamicObject[] accounts = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"id, number, masterid", (QFilter[])accountFilter.toArray(new QFilter[0]));
        HashMap<String, DynamicObject> acctNumDynMap = new HashMap<String, DynamicObject>(8);
        for (DynamicObject account : accounts) {
            acctNumDynMap.put(account.getString("number"), account);
        }
        acctNums = isImportAll ? new ArrayList(acctNumDynMap.keySet()) : acctNums;
        long curPeriodId = bookInfo.getCurPeriodId();
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(8);
        ArrayList<String> notAvailableAccNums = new ArrayList<String>(8);
        for (String accNum : acctNums) {
            DynamicObject account = (DynamicObject)acctNumDynMap.get(accNum);
            if (account == null) {
                notAvailableAccNums.add(accNum);
                continue;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"gl_initacccurrent");
            dynamicObject.set("account", (Object)account);
            dynamicObjects.add(dynamicObject);
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("org", String.valueOf(orgId));
        operateOption.setVariableValue("bookstype", String.valueOf(bookTypeId));
        operateOption.setVariableValue("period", String.valueOf(curPeriodId));
        OperationResult result = OperationServiceHelper.executeOperate((String)"importbal", (String)"gl_initacccurrent", (DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]), (OperateOption)operateOption);
        boolean hasError = false;
        if (!notAvailableAccNums.isEmpty()) {
            hasError = true;
            buildResult = this.buildFailResult(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801%s\u4e0d\u7b26\u5408\u5bfc\u5165\u6838\u7b97\u7ef4\u5ea6\u4f59\u989d\u6761\u4ef6\u3002", (String)"ReciprocalEndInitApiHelper_4", (String)"fi-gl-webapi", (Object[])new Object[0]), String.join((CharSequence)",", notAvailableAccNums)));
            resultList.add(buildResult);
        }
        if (result.isSuccess() && !hasError) {
            buildResult = this.buildSuccessResult(ResManager.loadKDString((String)"\u5f15\u5165\u6838\u7b97\u7ef4\u5ea6\u4f59\u989d\u6210\u529f\u3002", (String)"ReciprocalEndInitApiHelper_6", (String)"fi-gl-webapi", (Object[])new Object[0]));
            resultList.add(buildResult);
        } else if (!result.getValidateResult().getValidateErrors().isEmpty()) {
            for (ValidateResult validateError : result.getValidateResult().getValidateErrors()) {
                for (OperateErrorInfo info : validateError.getAllErrorInfo()) {
                    Map<String, Object> buildResult2 = this.buildFailResult(info.getMessage());
                    resultList.add(buildResult2);
                }
            }
        } else if (!hasError) {
            buildResult = this.buildFailResult(ResManager.loadKDString((String)"\u5bfc\u5165\u6838\u7b97\u7ef4\u5ea6\u4f59\u989d\u5931\u8d25\u3002", (String)"ReciprocalEndInitApiHelper_5", (String)"fi-gl-webapi", (Object[])new Object[0]));
            resultList.add(buildResult);
        }
        return this.buildResult(resultList, result.getSuccessPkIds().size());
    }

    @ApiPostMapping(value="/endinitOrAntiEndinit")
    public CustomApiResult<String> endinitOrAntiEndinit(@ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", example="\"110220101\"", required=true) @ApiParam(value="\u7ec4\u7ec7\u7f16\u7801", example="\"110220101\"", required=true) String orgNum, @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", example="\"2000001\"", required=true) @ApiParam(value="\u8d26\u7c3f\u7c7b\u578b\u7f16\u7801", example="\"2000001\"", required=true) String bookTypeNum, @ApiParam(value="\u79d1\u76ee\u7f16\u7801\u548c\u671f\u95f4\u7f16\u7801\uff0c\u4e3a\u7a7a\u5219\u53d6\u6240\u6709\u79d1\u76ee", example="[\"1001\",\"1002\"]") @ApiParam(value="\u79d1\u76ee\u7f16\u7801\u548c\u671f\u95f4\u7f16\u7801\uff0c\u4e3a\u7a7a\u5219\u53d6\u6240\u6709\u79d1\u76ee", example="[\"1001\",\"1002\"]") List<String> accNums, @ApiParam(value="\u64cd\u4f5c\u7c7b\u578b\uff0c\u7ed3\u675f\u521d\u59cb\u5316\uff1aendinit\uff0c\u53cd\u7ed3\u675f\u521d\u59cb\u5316\uff1aantiendinit", example="\"endinit\"", required=true) @ApiParam(value="\u64cd\u4f5c\u7c7b\u578b\uff0c\u7ed3\u675f\u521d\u59cb\u5316\uff1aendinit\uff0c\u53cd\u7ed3\u675f\u521d\u59cb\u5316\uff1aantiendinit", example="\"endinit\"", required=true) String operationKey) {
        Map<String, Object> buildResult;
        long bookTypeId;
        long orgId;
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(8);
        DynamicObject orgDyn = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNum)});
        long l = orgId = orgDyn == null ? 0L : orgDyn.getLong("id");
        if (orgId == 0L) {
            resultList.add(this.buildFailResult(ResManager.loadKDString((String)"\u6838\u7b97\u4e3b\u4f53\u4e3a\u7a7a", (String)"CashflowQueryParamApi_0", (String)"fi-gl-webapi", (Object[])new Object[0])));
            return this.buildResult(resultList, 0);
        }
        DynamicObject bookTypeDyn = QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)bookTypeNum)});
        long l2 = bookTypeId = bookTypeDyn == null ? 0L : bookTypeDyn.getLong("id");
        if (bookTypeId == 0L) {
            resultList.add(this.buildFailResult(ResManager.loadKDString((String)"\u8d26\u7c3f\u7c7b\u578b\u4e0d\u5b58\u5728\u3002", (String)"ReciprocalEndInitApiHelper_0", (String)"fi-gl-webapi", (Object[])new Object[0])));
            return this.buildResult(resultList, 0);
        }
        AccountBookInfo accountBookInfo = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
        if (accountBookInfo == null) {
            resultList.add(this.buildFailResult(ResManager.loadKDString((String)"\u8d26\u7c3f\u4e3a\u7a7a\u3002", (String)"BalanceQueryParamApi_1", (String)"fi-gl-webapi", (Object[])new Object[0])));
            return this.buildResult(resultList, 0);
        }
        if (!accountBookInfo.isIsbizunit()) {
            resultList.add(this.buildFailResult(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b9e\u4f53\u7ec4\u7ec7\u3002", (String)"ReciprocalEndInitApiHelper_13", (String)"fi-gl-webapi", (Object[])new Object[0])));
            return this.buildResult(resultList, 0);
        }
        if (!ENDINIT.equals(operationKey) && !ANTIENDINIT.equals(operationKey)) {
            resultList.add(this.buildFailResult(ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b\u53c2\u6570\u5fc5\u987b\u4e3aendinit\u6216antiendinit\u3002", (String)"ReciprocalEndInitApiHelper_3", (String)"fi-gl-webapi", (Object[])new Object[0])));
            return this.buildResult(resultList, 0);
        }
        boolean isOperateAll = false;
        if (accNums == null || accNums.isEmpty()) {
            isOperateAll = true;
        }
        boolean needEndInit = ENDINIT.equals(operationKey);
        long accountTableId = accountBookInfo.getAccountTableId();
        IDataEntityType dataEntityType = BusinessDataServiceHelper.newDynamicObject((String)"gl_initacccurrent").getDataEntityType();
        MainEntityType mainEntityType = new MainEntityType();
        mainEntityType.setName("gl_initacccurrent");
        mainEntityType.setDisplayName(dataEntityType.getDisplayName());
        LongProp pkProp = new LongProp();
        pkProp.setPrimaryKey(Boolean.TRUE.booleanValue());
        pkProp.setName("id");
        mainEntityType.registerSimpleProperty((DynamicSimpleProperty)pkProp);
        mainEntityType.registerProperty("account", AccountProp.class, null, false);
        mainEntityType.registerProperty("period", BaseDataProp.class, null, false);
        ArrayList<DynamicObject> reciprocalInitStates = new ArrayList<DynamicObject>(8);
        OperationResult result = new OperationResult();
        ArrayList<String> notAvailableAccNums = new ArrayList<String>(8);
        DataSet dSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_accountview", (String)"id acct", (QFilter[])ReciprocalUtils.getAccAccountFilter((Long)accountBookInfo.getOrgId(), (Long)accountBookInfo.getBookTypeId(), (Long)accountTableId).toArray(new QFilter[0]), null);
        DataSet endInitSet = ReciprocalInitUtils.queryIsEndInitReciprocalInit((boolean)needEndInit, (Long)accountBookInfo.getOrgId(), (Long)accountBookInfo.getBookTypeId(), (Long)accountTableId);
        try (DataSet ds = endInitSet.join(dSet, JoinType.INNER).on("id", "acct").select(new String[]{"id", ENDINITPERIOD}).finish();){
            if (ds != null) {
                ArrayList<Long> acctIds = new ArrayList<Long>(16);
                HashMap acctNumMap = new HashMap(16);
                HashMap<Long, DynamicObject> periodIds = new HashMap<Long, DynamicObject>(16);
                HashMap<Long, Long> acctToPeriod = new HashMap<Long, Long>(16);
                long curPeriodId = accountBookInfo.getCurPeriodId();
                periodIds.put(curPeriodId, null);
                for (Row row : ds) {
                    Long acctId = row.getLong("id");
                    Long endInitPeriodId = row.getLong(ENDINITPERIOD);
                    acctIds.add(acctId);
                    periodIds.put(endInitPeriodId, null);
                    acctToPeriod.put(acctId, endInitPeriodId);
                }
                this.setAcctDynById("bd_accountview", "id,number,masterid", acctIds, acctNumMap);
                this.setDynamicObjectById("bd_period", "id,number", periodIds);
                accNums = isOperateAll ? new ArrayList(acctNumMap.keySet()) : accNums;
                for (String acctNum : accNums) {
                    DynamicObject dynAcct = (DynamicObject)acctNumMap.get(acctNum);
                    if (dynAcct == null) {
                        notAvailableAccNums.add(acctNum);
                        continue;
                    }
                    DynamicObject reciprocalInitState = (DynamicObject)mainEntityType.createInstance();
                    long accountId = dynAcct.getLong("id");
                    reciprocalInitState.set("id", (Object)accountId);
                    reciprocalInitState.set("account", (Object)dynAcct);
                    Long periodId = (Long)acctToPeriod.get(accountId);
                    if (periodId == null) {
                        periodId = curPeriodId;
                    }
                    reciprocalInitState.set("period", periodIds.get(periodId));
                    reciprocalInitStates.add(reciprocalInitState);
                    if (reciprocalInitStates.size() % 10 != 0) continue;
                    this.executeInitOrAntiInitOperate(orgId, bookTypeId, reciprocalInitStates, result, operationKey);
                }
                if (!reciprocalInitStates.isEmpty()) {
                    this.executeInitOrAntiInitOperate(orgId, bookTypeId, reciprocalInitStates, result, operationKey);
                }
            }
        }
        boolean hasError = false;
        if (!notAvailableAccNums.isEmpty()) {
            hasError = true;
            buildResult = this.buildFailResult(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u7f16\u7801%s\u4e0d\u7b26\u5408\u7ed3\u675f\u5f80\u6765\u521d\u59cb\u6761\u4ef6\u3002", (String)"ReciprocalEndInitApiHelper_1", (String)"fi-gl-webapi", (Object[])new Object[0]), String.join((CharSequence)",", notAvailableAccNums)));
            resultList.add(buildResult);
        }
        if (result.isSuccess() && !hasError) {
            buildResult = this.buildSuccessResult("");
            resultList.add(buildResult);
        } else if (!result.getValidateResult().getValidateErrors().isEmpty()) {
            for (ValidateResult validateError : result.getValidateResult().getValidateErrors()) {
                for (OperateErrorInfo info : validateError.getAllErrorInfo()) {
                    Map<String, Object> buildResult2 = this.buildFailResult(info.getMessage());
                    resultList.add(buildResult2);
                }
            }
        } else if (!hasError) {
            String endinitMsg = ResManager.loadKDString((String)"\u7ed3\u675f\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"ReciprocalEndInitApiHelper_9", (String)"fi-gl-webapi", (Object[])new Object[0]);
            String antiAndinitMsg = ResManager.loadKDString((String)"\u53cd\u7ed3\u675f\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"ReciprocalEndInitApiHelper_10", (String)"fi-gl-webapi", (Object[])new Object[0]);
            Map<String, Object> buildResult3 = this.buildFailResult(needEndInit ? endinitMsg : antiAndinitMsg);
            resultList.add(buildResult3);
        }
        return this.buildResult(resultList, result.getSuccessPkIds().size());
    }

    private void setDynamicObjectById(String entityName, String selectProperties, Map<Long, DynamicObject> dynIdMap) {
        DynamicObject[] dyns;
        QFilter filter = new QFilter("id", "in", dynIdMap.keySet());
        for (DynamicObject dyn : dyns = BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])filter.toArray())) {
            dynIdMap.put(dyn.getLong("id"), dyn);
        }
    }

    private void setAcctDynById(String entityName, String selectProperties, List<Long> acctIds, Map<String, DynamicObject> dynIdMap) {
        DynamicObject[] dyns;
        QFilter filter = new QFilter("id", "in", acctIds);
        for (DynamicObject dyn : dyns = BusinessDataServiceHelper.load((String)entityName, (String)selectProperties, (QFilter[])filter.toArray())) {
            dynIdMap.put(dyn.getString("number"), dyn);
        }
    }

    private CustomApiResult<String> buildResult(List<Map<String, Object>> resultList, int successCount) {
        boolean hasFail = false;
        StringBuilder errorMsgSb = new StringBuilder();
        for (Map<String, Object> result : resultList) {
            boolean success = (Boolean)result.getOrDefault(SUCCESS_KEY, false);
            if (success) continue;
            hasFail = true;
            errorMsgSb.append(result.getOrDefault(MESSAGE_KEY, ""));
        }
        if (hasFail) {
            String countMessage = ResManager.loadResFormat((String)"\u6210\u529f%1\u9879\u3002", (String)"ReciprocalEndInitApiHelper_11", (String)"fi-gl-webapi", (Object[])new Object[]{successCount});
            String errorMsg = errorMsgSb.toString().replaceAll("\\r\\n", "");
            return CustomApiResult.fail((String)"500", (String)(countMessage + errorMsg));
        }
        return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"ReciprocalEndInitApiHelper_14", (String)"fi-gl-webapi", (Object[])new Object[0]));
    }

    private void executeInitOrAntiInitOperate(long orgId, long bookTypeId, List<DynamicObject> reciprocalInitStates, OperationResult operationResultAll, String operationKey) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("org", String.valueOf(orgId));
        operateOption.setVariableValue("bookstype", String.valueOf(bookTypeId));
        operateOption.setVariableValue("batchsize", "10");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)"gl_initacccurrent", (DynamicObject[])reciprocalInitStates.toArray(new DynamicObject[0]), (OperateOption)operateOption);
        if (operationResultAll.isSuccess()) {
            operationResultAll.setSuccess(operationResult.isSuccess());
        }
        operationResultAll.mergeOperateResult(operationResult);
        reciprocalInitStates.clear();
    }

    private Map<String, Object> buildFailResult(String errorMessage) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put(SUCCESS_KEY, false);
        result.put(MESSAGE_KEY, errorMessage);
        return result;
    }

    private Map<String, Object> buildSuccessResult(String successMessage) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        result.put(SUCCESS_KEY, true);
        result.put(MESSAGE_KEY, successMessage);
        return result;
    }

    private Set<Long> endInitAccount(AccountBookInfo bookInfo) {
        QFilter filter = new QFilter("org", "=", (Object)bookInfo.getOrgId());
        filter.and(new QFilter("booktype", "=", (Object)bookInfo.getBookTypeId()));
        filter.and(new QFilter("isendinit", "=", (Object)true));
        return QueryServiceHelper.query((String)"gl_reci_init_state", (String)"account.masterid", (QFilter[])filter.toArray()).stream().map(v -> v.getLong("account.masterid")).collect(Collectors.toSet());
    }
}

