/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.util.CommonAssistUtil;

public class AsstUtil {
    public static final String accountKey = "accountMap";
    public static final String flexfieldKey = "flexfieldMap";
    public static final String assgrpKey = "assgrpIdMap";
    public static final String COM_ASSIST_PRE = "comassist";

    public static Map<String, Object> acctAssgrpNumberToID(Map<String, List<Map<String, String>>> accountAssgrpMap, long accountTableId, long orgId, DynamicObject period) {
        String accountTableTable = "bd_accountview";
        ArrayList<String> accountNumbers = new ArrayList<String>(accountAssgrpMap.size());
        HashMap<String, List<String>> assgrpMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<Map<String, String>>> map : accountAssgrpMap.entrySet()) {
            accountNumbers.add(map.getKey());
            if (map.getValue() == null) continue;
            for (Map<String, String> groupMap : map.getValue()) {
                for (Map.Entry<String, String> entry : groupMap.entrySet()) {
                    String asstactTypeNumber = entry.getKey();
                    if (!StringUtils.isEmpty((String)entry.getValue())) {
                        String assgrpNumber = entry.getValue();
                        if (assgrpMap.get(asstactTypeNumber) != null) {
                            ((List)assgrpMap.get(asstactTypeNumber)).add(assgrpNumber);
                            continue;
                        }
                        ArrayList<String> assgrpNumbers = new ArrayList<String>();
                        assgrpNumbers.add(assgrpNumber);
                        assgrpMap.put(asstactTypeNumber, assgrpNumbers);
                        continue;
                    }
                    assgrpMap.put(asstactTypeNumber, null);
                }
            }
        }
        QFilter faccountNumber = new QFilter("number", "in", accountNumbers);
        QFilter atFilter = new QFilter("startdate", "<=", (Object)period.getDate("enddate"));
        atFilter.and(new QFilter("enddate", ">=", (Object)period.getDate("enddate")));
        HashMap<String, Long> acctMap = new HashMap<String, Long>(10);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(faccountNumber);
        filters.add(atFilter);
        Throwable throwable = null;
        try (DataSet ds = AccountUtils.queryAccountDataSet((long)orgId, (long)accountTableId, (String)"id,number", filters);){
            for (Row row : ds) {
                acctMap.put(row.getString("number"), row.getLong("id"));
            }
        }
        catch (Throwable asstactTypeNumber) {
            Throwable throwable2 = asstactTypeNumber;
            throw asstactTypeNumber;
        }
        HashMap resultMap = new HashMap(accountAssgrpMap.size());
        Map<String, Map<String, ?>> map = AsstUtil.assgrpNumberToID(assgrpMap);
        Map<String, ?> flexFieldMap = map.get(flexfieldKey);
        Map<String, ?> assgrpIdMap = map.get(assgrpKey);
        for (Map.Entry entry : accountAssgrpMap.entrySet()) {
            String acctNumber = (String)entry.getKey();
            if (acctMap.get(acctNumber) == null) continue;
            long acctId = (Long)acctMap.get(acctNumber);
            ArrayList assgrpNumberList = (ArrayList)entry.getValue();
            if (assgrpNumberList == null) {
                assgrpNumberList = new ArrayList();
            }
            ArrayList assgrpIdList = new ArrayList(assgrpNumberList.size());
            for (Map asstMap : assgrpNumberList) {
                HashMap<String, Long> asstGroupMap = new HashMap<String, Long>();
                for (Map.Entry asstEntry : asstMap.entrySet()) {
                    String flexField = (String)flexFieldMap.get(asstEntry.getKey());
                    Map assMap = (Map)assgrpIdMap.get(flexField);
                    if (!assMap.isEmpty() && !StringUtils.isBlank((String)((String)asstEntry.getValue()))) {
                        long assId = 0L;
                        if (assMap.get(asstEntry.getValue()) != null) {
                            assId = (Long)assMap.get(asstEntry.getValue());
                        }
                        asstGroupMap.put(flexField, assId);
                        continue;
                    }
                    asstGroupMap.put(flexField, null);
                }
                assgrpIdList.add(asstGroupMap);
            }
            resultMap.put(acctId, assgrpIdList);
        }
        HashMap<String, Object> flexMap = new HashMap<String, Object>();
        flexMap.put("numberToFlex", flexFieldMap);
        flexMap.put("flexToIdMap", resultMap);
        return flexMap;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Map<String, ?>> assgrpNumberToID(Map<String, List<String>> assgrpMap) {
        void var11_13;
        HashMap assgrpIdMap = new HashMap(assgrpMap.size());
        String flexField = "flexfield";
        String sstactType = "bd_asstacttype";
        ArrayList<String> asstNumberList = new ArrayList<String>(assgrpMap.size());
        for (Map.Entry<String, List<String>> mapEntry : assgrpMap.entrySet()) {
            asstNumberList.add(mapEntry.getKey());
        }
        QFilter fnumber = new QFilter("number", "in", asstNumberList);
        QFilter fflex = new QFilter("flexid", "=", (Object)2L);
        DynamicObject[] accTypes = BusinessDataServiceHelper.load((String)sstactType, (String)"number,flexfield,valuesource,valuetype,assistanttype", (QFilter[])new QFilter[]{fnumber, fflex});
        HashMap<String, String> flexfieldMap = new HashMap<String, String>(accTypes.length);
        DynamicObject[] dynamicObjectArray = accTypes;
        int n = dynamicObjectArray.length;
        boolean bl = false;
        while (var11_13 < n) {
            DynamicObject assgrpDyn = dynamicObjectArray[var11_13];
            flexfieldMap.put(assgrpDyn.getString("number"), assgrpDyn.getString("flexfield"));
            ++var11_13;
        }
        HashMap<String, DynamicObject> accTypeMap = new HashMap<String, DynamicObject>(accTypes.length);
        for (DynamicObject accType : accTypes) {
            accTypeMap.put(accType.getString(flexField), accType);
        }
        for (Map.Entry entry : assgrpMap.entrySet()) {
            String flex = (String)flexfieldMap.get(entry.getKey());
            List baseNumberList = (List)entry.getValue();
            DynamicObject accType = (DynamicObject)accTypeMap.get(flex);
            if (accType == null) continue;
            String entityName = "";
            QFilter fbaseNumber = new QFilter("number", "in", (Object)baseNumberList);
            DynamicObjectCollection baseColl = null;
            String midField = "masterid";
            if ("1".equals(accType.getString("valuetype"))) {
                entityName = accType.getDynamicObject("valuesource").getString("number");
                if (EntityMetadataCache.getDataEntityType((String)entityName).getProperty("masterid") == null) {
                    midField = "id";
                }
                baseColl = QueryServiceHelper.query((String)entityName, (String)(midField + ",number"), (QFilter[])new QFilter[]{fbaseNumber});
            } else if ("2".equals(accType.getString("valuetype")) && accType.getDynamicObject("assistanttype") != null) {
                entityName = accType.getDynamicObject("assistanttype").getString("number");
                QFilter filterGroup = new QFilter("number", "=", (Object)entityName);
                DynamicObject groupDyn = QueryServiceHelper.queryOne((String)"bos_assistantdatagroup", (String)"id", (QFilter[])new QFilter[]{filterGroup});
                QFilter fDetail = new QFilter("group.id", "=", groupDyn.get("id"));
                baseColl = QueryServiceHelper.query((String)"bos_assistantdata_detail", (String)"id,masterid,number", (QFilter[])new QFilter[]{fDetail, fbaseNumber});
            }
            HashMap<String, Long> numberIdMap = new HashMap<String, Long>(0);
            if (baseNumberList != null && !baseNumberList.isEmpty()) {
                if (baseColl != null) {
                    numberIdMap = new HashMap(baseColl.size());
                    for (DynamicObject baseDyn : baseColl) {
                        numberIdMap.put(baseDyn.getString("number"), baseDyn.getLong(midField));
                    }
                }
                for (String number : baseNumberList) {
                    numberIdMap.putIfAbsent(number, 0L);
                }
            }
            assgrpIdMap.put(flex, numberIdMap);
        }
        HashMap map = new HashMap();
        map.put(flexfieldKey, flexfieldMap);
        map.put(assgrpKey, assgrpIdMap);
        return map;
    }

    public static Map<String, List<Long>> transComassist(Long accountTableId, Map<String, List<String>> comassist) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>(comassist.size());
        ComAssistTable table = ComAssistTable.get((Long)accountTableId);
        List assists = table.getCommonAssists();
        comassist.forEach((k, v) -> {
            List collect = assists.stream().filter(x -> x.number.equals(k)).collect(Collectors.toList());
            if (!collect.isEmpty()) {
                CommonAssist commonAssist = (CommonAssist)collect.get(0);
                map.put(commonAssist.key, QueryServiceHelper.queryPrimaryKeys((String)commonAssist.valueSource, (QFilter[])new QFilter[]{new QFilter("number", "in", v)}, null, (int)-1).stream().map(x -> Long.parseLong(String.valueOf(x))).collect(Collectors.toList()));
            }
        });
        return map;
    }

    public static DynamicObject queryPeriodIdByNumber(long periodType, String periodNumberStr) {
        QFilter fpn;
        QFilter fpt = new QFilter("periodtype", "=", (Object)periodType);
        if (StringUtils.isBlank((String)periodNumberStr)) {
            return null;
        }
        if (periodNumberStr.endsWith("T")) {
            fpn = new QFilter("number", "=", (Object)periodNumberStr);
        } else if (periodNumberStr.length() == 6) {
            int year = Integer.parseInt(periodNumberStr.substring(0, 4));
            int period = Integer.parseInt(periodNumberStr.substring(4, 6));
            fpn = new QFilter("periodyear", "=", (Object)year).and(new QFilter("periodnumber", "=", (Object)period));
        } else {
            return null;
        }
        DynamicObject periodDyn = QueryServiceHelper.queryOne((String)"bd_period", (String)"id,enddate", (QFilter[])new QFilter[]{fpt, fpn});
        return periodDyn;
    }

    public static boolean checkComAssistFieldIsExist(Set<String> comAssistFieldSet, long accountTableId) {
        List allCommonAssistKeys = ComAssistTable.get((Long)accountTableId).getAllCommonAssistKeys();
        for (String comAssistField : comAssistFieldSet) {
            if (allCommonAssistKeys.contains(comAssistField)) continue;
            return false;
        }
        return true;
    }

    public static Table<String, Long, Map<String, String>> queryComAssistIdToNum(Map<String, Set<Long>> comAssistToIdsMap, long accountTableId) {
        HashBasedTable comAssistIdToNumTable = HashBasedTable.create();
        List comAssistValSource = CommonAssistUtil.getComAssistValSource((long)accountTableId);
        for (Map.Entry<String, Set<Long>> comAssistToIdsEntry : comAssistToIdsMap.entrySet()) {
            String comAssistKey = comAssistToIdsEntry.getKey();
            DataSet dataSet = AsstUtil.queryEntityId((String)comAssistValSource.get(Integer.parseInt(comAssistKey.substring(COM_ASSIST_PRE.length())) - 1), comAssistToIdsEntry.getValue());
            Throwable throwable = null;
            try {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    HashMap<String, String> comAssistInfoMap = new HashMap<String, String>(8);
                    comAssistInfoMap.put("number", row.getString("number"));
                    comAssistInfoMap.put("name", row.getString("name"));
                    comAssistIdToNumTable.put((Object)comAssistKey, (Object)row.getLong("id"), comAssistInfoMap);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
        return comAssistIdToNumTable;
    }

    public static DataSet queryEntityId(String entityId, Set<Long> ids) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)AsstUtil.class.getName(), (String)entityId, (String)"number,name,id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}, null);
        return dataSet;
    }
}

