/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.accountref.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.fi.gl.accountref.constant.AbstractBalData;
import kd.fi.gl.accountref.handler.AbstractBalDataHandler;

public abstract class AbstractSaveDataHandler
extends AbstractBalDataHandler {
    private static final String DELETE_SQL = "DELETE FROM %s WHERE FID IN (%s)";
    protected static final int SPLIT_EXECUTE_COUNT = 5000;

    protected void patchExecute(String sql, List<Object[]> insertParams) {
        DB.executeBatch((DBRoute)gl, (String)sql, insertParams);
    }

    protected void deleteBalData(Collection<AbstractBalData> deleteBalDatas, String entityTableName) {
        ArrayList<String> delIds = new ArrayList<String>(1024);
        for (AbstractBalData deleteBalData : deleteBalDatas) {
            delIds.add(String.valueOf(deleteBalData.getId()));
            if (delIds.size() < 5000) continue;
            String delSql = String.format(DELETE_SQL, entityTableName, String.join((CharSequence)",", delIds.toArray(new String[0])));
            this.singleDeleteBalDatas(delSql);
            delIds.clear();
        }
        if (!delIds.isEmpty()) {
            String delSql = String.format(DELETE_SQL, entityTableName, String.join((CharSequence)",", delIds.toArray(new String[0])));
            this.singleDeleteBalDatas(delSql);
        }
    }

    private void singleDeleteBalDatas(String delSql) {
        DB.execute((DBRoute)gl, (String)delSql);
    }
}

